/*****************************************************************************
* SASload_KID_2012_DX_PR_GRPS.SAS
* This program will load the 2012 KID ASCII DX_PR_GRPS File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA KID_2012_DX_PR_GRPS; 
INFILE 'KID_2012_DX_PR_GRPS.ASC' LRECL = 238;

*** Define data element attributes ***;
ATTRIB 
  HOSP_KID                   LENGTH=4            FORMAT=Z5.
  LABEL="KID hospital number"

  RECNUM                     LENGTH=5            FORMAT=Z8.
  LABEL="KID record number"

  CHRON1                     LENGTH=3
  LABEL="Chronic condition indicator 1"

  CHRON2                     LENGTH=3
  LABEL="Chronic condition indicator 2"

  CHRON3                     LENGTH=3
  LABEL="Chronic condition indicator 3"

  CHRON4                     LENGTH=3
  LABEL="Chronic condition indicator 4"

  CHRON5                     LENGTH=3
  LABEL="Chronic condition indicator 5"

  CHRON6                     LENGTH=3
  LABEL="Chronic condition indicator 6"

  CHRON7                     LENGTH=3
  LABEL="Chronic condition indicator 7"

  CHRON8                     LENGTH=3
  LABEL="Chronic condition indicator 8"

  CHRON9                     LENGTH=3
  LABEL="Chronic condition indicator 9"

  CHRON10                    LENGTH=3
  LABEL="Chronic condition indicator 10"

  CHRON11                    LENGTH=3
  LABEL="Chronic condition indicator 11"

  CHRON12                    LENGTH=3
  LABEL="Chronic condition indicator 12"

  CHRON13                    LENGTH=3
  LABEL="Chronic condition indicator 13"

  CHRON14                    LENGTH=3
  LABEL="Chronic condition indicator 14"

  CHRON15                    LENGTH=3
  LABEL="Chronic condition indicator 15"

  CHRON16                    LENGTH=3
  LABEL="Chronic condition indicator 16"

  CHRON17                    LENGTH=3
  LABEL="Chronic condition indicator 17"

  CHRON18                    LENGTH=3
  LABEL="Chronic condition indicator 18"

  CHRON19                    LENGTH=3
  LABEL="Chronic condition indicator 19"

  CHRON20                    LENGTH=3
  LABEL="Chronic condition indicator 20"

  CHRON21                    LENGTH=3
  LABEL="Chronic condition indicator 21"

  CHRON22                    LENGTH=3
  LABEL="Chronic condition indicator 22"

  CHRON23                    LENGTH=3
  LABEL="Chronic condition indicator 23"

  CHRON24                    LENGTH=3
  LABEL="Chronic condition indicator 24"

  CHRON25                    LENGTH=3
  LABEL="Chronic condition indicator 25"

  CHRONB1                    LENGTH=3
  LABEL="Chronic condition body system 1"

  CHRONB2                    LENGTH=3
  LABEL="Chronic condition body system 2"

  CHRONB3                    LENGTH=3
  LABEL="Chronic condition body system 3"

  CHRONB4                    LENGTH=3
  LABEL="Chronic condition body system 4"

  CHRONB5                    LENGTH=3
  LABEL="Chronic condition body system 5"

  CHRONB6                    LENGTH=3
  LABEL="Chronic condition body system 6"

  CHRONB7                    LENGTH=3
  LABEL="Chronic condition body system 7"

  CHRONB8                    LENGTH=3
  LABEL="Chronic condition body system 8"

  CHRONB9                    LENGTH=3
  LABEL="Chronic condition body system 9"

  CHRONB10                   LENGTH=3
  LABEL="Chronic condition body system 10"

  CHRONB11                   LENGTH=3
  LABEL="Chronic condition body system 11"

  CHRONB12                   LENGTH=3
  LABEL="Chronic condition body system 12"

  CHRONB13                   LENGTH=3
  LABEL="Chronic condition body system 13"

  CHRONB14                   LENGTH=3
  LABEL="Chronic condition body system 14"

  CHRONB15                   LENGTH=3
  LABEL="Chronic condition body system 15"

  CHRONB16                   LENGTH=3
  LABEL="Chronic condition body system 16"

  CHRONB17                   LENGTH=3
  LABEL="Chronic condition body system 17"

  CHRONB18                   LENGTH=3
  LABEL="Chronic condition body system 18"

  CHRONB19                   LENGTH=3
  LABEL="Chronic condition body system 19"

  CHRONB20                   LENGTH=3
  LABEL="Chronic condition body system 20"

  CHRONB21                   LENGTH=3
  LABEL="Chronic condition body system 21"

  CHRONB22                   LENGTH=3
  LABEL="Chronic condition body system 22"

  CHRONB23                   LENGTH=3
  LABEL="Chronic condition body system 23"

  CHRONB24                   LENGTH=3
  LABEL="Chronic condition body system 24"

  CHRONB25                   LENGTH=3
  LABEL="Chronic condition body system 25"

  DXMCCS1                    LENGTH=$11
  LABEL="Multi-Level CCS:  Diagnosis 1"

  E_MCCS1                    LENGTH=$11
  LABEL="Multi-Level CCS:  E Code 1"

  PCLASS1                    LENGTH=3
  LABEL="Procedure class 1"

  PCLASS2                    LENGTH=3
  LABEL="Procedure class 2"

  PCLASS3                    LENGTH=3
  LABEL="Procedure class 3"

  PCLASS4                    LENGTH=3
  LABEL="Procedure class 4"

  PCLASS5                    LENGTH=3
  LABEL="Procedure class 5"

  PCLASS6                    LENGTH=3
  LABEL="Procedure class 6"

  PCLASS7                    LENGTH=3
  LABEL="Procedure class 7"

  PCLASS8                    LENGTH=3
  LABEL="Procedure class 8"

  PCLASS9                    LENGTH=3
  LABEL="Procedure class 9"

  PCLASS10                   LENGTH=3
  LABEL="Procedure class 10"

  PCLASS11                   LENGTH=3
  LABEL="Procedure class 11"

  PCLASS12                   LENGTH=3
  LABEL="Procedure class 12"

  PCLASS13                   LENGTH=3
  LABEL="Procedure class 13"

  PCLASS14                   LENGTH=3
  LABEL="Procedure class 14"

  PCLASS15                   LENGTH=3
  LABEL="Procedure class 15"

  PRMCCS1                    LENGTH=$8
  LABEL="Multi-Level CCS:  Procedure 1"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      HOSP_KID                 N5PF.
      @6      RECNUM                   N8PF.
      @14     CHRON1                   N3PF.
      @17     CHRON2                   N3PF.
      @20     CHRON3                   N3PF.
      @23     CHRON4                   N3PF.
      @26     CHRON5                   N3PF.
      @29     CHRON6                   N3PF.
      @32     CHRON7                   N3PF.
      @35     CHRON8                   N3PF.
      @38     CHRON9                   N3PF.
      @41     CHRON10                  N3PF.
      @44     CHRON11                  N3PF.
      @47     CHRON12                  N3PF.
      @50     CHRON13                  N3PF.
      @53     CHRON14                  N3PF.
      @56     CHRON15                  N3PF.
      @59     CHRON16                  N3PF.
      @62     CHRON17                  N3PF.
      @65     CHRON18                  N3PF.
      @68     CHRON19                  N3PF.
      @71     CHRON20                  N3PF.
      @74     CHRON21                  N3PF.
      @77     CHRON22                  N3PF.
      @80     CHRON23                  N3PF.
      @83     CHRON24                  N3PF.
      @86     CHRON25                  N3PF.
      @89     CHRONB1                  N3PF.
      @92     CHRONB2                  N3PF.
      @95     CHRONB3                  N3PF.
      @98     CHRONB4                  N3PF.
      @101    CHRONB5                  N3PF.
      @104    CHRONB6                  N3PF.
      @107    CHRONB7                  N3PF.
      @110    CHRONB8                  N3PF.
      @113    CHRONB9                  N3PF.
      @116    CHRONB10                 N3PF.
      @119    CHRONB11                 N3PF.
      @122    CHRONB12                 N3PF.
      @125    CHRONB13                 N3PF.
      @128    CHRONB14                 N3PF.
      @131    CHRONB15                 N3PF.
      @134    CHRONB16                 N3PF.
      @137    CHRONB17                 N3PF.
      @140    CHRONB18                 N3PF.
      @143    CHRONB19                 N3PF.
      @146    CHRONB20                 N3PF.
      @149    CHRONB21                 N3PF.
      @152    CHRONB22                 N3PF.
      @155    CHRONB23                 N3PF.
      @158    CHRONB24                 N3PF.
      @161    CHRONB25                 N3PF.
      @164    DXMCCS1                  $CHAR11.
      @175    E_MCCS1                  $CHAR11.
      @186    PCLASS1                  N3PF.
      @189    PCLASS2                  N3PF.
      @192    PCLASS3                  N3PF.
      @195    PCLASS4                  N3PF.
      @198    PCLASS5                  N3PF.
      @201    PCLASS6                  N3PF.
      @204    PCLASS7                  N3PF.
      @207    PCLASS8                  N3PF.
      @210    PCLASS9                  N3PF.
      @213    PCLASS10                 N3PF.
      @216    PCLASS11                 N3PF.
      @219    PCLASS12                 N3PF.
      @222    PCLASS13                 N3PF.
      @225    PCLASS14                 N3PF.
      @228    PCLASS15                 N3PF.
      @231    PRMCCS1                  $CHAR8.
      ;
RUN;
