/*****************************************************************************
* Stataload_KID_2009_Hospital.Do
* This program will load the 2009 KID ASCII Hospital File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix str    AHAID                       1-  7   ///
      long   HFIPSSTCO                   8- 12   ///
      str    HOSPADDR                   13- 72   ///
      str    HOSPCITY                   73- 92   ///
      long   HOSPID                     93- 97   ///
      str    HOSPNAME                   98-187   ///
      str    HOSPST                    188-189   ///
      long   HOSPSTCO                  190-194   ///
      str    HOSPZIP                   195-199   ///
      byte   HOSP_BEDSIZE              200-201   ///
      byte   HOSP_CONTROL              202-203   ///
      byte   HOSP_LOCATION             204-205   ///
      byte   HOSP_LOCTEACH             206-207   ///
      byte   HOSP_REGION               208-209   ///
      byte   HOSP_TEACH                210-211   ///
      str    IDNUMBER                  212-217   ///
      int    KID_STRATUM               218-221   ///
      byte   NACHTYPE                  222-223   ///
      long   N_BRTH_U                  224-229   ///
      long   N_DISC_U                  230-237   ///
      int    N_HOSP_U                  238-241   ///
      long   PEDS_DISC                 242-247   ///
      double PEDS_PCT                  248-255   ///
      long   S_BRTH_U                  256-261   ///
      long   S_CHLD_U                  262-267   ///
      long   S_CMPB_U                  268-273   ///
      long   S_DISC_U                  274-279   ///
      int    S_HOSP_U                  280-283   ///
      long   S_UNCB_U                  284-289   ///
      long   TOTAL_DISC                290-295   ///
      int    YEAR                      296-299   ///
      byte   H_CONTRL                  300-301   ///
      int    HOSP_RNPCT                302-304   ///
      float  HOSP_RNFTEAPD             305-308   ///
      float  HOSP_LPNFTEAPD            309-312   ///
      float  HOSP_NAFTEAPD             313-316   ///
      int    HOSP_OPSURGPCT            317-319   ///
      byte   HOSP_MHSMEMBER            320-321   ///
      byte   HOSP_MHSCLUSTER           322-323   ///
      using  "KID_2009_Hospital.ASC"

***  Assign labels to the data elements ***
label var AHAID                    "AHA hospital identifier"
label var HFIPSSTCO                "Hospital FIPS state/county code"
label var HOSPADDR                 "Hospital address from AHA Survey (Z011)"
label var HOSPCITY                 "Hospital city from AHA Survey (Z012)"
label var HOSPID                   "HCUP hospital identification number"
label var HOSPNAME                 "Hospital name from AHA Survey (Z000)"
label var HOSPST                   "Hospital state postal code"
label var HOSPSTCO                 "Hospital modified FIPS state/county code"
label var HOSPZIP                  "Hospital ZIP Code from AHA Survey (Z014)"
label var HOSP_BEDSIZE             "Bedsize of hospital"
label var HOSP_CONTROL             "Control/ownership of hospital"
label var HOSP_LOCATION            "Location (urban/rural) of hospital"
label var HOSP_LOCTEACH            "Location/teaching status of hospital"
label var HOSP_REGION              "Region of hospital"
label var HOSP_TEACH               "Teaching status of hospital"
label var IDNUMBER                 "AHA hospital identifier without the leading 6"
label var KID_STRATUM              "Hospital stratum used for weights"
label var NACHTYPE                 "NACHRI hospital type"
label var N_BRTH_U                 "Number of universe births in KID_STRATUM"
label var N_DISC_U                 "Number of universe discharges in KID_STRATUM"
label var N_HOSP_U                 "Number of universe hospitals in KID_STRATUM"
label var PEDS_DISC                "Number of discharges, 20 years old or younger, from this hospital in the SID"
label var PEDS_PCT                 "Percentage of hospital discharges, 20 years old or younger"
label var S_BRTH_U                 "Number of sample births in KID_STRATUM"
label var S_CHLD_U                 "Number of sample pediatric non-births in KID_STRATUM"
label var S_CMPB_U                 "Number of sample complicated births in KID_STRATUM"
label var S_DISC_U                 "Number of sample births and children in KID_STRATUM"
label var S_HOSP_U                 "Number of sample hospitals in KID_STRATUM"
label var S_UNCB_U                 "Number of sample uncomplicated births in KID_STRATUM"
label var TOTAL_DISC               "Total number of discharges from this hospital in the SID"
label var YEAR                     "Calendar year"
label var H_CONTRL                 "Control/ownership of hospital"
label var HOSP_RNPCT               "Percentage of RNs among licensed nurses"
label var HOSP_RNFTEAPD            "RN FTEs per 1000 adjusted patient days"
label var HOSP_LPNFTEAPD           "LPN FTEs per 1000 adjusted patient days"
label var HOSP_NAFTEAPD            "Nurse aides per 1000 adjusted patient days"
label var HOSP_OPSURGPCT           "Percentage of all surgeries performed in outpatient setting"
label var HOSP_MHSMEMBER           "Hospital is part of multiple hospital system-@"
label var HOSP_MHSCLUSTER          "AHA multiple hospital system cluster code"

*** Convert special values to missing values ***
recode HFIPSSTCO                 (-9999 -8888 -6666=.)
recode HOSPSTCO                  (-9999 -8888 -6666=.)
recode HOSP_BEDSIZE              (-9 -8 -6 -5=.)
recode HOSP_CONTROL              (-9 -8 -6 -5=.)
recode HOSP_LOCATION             (-9 -8 -6 -5=.)
recode HOSP_LOCTEACH             (-9 -8 -6 -5=.)
recode HOSP_REGION               (-9 -8 -6 -5=.)
recode HOSP_TEACH                (-9 -8 -6 -5=.)
recode KID_STRATUM               (-999 -888 -666=.)
recode NACHTYPE                  (-9 -8 -6 -5=.)
recode N_BRTH_U                  (-99999 -88888 -66666=.)
recode N_DISC_U                  (-9999999 -8888888 -6666666=.)
recode N_HOSP_U                  (-999 -888 -666=.)
recode PEDS_DISC                 (-99999 -88888 -66666=.)
recode PEDS_PCT                  (-99.9999 -88.8888 -66.6666=.)
recode S_BRTH_U                  (-99999 -88888 -66666=.)
recode S_CHLD_U                  (-99999 -88888 -66666=.)
recode S_CMPB_U                  (-99999 -88888 -66666=.)
recode S_DISC_U                  (-99999 -88888 -66666=.)
recode S_HOSP_U                  (-999 -888 -666=.)
recode S_UNCB_U                  (-99999 -88888 -66666=.)
recode TOTAL_DISC                (-99999 -88888 -66666=.)
recode YEAR                      (-999 -888 -666=.)
recode H_CONTRL                  (-9 -8 -6 -5=.)
recode HOSP_RNPCT                (-99 -88 -66=.)
recode HOSP_RNFTEAPD             (-9.9 -8.8 -6.6=.)
recode HOSP_LPNFTEAPD            (-9.9 -8.8 -6.6=.)
recode HOSP_NAFTEAPD             (-9.9 -8.8 -6.6=.)
recode HOSP_OPSURGPCT            (-99 -88 -66=.)
recode HOSP_MHSMEMBER            (-9 -8 -6 -5=.)
recode HOSP_MHSCLUSTER           (-9 -8 -6 -5=.)

save "KID_2009_Hospital.dta", replace
