/*****************************************************************************
* Stataload_KID_2022_Severity.Do
* This program will load the KID_2022_Severity ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
* Created on 11/07/2024.
*****************************************************************************/

*** Read data elements from the ASCII file ***
infix long   HOSP_KID                     1-   5   ///
      long   RECNUM                       6-  13   ///
      int    APRDRG                      14-  17   ///
      byte   APRDRG_Risk_Mortality       18-  19   ///
      byte   APRDRG_Severity             20-  21   ///
      using  "KID_2022_Severity.ASC"

***  Assign labels to the data elements ***
label var HOSP_KID                 "KID hospital number"
label var RECNUM                   "KID record number"
label var APRDRG                   "All Patient Refined DRG"
label var APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
label var APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"

*** Convert special values to missing values ***
recode HOSP_KID                  (-9999 -8888 -6666=.)
recode RECNUM                    (-9999999 -8888888 -6666666=.)
recode APRDRG                    (-999 -888 -666=.)
recode APRDRG_Risk_Mortality     (-9 -8 -6 -5=.)
recode APRDRG_Severity           (-9 -8 -6 -5=.)

save "KID_2022_Severity.dta", replace
