/*****************************************************************************
 * SASload_NASS_2016_Hospital.SAS
 * This program will load the NASS 2016 Hospital csv File into SAS.
 *****************************************************************************/

/* Create SAS informats for missing values */
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

/* Data Step to load the file */
DATA Hospital; 
INFILE 'Hospital.csv' dsd dlm=',' LRECL = 83;

/* Define data element attributes */
ATTRIB 
  HOSP_NASS                  LENGTH=4
  LABEL="NASS Hospital Number"

  HOSP_CONTROL               LENGTH=5
  LABEL="AHA: Control/ownership of hospital"

  HOSP_TEACH                 LENGTH=3
  LABEL="AHA: Teaching status of hospital, 0:non-teaching, 1: teaching"

  HOSP_LOCATION              LENGTH=3
  LABEL="AHA: Location of Hospital, 0:rural, 1:urban"

  HOSP_LOCTEACH              LENGTH=3
  LABEL="Location/teaching status of hospital			"

  HOSP_REGION                LENGTH=8
  LABEL="Hospital Census Region, 1:Northeast, 2:Midwest, 3:South, 4:West"

  HOSP_BEDSIZE_CAT           LENGTH=3
  LABEL="Hospital Beds 1:0-99 2:100-299 3:300+"

  DISCWT                     LENGTH=8
  LABEL="Encounter Weight"

  NASS_STRATUM               LENGTH=$4
  LABEL="NASS sample stratum"

  N_DISC_U                   LENGTH=8
  LABEL="Total Number of AS Encounters for all Hospitals in NASS_STRATUM"

  N_HOSP_U                   LENGTH=8
  LABEL="Total Number of Hospitals in NASS_STRATUM"

  S_DISC_U                   LENGTH=8
  LABEL="Total Number of AS Encounters for Sampled Hospitals in NASS STRATUM"

  S_HOSP_U                   LENGTH=8
  LABEL="Total Number of Sampled Hospitals in NASS STRATUM"

  TOTAL_AS_ENCOUNTERS        LENGTH=8
  LABEL="SASD encounters with >= 1 narrow surgery"

  YEAR                       LENGTH=8
  LABEL="Data Year"
  ;

/* Read data elements from the CSV file */
INPUT 
      HOSP_NASS                :N5PF.
      HOSP_CONTROL             :N2PF.
      HOSP_TEACH               :N2PF.
      HOSP_LOCATION            :N2PF.
      HOSP_LOCTEACH            :N2PF.
      HOSP_REGION              :N2PF.
      HOSP_BEDSIZE_CAT         :N2PF.
      DISCWT                   :N11P7F.
      NASS_STRATUM             :$CHAR4.
      N_DISC_U                 :N8PF.
      N_HOSP_U                 :N4PF.
      S_DISC_U                 :N8PF.
      S_HOSP_U                 :N4PF.
      TOTAL_AS_ENCOUNTERS      :N8PF.
      YEAR                     :N4PF.
      ;
RUN;
