/*****************************************************************************/
/* SPSSload_NASS_2023_Encounter.SPS                                          */
/* This program will load the NASS 2023 Encounter csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NASS_2023_Encounter.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_NASS                F5.0
    KEY_NASS                 F8.0
    AGE                      F3.0
    AMONTH                   F2.0
    AWEEKEND                 F2.0
    CPT1                     A5
    CPT2                     A5
    CPT3                     A5
    CPT4                     A5
    CPT5                     A5
    CPT6                     A5
    CPT7                     A5
    CPT8                     A5
    CPT9                     A5
    CPT10                    A5
    CPT11                    A5
    CPT12                    A5
    CPT13                    A5
    CPT14                    A5
    CPT15                    A5
    CPT16                    A5
    CPT17                    A5
    CPT18                    A5
    CPT19                    A5
    CPT20                    A5
    CPT21                    A5
    CPT22                    A5
    CPT23                    A5
    CPT24                    A5
    CPT25                    A5
    CPT26                    A5
    CPT27                    A5
    CPT28                    A5
    CPT29                    A5
    CPT30                    A5
    CPTCCS1                  F4.0
    CPTCCS2                  F4.0
    CPTCCS3                  F4.0
    CPTCCS4                  F4.0
    CPTCCS5                  F4.0
    CPTCCS6                  F4.0
    CPTCCS7                  F4.0
    CPTCCS8                  F4.0
    CPTCCS9                  F4.0
    CPTCCS10                 F4.0
    CPTCCS11                 F4.0
    CPTCCS12                 F4.0
    CPTCCS13                 F4.0
    CPTCCS14                 F4.0
    CPTCCS15                 F4.0
    CPTCCS16                 F4.0
    CPTCCS17                 F4.0
    CPTCCS18                 F4.0
    CPTCCS19                 F4.0
    CPTCCS20                 F4.0
    CPTCCS21                 F4.0
    CPTCCS22                 F4.0
    CPTCCS23                 F4.0
    CPTCCS24                 F4.0
    CPTCCS25                 F4.0
    CPTCCS26                 F4.0
    CPTCCS27                 F4.0
    CPTCCS28                 F4.0
    CPTCCS29                 F4.0
    CPTCCS30                 F4.0
    DISCWT                   F11.7
    DISPUNIFORM              F2.0
    DQTR                     F2.0
    FEMALE                   F2.0
    I10_DX1                  A7
    I10_DX2                  A7
    I10_DX3                  A7
    I10_DX4                  A7
    I10_DX5                  A7
    I10_DX6                  A7
    I10_DX7                  A7
    I10_DX8                  A7
    I10_DX9                  A7
    I10_DX10                 A7
    I10_DX11                 A7
    I10_DX12                 A7
    I10_DX13                 A7
    I10_DX14                 A7
    I10_DX15                 A7
    I10_DX16                 A7
    I10_DX17                 A7
    I10_DX18                 A7
    I10_DX19                 A7
    I10_DX20                 A7
    I10_DX21                 A7
    I10_DX22                 A7
    I10_DX23                 A7
    I10_DX24                 A7
    I10_DX25                 A7
    I10_DX26                 A7
    I10_DX27                 A7
    I10_DX28                 A7
    I10_DX29                 A7
    I10_DX30                 A7
    I10_INJURY               F3.0
    I10_MULTINJURY           F3.0
    I10_NDX                  F3.0
    NASS_STRATUM             A2
    NCPT_INSCOPE             F3.0
    PAY1                     F2.0
    YEAR                     F4.0
    ZIPINC_QRTL              F2.0
    PL_NCHS2                 F3.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_NASS                "NASS Hospital Number"
    KEY_NASS                 "NASS Record Number"
    AGE                      "Age in years at admission"
    AMONTH                   "Admission Month, 1-12"
    AWEEKEND                 "Admission day is a weekend"
    CPT1                     "CPT Procedure 1"
    CPT2                     "CPT Procedure 2"
    CPT3                     "CPT Procedure 3"
    CPT4                     "CPT Procedure 4"
    CPT5                     "CPT Procedure 5"
    CPT6                     "CPT Procedure 6"
    CPT7                     "CPT Procedure 7"
    CPT8                     "CPT Procedure 8"
    CPT9                     "CPT Procedure 9"
    CPT10                    "CPT Procedure 10"
    CPT11                    "CPT Procedure 11"
    CPT12                    "CPT Procedure 12"
    CPT13                    "CPT Procedure 13"
    CPT14                    "CPT Procedure 14"
    CPT15                    "CPT Procedure 15"
    CPT16                    "CPT Procedure 16"
    CPT17                    "CPT Procedure 17"
    CPT18                    "CPT Procedure 18"
    CPT19                    "CPT Procedure 19"
    CPT20                    "CPT Procedure 20"
    CPT21                    "CPT Procedure 21"
    CPT22                    "CPT Procedure 22"
    CPT23                    "CPT Procedure 23"
    CPT24                    "CPT Procedure 24"
    CPT25                    "CPT Procedure 25"
    CPT26                    "CPT Procedure 26"
    CPT27                    "CPT Procedure 27"
    CPT28                    "CPT Procedure 28"
    CPT29                    "CPT Procedure 29"
    CPT30                    "CPT Procedure 30"
    CPTCCS1                  "CPT 1 Procedure CCS"
    CPTCCS2                  "CPT 2 Procedure CCS"
    CPTCCS3                  "CPT 3 Procedure CCS"
    CPTCCS4                  "CPT 4 Procedure CCS"
    CPTCCS5                  "CPT 5 Procedure CCS"
    CPTCCS6                  "CPT 6 Procedure CCS"
    CPTCCS7                  "CPT 7 Procedure CCS"
    CPTCCS8                  "CPT 8 Procedure CCS"
    CPTCCS9                  "CPT 9 Procedure CCS"
    CPTCCS10                 "CPT 10 Procedure CCS"
    CPTCCS11                 "CPT 11 Procedure CCS"
    CPTCCS12                 "CPT 12 Procedure CCS"
    CPTCCS13                 "CPT 13 Procedure CCS"
    CPTCCS14                 "CPT 14 Procedure CCS"
    CPTCCS15                 "CPT 15 Procedure CCS"
    CPTCCS16                 "CPT 16 Procedure CCS"
    CPTCCS17                 "CPT 17 Procedure CCS"
    CPTCCS18                 "CPT 18 Procedure CCS"
    CPTCCS19                 "CPT 19 Procedure CCS"
    CPTCCS20                 "CPT 20 Procedure CCS"
    CPTCCS21                 "CPT 21 Procedure CCS"
    CPTCCS22                 "CPT 22 Procedure CCS"
    CPTCCS23                 "CPT 23 Procedure CCS"
    CPTCCS24                 "CPT 24 Procedure CCS"
    CPTCCS25                 "CPT 25 Procedure CCS"
    CPTCCS26                 "CPT 26 Procedure CCS"
    CPTCCS27                 "CPT 27 Procedure CCS"
    CPTCCS28                 "CPT 28 Procedure CCS"
    CPTCCS29                 "CPT 29 Procedure CCS"
    CPTCCS30                 "CPT 30 Procedure CCS"
    DISCWT                   "Encounter Weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    FEMALE                   "Indicator of sex"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_INJURY
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)"
    I10_MULTINJURY           "Multiple ICD-10-CM injuries reported on record"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    NASS_STRATUM             "NASS Sample Stratum"
    NCPT_INSCOPE             "Number of In-Scope CPTs for this encounter"
    PAY1                     "Primary expected payer (uniform)"
    YEAR                     "Data Year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
    PL_NCHS2                 "Patient Location: NCHS Urban-Rural Code (collapsed)" .

/* Convert special values to system missing values */
RECODE HOSP_NASS                (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NASS                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE CPTCCS1                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS2                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS3                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS4                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS5                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS6                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS7                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS8                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS9                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS10                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS11                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS12                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS13                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS14                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS15                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS16                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS17                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS18                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS19                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS20                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS21                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS22                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS23                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS24                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS25                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS26                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS27                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS28                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS29                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS30                 (-999 -888 -666=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY               (-99 -88 -66=SYSMIS).
RECODE I10_MULTINJURY           (-99 -88 -66=SYSMIS).
RECODE I10_NDX                  (-99 -88 -66=SYSMIS).
RECODE NCPT_INSCOPE             (-99 -88 -66=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NASS_2023_Encounter.SAV' / COMPRESSED.
