/*****************************************************************************/
/* SPSSload_NEDS_2015Q4_ED.SPS                                          */
/* This program will load the NEDS 2015 Q4 ED csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2015Q4_ED.csv"
    /delimiters = ',' 
    /variables = 
    CPT1                     A5
    CPT2                     A5
    CPT3                     A5
    CPT4                     A5
    CPT5                     A5
    CPT6                     A5
    CPT7                     A5
    CPT8                     A5
    CPT9                     A5
    CPT10                    A5
    CPT11                    A5
    CPT12                    A5
    CPT13                    A5
    CPT14                    A5
    CPT15                    A5
    CPTCCS1                  F4.0
    CPTCCS2                  F4.0
    CPTCCS3                  F4.0
    CPTCCS4                  F4.0
    CPTCCS5                  F4.0
    CPTCCS6                  F4.0
    CPTCCS7                  F4.0
    CPTCCS8                  F4.0
    CPTCCS9                  F4.0
    CPTCCS10                 F4.0
    CPTCCS11                 F4.0
    CPTCCS12                 F4.0
    CPTCCS13                 F4.0
    CPTCCS14                 F4.0
    CPTCCS15                 F4.0
    DXVER                    F2.0
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    I10_DX1                  A7
    I10_DX2                  A7
    I10_DX3                  A7
    I10_DX4                  A7
    I10_DX5                  A7
    I10_DX6                  A7
    I10_DX7                  A7
    I10_DX8                  A7
    I10_DX9                  A7
    I10_DX10                 A7
    I10_DX11                 A7
    I10_DX12                 A7
    I10_DX13                 A7
    I10_DX14                 A7
    I10_DX15                 A7
    I10_DX16                 A7
    I10_DX17                 A7
    I10_DX18                 A7
    I10_DX19                 A7
    I10_DX20                 A7
    I10_DX21                 A7
    I10_DX22                 A7
    I10_DX23                 A7
    I10_DX24                 A7
    I10_DX25                 A7
    I10_DX26                 A7
    I10_DX27                 A7
    I10_DX28                 A7
    I10_DX29                 A7
    I10_DX30                 A7
    I10_ECAUSE1              A7
    I10_ECAUSE2              A7
    I10_ECAUSE3              A7
    I10_ECAUSE4              A7
    I10_NDX                  F3.0
    I10_NECAUSE              F3.0
    KEY_ED                   F16.0
    NCPT                     F4.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    CPT1                     "CPT/HCPCS procedure code 1"
    CPT2                     "CPT/HCPCS procedure code 2"
    CPT3                     "CPT/HCPCS procedure code 3"
    CPT4                     "CPT/HCPCS procedure code 4"
    CPT5                     "CPT/HCPCS procedure code 5"
    CPT6                     "CPT/HCPCS procedure code 6"
    CPT7                     "CPT/HCPCS procedure code 7"
    CPT8                     "CPT/HCPCS procedure code 8"
    CPT9                     "CPT/HCPCS procedure code 9"
    CPT10                    "CPT/HCPCS procedure code 10"
    CPT11                    "CPT/HCPCS procedure code 11"
    CPT12                    "CPT/HCPCS procedure code 12"
    CPT13                    "CPT/HCPCS procedure code 13"
    CPT14                    "CPT/HCPCS procedure code 14"
    CPT15                    "CPT/HCPCS procedure code 15"
    CPTCCS1                  "CCS: CPT 1"
    CPTCCS2                  "CCS: CPT 2"
    CPTCCS3                  "CCS: CPT 3"
    CPTCCS4                  "CCS: CPT 4"
    CPTCCS5                  "CCS: CPT 5"
    CPTCCS6                  "CCS: CPT 6"
    CPTCCS7                  "CCS: CPT 7"
    CPTCCS8                  "CCS: CPT 8"
    CPTCCS9                  "CCS: CPT 9"
    CPTCCS10                 "CCS: CPT 10"
    CPTCCS11                 "CCS: CPT 11"
    CPTCCS12                 "CCS: CPT 12"
    CPTCCS13                 "CCS: CPT 13"
    CPTCCS14                 "CCS: CPT 14"
    CPTCCS15                 "CCS: CPT 15"
    DXVER                    "Diagnosis Version"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_ECAUSE1              "ICD-10-CM External cause 1"
    I10_ECAUSE2              "ICD-10-CM External cause 2"
    I10_ECAUSE3              "ICD-10-CM External cause 3"
    I10_ECAUSE4              "ICD-10-CM External cause 4"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NECAUSE              "ICD-10-CM Number of external cause codes on this record"
    KEY_ED                   "HCUP NEDS record identifier"
    NCPT                     "Number of CPT/HCPCS procedures for this visit" .

/* Convert special values to system missing values */
RECODE CPTCCS1                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS2                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS3                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS4                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS5                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS6                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS7                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS8                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS9                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS10                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS11                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS12                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS13                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS14                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS15                 (-999 -888 -666=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE I10_NDX                  (-99 -88 -66=SYSMIS).
RECODE I10_NECAUSE              (-99 -88 -66=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE NCPT                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NEDS_2015Q4_ED.SAV' / COMPRESSED.
