/*****************************************************************************
* SASload_NIS_2006_Dx_Pr_Grps.SAS
* This program will load the 2006 NIS ASCII Dx_Pr_Grps File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NIS_2006_Dx_Pr_Grps; 
INFILE 'NIS_2006_Dx_Pr_Grps.ASC' LRECL = 271;                                                                                                                                                                                                    

*** Define data element attributes ***;
ATTRIB 
  HOSPID                     LENGTH=4            FORMAT=Z5.
  LABEL="HCUP hospital identification number"

  KEY                        LENGTH=8            FORMAT=Z14.
  LABEL="HCUP record identifier"

  CCSMGN1                    LENGTH=3
  LABEL="CCS-MHSA general category: principal diagnosis"

  CCSMGN2                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 2"

  CCSMGN3                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 3"

  CCSMGN4                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 4"

  CCSMGN5                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 5"

  CCSMGN6                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 6"

  CCSMGN7                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 7"

  CCSMGN8                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 8"

  CCSMGN9                    LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 9"

  CCSMGN10                   LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 10"

  CCSMGN11                   LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 11"

  CCSMGN12                   LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 12"

  CCSMGN13                   LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 13"

  CCSMGN14                   LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 14"

  CCSMGN15                   LENGTH=3
  LABEL="CCS-MHSA general category: diagnosis 15"

  CCSMSP1                    LENGTH=3
  LABEL="CCS-MHSA specific category: principal diagnosis"

  CCSMSP2                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 2"

  CCSMSP3                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 3"

  CCSMSP4                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 4"

  CCSMSP5                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 5"

  CCSMSP6                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 6"

  CCSMSP7                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 7"

  CCSMSP8                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 8"

  CCSMSP9                    LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 9"

  CCSMSP10                   LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 10"

  CCSMSP11                   LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 11"

  CCSMSP12                   LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 12"

  CCSMSP13                   LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 13"

  CCSMSP14                   LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 14"

  CCSMSP15                   LENGTH=3
  LABEL="CCS-MHSA specific category: diagnosis 15"

  CHRON1                     LENGTH=3
  LABEL="Chronic condition indicator 1"

  CHRON2                     LENGTH=3
  LABEL="Chronic condition indicator 2"

  CHRON3                     LENGTH=3
  LABEL="Chronic condition indicator 3"

  CHRON4                     LENGTH=3
  LABEL="Chronic condition indicator 4"

  CHRON5                     LENGTH=3
  LABEL="Chronic condition indicator 5"

  CHRON6                     LENGTH=3
  LABEL="Chronic condition indicator 6"

  CHRON7                     LENGTH=3
  LABEL="Chronic condition indicator 7"

  CHRON8                     LENGTH=3
  LABEL="Chronic condition indicator 8"

  CHRON9                     LENGTH=3
  LABEL="Chronic condition indicator 9"

  CHRON10                    LENGTH=3
  LABEL="Chronic condition indicator 10"

  CHRON11                    LENGTH=3
  LABEL="Chronic condition indicator 11"

  CHRON12                    LENGTH=3
  LABEL="Chronic condition indicator 12"

  CHRON13                    LENGTH=3
  LABEL="Chronic condition indicator 13"

  CHRON14                    LENGTH=3
  LABEL="Chronic condition indicator 14"

  CHRON15                    LENGTH=3
  LABEL="Chronic condition indicator 15"

  CHRONB1                    LENGTH=3
  LABEL="Chronic condition body system 1"

  CHRONB2                    LENGTH=3
  LABEL="Chronic condition body system 2"

  CHRONB3                    LENGTH=3
  LABEL="Chronic condition body system 3"

  CHRONB4                    LENGTH=3
  LABEL="Chronic condition body system 4"

  CHRONB5                    LENGTH=3
  LABEL="Chronic condition body system 5"

  CHRONB6                    LENGTH=3
  LABEL="Chronic condition body system 6"

  CHRONB7                    LENGTH=3
  LABEL="Chronic condition body system 7"

  CHRONB8                    LENGTH=3
  LABEL="Chronic condition body system 8"

  CHRONB9                    LENGTH=3
  LABEL="Chronic condition body system 9"

  CHRONB10                   LENGTH=3
  LABEL="Chronic condition body system 10"

  CHRONB11                   LENGTH=3
  LABEL="Chronic condition body system 11"

  CHRONB12                   LENGTH=3
  LABEL="Chronic condition body system 12"

  CHRONB13                   LENGTH=3
  LABEL="Chronic condition body system 13"

  CHRONB14                   LENGTH=3
  LABEL="Chronic condition body system 14"

  CHRONB15                   LENGTH=3
  LABEL="Chronic condition body system 15"

  ECCSMGN1                   LENGTH=3
  LABEL="CCS-MHSA general category: E Code 1"

  ECCSMGN2                   LENGTH=3
  LABEL="CCS-MHSA general category: E Code 2"

  ECCSMGN3                   LENGTH=3
  LABEL="CCS-MHSA general category: E Code 3"

  ECCSMGN4                   LENGTH=3
  LABEL="CCS-MHSA general category: E Code 4"

  PCLASS1                    LENGTH=3
  LABEL="Principal procedure class"

  PCLASS2                    LENGTH=3
  LABEL="Procedure class 2"

  PCLASS3                    LENGTH=3
  LABEL="Procedure class 3"

  PCLASS4                    LENGTH=3
  LABEL="Procedure class 4"

  PCLASS5                    LENGTH=3
  LABEL="Procedure class 5"

  PCLASS6                    LENGTH=3
  LABEL="Procedure class 6"

  PCLASS7                    LENGTH=3
  LABEL="Procedure class 7"

  PCLASS8                    LENGTH=3
  LABEL="Procedure class 8"

  PCLASS9                    LENGTH=3
  LABEL="Procedure class 9"

  PCLASS10                   LENGTH=3
  LABEL="Procedure class 10"

  PCLASS11                   LENGTH=3
  LABEL="Procedure class 11"

  PCLASS12                   LENGTH=3
  LABEL="Procedure class 12"

  PCLASS13                   LENGTH=3
  LABEL="Procedure class 13"

  PCLASS14                   LENGTH=3
  LABEL="Procedure class 14"

  PCLASS15                   LENGTH=3
  LABEL="Procedure class 15"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      HOSPID                   5.
      @6      KEY                      14.
      @20     CCSMGN1                  N3PF.
      @23     CCSMGN2                  N3PF.
      @26     CCSMGN3                  N3PF.
      @29     CCSMGN4                  N3PF.
      @32     CCSMGN5                  N3PF.
      @35     CCSMGN6                  N3PF.
      @38     CCSMGN7                  N3PF.
      @41     CCSMGN8                  N3PF.
      @44     CCSMGN9                  N3PF.
      @47     CCSMGN10                 N3PF.
      @50     CCSMGN11                 N3PF.
      @53     CCSMGN12                 N3PF.
      @56     CCSMGN13                 N3PF.
      @59     CCSMGN14                 N3PF.
      @62     CCSMGN15                 N3PF.
      @65     CCSMSP1                  N4PF.
      @69     CCSMSP2                  N4PF.
      @73     CCSMSP3                  N4PF.
      @77     CCSMSP4                  N4PF.
      @81     CCSMSP5                  N4PF.
      @85     CCSMSP6                  N4PF.
      @89     CCSMSP7                  N4PF.
      @93     CCSMSP8                  N4PF.
      @97     CCSMSP9                  N4PF.
      @101    CCSMSP10                 N4PF.
      @105    CCSMSP11                 N4PF.
      @109    CCSMSP12                 N4PF.
      @113    CCSMSP13                 N4PF.
      @117    CCSMSP14                 N4PF.
      @121    CCSMSP15                 N4PF.
      @125    CHRON1                   N3PF.
      @128    CHRON2                   N3PF.
      @131    CHRON3                   N3PF.
      @134    CHRON4                   N3PF.
      @137    CHRON5                   N3PF.
      @140    CHRON6                   N3PF.
      @143    CHRON7                   N3PF.
      @146    CHRON8                   N3PF.
      @149    CHRON9                   N3PF.
      @152    CHRON10                  N3PF.
      @155    CHRON11                  N3PF.
      @158    CHRON12                  N3PF.
      @161    CHRON13                  N3PF.
      @164    CHRON14                  N3PF.
      @167    CHRON15                  N3PF.
      @170    CHRONB1                  N3PF.
      @173    CHRONB2                  N3PF.
      @176    CHRONB3                  N3PF.
      @179    CHRONB4                  N3PF.
      @182    CHRONB5                  N3PF.
      @185    CHRONB6                  N3PF.
      @188    CHRONB7                  N3PF.
      @191    CHRONB8                  N3PF.
      @194    CHRONB9                  N3PF.
      @197    CHRONB10                 N3PF.
      @200    CHRONB11                 N3PF.
      @203    CHRONB12                 N3PF.
      @206    CHRONB13                 N3PF.
      @209    CHRONB14                 N3PF.
      @212    CHRONB15                 N3PF.
      @215    ECCSMGN1                 N3PF.
      @218    ECCSMGN2                 N3PF.
      @221    ECCSMGN3                 N3PF.
      @224    ECCSMGN4                 N3PF.
      @227    PCLASS1                  N3PF.
      @230    PCLASS2                  N3PF.
      @233    PCLASS3                  N3PF.
      @236    PCLASS4                  N3PF.
      @239    PCLASS5                  N3PF.
      @242    PCLASS6                  N3PF.
      @245    PCLASS7                  N3PF.
      @248    PCLASS8                  N3PF.
      @251    PCLASS9                  N3PF.
      @254    PCLASS10                 N3PF.
      @257    PCLASS11                 N3PF.
      @260    PCLASS12                 N3PF.
      @263    PCLASS13                 N3PF.
      @266    PCLASS14                 N3PF.
      @269    PCLASS15                 N3PF.
      ;
RUN;
