/*****************************************************************************
* SASload_NIS_2011_Hospital.SAS
* This program will load the 2011 NIS ASCII Hospital File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NIS_2011_Hospital; 
INFILE 'NIS_2011_Hospital.ASC' LRECL = 299;

*** Define data element attributes ***;
ATTRIB 
  HOSPST                     LENGTH=$2           FORMAT=$8.
  LABEL="Hospital state postal code"

  AHAID                      LENGTH=$7
  LABEL="AHA hospital identifier with the leading 6"

  DISCWT                     LENGTH=8
  LABEL="Weight to discharges in AHA universe"

  HFIPSSTCO                  LENGTH=4
  LABEL="Hospital FIPS state/county code"

  H_CONTRL                   LENGTH=3
  LABEL="Control/ownership of hospital"

  HOSPADDR                   LENGTH=$60
  LABEL="Hospital address from AHA Survey (Z011)"

  HOSPCITY                   LENGTH=$20
  LABEL="Hospital city from AHA Survey (Z012)"

  HOSPID                     LENGTH=4            FORMAT=Z5.
  LABEL="HCUP hospital identification number"

  HOSPNAME                   LENGTH=$90
  LABEL="Hospital name from AHA Survey (Z000)"

  HOSPSTCO                   LENGTH=4            FORMAT=Z5.
  LABEL="Hospital modified FIPS state/county code"

  HOSPWT                     LENGTH=8
  LABEL="Weight to hospitals in AHA universe"

  HOSPZIP                    LENGTH=$5
  LABEL="Hospital ZIP Code from AHA Survey (Z014)"

  HOSP_BEDSIZE               LENGTH=3            FORMAT=1.
  LABEL="Bed size of hospital (STRATA)"

  HOSP_CONTROL               LENGTH=3            FORMAT=1.
  LABEL="Control/ownership of hospital (STRATA)"

  HOSP_LOCATION              LENGTH=3            FORMAT=1.
  LABEL="Location (urban/rural) of hospital"

  HOSP_LOCTEACH              LENGTH=3            FORMAT=1.
  LABEL="Location/teaching status of hospital (STRATA)"

  HOSP_REGION                LENGTH=3            FORMAT=1.
  LABEL="Region of hospital (STRATA)"

  HOSP_TEACH                 LENGTH=3            FORMAT=1.
  LABEL="Teaching status of hospital"

  IDNUMBER                   LENGTH=$6
  LABEL="AHA hospital identifier without the leading 6"

  NIS_STRATUM                LENGTH=3            FORMAT=4.
  LABEL="Stratum used to sample hospital"

  N_DISC_U                   LENGTH=5
  LABEL="Number of AHA universe discharges in NIS_STRATUM"

  N_HOSP_U                   LENGTH=3
  LABEL="Number of AHA universe hospitals in NIS_STRATUM"

  S_DISC_U                   LENGTH=4
  LABEL="Number of sample discharges in NIS_STRATUM"

  S_HOSP_U                   LENGTH=3
  LABEL="Number of sample hospitals in NIS_STRATUM"

  TOTAL_DISC                 LENGTH=4
  LABEL="Total number of discharges from this hospital in the NIS"

  YEAR                       LENGTH=3
  LABEL="Calendar Year"

  HOSP_RNPCT                 LENGTH=3
  LABEL="Percentage of RN among licensed nurses-H"

  HOSP_RNFTEAPD              LENGTH=4            FORMAT=5.1
  LABEL="RN FTEs per 1000 adjusted patient days-H"

  HOSP_LPNFTEAPD             LENGTH=4            FORMAT=5.1
  LABEL="LPN FTEs per 1000 adjusted patient days-H"

  HOSP_NAFTEAPD              LENGTH=4            FORMAT=5.1
  LABEL="Nurse aides per 1000 adjusted patient days-H"

  HOSP_OPSURGPCT             LENGTH=3
  LABEL="Percentage of all surgeries performed in outpatient setting-H"

  HOSP_MHSMEMBER             LENGTH=3
  LABEL="Hospital is part of multiple hospital system-H"

  HOSP_MHSCLUSTER            LENGTH=3
  LABEL="AHA multiple hospital system cluster code-H"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      HOSPST                   $CHAR2.
      @3      AHAID                    $CHAR7.
      @10     DISCWT                   N11P7F.
      @21     HFIPSSTCO                N5PF.
      @26     H_CONTRL                 N2PF.
      @28     HOSPADDR                 $CHAR60.
      @88     HOSPCITY                 $CHAR20.
      @108    HOSPID                   5.
      @113    HOSPNAME                 $CHAR90.
      @203    HOSPSTCO                 N5PF.
      @208    HOSPWT                   N11P7F.
      @219    HOSPZIP                  $CHAR5.
      @224    HOSP_BEDSIZE             N2PF.
      @226    HOSP_CONTROL             N2PF.
      @228    HOSP_LOCATION            N2PF.
      @230    HOSP_LOCTEACH            N2PF.
      @232    HOSP_REGION              N2PF.
      @234    HOSP_TEACH               N2PF.
      @236    IDNUMBER                 $CHAR6.
      @242    NIS_STRATUM              N4PF.
      @246    N_DISC_U                 N8PF.
      @254    N_HOSP_U                 N4PF.
      @258    S_DISC_U                 N6PF.
      @264    S_HOSP_U                 N4PF.
      @268    TOTAL_DISC               N6PF.
      @274    YEAR                     N4PF.
      @278    HOSP_RNPCT               N3PF.
      @281    HOSP_RNFTEAPD            N4P1F.
      @285    HOSP_LPNFTEAPD           N4P1F.
      @289    HOSP_NAFTEAPD            N4P1F.
      @293    HOSP_OPSURGPCT           N3PF.
      @296    HOSP_MHSMEMBER           N2PF.
      @298    HOSP_MHSCLUSTER          N2PF.
      ;
RUN;
