/*******************************************************************
*   NIS_1998_HOSPITAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII NIS         
*      INPATIENT STAY HOSPITAL FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NIS_1998_HOSPITAL.ASC' FIXED / 
 AHAID                1-  7 (A)
 DISCWT               8- 17
 HOSPADDR            18- 47 (A)
 HOSPCITY            48- 67 (A)
 HOSPID              68- 72
 HOSPNAME            73-102 (A)
 HOSPST             103-104 (A)
 HOSPWT             105-114
 HOSPZIP            115-119 (A)
 HOSP_BED           120-121
 HOSP_CON           122-123
 HOSP_LOC           124-125
 HOSP_LT            126-127
 HOSP_REG           128-129
 HOSP_TEA           130-131
 IDNUMBER           132-137 (A)
 NIS_STRA           138-141
 N_DISC_U           142-149
 N_HOSP_U           150-153
 S_DISC_U           154-159
 S_HOSP_U           160-163
 TOTAL_DI           164-169
 YEAR               170-173.


***  Specify write formats  ***.
FORMATS
 DISCWT              (F8.4) /
 HOSPID              (F4.0) /
 HOSPWT              (F8.4) /
 HOSP_BED            (F3.0) /
 HOSP_CON            (F3.0) /
 HOSP_LOC            (F3.0) /
 HOSP_LT             (F3.0) /
 HOSP_REG            (F3.0) /
 HOSP_TEA            (F3.0) /
 NIS_STRA            (F3.0) /
 N_DISC_U            (F4.0) /
 N_HOSP_U            (F3.0) /
 S_DISC_U            (F4.0) /
 S_HOSP_U            (F3.0) /
 TOTAL_DI            (F4.0) /
 YEAR                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AHAID        "AHA hospital identifier with the leading 6"
 DISCWT       "Weight to discharges in AHA Universe"
 HOSPADDR     "Hospital address from AHA Survey (Z011)"
 HOSPCITY     "Hospital city from AHA Survey (Z012)"
 HOSPID       "HCUP hospital identification number"
 HOSPNAME     "Hospital name from AHA Survey (Z000)"
 HOSPST       "Hospital state postal code"
 HOSPWT       "Weight to hospitals in AHA Universe"
 HOSPZIP      "Hospital zip code from AHA Survey (Z014)"
 HOSP_BED     "Bedsize of hospital"
 HOSP_CON     "Control/ownership of hospital"
 HOSP_LOC     "Location (urban/rural) of hospital"
 HOSP_LT      "Location/teaching status of hospital"
 HOSP_REG     "Region of hospital"
 HOSP_TEA     "Teaching status of hospital"
 IDNUMBER     "AHA hospital identifier without the leading 6"
 NIS_STRA     "Stratum used to sample hospital"
 N_DISC_U     "Number of AHA universe discharges in NIS_STRATUM"
 N_HOSP_U     "Number of AHA universe hospitals in NIS_STRATUM"
 S_DISC_U     "Number of sample discharges in NIS_STRATUM"
 S_HOSP_U     "Number of sample hospitals in NIS_STRATUM"
 TOTAL_DI     "Total number of discharges from this hospital in the NIS"
 YEAR         "Calendar Year".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE DISCWT
 (-9999.9999,-8888.8888,-6666.6666,-5555.5555=SYSMIS).
RECODE HOSPWT
 (-9999.9999,-8888.8888,-6666.6666,-5555.5555=SYSMIS).
RECODE HOSP_BED
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSP_CON
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSP_LOC
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSP_LT
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSP_REG
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSP_TEA
 (-9,-8,-6,-5=SYSMIS).
RECODE NIS_STRA
 (-999,-888,-666,-555=SYSMIS).
RECODE N_DISC_U
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE N_HOSP_U
 (-999,-888,-666,-555=SYSMIS).
RECODE S_DISC_U
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE S_HOSP_U
 (-999,-888,-666,-555=SYSMIS).
RECODE TOTAL_DI
 (-99999,-88888,-66666,-55555=SYSMIS).



SAVE OUTFILE = 'NIS_1998_HOSPITAL.SAV' /COMPRESSED.
