/*****************************************************************************
* SPSSload_NIS_2008_Core.SPS
* This program will load the 2008 NIS ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2008_Core.ASC' FIXED / 
    AGE                        1-  3
    AGEDAY                     4-  6
    AMONTH                     7-  8
    ASOURCE                    9- 10
    ASOURCEUB92               11     (A)
    ASOURCE_X                 12- 14 (A)
    ATYPE                     15- 16
    AWEEKEND                  17- 18
    DIED                      19- 20
    DISCWT                    21- 31
    DISPUB04                  32- 33
    DISPUNIFORM               34- 35
    DQTR                      36- 37
    DQTR_X                    38- 39
    DRG                       40- 42
    DRG24                     43- 45
    DRGVER                    46- 47
    DRG_NoPOA                 48- 50
    DSHOSPID                  51- 67 (A)
    DX1                       68- 72 (A)
    DX2                       73- 77 (A)
    DX3                       78- 82 (A)
    DX4                       83- 87 (A)
    DX5                       88- 92 (A)
    DX6                       93- 97 (A)
    DX7                       98-102 (A)
    DX8                      103-107 (A)
    DX9                      108-112 (A)
    DX10                     113-117 (A)
    DX11                     118-122 (A)
    DX12                     123-127 (A)
    DX13                     128-132 (A)
    DX14                     133-137 (A)
    DX15                     138-142 (A)
    DXCCS1                   143-145
    DXCCS2                   146-148
    DXCCS3                   149-151
    DXCCS4                   152-154
    DXCCS5                   155-157
    DXCCS6                   158-160
    DXCCS7                   161-163
    DXCCS8                   164-166
    DXCCS9                   167-169
    DXCCS10                  170-172
    DXCCS11                  173-175
    DXCCS12                  176-178
    DXCCS13                  179-181
    DXCCS14                  182-184
    DXCCS15                  185-187
    ECODE1                   188-192 (A)
    ECODE2                   193-197 (A)
    ECODE3                   198-202 (A)
    ECODE4                   203-207 (A)
    ELECTIVE                 208-209
    E_CCS1                   210-213
    E_CCS2                   214-217
    E_CCS3                   218-221
    E_CCS4                   222-225
    FEMALE                   226-227
    HCUP_ED                  228-230
    HOSPBRTH                 231-232
    HOSPID                   233-237
    HOSPST                   238-239 (A)
    KEY                      240-253
    LOS                      254-258
    LOS_X                    259-264
    MDC                      265-266
    MDC24                    267-268
    MDNUM1_R                 269-273
    MDNUM2_R                 274-278
    NCHRONIC                 279-280
    NDX                      281-282
    NECODE                   283-285
    NEOMAT                   286-287
    NIS_STRATUM              288-291
    NPR                      292-293
    ORPROC                   294-295
    PAY1                     296-297
    PAY1_X                   298-307 (A)
    PAY2                     308-309
    PAY2_X                   310-319 (A)
    PL_NCHS2006              320-322
    PR1                      323-326 (A)
    PR2                      327-330 (A)
    PR3                      331-334 (A)
    PR4                      335-338 (A)
    PR5                      339-342 (A)
    PR6                      343-346 (A)
    PR7                      347-350 (A)
    PR8                      351-354 (A)
    PR9                      355-358 (A)
    PR10                     359-362 (A)
    PR11                     363-366 (A)
    PR12                     367-370 (A)
    PR13                     371-374 (A)
    PR14                     375-378 (A)
    PR15                     379-382 (A)
    PRCCS1                   383-385
    PRCCS2                   386-388
    PRCCS3                   389-391
    PRCCS4                   392-394
    PRCCS5                   395-397
    PRCCS6                   398-400
    PRCCS7                   401-403
    PRCCS8                   404-406
    PRCCS9                   407-409
    PRCCS10                  410-412
    PRCCS11                  413-415
    PRCCS12                  416-418
    PRCCS13                  419-421
    PRCCS14                  422-424
    PRCCS15                  425-427
    PRDAY1                   428-430
    PRDAY2                   431-433
    PRDAY3                   434-436
    PRDAY4                   437-439
    PRDAY5                   440-442
    PRDAY6                   443-445
    PRDAY7                   446-448
    PRDAY8                   449-451
    PRDAY9                   452-454
    PRDAY10                  455-457
    PRDAY11                  458-460
    PRDAY12                  461-463
    PRDAY13                  464-466
    PRDAY14                  467-469
    PRDAY15                  470-472
    PointOfOriginUB04        473     (A)
    PointOfOrigin_X          474-481 (A)
    RACE                     482-483
    TOTCHG                   484-493
    TOTCHG_X                 494-508
    TRAN_IN                  509-510
    YEAR                     511-514
    ZIPINC_QRTL              515-516.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGEDAY                   (F3.0) /
    AMONTH                   (F2.0) /
    ASOURCE                  (F2.0) /
    ATYPE                    (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUB04                 (F2.0) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DQTR_X                   (F2.0) /
    DRG                      (F3.0) /
    DRG24                    (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSPBRTH                 (F2.0) /
    HOSPID                   (F5.0) /
    KEY                      (F14.0) /
    LOS                      (F5.0) /
    LOS_X                    (F6.0) /
    MDC                      (F2.0) /
    MDC24                    (F2.0) /
    MDNUM1_R                 (F5.0) /
    MDNUM2_R                 (F5.0) /
    NCHRONIC                 (F2.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NIS_STRATUM              (F4.0) /
    NPR                      (F2.0) /
    ORPROC                   (F2.0) /
    PAY1                     (F2.0) /
    PAY2                     (F2.0) /
    PL_NCHS2006              (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TOTCHG_X                 (F15.2) /
    TRAN_IN                  (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGEDAY                   "Age in days (when age < 1 year)"
    AMONTH                   "Admission month"
    ASOURCE                  "Admission source (uniform)"
    ASOURCEUB92              "Admission source (UB-92 standard coding)"
    ASOURCE_X                "Admission source (as received from source)"
    ATYPE                    "Admission type"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUB04                 "Disposition of patient (UB-04 standard coding)"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DQTR_X                   "Discharge quarter (as received from source)"
    DRG                      "DRG in effect on discharge date"
    DRG24                    "DRG, version 24"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DSHOSPID                 "Data source hospital identifier"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSPBRTH                 "Indicator of birth in this hospital"
    HOSPID                   "HCUP hospital identification number"
    HOSPST                   "Hospital state postal code"
    KEY                      "HCUP record identifier"
    LOS                      "Length of stay (cleaned)"
    LOS_X                    "Length of stay (as received from source)"
    MDC                      "MDC in effect on discharge date"
    MDC24                    "MDC, version 24"
    MDNUM1_R                 "Physician 1 number (re-identified)"
    MDNUM2_R                 "Physician 2 number (re-identified)"
    NCHRONIC                 "Number of chronic conditions"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NIS_STRATUM              "Stratum used to sample hospital"
    NPR                      "Number of procedures on this record"
    ORPROC                   "Major operating room procedure indicator"
    PAY1                     "Primary expected payer (uniform)"
    PAY1_X                   "Primary expected payer (as received from source)"
    PAY2                     "Secondary expected payer (uniform)"
    PAY2_X                   "Secondary expected payer (as received from source)"
    PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
    PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TOTCHG_X                 "Total charges (as received from source)"
    TRAN_IN                  "Transfer in indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGEDAY                   (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE ASOURCE                  (-9 -8 -6 -5=SYSMIS).
RECODE ATYPE                    (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUB04                 (-9 -8 -6 -5=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DQTR_X                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG24                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE LOS_X                    (-99999 -88888 -66666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC24                    (-9 -8 -6 -5=SYSMIS).
RECODE MDNUM1_R                 (-9999 -8888 -6666=SYSMIS).
RECODE MDNUM2_R                 (-9999 -8888 -6666=SYSMIS).
RECODE NCHRONIC                 (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE ORPROC                   (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2006              (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TOTCHG_X                 (-99999999999.99 -88888888888.88 -66666666666.66=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2008_Core.SAV' / COMPRESSED.
