/*****************************************************************************
* SPSSload_NIS_2015Q4_DX_PR_GRPS.SPS
* This program will load the NIS_2015Q4_DX_PR_GRPS ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2015Q4_DX_PR_GRPS.ASC' FIXED / 
    DRG                        1-  3
    DRG_NoPOA                  4-  6
    DRGVER                     7-  8
    DXVER                      9- 10
    HOSP_NIS                  11- 15
    I10_DX1                   16- 22 (A)
    I10_DX2                   23- 29 (A)
    I10_DX3                   30- 36 (A)
    I10_DX4                   37- 43 (A)
    I10_DX5                   44- 50 (A)
    I10_DX6                   51- 57 (A)
    I10_DX7                   58- 64 (A)
    I10_DX8                   65- 71 (A)
    I10_DX9                   72- 78 (A)
    I10_DX10                  79- 85 (A)
    I10_DX11                  86- 92 (A)
    I10_DX12                  93- 99 (A)
    I10_DX13                 100-106 (A)
    I10_DX14                 107-113 (A)
    I10_DX15                 114-120 (A)
    I10_DX16                 121-127 (A)
    I10_DX17                 128-134 (A)
    I10_DX18                 135-141 (A)
    I10_DX19                 142-148 (A)
    I10_DX20                 149-155 (A)
    I10_DX21                 156-162 (A)
    I10_DX22                 163-169 (A)
    I10_DX23                 170-176 (A)
    I10_DX24                 177-183 (A)
    I10_DX25                 184-190 (A)
    I10_DX26                 191-197 (A)
    I10_DX27                 198-204 (A)
    I10_DX28                 205-211 (A)
    I10_DX29                 212-218 (A)
    I10_DX30                 219-225 (A)
    I10_ECAUSE1              226-232 (A)
    I10_ECAUSE2              233-239 (A)
    I10_ECAUSE3              240-246 (A)
    I10_ECAUSE4              247-253 (A)
    I10_NDX                  254-255
    I10_NECAUSE              256-258
    I10_NPR                  259-260
    I10_PR1                  261-267 (A)
    I10_PR2                  268-274 (A)
    I10_PR3                  275-281 (A)
    I10_PR4                  282-288 (A)
    I10_PR5                  289-295 (A)
    I10_PR6                  296-302 (A)
    I10_PR7                  303-309 (A)
    I10_PR8                  310-316 (A)
    I10_PR9                  317-323 (A)
    I10_PR10                 324-330 (A)
    I10_PR11                 331-337 (A)
    I10_PR12                 338-344 (A)
    I10_PR13                 345-351 (A)
    I10_PR14                 352-358 (A)
    I10_PR15                 359-365 (A)
    KEY_NIS                  366-375
    MDC                      376-377
    MDC_NoPOA                378-379
    PRDAY1                   380-382
    PRDAY2                   383-385
    PRDAY3                   386-388
    PRDAY4                   389-391
    PRDAY5                   392-394
    PRDAY6                   395-397
    PRDAY7                   398-400
    PRDAY8                   401-403
    PRDAY9                   404-406
    PRDAY10                  407-409
    PRDAY11                  410-412
    PRDAY12                  413-415
    PRDAY13                  416-418
    PRDAY14                  419-421
    PRDAY15                  422-424
    PRVER                    425-426.

***  Specify write formats  ***.
FORMATS
    DRG                      (F3.0) /
    DRG_NoPOA                (F3.0) /
    DRGVER                   (F2.0) /
    DXVER                    (F2.0) /
    HOSP_NIS                 (F5.0) /
    I10_NDX                  (F2.0) /
    I10_NECAUSE              (F3.0) /
    I10_NPR                  (F2.0) /
    KEY_NIS                  (F10.0) /
    MDC                      (F2.0) /
    MDC_NoPOA                (F2.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    PRVER                    (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    DRG                      "DRG in effect on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DRGVER                   "DRG grouper version used on discharge date"
    DXVER                    "Diagnosis Version"
    HOSP_NIS                 "NIS hospital number"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_ECAUSE1              "ICD-10-CM External cause 1"
    I10_ECAUSE2              "ICD-10-CM External cause 2"
    I10_ECAUSE3              "ICD-10-CM External cause 3"
    I10_ECAUSE4              "ICD-10-CM External cause 4"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NECAUSE              "ICD-10-CM Number of external cause codes on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    KEY_NIS                  "NIS record number"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRVER                    "Procedure Version" .

*** Convert special values to system missing values ***.
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE I10_NDX                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_NECAUSE              (-99 -88 -66=SYSMIS).
RECODE I10_NPR                  (-9 -8 -6 -5=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRVER                    (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2015Q4_DX_PR_GRPS.SAV' / COMPRESSED.
