/*****************************************************************************
* SPSSload_NIS_2005_Dx_Pr_Grps.SPS
* This program will load the 2005 NIS ASCII Dx_Pr_Grps File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2005_Dx_Pr_Grps.ASC' FIXED / 
    HOSPID                     1-  5
    KEY                        6- 19
    CCSMGN1                   20- 22
    CCSMGN2                   23- 25
    CCSMGN3                   26- 28
    CCSMGN4                   29- 31
    CCSMGN5                   32- 34
    CCSMGN6                   35- 37
    CCSMGN7                   38- 40
    CCSMGN8                   41- 43
    CCSMGN9                   44- 46
    CCSMGN10                  47- 49
    CCSMGN11                  50- 52
    CCSMGN12                  53- 55
    CCSMGN13                  56- 58
    CCSMGN14                  59- 61
    CCSMGN15                  62- 64
    CCSMSP1                   65- 68
    CCSMSP2                   69- 72
    CCSMSP3                   73- 76
    CCSMSP4                   77- 80
    CCSMSP5                   81- 84
    CCSMSP6                   85- 88
    CCSMSP7                   89- 92
    CCSMSP8                   93- 96
    CCSMSP9                   97-100
    CCSMSP10                 101-104
    CCSMSP11                 105-108
    CCSMSP12                 109-112
    CCSMSP13                 113-116
    CCSMSP14                 117-120
    CCSMSP15                 121-124
    CHRON1                   125-127
    CHRON2                   128-130
    CHRON3                   131-133
    CHRON4                   134-136
    CHRON5                   137-139
    CHRON6                   140-142
    CHRON7                   143-145
    CHRON8                   146-148
    CHRON9                   149-151
    CHRON10                  152-154
    CHRON11                  155-157
    CHRON12                  158-160
    CHRON13                  161-163
    CHRON14                  164-166
    CHRON15                  167-169
    CHRONB1                  170-172
    CHRONB2                  173-175
    CHRONB3                  176-178
    CHRONB4                  179-181
    CHRONB5                  182-184
    CHRONB6                  185-187
    CHRONB7                  188-190
    CHRONB8                  191-193
    CHRONB9                  194-196
    CHRONB10                 197-199
    CHRONB11                 200-202
    CHRONB12                 203-205
    CHRONB13                 206-208
    CHRONB14                 209-211
    CHRONB15                 212-214
    ECCSMGN1                 215-217
    ECCSMGN2                 218-220
    ECCSMGN3                 221-223
    ECCSMGN4                 224-226
    PCLASS1                  227-229
    PCLASS2                  230-232
    PCLASS3                  233-235
    PCLASS4                  236-238
    PCLASS5                  239-241
    PCLASS6                  242-244
    PCLASS7                  245-247
    PCLASS8                  248-250
    PCLASS9                  251-253
    PCLASS10                 254-256
    PCLASS11                 257-259
    PCLASS12                 260-262
    PCLASS13                 263-265
    PCLASS14                 266-268
    PCLASS15                 269-271.

***  Specify write formats  ***.
FORMATS
    HOSPID                   (F5.0) /
    KEY                      (F14.0) /
    CCSMGN1                  (F3.0) /
    CCSMGN2                  (F3.0) /
    CCSMGN3                  (F3.0) /
    CCSMGN4                  (F3.0) /
    CCSMGN5                  (F3.0) /
    CCSMGN6                  (F3.0) /
    CCSMGN7                  (F3.0) /
    CCSMGN8                  (F3.0) /
    CCSMGN9                  (F3.0) /
    CCSMGN10                 (F3.0) /
    CCSMGN11                 (F3.0) /
    CCSMGN12                 (F3.0) /
    CCSMGN13                 (F3.0) /
    CCSMGN14                 (F3.0) /
    CCSMGN15                 (F3.0) /
    CCSMSP1                  (F4.0) /
    CCSMSP2                  (F4.0) /
    CCSMSP3                  (F4.0) /
    CCSMSP4                  (F4.0) /
    CCSMSP5                  (F4.0) /
    CCSMSP6                  (F4.0) /
    CCSMSP7                  (F4.0) /
    CCSMSP8                  (F4.0) /
    CCSMSP9                  (F4.0) /
    CCSMSP10                 (F4.0) /
    CCSMSP11                 (F4.0) /
    CCSMSP12                 (F4.0) /
    CCSMSP13                 (F4.0) /
    CCSMSP14                 (F4.0) /
    CCSMSP15                 (F4.0) /
    CHRON1                   (F3.0) /
    CHRON2                   (F3.0) /
    CHRON3                   (F3.0) /
    CHRON4                   (F3.0) /
    CHRON5                   (F3.0) /
    CHRON6                   (F3.0) /
    CHRON7                   (F3.0) /
    CHRON8                   (F3.0) /
    CHRON9                   (F3.0) /
    CHRON10                  (F3.0) /
    CHRON11                  (F3.0) /
    CHRON12                  (F3.0) /
    CHRON13                  (F3.0) /
    CHRON14                  (F3.0) /
    CHRON15                  (F3.0) /
    CHRONB1                  (F3.0) /
    CHRONB2                  (F3.0) /
    CHRONB3                  (F3.0) /
    CHRONB4                  (F3.0) /
    CHRONB5                  (F3.0) /
    CHRONB6                  (F3.0) /
    CHRONB7                  (F3.0) /
    CHRONB8                  (F3.0) /
    CHRONB9                  (F3.0) /
    CHRONB10                 (F3.0) /
    CHRONB11                 (F3.0) /
    CHRONB12                 (F3.0) /
    CHRONB13                 (F3.0) /
    CHRONB14                 (F3.0) /
    CHRONB15                 (F3.0) /
    ECCSMGN1                 (F3.0) /
    ECCSMGN2                 (F3.0) /
    ECCSMGN3                 (F3.0) /
    ECCSMGN4                 (F3.0) /
    PCLASS1                  (F3.0) /
    PCLASS2                  (F3.0) /
    PCLASS3                  (F3.0) /
    PCLASS4                  (F3.0) /
    PCLASS5                  (F3.0) /
    PCLASS6                  (F3.0) /
    PCLASS7                  (F3.0) /
    PCLASS8                  (F3.0) /
    PCLASS9                  (F3.0) /
    PCLASS10                 (F3.0) /
    PCLASS11                 (F3.0) /
    PCLASS12                 (F3.0) /
    PCLASS13                 (F3.0) /
    PCLASS14                 (F3.0) /
    PCLASS15                 (F3.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPID                   "HCUP hospital identification number"
    KEY                      "HCUP record identifier"
    CCSMGN1                  "CCS-MHSA general category: principal diagnosis"
    CCSMGN2                  "CCS-MHSA general category: diagnosis 2"
    CCSMGN3                  "CCS-MHSA general category: diagnosis 3"
    CCSMGN4                  "CCS-MHSA general category: diagnosis 4"
    CCSMGN5                  "CCS-MHSA general category: diagnosis 5"
    CCSMGN6                  "CCS-MHSA general category: diagnosis 6"
    CCSMGN7                  "CCS-MHSA general category: diagnosis 7"
    CCSMGN8                  "CCS-MHSA general category: diagnosis 8"
    CCSMGN9                  "CCS-MHSA general category: diagnosis 9"
    CCSMGN10                 "CCS-MHSA general category: diagnosis 10"
    CCSMGN11                 "CCS-MHSA general category: diagnosis 11"
    CCSMGN12                 "CCS-MHSA general category: diagnosis 12"
    CCSMGN13                 "CCS-MHSA general category: diagnosis 13"
    CCSMGN14                 "CCS-MHSA general category: diagnosis 14"
    CCSMGN15                 "CCS-MHSA general category: diagnosis 15"
    CCSMSP1                  "CCS-MHSA specific category: principal diagnosis"
    CCSMSP2                  "CCS-MHSA specific category: diagnosis 2"
    CCSMSP3                  "CCS-MHSA specific category: diagnosis 3"
    CCSMSP4                  "CCS-MHSA specific category: diagnosis 4"
    CCSMSP5                  "CCS-MHSA specific category: diagnosis 5"
    CCSMSP6                  "CCS-MHSA specific category: diagnosis 6"
    CCSMSP7                  "CCS-MHSA specific category: diagnosis 7"
    CCSMSP8                  "CCS-MHSA specific category: diagnosis 8"
    CCSMSP9                  "CCS-MHSA specific category: diagnosis 9"
    CCSMSP10                 "CCS-MHSA specific category: diagnosis 10"
    CCSMSP11                 "CCS-MHSA specific category: diagnosis 11"
    CCSMSP12                 "CCS-MHSA specific category: diagnosis 12"
    CCSMSP13                 "CCS-MHSA specific category: diagnosis 13"
    CCSMSP14                 "CCS-MHSA specific category: diagnosis 14"
    CCSMSP15                 "CCS-MHSA specific category: diagnosis 15"
    CHRON1                   "Chronic condition indicator 1"
    CHRON2                   "Chronic condition indicator 2"
    CHRON3                   "Chronic condition indicator 3"
    CHRON4                   "Chronic condition indicator 4"
    CHRON5                   "Chronic condition indicator 5"
    CHRON6                   "Chronic condition indicator 6"
    CHRON7                   "Chronic condition indicator 7"
    CHRON8                   "Chronic condition indicator 8"
    CHRON9                   "Chronic condition indicator 9"
    CHRON10                  "Chronic condition indicator 10"
    CHRON11                  "Chronic condition indicator 11"
    CHRON12                  "Chronic condition indicator 12"
    CHRON13                  "Chronic condition indicator 13"
    CHRON14                  "Chronic condition indicator 14"
    CHRON15                  "Chronic condition indicator 15"
    CHRONB1                  "Chronic condition body system 1"
    CHRONB2                  "Chronic condition body system 2"
    CHRONB3                  "Chronic condition body system 3"
    CHRONB4                  "Chronic condition body system 4"
    CHRONB5                  "Chronic condition body system 5"
    CHRONB6                  "Chronic condition body system 6"
    CHRONB7                  "Chronic condition body system 7"
    CHRONB8                  "Chronic condition body system 8"
    CHRONB9                  "Chronic condition body system 9"
    CHRONB10                 "Chronic condition body system 10"
    CHRONB11                 "Chronic condition body system 11"
    CHRONB12                 "Chronic condition body system 12"
    CHRONB13                 "Chronic condition body system 13"
    CHRONB14                 "Chronic condition body system 14"
    CHRONB15                 "Chronic condition body system 15"
    ECCSMGN1                 "CCS-MHSA general category: E Code 1"
    ECCSMGN2                 "CCS-MHSA general category: E Code 2"
    ECCSMGN3                 "CCS-MHSA general category: E Code 3"
    ECCSMGN4                 "CCS-MHSA general category: E Code 4"
    PCLASS1                  "Principal procedure class"
    PCLASS2                  "Procedure class 2"
    PCLASS3                  "Procedure class 3"
    PCLASS4                  "Procedure class 4"
    PCLASS5                  "Procedure class 5"
    PCLASS6                  "Procedure class 6"
    PCLASS7                  "Procedure class 7"
    PCLASS8                  "Procedure class 8"
    PCLASS9                  "Procedure class 9"
    PCLASS10                 "Procedure class 10"
    PCLASS11                 "Procedure class 11"
    PCLASS12                 "Procedure class 12"
    PCLASS13                 "Procedure class 13"
    PCLASS14                 "Procedure class 14"
    PCLASS15                 "Procedure class 15" .

*** Convert special values to system missing values ***.
RECODE CCSMGN1                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN2                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN3                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN4                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN5                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN6                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN7                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN8                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN9                  (-99 -88 -66=SYSMIS).
RECODE CCSMGN10                 (-99 -88 -66=SYSMIS).
RECODE CCSMGN11                 (-99 -88 -66=SYSMIS).
RECODE CCSMGN12                 (-99 -88 -66=SYSMIS).
RECODE CCSMGN13                 (-99 -88 -66=SYSMIS).
RECODE CCSMGN14                 (-99 -88 -66=SYSMIS).
RECODE CCSMGN15                 (-99 -88 -66=SYSMIS).
RECODE CCSMSP1                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP2                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP3                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP4                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP5                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP6                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP7                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP8                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP9                  (-999 -888 -666=SYSMIS).
RECODE CCSMSP10                 (-999 -888 -666=SYSMIS).
RECODE CCSMSP11                 (-999 -888 -666=SYSMIS).
RECODE CCSMSP12                 (-999 -888 -666=SYSMIS).
RECODE CCSMSP13                 (-999 -888 -666=SYSMIS).
RECODE CCSMSP14                 (-999 -888 -666=SYSMIS).
RECODE CCSMSP15                 (-999 -888 -666=SYSMIS).
RECODE CHRON1                   (-99 -88 -66=SYSMIS).
RECODE CHRON2                   (-99 -88 -66=SYSMIS).
RECODE CHRON3                   (-99 -88 -66=SYSMIS).
RECODE CHRON4                   (-99 -88 -66=SYSMIS).
RECODE CHRON5                   (-99 -88 -66=SYSMIS).
RECODE CHRON6                   (-99 -88 -66=SYSMIS).
RECODE CHRON7                   (-99 -88 -66=SYSMIS).
RECODE CHRON8                   (-99 -88 -66=SYSMIS).
RECODE CHRON9                   (-99 -88 -66=SYSMIS).
RECODE CHRON10                  (-99 -88 -66=SYSMIS).
RECODE CHRON11                  (-99 -88 -66=SYSMIS).
RECODE CHRON12                  (-99 -88 -66=SYSMIS).
RECODE CHRON13                  (-99 -88 -66=SYSMIS).
RECODE CHRON14                  (-99 -88 -66=SYSMIS).
RECODE CHRON15                  (-99 -88 -66=SYSMIS).
RECODE CHRONB1                  (-99 -88 -66=SYSMIS).
RECODE CHRONB2                  (-99 -88 -66=SYSMIS).
RECODE CHRONB3                  (-99 -88 -66=SYSMIS).
RECODE CHRONB4                  (-99 -88 -66=SYSMIS).
RECODE CHRONB5                  (-99 -88 -66=SYSMIS).
RECODE CHRONB6                  (-99 -88 -66=SYSMIS).
RECODE CHRONB7                  (-99 -88 -66=SYSMIS).
RECODE CHRONB8                  (-99 -88 -66=SYSMIS).
RECODE CHRONB9                  (-99 -88 -66=SYSMIS).
RECODE CHRONB10                 (-99 -88 -66=SYSMIS).
RECODE CHRONB11                 (-99 -88 -66=SYSMIS).
RECODE CHRONB12                 (-99 -88 -66=SYSMIS).
RECODE CHRONB13                 (-99 -88 -66=SYSMIS).
RECODE CHRONB14                 (-99 -88 -66=SYSMIS).
RECODE CHRONB15                 (-99 -88 -66=SYSMIS).
RECODE ECCSMGN1                 (-99 -88 -66=SYSMIS).
RECODE ECCSMGN2                 (-99 -88 -66=SYSMIS).
RECODE ECCSMGN3                 (-99 -88 -66=SYSMIS).
RECODE ECCSMGN4                 (-99 -88 -66=SYSMIS).
RECODE PCLASS1                  (-99 -88 -66=SYSMIS).
RECODE PCLASS2                  (-99 -88 -66=SYSMIS).
RECODE PCLASS3                  (-99 -88 -66=SYSMIS).
RECODE PCLASS4                  (-99 -88 -66=SYSMIS).
RECODE PCLASS5                  (-99 -88 -66=SYSMIS).
RECODE PCLASS6                  (-99 -88 -66=SYSMIS).
RECODE PCLASS7                  (-99 -88 -66=SYSMIS).
RECODE PCLASS8                  (-99 -88 -66=SYSMIS).
RECODE PCLASS9                  (-99 -88 -66=SYSMIS).
RECODE PCLASS10                 (-99 -88 -66=SYSMIS).
RECODE PCLASS11                 (-99 -88 -66=SYSMIS).
RECODE PCLASS12                 (-99 -88 -66=SYSMIS).
RECODE PCLASS13                 (-99 -88 -66=SYSMIS).
RECODE PCLASS14                 (-99 -88 -66=SYSMIS).
RECODE PCLASS15                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NIS_2005_Dx_Pr_Grps.SAV' / COMPRESSED.
