/*****************************************************************************
* SPSSload_NIS_2007_Dx_Pr_Grps.SPS
* This program will load the 2007 NIS ASCII Dx_Pr_Grps File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2007_Dx_Pr_Grps.ASC' FIXED / 
    HOSPID                     1-  5
    KEY                        6- 19
    CHRON1                    20- 22
    CHRON2                    23- 25
    CHRON3                    26- 28
    CHRON4                    29- 31
    CHRON5                    32- 34
    CHRON6                    35- 37
    CHRON7                    38- 40
    CHRON8                    41- 43
    CHRON9                    44- 46
    CHRON10                   47- 49
    CHRON11                   50- 52
    CHRON12                   53- 55
    CHRON13                   56- 58
    CHRON14                   59- 61
    CHRON15                   62- 64
    CHRONB1                   65- 67
    CHRONB2                   68- 70
    CHRONB3                   71- 73
    CHRONB4                   74- 76
    CHRONB5                   77- 79
    CHRONB6                   80- 82
    CHRONB7                   83- 85
    CHRONB8                   86- 88
    CHRONB9                   89- 91
    CHRONB10                  92- 94
    CHRONB11                  95- 97
    CHRONB12                  98-100
    CHRONB13                 101-103
    CHRONB14                 104-106
    CHRONB15                 107-109
    PCLASS1                  110-112
    PCLASS2                  113-115
    PCLASS3                  116-118
    PCLASS4                  119-121
    PCLASS5                  122-124
    PCLASS6                  125-127
    PCLASS7                  128-130
    PCLASS8                  131-133
    PCLASS9                  134-136
    PCLASS10                 137-139
    PCLASS11                 140-142
    PCLASS12                 143-145
    PCLASS13                 146-148
    PCLASS14                 149-151
    PCLASS15                 152-154.

***  Specify write formats  ***.
FORMATS
    HOSPID                   (F5.0) /
    KEY                      (F14.0) /
    CHRON1                   (F3.0) /
    CHRON2                   (F3.0) /
    CHRON3                   (F3.0) /
    CHRON4                   (F3.0) /
    CHRON5                   (F3.0) /
    CHRON6                   (F3.0) /
    CHRON7                   (F3.0) /
    CHRON8                   (F3.0) /
    CHRON9                   (F3.0) /
    CHRON10                  (F3.0) /
    CHRON11                  (F3.0) /
    CHRON12                  (F3.0) /
    CHRON13                  (F3.0) /
    CHRON14                  (F3.0) /
    CHRON15                  (F3.0) /
    CHRONB1                  (F3.0) /
    CHRONB2                  (F3.0) /
    CHRONB3                  (F3.0) /
    CHRONB4                  (F3.0) /
    CHRONB5                  (F3.0) /
    CHRONB6                  (F3.0) /
    CHRONB7                  (F3.0) /
    CHRONB8                  (F3.0) /
    CHRONB9                  (F3.0) /
    CHRONB10                 (F3.0) /
    CHRONB11                 (F3.0) /
    CHRONB12                 (F3.0) /
    CHRONB13                 (F3.0) /
    CHRONB14                 (F3.0) /
    CHRONB15                 (F3.0) /
    PCLASS1                  (F3.0) /
    PCLASS2                  (F3.0) /
    PCLASS3                  (F3.0) /
    PCLASS4                  (F3.0) /
    PCLASS5                  (F3.0) /
    PCLASS6                  (F3.0) /
    PCLASS7                  (F3.0) /
    PCLASS8                  (F3.0) /
    PCLASS9                  (F3.0) /
    PCLASS10                 (F3.0) /
    PCLASS11                 (F3.0) /
    PCLASS12                 (F3.0) /
    PCLASS13                 (F3.0) /
    PCLASS14                 (F3.0) /
    PCLASS15                 (F3.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPID                   "HCUP hospital identification number"
    KEY                      "HCUP record identifier"
    CHRON1                   "Chronic condition indicator 1"
    CHRON2                   "Chronic condition indicator 2"
    CHRON3                   "Chronic condition indicator 3"
    CHRON4                   "Chronic condition indicator 4"
    CHRON5                   "Chronic condition indicator 5"
    CHRON6                   "Chronic condition indicator 6"
    CHRON7                   "Chronic condition indicator 7"
    CHRON8                   "Chronic condition indicator 8"
    CHRON9                   "Chronic condition indicator 9"
    CHRON10                  "Chronic condition indicator 10"
    CHRON11                  "Chronic condition indicator 11"
    CHRON12                  "Chronic condition indicator 12"
    CHRON13                  "Chronic condition indicator 13"
    CHRON14                  "Chronic condition indicator 14"
    CHRON15                  "Chronic condition indicator 15"
    CHRONB1                  "Chronic condition body system 1"
    CHRONB2                  "Chronic condition body system 2"
    CHRONB3                  "Chronic condition body system 3"
    CHRONB4                  "Chronic condition body system 4"
    CHRONB5                  "Chronic condition body system 5"
    CHRONB6                  "Chronic condition body system 6"
    CHRONB7                  "Chronic condition body system 7"
    CHRONB8                  "Chronic condition body system 8"
    CHRONB9                  "Chronic condition body system 9"
    CHRONB10                 "Chronic condition body system 10"
    CHRONB11                 "Chronic condition body system 11"
    CHRONB12                 "Chronic condition body system 12"
    CHRONB13                 "Chronic condition body system 13"
    CHRONB14                 "Chronic condition body system 14"
    CHRONB15                 "Chronic condition body system 15"
    PCLASS1                  "Procedure class 1"
    PCLASS2                  "Procedure class 2"
    PCLASS3                  "Procedure class 3"
    PCLASS4                  "Procedure class 4"
    PCLASS5                  "Procedure class 5"
    PCLASS6                  "Procedure class 6"
    PCLASS7                  "Procedure class 7"
    PCLASS8                  "Procedure class 8"
    PCLASS9                  "Procedure class 9"
    PCLASS10                 "Procedure class 10"
    PCLASS11                 "Procedure class 11"
    PCLASS12                 "Procedure class 12"
    PCLASS13                 "Procedure class 13"
    PCLASS14                 "Procedure class 14"
    PCLASS15                 "Procedure class 15" .

*** Convert special values to system missing values ***.
RECODE CHRON1                   (-99 -88 -66=SYSMIS).
RECODE CHRON2                   (-99 -88 -66=SYSMIS).
RECODE CHRON3                   (-99 -88 -66=SYSMIS).
RECODE CHRON4                   (-99 -88 -66=SYSMIS).
RECODE CHRON5                   (-99 -88 -66=SYSMIS).
RECODE CHRON6                   (-99 -88 -66=SYSMIS).
RECODE CHRON7                   (-99 -88 -66=SYSMIS).
RECODE CHRON8                   (-99 -88 -66=SYSMIS).
RECODE CHRON9                   (-99 -88 -66=SYSMIS).
RECODE CHRON10                  (-99 -88 -66=SYSMIS).
RECODE CHRON11                  (-99 -88 -66=SYSMIS).
RECODE CHRON12                  (-99 -88 -66=SYSMIS).
RECODE CHRON13                  (-99 -88 -66=SYSMIS).
RECODE CHRON14                  (-99 -88 -66=SYSMIS).
RECODE CHRON15                  (-99 -88 -66=SYSMIS).
RECODE CHRONB1                  (-99 -88 -66=SYSMIS).
RECODE CHRONB2                  (-99 -88 -66=SYSMIS).
RECODE CHRONB3                  (-99 -88 -66=SYSMIS).
RECODE CHRONB4                  (-99 -88 -66=SYSMIS).
RECODE CHRONB5                  (-99 -88 -66=SYSMIS).
RECODE CHRONB6                  (-99 -88 -66=SYSMIS).
RECODE CHRONB7                  (-99 -88 -66=SYSMIS).
RECODE CHRONB8                  (-99 -88 -66=SYSMIS).
RECODE CHRONB9                  (-99 -88 -66=SYSMIS).
RECODE CHRONB10                 (-99 -88 -66=SYSMIS).
RECODE CHRONB11                 (-99 -88 -66=SYSMIS).
RECODE CHRONB12                 (-99 -88 -66=SYSMIS).
RECODE CHRONB13                 (-99 -88 -66=SYSMIS).
RECODE CHRONB14                 (-99 -88 -66=SYSMIS).
RECODE CHRONB15                 (-99 -88 -66=SYSMIS).
RECODE PCLASS1                  (-99 -88 -66=SYSMIS).
RECODE PCLASS2                  (-99 -88 -66=SYSMIS).
RECODE PCLASS3                  (-99 -88 -66=SYSMIS).
RECODE PCLASS4                  (-99 -88 -66=SYSMIS).
RECODE PCLASS5                  (-99 -88 -66=SYSMIS).
RECODE PCLASS6                  (-99 -88 -66=SYSMIS).
RECODE PCLASS7                  (-99 -88 -66=SYSMIS).
RECODE PCLASS8                  (-99 -88 -66=SYSMIS).
RECODE PCLASS9                  (-99 -88 -66=SYSMIS).
RECODE PCLASS10                 (-99 -88 -66=SYSMIS).
RECODE PCLASS11                 (-99 -88 -66=SYSMIS).
RECODE PCLASS12                 (-99 -88 -66=SYSMIS).
RECODE PCLASS13                 (-99 -88 -66=SYSMIS).
RECODE PCLASS14                 (-99 -88 -66=SYSMIS).
RECODE PCLASS15                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NIS_2007_Dx_Pr_Grps.SAV' / COMPRESSED.
