/*****************************************************************************
* SPSSload_NIS_2010_Core.SPS
* This program will load the 2010 NIS ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2010_Core.ASC' FIXED / 
    AGE                        1-  3
    AGEDAY                     4-  6
    AMONTH                     7-  8
    ASOURCE                    9- 10
    ASOURCEUB92               11     (A)
    ASOURCE_X                 12- 15 (A)
    ATYPE                     16- 17
    AWEEKEND                  18- 19
    DIED                      20- 21
    DISCWT                    22- 32
    DISPUB04                  33- 34
    DISPUNIFORM               35- 36
    DQTR                      37- 38
    DQTR_X                    39- 40
    DRG                       41- 43
    DRG24                     44- 46
    DRGVER                    47- 48
    DRG_NoPOA                 49- 51
    DSHOSPID                  52- 68 (A)
    DX1                       69- 73 (A)
    DX2                       74- 78 (A)
    DX3                       79- 83 (A)
    DX4                       84- 88 (A)
    DX5                       89- 93 (A)
    DX6                       94- 98 (A)
    DX7                       99-103 (A)
    DX8                      104-108 (A)
    DX9                      109-113 (A)
    DX10                     114-118 (A)
    DX11                     119-123 (A)
    DX12                     124-128 (A)
    DX13                     129-133 (A)
    DX14                     134-138 (A)
    DX15                     139-143 (A)
    DX16                     144-148 (A)
    DX17                     149-153 (A)
    DX18                     154-158 (A)
    DX19                     159-163 (A)
    DX20                     164-168 (A)
    DX21                     169-173 (A)
    DX22                     174-178 (A)
    DX23                     179-183 (A)
    DX24                     184-188 (A)
    DX25                     189-193 (A)
    DXCCS1                   194-196
    DXCCS2                   197-199
    DXCCS3                   200-202
    DXCCS4                   203-205
    DXCCS5                   206-208
    DXCCS6                   209-211
    DXCCS7                   212-214
    DXCCS8                   215-217
    DXCCS9                   218-220
    DXCCS10                  221-223
    DXCCS11                  224-226
    DXCCS12                  227-229
    DXCCS13                  230-232
    DXCCS14                  233-235
    DXCCS15                  236-238
    DXCCS16                  239-241
    DXCCS17                  242-244
    DXCCS18                  245-247
    DXCCS19                  248-250
    DXCCS20                  251-253
    DXCCS21                  254-256
    DXCCS22                  257-259
    DXCCS23                  260-262
    DXCCS24                  263-265
    DXCCS25                  266-268
    ECODE1                   269-273 (A)
    ECODE2                   274-278 (A)
    ECODE3                   279-283 (A)
    ECODE4                   284-288 (A)
    ELECTIVE                 289-290
    E_CCS1                   291-294
    E_CCS2                   295-298
    E_CCS3                   299-302
    E_CCS4                   303-306
    FEMALE                   307-308
    HCUP_ED                  309-311
    HOSPBRTH                 312-313
    HOSPID                   314-318
    HOSPST                   319-320 (A)
    KEY                      321-334
    LOS                      335-339
    LOS_X                    340-345
    MDC                      346-347
    MDC24                    348-349
    MDC_NoPOA                350-351
    NCHRONIC                 352-353
    NDX                      354-355
    NECODE                   356-358
    NEOMAT                   359-360
    NIS_STRATUM              361-364
    NPR                      365-366
    ORPROC                   367-368
    PAY1                     369-370
    PAY1_X                   371-380 (A)
    PAY2                     381-382
    PAY2_X                   383-392 (A)
    PL_NCHS2006              393-395
    PR1                      396-399 (A)
    PR2                      400-403 (A)
    PR3                      404-407 (A)
    PR4                      408-411 (A)
    PR5                      412-415 (A)
    PR6                      416-419 (A)
    PR7                      420-423 (A)
    PR8                      424-427 (A)
    PR9                      428-431 (A)
    PR10                     432-435 (A)
    PR11                     436-439 (A)
    PR12                     440-443 (A)
    PR13                     444-447 (A)
    PR14                     448-451 (A)
    PR15                     452-455 (A)
    PRCCS1                   456-458
    PRCCS2                   459-461
    PRCCS3                   462-464
    PRCCS4                   465-467
    PRCCS5                   468-470
    PRCCS6                   471-473
    PRCCS7                   474-476
    PRCCS8                   477-479
    PRCCS9                   480-482
    PRCCS10                  483-485
    PRCCS11                  486-488
    PRCCS12                  489-491
    PRCCS13                  492-494
    PRCCS14                  495-497
    PRCCS15                  498-500
    PRDAY1                   501-503
    PRDAY2                   504-506
    PRDAY3                   507-509
    PRDAY4                   510-512
    PRDAY5                   513-515
    PRDAY6                   516-518
    PRDAY7                   519-521
    PRDAY8                   522-524
    PRDAY9                   525-527
    PRDAY10                  528-530
    PRDAY11                  531-533
    PRDAY12                  534-536
    PRDAY13                  537-539
    PRDAY14                  540-542
    PRDAY15                  543-545
    PointOfOriginUB04        546     (A)
    PointOfOrigin_X          547-554 (A)
    RACE                     555-556
    TOTCHG                   557-566
    TOTCHG_X                 567-581
    TRAN_IN                  582-583
    TRAN_OUT                 584-585
    YEAR                     586-589
    ZIPINC_QRTL              590-591.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGEDAY                   (F3.0) /
    AMONTH                   (F2.0) /
    ASOURCE                  (F2.0) /
    ATYPE                    (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUB04                 (F2.0) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DQTR_X                   (F2.0) /
    DRG                      (F3.0) /
    DRG24                    (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    DXCCS16                  (F3.0) /
    DXCCS17                  (F3.0) /
    DXCCS18                  (F3.0) /
    DXCCS19                  (F3.0) /
    DXCCS20                  (F3.0) /
    DXCCS21                  (F3.0) /
    DXCCS22                  (F3.0) /
    DXCCS23                  (F3.0) /
    DXCCS24                  (F3.0) /
    DXCCS25                  (F3.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSPBRTH                 (F2.0) /
    HOSPID                   (F5.0) /
    KEY                      (F14.0) /
    LOS                      (F5.0) /
    LOS_X                    (F6.0) /
    MDC                      (F2.0) /
    MDC24                    (F2.0) /
    MDC_NoPOA                (F2.0) /
    NCHRONIC                 (F2.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NIS_STRATUM              (F4.0) /
    NPR                      (F2.0) /
    ORPROC                   (F2.0) /
    PAY1                     (F2.0) /
    PAY2                     (F2.0) /
    PL_NCHS2006              (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TOTCHG_X                 (F15.2) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGEDAY                   "Age in days (when age < 1 year)"
    AMONTH                   "Admission month"
    ASOURCE                  "Admission source (uniform)"
    ASOURCEUB92              "Admission source (UB-92 standard coding)"
    ASOURCE_X                "Admission source (as received from source)"
    ATYPE                    "Admission type"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUB04                 "Disposition of patient (UB-04 standard coding)"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DQTR_X                   "Discharge quarter (as received from source)"
    DRG                      "DRG in effect on discharge date"
    DRG24                    "DRG, version 24"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DSHOSPID                 "Data source hospital identifier"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DX16                     "Diagnosis 16"
    DX17                     "Diagnosis 17"
    DX18                     "Diagnosis 18"
    DX19                     "Diagnosis 19"
    DX20                     "Diagnosis 20"
    DX21                     "Diagnosis 21"
    DX22                     "Diagnosis 22"
    DX23                     "Diagnosis 23"
    DX24                     "Diagnosis 24"
    DX25                     "Diagnosis 25"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    DXCCS16                  "CCS: diagnosis 16"
    DXCCS17                  "CCS: diagnosis 17"
    DXCCS18                  "CCS: diagnosis 18"
    DXCCS19                  "CCS: diagnosis 19"
    DXCCS20                  "CCS: diagnosis 20"
    DXCCS21                  "CCS: diagnosis 21"
    DXCCS22                  "CCS: diagnosis 22"
    DXCCS23                  "CCS: diagnosis 23"
    DXCCS24                  "CCS: diagnosis 24"
    DXCCS25                  "CCS: diagnosis 25"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSPBRTH                 "Indicator of birth in this hospital"
    HOSPID                   "HCUP hospital identification number"
    HOSPST                   "Hospital state postal code"
    KEY                      "HCUP record identifier"
    LOS                      "Length of stay (cleaned)"
    LOS_X                    "Length of stay (as received from source)"
    MDC                      "MDC in effect on discharge date"
    MDC24                    "MDC, version 24"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    NCHRONIC                 "Number of chronic conditions"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NIS_STRATUM              "Stratum used to sample hospital"
    NPR                      "Number of procedures on this record"
    ORPROC                   "Major operating room procedure indicator"
    PAY1                     "Primary expected payer (uniform)"
    PAY1_X                   "Primary expected payer (as received from source)"
    PAY2                     "Secondary expected payer (uniform)"
    PAY2_X                   "Secondary expected payer (as received from source)"
    PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
    PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TOTCHG_X                 "Total charges (as received from source)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGEDAY                   (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE ASOURCE                  (-9 -8 -6 -5=SYSMIS).
RECODE ATYPE                    (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUB04                 (-9 -8 -6 -5=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DQTR_X                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG24                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE DXCCS16                  (-99 -88 -66=SYSMIS).
RECODE DXCCS17                  (-99 -88 -66=SYSMIS).
RECODE DXCCS18                  (-99 -88 -66=SYSMIS).
RECODE DXCCS19                  (-99 -88 -66=SYSMIS).
RECODE DXCCS20                  (-99 -88 -66=SYSMIS).
RECODE DXCCS21                  (-99 -88 -66=SYSMIS).
RECODE DXCCS22                  (-99 -88 -66=SYSMIS).
RECODE DXCCS23                  (-99 -88 -66=SYSMIS).
RECODE DXCCS24                  (-99 -88 -66=SYSMIS).
RECODE DXCCS25                  (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE LOS_X                    (-99999 -88888 -66666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC24                    (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NCHRONIC                 (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE ORPROC                   (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2006              (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TOTCHG_X                 (-99999999999.99 -88888888888.88 -66666666666.66=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2010_Core.SAV' / COMPRESSED.
