/*****************************************************************************
* SPSSload_NIS_2012_DX_PR_GRPS.SPS
* This program will load the 2012 NIS ASCII DX_PR_GRPS File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2012_DX_PR_GRPS.ASC' FIXED / 
    HOSP_NIS                   1-  5
    KEY_NIS                    6- 15
    CHRON1                    16- 18
    CHRON2                    19- 21
    CHRON3                    22- 24
    CHRON4                    25- 27
    CHRON5                    28- 30
    CHRON6                    31- 33
    CHRON7                    34- 36
    CHRON8                    37- 39
    CHRON9                    40- 42
    CHRON10                   43- 45
    CHRON11                   46- 48
    CHRON12                   49- 51
    CHRON13                   52- 54
    CHRON14                   55- 57
    CHRON15                   58- 60
    CHRON16                   61- 63
    CHRON17                   64- 66
    CHRON18                   67- 69
    CHRON19                   70- 72
    CHRON20                   73- 75
    CHRON21                   76- 78
    CHRON22                   79- 81
    CHRON23                   82- 84
    CHRON24                   85- 87
    CHRON25                   88- 90
    CHRONB1                   91- 93
    CHRONB2                   94- 96
    CHRONB3                   97- 99
    CHRONB4                  100-102
    CHRONB5                  103-105
    CHRONB6                  106-108
    CHRONB7                  109-111
    CHRONB8                  112-114
    CHRONB9                  115-117
    CHRONB10                 118-120
    CHRONB11                 121-123
    CHRONB12                 124-126
    CHRONB13                 127-129
    CHRONB14                 130-132
    CHRONB15                 133-135
    CHRONB16                 136-138
    CHRONB17                 139-141
    CHRONB18                 142-144
    CHRONB19                 145-147
    CHRONB20                 148-150
    CHRONB21                 151-153
    CHRONB22                 154-156
    CHRONB23                 157-159
    CHRONB24                 160-162
    CHRONB25                 163-165
    DXMCCS1                  166-176 (A)
    E_MCCS1                  177-187 (A)
    PCLASS1                  188-190
    PCLASS2                  191-193
    PCLASS3                  194-196
    PCLASS4                  197-199
    PCLASS5                  200-202
    PCLASS6                  203-205
    PCLASS7                  206-208
    PCLASS8                  209-211
    PCLASS9                  212-214
    PCLASS10                 215-217
    PCLASS11                 218-220
    PCLASS12                 221-223
    PCLASS13                 224-226
    PCLASS14                 227-229
    PCLASS15                 230-232
    PRMCCS1                  233-240 (A).

***  Specify write formats  ***.
FORMATS
    HOSP_NIS                 (F5.0) /
    KEY_NIS                  (F10.0) /
    CHRON1                   (F3.0) /
    CHRON2                   (F3.0) /
    CHRON3                   (F3.0) /
    CHRON4                   (F3.0) /
    CHRON5                   (F3.0) /
    CHRON6                   (F3.0) /
    CHRON7                   (F3.0) /
    CHRON8                   (F3.0) /
    CHRON9                   (F3.0) /
    CHRON10                  (F3.0) /
    CHRON11                  (F3.0) /
    CHRON12                  (F3.0) /
    CHRON13                  (F3.0) /
    CHRON14                  (F3.0) /
    CHRON15                  (F3.0) /
    CHRON16                  (F3.0) /
    CHRON17                  (F3.0) /
    CHRON18                  (F3.0) /
    CHRON19                  (F3.0) /
    CHRON20                  (F3.0) /
    CHRON21                  (F3.0) /
    CHRON22                  (F3.0) /
    CHRON23                  (F3.0) /
    CHRON24                  (F3.0) /
    CHRON25                  (F3.0) /
    CHRONB1                  (F3.0) /
    CHRONB2                  (F3.0) /
    CHRONB3                  (F3.0) /
    CHRONB4                  (F3.0) /
    CHRONB5                  (F3.0) /
    CHRONB6                  (F3.0) /
    CHRONB7                  (F3.0) /
    CHRONB8                  (F3.0) /
    CHRONB9                  (F3.0) /
    CHRONB10                 (F3.0) /
    CHRONB11                 (F3.0) /
    CHRONB12                 (F3.0) /
    CHRONB13                 (F3.0) /
    CHRONB14                 (F3.0) /
    CHRONB15                 (F3.0) /
    CHRONB16                 (F3.0) /
    CHRONB17                 (F3.0) /
    CHRONB18                 (F3.0) /
    CHRONB19                 (F3.0) /
    CHRONB20                 (F3.0) /
    CHRONB21                 (F3.0) /
    CHRONB22                 (F3.0) /
    CHRONB23                 (F3.0) /
    CHRONB24                 (F3.0) /
    CHRONB25                 (F3.0) /
    PCLASS1                  (F3.0) /
    PCLASS2                  (F3.0) /
    PCLASS3                  (F3.0) /
    PCLASS4                  (F3.0) /
    PCLASS5                  (F3.0) /
    PCLASS6                  (F3.0) /
    PCLASS7                  (F3.0) /
    PCLASS8                  (F3.0) /
    PCLASS9                  (F3.0) /
    PCLASS10                 (F3.0) /
    PCLASS11                 (F3.0) /
    PCLASS12                 (F3.0) /
    PCLASS13                 (F3.0) /
    PCLASS14                 (F3.0) /
    PCLASS15                 (F3.0) /
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_NIS                 "NIS hospital number"
    KEY_NIS                  "NIS record number"
    CHRON1                   "Chronic condition indicator 1"
    CHRON2                   "Chronic condition indicator 2"
    CHRON3                   "Chronic condition indicator 3"
    CHRON4                   "Chronic condition indicator 4"
    CHRON5                   "Chronic condition indicator 5"
    CHRON6                   "Chronic condition indicator 6"
    CHRON7                   "Chronic condition indicator 7"
    CHRON8                   "Chronic condition indicator 8"
    CHRON9                   "Chronic condition indicator 9"
    CHRON10                  "Chronic condition indicator 10"
    CHRON11                  "Chronic condition indicator 11"
    CHRON12                  "Chronic condition indicator 12"
    CHRON13                  "Chronic condition indicator 13"
    CHRON14                  "Chronic condition indicator 14"
    CHRON15                  "Chronic condition indicator 15"
    CHRON16                  "Chronic condition indicator 16"
    CHRON17                  "Chronic condition indicator 17"
    CHRON18                  "Chronic condition indicator 18"
    CHRON19                  "Chronic condition indicator 19"
    CHRON20                  "Chronic condition indicator 20"
    CHRON21                  "Chronic condition indicator 21"
    CHRON22                  "Chronic condition indicator 22"
    CHRON23                  "Chronic condition indicator 23"
    CHRON24                  "Chronic condition indicator 24"
    CHRON25                  "Chronic condition indicator 25"
    CHRONB1                  "Chronic condition body system 1"
    CHRONB2                  "Chronic condition body system 2"
    CHRONB3                  "Chronic condition body system 3"
    CHRONB4                  "Chronic condition body system 4"
    CHRONB5                  "Chronic condition body system 5"
    CHRONB6                  "Chronic condition body system 6"
    CHRONB7                  "Chronic condition body system 7"
    CHRONB8                  "Chronic condition body system 8"
    CHRONB9                  "Chronic condition body system 9"
    CHRONB10                 "Chronic condition body system 10"
    CHRONB11                 "Chronic condition body system 11"
    CHRONB12                 "Chronic condition body system 12"
    CHRONB13                 "Chronic condition body system 13"
    CHRONB14                 "Chronic condition body system 14"
    CHRONB15                 "Chronic condition body system 15"
    CHRONB16                 "Chronic condition body system 16"
    CHRONB17                 "Chronic condition body system 17"
    CHRONB18                 "Chronic condition body system 18"
    CHRONB19                 "Chronic condition body system 19"
    CHRONB20                 "Chronic condition body system 20"
    CHRONB21                 "Chronic condition body system 21"
    CHRONB22                 "Chronic condition body system 22"
    CHRONB23                 "Chronic condition body system 23"
    CHRONB24                 "Chronic condition body system 24"
    CHRONB25                 "Chronic condition body system 25"
    DXMCCS1                  "Multi-Level CCS:  Diagnosis 1"
    E_MCCS1                  "Multi-Level CCS:  E Code 1"
    PCLASS1                  "Procedure class 1"
    PCLASS2                  "Procedure class 2"
    PCLASS3                  "Procedure class 3"
    PCLASS4                  "Procedure class 4"
    PCLASS5                  "Procedure class 5"
    PCLASS6                  "Procedure class 6"
    PCLASS7                  "Procedure class 7"
    PCLASS8                  "Procedure class 8"
    PCLASS9                  "Procedure class 9"
    PCLASS10                 "Procedure class 10"
    PCLASS11                 "Procedure class 11"
    PCLASS12                 "Procedure class 12"
    PCLASS13                 "Procedure class 13"
    PCLASS14                 "Procedure class 14"
    PCLASS15                 "Procedure class 15"
    PRMCCS1                  "Multi-Level CCS:  Procedure 1" .

*** Convert special values to system missing values ***.
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE CHRON1                   (-99 -88 -66=SYSMIS).
RECODE CHRON2                   (-99 -88 -66=SYSMIS).
RECODE CHRON3                   (-99 -88 -66=SYSMIS).
RECODE CHRON4                   (-99 -88 -66=SYSMIS).
RECODE CHRON5                   (-99 -88 -66=SYSMIS).
RECODE CHRON6                   (-99 -88 -66=SYSMIS).
RECODE CHRON7                   (-99 -88 -66=SYSMIS).
RECODE CHRON8                   (-99 -88 -66=SYSMIS).
RECODE CHRON9                   (-99 -88 -66=SYSMIS).
RECODE CHRON10                  (-99 -88 -66=SYSMIS).
RECODE CHRON11                  (-99 -88 -66=SYSMIS).
RECODE CHRON12                  (-99 -88 -66=SYSMIS).
RECODE CHRON13                  (-99 -88 -66=SYSMIS).
RECODE CHRON14                  (-99 -88 -66=SYSMIS).
RECODE CHRON15                  (-99 -88 -66=SYSMIS).
RECODE CHRON16                  (-99 -88 -66=SYSMIS).
RECODE CHRON17                  (-99 -88 -66=SYSMIS).
RECODE CHRON18                  (-99 -88 -66=SYSMIS).
RECODE CHRON19                  (-99 -88 -66=SYSMIS).
RECODE CHRON20                  (-99 -88 -66=SYSMIS).
RECODE CHRON21                  (-99 -88 -66=SYSMIS).
RECODE CHRON22                  (-99 -88 -66=SYSMIS).
RECODE CHRON23                  (-99 -88 -66=SYSMIS).
RECODE CHRON24                  (-99 -88 -66=SYSMIS).
RECODE CHRON25                  (-99 -88 -66=SYSMIS).
RECODE CHRONB1                  (-99 -88 -66=SYSMIS).
RECODE CHRONB2                  (-99 -88 -66=SYSMIS).
RECODE CHRONB3                  (-99 -88 -66=SYSMIS).
RECODE CHRONB4                  (-99 -88 -66=SYSMIS).
RECODE CHRONB5                  (-99 -88 -66=SYSMIS).
RECODE CHRONB6                  (-99 -88 -66=SYSMIS).
RECODE CHRONB7                  (-99 -88 -66=SYSMIS).
RECODE CHRONB8                  (-99 -88 -66=SYSMIS).
RECODE CHRONB9                  (-99 -88 -66=SYSMIS).
RECODE CHRONB10                 (-99 -88 -66=SYSMIS).
RECODE CHRONB11                 (-99 -88 -66=SYSMIS).
RECODE CHRONB12                 (-99 -88 -66=SYSMIS).
RECODE CHRONB13                 (-99 -88 -66=SYSMIS).
RECODE CHRONB14                 (-99 -88 -66=SYSMIS).
RECODE CHRONB15                 (-99 -88 -66=SYSMIS).
RECODE CHRONB16                 (-99 -88 -66=SYSMIS).
RECODE CHRONB17                 (-99 -88 -66=SYSMIS).
RECODE CHRONB18                 (-99 -88 -66=SYSMIS).
RECODE CHRONB19                 (-99 -88 -66=SYSMIS).
RECODE CHRONB20                 (-99 -88 -66=SYSMIS).
RECODE CHRONB21                 (-99 -88 -66=SYSMIS).
RECODE CHRONB22                 (-99 -88 -66=SYSMIS).
RECODE CHRONB23                 (-99 -88 -66=SYSMIS).
RECODE CHRONB24                 (-99 -88 -66=SYSMIS).
RECODE CHRONB25                 (-99 -88 -66=SYSMIS).
RECODE PCLASS1                  (-99 -88 -66=SYSMIS).
RECODE PCLASS2                  (-99 -88 -66=SYSMIS).
RECODE PCLASS3                  (-99 -88 -66=SYSMIS).
RECODE PCLASS4                  (-99 -88 -66=SYSMIS).
RECODE PCLASS5                  (-99 -88 -66=SYSMIS).
RECODE PCLASS6                  (-99 -88 -66=SYSMIS).
RECODE PCLASS7                  (-99 -88 -66=SYSMIS).
RECODE PCLASS8                  (-99 -88 -66=SYSMIS).
RECODE PCLASS9                  (-99 -88 -66=SYSMIS).
RECODE PCLASS10                 (-99 -88 -66=SYSMIS).
RECODE PCLASS11                 (-99 -88 -66=SYSMIS).
RECODE PCLASS12                 (-99 -88 -66=SYSMIS).
RECODE PCLASS13                 (-99 -88 -66=SYSMIS).
RECODE PCLASS14                 (-99 -88 -66=SYSMIS).
RECODE PCLASS15                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NIS_2012_DX_PR_GRPS.SAV' / COMPRESSED.
