/*****************************************************************************
* SPSSload_NIS_2014_Core.SPS
* This program will load the 2014 NIS ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2014_Core.ASC' FIXED / 
    AGE                        1-  3
    AGE_NEONATE                4-  5
    AMONTH                     6-  7
    AWEEKEND                   8-  9
    DIED                      10- 11
    DISCWT                    12- 22
    DISPUNIFORM               23- 24
    DQTR                      25- 26
    DRG                       27- 29
    DRG24                     30- 32
    DRGVER                    33- 34
    DRG_NoPOA                 35- 37
    DX1                       38- 42 (A)
    DX2                       43- 47 (A)
    DX3                       48- 52 (A)
    DX4                       53- 57 (A)
    DX5                       58- 62 (A)
    DX6                       63- 67 (A)
    DX7                       68- 72 (A)
    DX8                       73- 77 (A)
    DX9                       78- 82 (A)
    DX10                      83- 87 (A)
    DX11                      88- 92 (A)
    DX12                      93- 97 (A)
    DX13                      98-102 (A)
    DX14                     103-107 (A)
    DX15                     108-112 (A)
    DX16                     113-117 (A)
    DX17                     118-122 (A)
    DX18                     123-127 (A)
    DX19                     128-132 (A)
    DX20                     133-137 (A)
    DX21                     138-142 (A)
    DX22                     143-147 (A)
    DX23                     148-152 (A)
    DX24                     153-157 (A)
    DX25                     158-162 (A)
    DX26                     163-167 (A)
    DX27                     168-172 (A)
    DX28                     173-177 (A)
    DX29                     178-182 (A)
    DX30                     183-187 (A)
    DXCCS1                   188-190
    DXCCS2                   191-193
    DXCCS3                   194-196
    DXCCS4                   197-199
    DXCCS5                   200-202
    DXCCS6                   203-205
    DXCCS7                   206-208
    DXCCS8                   209-211
    DXCCS9                   212-214
    DXCCS10                  215-217
    DXCCS11                  218-220
    DXCCS12                  221-223
    DXCCS13                  224-226
    DXCCS14                  227-229
    DXCCS15                  230-232
    DXCCS16                  233-235
    DXCCS17                  236-238
    DXCCS18                  239-241
    DXCCS19                  242-244
    DXCCS20                  245-247
    DXCCS21                  248-250
    DXCCS22                  251-253
    DXCCS23                  254-256
    DXCCS24                  257-259
    DXCCS25                  260-262
    DXCCS26                  263-265
    DXCCS27                  266-268
    DXCCS28                  269-271
    DXCCS29                  272-274
    DXCCS30                  275-277
    ECODE1                   278-282 (A)
    ECODE2                   283-287 (A)
    ECODE3                   288-292 (A)
    ECODE4                   293-297 (A)
    ELECTIVE                 298-299
    E_CCS1                   300-303
    E_CCS2                   304-307
    E_CCS3                   308-311
    E_CCS4                   312-315
    FEMALE                   316-317
    HCUP_ED                  318-320
    HOSPBRTH                 321-322
    HOSP_DIVISION            323-324
    HOSP_NIS                 325-329
    KEY_NIS                  330-339
    LOS                      340-344
    MDC                      345-346
    MDC24                    347-348
    MDC_NoPOA                349-350
    NCHRONIC                 351-352
    NDX                      353-354
    NECODE                   355-357
    NEOMAT                   358-359
    NIS_STRATUM              360-363
    NPR                      364-365
    ORPROC                   366-367
    PAY1                     368-369
    PL_NCHS                  370-372
    PR1                      373-376 (A)
    PR2                      377-380 (A)
    PR3                      381-384 (A)
    PR4                      385-388 (A)
    PR5                      389-392 (A)
    PR6                      393-396 (A)
    PR7                      397-400 (A)
    PR8                      401-404 (A)
    PR9                      405-408 (A)
    PR10                     409-412 (A)
    PR11                     413-416 (A)
    PR12                     417-420 (A)
    PR13                     421-424 (A)
    PR14                     425-428 (A)
    PR15                     429-432 (A)
    PRCCS1                   433-435
    PRCCS2                   436-438
    PRCCS3                   439-441
    PRCCS4                   442-444
    PRCCS5                   445-447
    PRCCS6                   448-450
    PRCCS7                   451-453
    PRCCS8                   454-456
    PRCCS9                   457-459
    PRCCS10                  460-462
    PRCCS11                  463-465
    PRCCS12                  466-468
    PRCCS13                  469-471
    PRCCS14                  472-474
    PRCCS15                  475-477
    PRDAY1                   478-480
    PRDAY2                   481-483
    PRDAY3                   484-486
    PRDAY4                   487-489
    PRDAY5                   490-492
    PRDAY6                   493-495
    PRDAY7                   496-498
    PRDAY8                   499-501
    PRDAY9                   502-504
    PRDAY10                  505-507
    PRDAY11                  508-510
    PRDAY12                  511-513
    PRDAY13                  514-516
    PRDAY14                  517-519
    PRDAY15                  520-522
    RACE                     523-524
    SERVICELINE              525-527
    TOTCHG                   528-537
    TRAN_IN                  538-539
    TRAN_OUT                 540-541
    YEAR                     542-545
    ZIPINC_QRTL              546-547.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRG24                    (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    DXCCS16                  (F3.0) /
    DXCCS17                  (F3.0) /
    DXCCS18                  (F3.0) /
    DXCCS19                  (F3.0) /
    DXCCS20                  (F3.0) /
    DXCCS21                  (F3.0) /
    DXCCS22                  (F3.0) /
    DXCCS23                  (F3.0) /
    DXCCS24                  (F3.0) /
    DXCCS25                  (F3.0) /
    DXCCS26                  (F3.0) /
    DXCCS27                  (F3.0) /
    DXCCS28                  (F3.0) /
    DXCCS29                  (F3.0) /
    DXCCS30                  (F3.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSPBRTH                 (F2.0) /
    HOSP_DIVISION            (F2.0) /
    HOSP_NIS                 (F5.0) /
    KEY_NIS                  (F10.0) /
    LOS                      (F5.0) /
    MDC                      (F2.0) /
    MDC24                    (F2.0) /
    MDC_NoPOA                (F2.0) /
    NCHRONIC                 (F2.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NIS_STRATUM              (F4.0) /
    NPR                      (F2.0) /
    ORPROC                   (F2.0) /
    PAY1                     (F2.0) /
    PL_NCHS                  (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    SERVICELINE              (F3.0) /
    TOTCHG                   (F10.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "NIS discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRG24                    "DRG, version 24"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DX16                     "Diagnosis 16"
    DX17                     "Diagnosis 17"
    DX18                     "Diagnosis 18"
    DX19                     "Diagnosis 19"
    DX20                     "Diagnosis 20"
    DX21                     "Diagnosis 21"
    DX22                     "Diagnosis 22"
    DX23                     "Diagnosis 23"
    DX24                     "Diagnosis 24"
    DX25                     "Diagnosis 25"
    DX26                     "Diagnosis 26"
    DX27                     "Diagnosis 27"
    DX28                     "Diagnosis 28"
    DX29                     "Diagnosis 29"
    DX30                     "Diagnosis 30"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    DXCCS16                  "CCS: diagnosis 16"
    DXCCS17                  "CCS: diagnosis 17"
    DXCCS18                  "CCS: diagnosis 18"
    DXCCS19                  "CCS: diagnosis 19"
    DXCCS20                  "CCS: diagnosis 20"
    DXCCS21                  "CCS: diagnosis 21"
    DXCCS22                  "CCS: diagnosis 22"
    DXCCS23                  "CCS: diagnosis 23"
    DXCCS24                  "CCS: diagnosis 24"
    DXCCS25                  "CCS: diagnosis 25"
    DXCCS26                  "CCS: diagnosis 26"
    DXCCS27                  "CCS: diagnosis 27"
    DXCCS28                  "CCS: diagnosis 28"
    DXCCS29                  "CCS: diagnosis 29"
    DXCCS30                  "CCS: diagnosis 30"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSPBRTH                 "Indicator of birth in this hospital"
    HOSP_DIVISION            "Census Division of hospital"
    HOSP_NIS                 "NIS hospital number"
    KEY_NIS                  "NIS record number"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC24                    "MDC, version 24"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    NCHRONIC                 "Number of chronic conditions"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NIS_STRATUM              "NIS hospital stratum"
    NPR                      "Number of procedures on this record"
    ORPROC                   "Major operating room procedure indicator"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    RACE                     "Race (uniform)"
    SERVICELINE              "Hospital Service Line"
    TOTCHG                   "Total charges (cleaned)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG24                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE DXCCS16                  (-99 -88 -66=SYSMIS).
RECODE DXCCS17                  (-99 -88 -66=SYSMIS).
RECODE DXCCS18                  (-99 -88 -66=SYSMIS).
RECODE DXCCS19                  (-99 -88 -66=SYSMIS).
RECODE DXCCS20                  (-99 -88 -66=SYSMIS).
RECODE DXCCS21                  (-99 -88 -66=SYSMIS).
RECODE DXCCS22                  (-99 -88 -66=SYSMIS).
RECODE DXCCS23                  (-99 -88 -66=SYSMIS).
RECODE DXCCS24                  (-99 -88 -66=SYSMIS).
RECODE DXCCS25                  (-99 -88 -66=SYSMIS).
RECODE DXCCS26                  (-99 -88 -66=SYSMIS).
RECODE DXCCS27                  (-99 -88 -66=SYSMIS).
RECODE DXCCS28                  (-99 -88 -66=SYSMIS).
RECODE DXCCS29                  (-99 -88 -66=SYSMIS).
RECODE DXCCS30                  (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_DIVISION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC24                    (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NCHRONIC                 (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE ORPROC                   (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE SERVICELINE              (-99 -88 -66=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2014_Core.SAV' / COMPRESSED.
