/*****************************************************************************
* SPSSload_NIS_2016_Core.SPS
* This program will load the NIS_2016_Core ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2016_Core.ASC' FIXED / 
    AGE                        1-  3
    AGE_NEONATE                4-  5
    AMONTH                     6-  7
    AWEEKEND                   8-  9
    DIED                      10- 11
    DISCWT                    12- 22
    DISPUNIFORM               23- 24
    DQTR                      25- 26
    DRG                       27- 29
    DRGVER                    30- 31
    DRG_NoPOA                 32- 34
    DXVER                     35- 36
    ELECTIVE                  37- 38
    FEMALE                    39- 40
    HCUP_ED                   41- 43
    HOSP_DIVISION             44- 45
    HOSP_NIS                  46- 50
    I10_DX1                   51- 57 (A)
    I10_DX2                   58- 64 (A)
    I10_DX3                   65- 71 (A)
    I10_DX4                   72- 78 (A)
    I10_DX5                   79- 85 (A)
    I10_DX6                   86- 92 (A)
    I10_DX7                   93- 99 (A)
    I10_DX8                  100-106 (A)
    I10_DX9                  107-113 (A)
    I10_DX10                 114-120 (A)
    I10_DX11                 121-127 (A)
    I10_DX12                 128-134 (A)
    I10_DX13                 135-141 (A)
    I10_DX14                 142-148 (A)
    I10_DX15                 149-155 (A)
    I10_DX16                 156-162 (A)
    I10_DX17                 163-169 (A)
    I10_DX18                 170-176 (A)
    I10_DX19                 177-183 (A)
    I10_DX20                 184-190 (A)
    I10_DX21                 191-197 (A)
    I10_DX22                 198-204 (A)
    I10_DX23                 205-211 (A)
    I10_DX24                 212-218 (A)
    I10_DX25                 219-225 (A)
    I10_DX26                 226-232 (A)
    I10_DX27                 233-239 (A)
    I10_DX28                 240-246 (A)
    I10_DX29                 247-253 (A)
    I10_DX30                 254-260 (A)
    I10_ECAUSE1              261-267 (A)
    I10_ECAUSE2              268-274 (A)
    I10_ECAUSE3              275-281 (A)
    I10_ECAUSE4              282-288 (A)
    I10_NDX                  289-290
    I10_NECAUSE              291-293
    I10_NPR                  294-295
    I10_PR1                  296-302 (A)
    I10_PR2                  303-309 (A)
    I10_PR3                  310-316 (A)
    I10_PR4                  317-323 (A)
    I10_PR5                  324-330 (A)
    I10_PR6                  331-337 (A)
    I10_PR7                  338-344 (A)
    I10_PR8                  345-351 (A)
    I10_PR9                  352-358 (A)
    I10_PR10                 359-365 (A)
    I10_PR11                 366-372 (A)
    I10_PR12                 373-379 (A)
    I10_PR13                 380-386 (A)
    I10_PR14                 387-393 (A)
    I10_PR15                 394-400 (A)
    KEY_NIS                  401-410
    LOS                      411-415
    MDC                      416-417
    MDC_NoPOA                418-419
    NIS_STRATUM              420-423
    PAY1                     424-425
    PL_NCHS                  426-428
    PRDAY1                   429-431
    PRDAY2                   432-434
    PRDAY3                   435-437
    PRDAY4                   438-440
    PRDAY5                   441-443
    PRDAY6                   444-446
    PRDAY7                   447-449
    PRDAY8                   450-452
    PRDAY9                   453-455
    PRDAY10                  456-458
    PRDAY11                  459-461
    PRDAY12                  462-464
    PRDAY13                  465-467
    PRDAY14                  468-470
    PRDAY15                  471-473
    PRVER                    474-475
    RACE                     476-477
    TOTCHG                   478-487
    TRAN_IN                  488-489
    TRAN_OUT                 490-491
    YEAR                     492-495
    ZIPINC_QRTL              496-497.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    DXVER                    (F2.0) /
    ELECTIVE                 (F2.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSP_DIVISION            (F2.0) /
    HOSP_NIS                 (F5.0) /
    I10_NDX                  (F2.0) /
    I10_NECAUSE              (F3.0) /
    I10_NPR                  (F2.0) /
    KEY_NIS                  (F10.0) /
    LOS                      (F5.0) /
    MDC                      (F2.0) /
    MDC_NoPOA                (F2.0) /
    NIS_STRATUM              (F4.0) /
    PAY1                     (F2.0) /
    PL_NCHS                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    PRVER                    (F2.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "NIS discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DXVER                    "Diagnosis Version"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_DIVISION            "Census Division of hospital"
    HOSP_NIS                 "NIS hospital number"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_ECAUSE1              "ICD-10-CM External cause 1"
    I10_ECAUSE2              "ICD-10-CM External cause 2"
    I10_ECAUSE3              "ICD-10-CM External cause 3"
    I10_ECAUSE4              "ICD-10-CM External cause 4"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NECAUSE              "ICD-10-CM Number of External cause codes on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    KEY_NIS                  "NIS record number"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    NIS_STRATUM              "NIS hospital stratum"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRVER                    "Procedure Version"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSP_DIVISION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE I10_NDX                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_NECAUSE              (-99 -88 -66=SYSMIS).
RECODE I10_NPR                  (-9 -8 -6 -5=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRVER                    (-9 -8 -6 -5=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2016_Core.SAV' / COMPRESSED.
