/*****************************************************************************
* SPSSload_NIS_2017_Severity.SPS
* This program will load the NIS_2017_Severity ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2017_Severity.ASC' FIXED / 
    HOSP_NIS                   1-  5
    KEY_NIS                    6- 15
    APRDRG                    16- 19
    APRDRG_Risk_Mortality     20- 21
    APRDRG_Severity           22- 23.

***  Specify write formats  ***.
FORMATS
    HOSP_NIS                 (F5.0) /
    KEY_NIS                  (F10.0) /
    APRDRG                   (F4.0) /
    APRDRG_Risk_Mortality    (F2.0) /
    APRDRG_Severity          (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_NIS                 "NIS hospital number"
    KEY_NIS                  "NIS record number"
    APRDRG                   "All Patient Refined DRG"
    APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
    APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass" .

*** Convert special values to system missing values ***.
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE APRDRG                   (-999 -888 -666=SYSMIS).
RECODE APRDRG_Risk_Mortality    (-9 -8 -6 -5=SYSMIS).
RECODE APRDRG_Severity          (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2017_Severity.SAV' / COMPRESSED.
