/*****************************************************************************
* SPSSload_NIS_2022_Hospital.SPS
* This program will load the NIS_2022_Hospital ASCII File into SPSS.
* Created on 10/15/2024.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2022_Hospital.ASC' FIXED / 
    DISCWT                      1-  11
    HOSP_BEDSIZE               12-  13
    HOSP_DIVISION              14-  15
    HOSP_LOCTEACH              16-  17
    HOSP_NIS                   18-  22
    HOSP_REGION                23-  24
    H_CONTRL                   25-  26
    NIS_STRATUM                27-  30
    N_DISC_U                   31-  38
    N_HOSP_U                   39-  42
    S_DISC_U                   43-  50
    S_HOSP_U                   51-  54
    TOTAL_DISC                 55-  60
    YEAR                       61-  64.

***  Specify write formats  ***.
FORMATS
    DISCWT                   (F11.7) /
    HOSP_BEDSIZE             (F2.0) /
    HOSP_DIVISION            (F2.0) /
    HOSP_LOCTEACH            (F2.0) /
    HOSP_NIS                 (F5.0) /
    HOSP_REGION              (F2.0) /
    H_CONTRL                 (F2.0) /
    NIS_STRATUM              (F4.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    S_DISC_U                 (F8.0) /
    S_HOSP_U                 (F4.0) /
    TOTAL_DISC               (F6.0) /
    YEAR                     (F4.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    DISCWT                   "NIS discharge weight"
    HOSP_BEDSIZE             "Relative bed size category of hospital (STRATA)"
    HOSP_DIVISION            "Census Division of hospital (STRATA)"
    HOSP_LOCTEACH            "Location/teaching status of hospital (STRATA)"
    HOSP_NIS                 "NIS hospital number"
    HOSP_REGION              "Region of hospital"
    H_CONTRL                 "Control/ownership of hospital (STRATA)"
    NIS_STRATUM              "NIS hospital stratum"
    N_DISC_U                 "Number of universe discharges in the stratum"
    N_HOSP_U                 "Number of universe hospitals in the stratum"
    S_DISC_U                 "Number of sample discharges in the stratum"
    S_HOSP_U                 "Number of sample hospitals in the stratum"
    TOTAL_DISC               "Total number of discharges from this hospital in the NIS"
    YEAR                     "Calendar year" .

*** Convert special values to system missing values ***.
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_DIVISION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE H_CONTRL                 (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRATUM              (-999 -888 -666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE TOTAL_DISC               (-99999 -88888 -66666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NIS_2022_Hospital.SAV' / COMPRESSED.
