/*****************************************************************************/
/* SPSSload_NRD_2013_Core.SPS                                          */
/* This program will load the 2013 NRD csv Core File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NRD_2013_Core.csv"
    /delimiters = ',' 
    /variables = 
    AGE                      F3.0
    AWEEKEND                 F2.0
    DIED                     F2.0
    DISCWT                   F11.7
    DISPUNIFORM              F2.0
    DMONTH                   F2.0
    DQTR                     F2.0
    DRG                      F3.0
    DRGVER                   F2.0
    DRG_NoPOA                F3.0
    DX1                      A5
    DX2                      A5
    DX3                      A5
    DX4                      A5
    DX5                      A5
    DX6                      A5
    DX7                      A5
    DX8                      A5
    DX9                      A5
    DX10                     A5
    DX11                     A5
    DX12                     A5
    DX13                     A5
    DX14                     A5
    DX15                     A5
    DX16                     A5
    DX17                     A5
    DX18                     A5
    DX19                     A5
    DX20                     A5
    DX21                     A5
    DX22                     A5
    DX23                     A5
    DX24                     A5
    DX25                     A5
    DXCCS1                   F3.0
    DXCCS2                   F3.0
    DXCCS3                   F3.0
    DXCCS4                   F3.0
    DXCCS5                   F3.0
    DXCCS6                   F3.0
    DXCCS7                   F3.0
    DXCCS8                   F3.0
    DXCCS9                   F3.0
    DXCCS10                  F3.0
    DXCCS11                  F3.0
    DXCCS12                  F3.0
    DXCCS13                  F3.0
    DXCCS14                  F3.0
    DXCCS15                  F3.0
    DXCCS16                  F3.0
    DXCCS17                  F3.0
    DXCCS18                  F3.0
    DXCCS19                  F3.0
    DXCCS20                  F3.0
    DXCCS21                  F3.0
    DXCCS22                  F3.0
    DXCCS23                  F3.0
    DXCCS24                  F3.0
    DXCCS25                  F3.0
    ECODE1                   A5
    ECODE2                   A5
    ECODE3                   A5
    ECODE4                   A5
    ELECTIVE                 F2.0
    E_CCS1                   F4.0
    E_CCS2                   F4.0
    E_CCS3                   F4.0
    E_CCS4                   F4.0
    FEMALE                   F2.0
    HCUP_ED                  F2.0
    HOSP_NRD                 F5.0
    KEY_NRD                  F15.0
    LOS                      F5.0
    MDC                      F2.0
    MDC_NoPOA                F2.0
    NCHRONIC                 F2.0
    NDX                      F3.0
    NECODE                   F3.0
    NPR                      F3.0
    NRD_DaysToEvent          F10.0
    NRD_STRATUM              F5.0
    NRD_VisitLink            A6
    ORPROC                   F2.0
    PAY1                     F2.0
    PL_NCHS                  F3.0
    PR1                      A4
    PR2                      A4
    PR3                      A4
    PR4                      A4
    PR5                      A4
    PR6                      A4
    PR7                      A4
    PR8                      A4
    PR9                      A4
    PR10                     A4
    PR11                     A4
    PR12                     A4
    PR13                     A4
    PR14                     A4
    PR15                     A4
    PRCCS1                   F3.0
    PRCCS2                   F3.0
    PRCCS3                   F3.0
    PRCCS4                   F3.0
    PRCCS5                   F3.0
    PRCCS6                   F3.0
    PRCCS7                   F3.0
    PRCCS8                   F3.0
    PRCCS9                   F3.0
    PRCCS10                  F3.0
    PRCCS11                  F3.0
    PRCCS12                  F3.0
    PRCCS13                  F3.0
    PRCCS14                  F3.0
    PRCCS15                  F3.0
    REHABTRANSFER            F2.0
    RESIDENT                 F2.0
    SAMEDAYEVENT             A2
    TOTCHG                   F10.0
    YEAR                     F4.0
    ZIPINC_QRTL              F2.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DMONTH                   "Discharge month"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DX16                     "Diagnosis 16"
    DX17                     "Diagnosis 17"
    DX18                     "Diagnosis 18"
    DX19                     "Diagnosis 19"
    DX20                     "Diagnosis 20"
    DX21                     "Diagnosis 21"
    DX22                     "Diagnosis 22"
    DX23                     "Diagnosis 23"
    DX24                     "Diagnosis 24"
    DX25                     "Diagnosis 25"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    DXCCS16                  "CCS: diagnosis 16"
    DXCCS17                  "CCS: diagnosis 17"
    DXCCS18                  "CCS: diagnosis 18"
    DXCCS19                  "CCS: diagnosis 19"
    DXCCS20                  "CCS: diagnosis 20"
    DXCCS21                  "CCS: diagnosis 21"
    DXCCS22                  "CCS: diagnosis 22"
    DXCCS23                  "CCS: diagnosis 23"
    DXCCS24                  "CCS: diagnosis 24"
    DXCCS25                  "CCS: diagnosis 25"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_NRD                 "NRD hospital identifier"
    KEY_NRD                  "NRD record identifier"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    NCHRONIC                 "Number of chronic conditions"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NPR                      "Number of procedures on this record"
    NRD_DaysToEvent          "Timing variable used to identify days between admissions"
    NRD_STRATUM              "NRD stratum used for weighting"
    NRD_VisitLink            "NRD visitlink"
    ORPROC                   "Major operating room procedure indicator"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    REHABTRANSFER            "A combined record involving rehab transfer"
    RESIDENT                 "Patient State is the same as Hospital State"
    SAMEDAYEVENT             "Transfer flag indicating combination of discharges involve same day events"
    TOTCHG                   "Total charges (cleaned)"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

/* Convert special values to system missing values */
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE DXCCS16                  (-99 -88 -66=SYSMIS).
RECODE DXCCS17                  (-99 -88 -66=SYSMIS).
RECODE DXCCS18                  (-99 -88 -66=SYSMIS).
RECODE DXCCS19                  (-99 -88 -66=SYSMIS).
RECODE DXCCS20                  (-99 -88 -66=SYSMIS).
RECODE DXCCS21                  (-99 -88 -66=SYSMIS).
RECODE DXCCS22                  (-99 -88 -66=SYSMIS).
RECODE DXCCS23                  (-99 -88 -66=SYSMIS).
RECODE DXCCS24                  (-99 -88 -66=SYSMIS).
RECODE DXCCS25                  (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_NRD                 (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NRD                  (-99999999999999 -88888888888888 -66666666666666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NCHRONIC                 (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-99 -88 -66=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NPR                      (-99 -88 -66=SYSMIS).
RECODE NRD_DaysToEvent          (-999999999 -888888888 -666666666=SYSMIS).
RECODE NRD_STRATUM              (-9999 -8888 -6666=SYSMIS).
RECODE ORPROC                   (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE REHABTRANSFER            (-9 -8 -6 -5=SYSMIS).
RECODE RESIDENT                 (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NRD_2013_Core.SAV' / COMPRESSED.
