/*******************************************************************
* Creation Date: 06/09/2024   
*   NJ_SASD_2022_AHAL.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT AHAL FILE INTO SPSS                             
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'NJ_SASD_2022_AHAL.asc' FIXED SKIP=2 / 
 AHAID                           1-   7 (A)
 DSHOSPID                        8-  24 (A)
 HOSPID                         25-  29
 HFIPSSTCO                      30-  34
 HOSPST                         35-  36 (A)
 HOSPITAL_OWNED                 37-  38
 YEAR                           39-  42.


/***  Specify write formats  ***/
FORMATS
 HOSPID                       (F4.0) /
 HFIPSSTCO                    (F4.0) /
 HOSPITAL_OWNED               (F3.0) /
 YEAR                         (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AHAID                        "AHA hospital identifier with the leading 6"
 DSHOSPID                     "Data source hospital identifier"
 HOSPID                       "HCUP hospital identification number"
 HFIPSSTCO                    "Hospital FIPS state/county code"
 HOSPST                       "Hospital state postal code"
 HOSPITAL_OWNED               "Hospital Owned Ambulatory Surgery Center Indicator"
 YEAR                         "Calendar year" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE HFIPSSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HOSPITAL_OWNED
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NJ_SASD_2022_AHAL.sav' /COMPRESSED.
