/*******************************************************************            
* Creation Date: 07/25/2018                                                     
*   CO_SASD_2016_CORE.SAS:                                                      
*      THE SAS CODE SHOWN BELOW WILL LOAD THE ASCII                             
*      OUTPATIENT SASD CORE FILE INTO SAS                                       
*      INPATIENT STAY CORE FILE INTO SAS                                        
*******************************************************************/            
                                                                                
                                                                                
***************************************************************;                
* ----------------------------------------------------------- *;                
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;                
* |  terms and conditions of the HCUP Data Use Agreement.   | *;                
* ----------------------------------------------------------- *;                
***************************************************************;                
                                                                                
                                                                                
***********************************************;                                
*  Create SAS informats for missing values     ;                                
***********************************************;                                
PROC FORMAT;                                                                    
  INVALUE N2PF                                                                  
    '-9' = .                                                                    
    '-8' = .A                                                                   
    '-6' = .C                                                                   
    '-5' = .N                                                                   
    OTHER = (|2.|)                                                              
  ;                                                                             
  INVALUE N3PF                                                                  
    '-99' = .                                                                   
    '-88' = .A                                                                  
    '-66' = .C                                                                  
    OTHER = (|3.|)                                                              
  ;                                                                             
  INVALUE N4PF                                                                  
    '-999' = .                                                                  
    '-888' = .A                                                                 
    '-666' = .C                                                                 
    OTHER = (|4.|)                                                              
  ;                                                                             
  INVALUE N4P1F                                                                 
    '-9.9' = .                                                                  
    '-8.8' = .A                                                                 
    '-6.6' = .C                                                                 
    OTHER = (|4.1|)                                                             
  ;                                                                             
  INVALUE N5PF                                                                  
    '-9999' = .                                                                 
    '-8888' = .A                                                                
    '-6666' = .C                                                                
    OTHER = (|5.|)                                                              
  ;                                                                             
  INVALUE N5P2F                                                                 
    '-9.99' = .                                                                 
    '-8.88' = .A                                                                
    '-6.66' = .C                                                                
    OTHER = (|5.2|)                                                             
  ;                                                                             
  INVALUE N6PF                                                                  
    '-99999' = .                                                                
    '-88888' = .A                                                               
    '-66666' = .C                                                               
    OTHER = (|6.|)                                                              
  ;                                                                             
  INVALUE N6P2F                                                                 
    '-99.99' = .                                                                
    '-88.88' = .A                                                               
    '-66.66' = .C                                                               
    OTHER = (|6.2|)                                                             
  ;                                                                             
  INVALUE N7P2F                                                                 
    '-999.99' = .                                                               
    '-888.88' = .A                                                              
    '-666.66' = .C                                                              
    OTHER = (|7.2|)                                                             
  ;                                                                             
  INVALUE N7P4F                                                                 
    '-9.9999' = .                                                               
    '-8.8888' = .A                                                              
    '-6.6666' = .C                                                              
    OTHER = (|7.4|)                                                             
  ;                                                                             
  INVALUE N8PF                                                                  
    '-9999999' = .                                                              
    '-8888888' = .A                                                             
    '-6666666' = .C                                                             
    OTHER = (|8.|)                                                              
  ;                                                                             
  INVALUE N8P2F                                                                 
    '-9999.99' = .                                                              
    '-8888.88' = .A                                                             
    '-6666.66' = .C                                                             
    OTHER = (|8.2|)                                                             
  ;                                                                             
  INVALUE N9PF                                                                  
    '-99999999' = .                                                             
    '-88888888' = .A                                                            
    '-66666666' = .C                                                            
    OTHER = (|9.|)                                                              
  ;                                                                             
  INVALUE N9P2F                                                                 
    '-99999.99' = .                                                             
    '-88888.88' = .A                                                            
    '-66666.66' = .C                                                            
    OTHER = (|9.2|)                                                             
  ;                                                                             
  INVALUE N10PF                                                                 
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|10.|)                                                             
  ;                                                                             
  INVALUE N10P4F                                                                
    '-9999.9999' = .                                                            
    '-8888.8888' = .A                                                           
    '-6666.6666' = .C                                                           
    OTHER = (|10.4|)                                                            
  ;                                                                             
  INVALUE N10P5F                                                                
    '-999.99999' = .                                                            
    '-888.88888' = .A                                                           
    '-666.66666' = .C                                                           
    OTHER = (|10.5|)                                                            
  ;                                                                             
  INVALUE DATE10F                                                               
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|MMDDYY10.|)                                                       
  ;                                                                             
  INVALUE N11PF                                                                 
    '-9999999999' = .                                                           
    '-8888888888' = .A                                                          
    '-6666666666' = .C                                                          
    OTHER = (|11.|)                                                             
  ;                                                                             
  INVALUE N11P2F                                                                
    '-9999999.99' = .                                                           
    '-8888888.88' = .A                                                          
    '-6666666.66' = .C                                                          
    OTHER = (|11.2|)                                                            
  ;                                                                             
  INVALUE N12P2F                                                                
    '-99999999.99' = .                                                          
    '-88888888.88' = .A                                                         
    '-66666666.66' = .C                                                         
    OTHER = (|12.2|)                                                            
  ;                                                                             
  INVALUE N12P5F                                                                
    '-99999.99999' = .                                                          
    '-88888.88888' = .A                                                         
    '-66666.66666' = .C                                                         
    OTHER = (|12.5|)                                                            
  ;                                                                             
  INVALUE N13PF                                                                 
    '-999999999999' = .                                                         
    '-888888888888' = .A                                                        
    '-666666666666' = .C                                                        
    OTHER = (|13.|)                                                             
  ;                                                                             
  INVALUE N15P2F                                                                
    '-99999999999.99' = .                                                       
    '-88888888888.88' = .A                                                      
    '-66666666666.66' = .C                                                      
    OTHER = (|15.2|)                                                            
  ;                                                                             
  RUN;                                                                          
                                                                                
                                                                                
*******************************;                                                
*  Data Step                  *;                                                
*******************************;                                                
DATA CO_SASDC_2016_CORE;                                                        
INFILE 'CO_SASD_2016_CORE.ASC' FIRSTOBS=3 LRECL = 1151;                         
                                                                                
*** Variable attribute ***;                                                     
ATTRIB                                                                          
  AGE                        LENGTH=3                                           
  LABEL="Age in years at admission"                                             
                                                                                
  AGEMONTH                   LENGTH=3                                           
  LABEL="Age in months (when age < 11 years)"                                   
                                                                                
  AMONTH                     LENGTH=3                                           
  LABEL="Admission month"                                                       
                                                                                
  ATYPE                      LENGTH=3                                           
  LABEL="Admission type"                                                        
                                                                                
  AWEEKEND                   LENGTH=3                                           
  LABEL="Admission day is a weekend"                                            
                                                                                
  CPT1                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 1"                                            
                                                                                
  CPT2                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 2"                                            
                                                                                
  CPT3                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 3"                                            
                                                                                
  CPT4                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 4"                                            
                                                                                
  CPT5                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 5"                                            
                                                                                
  CPT6                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 6"                                            
                                                                                
  CPT7                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 7"                                            
                                                                                
  CPT8                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 8"                                            
                                                                                
  CPT9                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 9"                                            
                                                                                
  CPT10                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 10"                                           
                                                                                
  CPT11                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 11"                                           
                                                                                
  CPT12                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 12"                                           
                                                                                
  CPT13                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 13"                                           
                                                                                
  CPT14                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 14"                                           
                                                                                
  CPT15                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 15"                                           
                                                                                
  CPTCCS1                    LENGTH=4                                           
  LABEL="CCS: CPT 1"                                                            
                                                                                
  CPTCCS2                    LENGTH=4                                           
  LABEL="CCS: CPT 2"                                                            
                                                                                
  CPTCCS3                    LENGTH=4                                           
  LABEL="CCS: CPT 3"                                                            
                                                                                
  CPTCCS4                    LENGTH=4                                           
  LABEL="CCS: CPT 4"                                                            
                                                                                
  CPTCCS5                    LENGTH=4                                           
  LABEL="CCS: CPT 5"                                                            
                                                                                
  CPTCCS6                    LENGTH=4                                           
  LABEL="CCS: CPT 6"                                                            
                                                                                
  CPTCCS7                    LENGTH=4                                           
  LABEL="CCS: CPT 7"                                                            
                                                                                
  CPTCCS8                    LENGTH=4                                           
  LABEL="CCS: CPT 8"                                                            
                                                                                
  CPTCCS9                    LENGTH=4                                           
  LABEL="CCS: CPT 9"                                                            
                                                                                
  CPTCCS10                   LENGTH=4                                           
  LABEL="CCS: CPT 10"                                                           
                                                                                
  CPTCCS11                   LENGTH=4                                           
  LABEL="CCS: CPT 11"                                                           
                                                                                
  CPTCCS12                   LENGTH=4                                           
  LABEL="CCS: CPT 12"                                                           
                                                                                
  CPTCCS13                   LENGTH=4                                           
  LABEL="CCS: CPT 13"                                                           
                                                                                
  CPTCCS14                   LENGTH=4                                           
  LABEL="CCS: CPT 14"                                                           
                                                                                
  CPTCCS15                   LENGTH=4                                           
  LABEL="CCS: CPT 15"                                                           
                                                                                
  DIED                       LENGTH=3                                           
  LABEL="Died during hospitalization"                                           
                                                                                
  DISP_X                     LENGTH=$2                                          
  LABEL="Disposition of patient (as received from source)"                      
                                                                                
  DISPUB04                   LENGTH=3                                           
  LABEL="Disposition of patient (UB-04 standard coding)"                        
                                                                                
  DISPUNIFORM                LENGTH=3                                           
  LABEL="Disposition of patient (uniform)"                                      
                                                                                
  DMONTH                     LENGTH=3                                           
  LABEL="Discharge month"                                                       
                                                                                
  DQTR                       LENGTH=3                                           
  LABEL="Discharge quarter"                                                     
                                                                                
  DSHOSPID                   LENGTH=$17                                         
  LABEL="Data source hospital identifier"                                       
                                                                                
  DXVER                      LENGTH=3                                           
  LABEL="Diagnosis Version"                                                     
                                                                                
  FEMALE                     LENGTH=3                                           
  LABEL="Indicator of sex"                                                      
                                                                                
  HCUP_ED                    LENGTH=3                                           
  LABEL="HCUP Emergency Department service indicator"                           
                                                                                
  HCUP_OS                    LENGTH=3                                           
  LABEL="HCUP Observation Stay service indicator"                               
                                                                                
  HCUP_SURGERY_BROAD_CPT     LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Number of reported CPT procedures that qualify as a surgery using a broad defin
ition"                                                                          
                                                                                
  HCUP_SURGERY_NARROW_CPT    LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Number of reported CPT procedures that qualify as a surgery using a narrow defi
nition"                                                                         
                                                                                
  Homeless                   LENGTH=3                                           
  LABEL="Indicator that patient is homeless"                                    
                                                                                
  HOSPST                     LENGTH=$2                                          
  LABEL="Hospital state postal code"                                            
                                                                                
  I10_DX1                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 1"                                                 
                                                                                
  I10_DX2                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 2"                                                 
                                                                                
  I10_DX3                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 3"                                                 
                                                                                
  I10_DX4                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 4"                                                 
                                                                                
  I10_DX5                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 5"                                                 
                                                                                
  I10_DX6                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 6"                                                 
                                                                                
  I10_DX7                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 7"                                                 
                                                                                
  I10_DX8                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 8"                                                 
                                                                                
  I10_DX9                    LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 9"                                                 
                                                                                
  I10_DX10                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 10"                                                
                                                                                
  I10_DX11                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 11"                                                
                                                                                
  I10_DX12                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 12"                                                
                                                                                
  I10_DX13                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 13"                                                
                                                                                
  I10_DX14                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 14"                                                
                                                                                
  I10_DX15                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 15"                                                
                                                                                
  I10_DX16                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 16"                                                
                                                                                
  I10_DX17                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 17"                                                
                                                                                
  I10_DX18                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 18"                                                
                                                                                
  I10_DX19                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 19"                                                
                                                                                
  I10_DX20                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 20"                                                
                                                                                
  I10_DX21                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 21"                                                
                                                                                
  I10_DX22                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 22"                                                
                                                                                
  I10_DX23                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 23"                                                
                                                                                
  I10_DX24                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 24"                                                
                                                                                
  I10_DX25                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 25"                                                
                                                                                
  I10_DX26                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 26"                                                
                                                                                
  I10_DX27                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 27"                                                
                                                                                
  I10_DX28                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 28"                                                
                                                                                
  I10_DX29                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 29"                                                
                                                                                
  I10_DX30                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 30"                                                
                                                                                
  I10_DX31                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 31"                                                
                                                                                
  I10_DX32                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 32"                                                
                                                                                
  I10_DX33                   LENGTH=$7                                          
  LABEL="ICD-10-CM Diagnosis 33"                                                
                                                                                
  I10_ECAUSE1                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 1"                                            
                                                                                
  I10_ECAUSE2                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 2"                                            
                                                                                
  I10_ECAUSE3                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 3"                                            
                                                                                
  I10_ECAUSE4                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 4"                                            
                                                                                
  I10_ECAUSE5                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 5"                                            
                                                                                
  I10_ECAUSE6                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 6"                                            
                                                                                
  I10_ECAUSE7                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 7"                                            
                                                                                
  I10_ECAUSE8                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 8"                                            
                                                                                
  I10_ECAUSE9                LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 9"                                            
                                                                                
  I10_ECAUSE10               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 10"                                           
                                                                                
  I10_ECAUSE11               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 11"                                           
                                                                                
  I10_ECAUSE12               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 12"                                           
                                                                                
  I10_ECAUSE13               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 13"                                           
                                                                                
  I10_ECAUSE14               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 14"                                           
                                                                                
  I10_ECAUSE15               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 15"                                           
                                                                                
  I10_ECAUSE16               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 16"                                           
                                                                                
  I10_ECAUSE17               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 17"                                           
                                                                                
  I10_ECAUSE18               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 18"                                           
                                                                                
  I10_ECAUSE19               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 19"                                           
                                                                                
  I10_ECAUSE20               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 20"                                           
                                                                                
  I10_ECAUSE21               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 21"                                           
                                                                                
  I10_ECAUSE22               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 22"                                           
                                                                                
  I10_ECAUSE23               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 23"                                           
                                                                                
  I10_ECAUSE24               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 24"                                           
                                                                                
  I10_ECAUSE25               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 25"                                           
                                                                                
  I10_ECAUSE26               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 26"                                           
                                                                                
  I10_ECAUSE27               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 27"                                           
                                                                                
  I10_ECAUSE28               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 28"                                           
                                                                                
  I10_ECAUSE29               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 29"                                           
                                                                                
  I10_ECAUSE30               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 30"                                           
                                                                                
  I10_ECAUSE31               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 31"                                           
                                                                                
  I10_ECAUSE32               LENGTH=$7                                          
  LABEL="ICD-10-CM External cause 32"                                           
                                                                                
  I10_NDX                    LENGTH=3                                           
  LABEL="ICD-10-CM Number of diagnoses on this record"                          
                                                                                
  I10_NECAUSE                LENGTH=3                                           
  LABEL="ICD-10-CM Number of External cause codes on this record"               
                                                                                
  I10_NPR                    LENGTH=3                                           
  LABEL="ICD-10-PCS Number of procedures on this record"                        
                                                                                
  I10_PR1                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 1"                                                
                                                                                
  I10_PR2                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 2"                                                
                                                                                
  I10_PR3                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 3"                                                
                                                                                
  I10_PR4                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 4"                                                
                                                                                
  I10_PR5                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 5"                                                
                                                                                
  I10_PR6                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 6"                                                
                                                                                
  I10_PR7                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 7"                                                
                                                                                
  I10_PR8                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 8"                                                
                                                                                
  I10_PR9                    LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 9"                                                
                                                                                
  I10_PR10                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 10"                                               
                                                                                
  I10_PR11                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 11"                                               
                                                                                
  I10_PR12                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 12"                                               
                                                                                
  I10_PR13                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 13"                                               
                                                                                
  I10_PR14                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 14"                                               
                                                                                
  I10_PR15                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 15"                                               
                                                                                
  I10_PR16                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 16"                                               
                                                                                
  I10_PR17                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 17"                                               
                                                                                
  I10_PR18                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 18"                                               
                                                                                
  I10_PR19                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 19"                                               
                                                                                
  I10_PR20                   LENGTH=$7                                          
  LABEL="ICD-10-PCS Procedure 20"                                               
                                                                                
  I10_PROCTYPE               LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure type indicator"                                   
                                                                                
  KEY                        LENGTH=8                      FORMAT=Z15.          
  LABEL="HCUP record identifier"                                                
                                                                                
  LOS                        LENGTH=4                                           
  LABEL="Length of stay (cleaned)"                                              
                                                                                
  LOS_X                      LENGTH=4                                           
  LABEL="Length of stay (as received from source)"                              
                                                                                
  MDNUM1_R                   LENGTH=5                                           
  LABEL="Physician 1 number (re-identified)"                                    
                                                                                
  MDNUM2_R                   LENGTH=5                                           
  LABEL="Physician 2 number (re-identified)"                                    
                                                                                
  MEDINCSTQ                  LENGTH=3                                           
  LABEL="Median household income state quartile for patient ZIP Code"           
                                                                                
  NCPT                       LENGTH=3                                           
  LABEL="Number of CPT/HCPCS procedures for this visit"                         
                                                                                
  PAY1                       LENGTH=3                                           
  LABEL="Primary expected payer (uniform)"                                      
                                                                                
  PAY1_X                     LENGTH=$2                                          
  LABEL="Primary expected payer (as received from source)"                      
                                                                                
  PL_CBSA                    LENGTH=3                                           
  LABEL="Patient location: Core Based Statistical Area (CBSA)"                  
                                                                                
  PL_NCHS                    LENGTH=3                                           
  LABEL="Patient Location: NCHS Urban-Rural Code"                               
                                                                                
  PL_RUCC                    LENGTH=3                                           
  LABEL="Patient location: Rural-Urban Continuum Codes(RUCC)"                   
                                                                                
  PL_UIC                     LENGTH=3                                           
  LABEL="Patient location: Urban Influence Codes"                               
                                                                                
  PL_UR_CAT4                 LENGTH=3                                           
  LABEL="Patient Location: Urban-Rural 4 Categories"                            
                                                                                
  PointOfOrigin_X            LENGTH=$1                                          
  LABEL="Point of origin for admission or visit, as received from source"       
                                                                                
  PointOfOriginUB04          LENGTH=$1                                          
  LABEL="Point of origin for admission or visit, UB-04 standard coding"         
                                                                                
  PRDAY1                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR1"                              
                                                                                
  PRDAY2                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR2"                              
                                                                                
  PRDAY3                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR3"                              
                                                                                
  PRDAY4                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR4"                              
                                                                                
  PRDAY5                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR5"                              
                                                                                
  PRDAY6                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR6"                              
                                                                                
  PRDAY7                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR7"                              
                                                                                
  PRDAY8                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR8"                              
                                                                                
  PRDAY9                     LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR9"                              
                                                                                
  PRDAY10                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR10"                             
                                                                                
  PRDAY11                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR11"                             
                                                                                
  PRDAY12                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR12"                             
                                                                                
  PRDAY13                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR13"                             
                                                                                
  PRDAY14                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR14"                             
                                                                                
  PRDAY15                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR15"                             
                                                                                
  PRDAY16                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR16"                             
                                                                                
  PRDAY17                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR17"                             
                                                                                
  PRDAY18                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR18"                             
                                                                                
  PRDAY19                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR19"                             
                                                                                
  PRDAY20                    LENGTH=4                                           
  LABEL="Number of days from admission to I10_PR20"                             
                                                                                
  PRVER                      LENGTH=3                                           
  LABEL="Procedure Version"                                                     
                                                                                
  PSTATE                     LENGTH=$2                                          
  LABEL="Patient State postal code"                                             
                                                                                
  PSTCO                      LENGTH=4                      FORMAT=Z5.           
  LABEL="Patient state/county FIPS code"                                        
                                                                                
  PSTCO2                     LENGTH=4                      FORMAT=Z5.           
  LABEL="Patient state/county FIPS code, possibly derived from ZIP Code"        
                                                                                
  RACE                       LENGTH=3                                           
  LABEL="Race (uniform)"                                                        
                                                                                
  RACE_X                     LENGTH=$1                                          
  LABEL="Race (as received from source)"                                        
                                                                                
  STATE_AS                   LENGTH=3                                           
  LABEL="State Ambulatory Surgery service indicator"                            
                                                                                
  STATE_ED                   LENGTH=3                                           
  LABEL="State Emergency Department service indicator"                          
                                                                                
  STATE_OS                   LENGTH=3                                           
  LABEL="State Observation Stay service indicator"                              
                                                                                
  TOTCHG                     LENGTH=6                                           
  LABEL="Total charges (cleaned)"                                               
                                                                                
  TOTCHG_X                   LENGTH=7                                           
  LABEL="Total charges (as received from source)"                               
                                                                                
  YEAR                       LENGTH=3                                           
  LABEL="Calendar year"                                                         
                                                                                
  ZIP                        LENGTH=$5                                          
  LABEL="Patient ZIP Code"                                                      
                                                                                
  ZIP3                       LENGTH=$3                                          
  LABEL="Patient ZIP Code, first 3 digits"                                      
                                                                                
  ZIPINC_QRTL                LENGTH=3                                           
  LABEL="Median household income national quartile for patient ZIP Code"        
                                                                                
  AYEAR                      LENGTH=3                                           
  LABEL="Admission year"                                                        
                                                                                
  BMONTH                     LENGTH=3                                           
  LABEL="Birth month"                                                           
                                                                                
  BYEAR                      LENGTH=3                                           
  LABEL="Birth year"                                                            
                                                                                
  PRMONTH1                   LENGTH=3                                           
  LABEL="Month of procedure 1"                                                  
                                                                                
  PRMONTH2                   LENGTH=3                                           
  LABEL="Month of procedure 2"                                                  
                                                                                
  PRMONTH3                   LENGTH=3                                           
  LABEL="Month of procedure 3"                                                  
                                                                                
  PRMONTH4                   LENGTH=3                                           
  LABEL="Month of procedure 4"                                                  
                                                                                
  PRMONTH5                   LENGTH=3                                           
  LABEL="Month of procedure 5"                                                  
                                                                                
  PRMONTH6                   LENGTH=3                                           
  LABEL="Month of procedure 6"                                                  
                                                                                
  PRMONTH7                   LENGTH=3                                           
  LABEL="Month of procedure 7"                                                  
                                                                                
  PRMONTH8                   LENGTH=3                                           
  LABEL="Month of procedure 8"                                                  
                                                                                
  PRMONTH9                   LENGTH=3                                           
  LABEL="Month of procedure 9"                                                  
                                                                                
  PRMONTH10                  LENGTH=3                                           
  LABEL="Month of procedure 10"                                                 
                                                                                
  PRMONTH11                  LENGTH=3                                           
  LABEL="Month of procedure 11"                                                 
                                                                                
  PRMONTH12                  LENGTH=3                                           
  LABEL="Month of procedure 12"                                                 
                                                                                
  PRMONTH13                  LENGTH=3                                           
  LABEL="Month of procedure 13"                                                 
                                                                                
  PRMONTH14                  LENGTH=3                                           
  LABEL="Month of procedure 14"                                                 
                                                                                
  PRMONTH15                  LENGTH=3                                           
  LABEL="Month of procedure 15"                                                 
                                                                                
  PRMONTH16                  LENGTH=3                                           
  LABEL="Month of procedure 16"                                                 
                                                                                
  PRMONTH17                  LENGTH=3                                           
  LABEL="Month of procedure 17"                                                 
                                                                                
  PRMONTH18                  LENGTH=3                                           
  LABEL="Month of procedure 18"                                                 
                                                                                
  PRMONTH19                  LENGTH=3                                           
  LABEL="Month of procedure 19"                                                 
                                                                                
  PRMONTH20                  LENGTH=3                                           
  LABEL="Month of procedure 20"                                                 
                                                                                
  PRYEAR1                    LENGTH=3                                           
  LABEL="Year of procedure 1"                                                   
                                                                                
  PRYEAR2                    LENGTH=3                                           
  LABEL="Year of procedure 2"                                                   
                                                                                
  PRYEAR3                    LENGTH=3                                           
  LABEL="Year of procedure 3"                                                   
                                                                                
  PRYEAR4                    LENGTH=3                                           
  LABEL="Year of procedure 4"                                                   
                                                                                
  PRYEAR5                    LENGTH=3                                           
  LABEL="Year of procedure 5"                                                   
                                                                                
  PRYEAR6                    LENGTH=3                                           
  LABEL="Year of procedure 6"                                                   
                                                                                
  PRYEAR7                    LENGTH=3                                           
  LABEL="Year of procedure 7"                                                   
                                                                                
  PRYEAR8                    LENGTH=3                                           
  LABEL="Year of procedure 8"                                                   
                                                                                
  PRYEAR9                    LENGTH=3                                           
  LABEL="Year of procedure 9"                                                   
                                                                                
  PRYEAR10                   LENGTH=3                                           
  LABEL="Year of procedure 10"                                                  
                                                                                
  PRYEAR11                   LENGTH=3                                           
  LABEL="Year of procedure 11"                                                  
                                                                                
  PRYEAR12                   LENGTH=3                                           
  LABEL="Year of procedure 12"                                                  
                                                                                
  PRYEAR13                   LENGTH=3                                           
  LABEL="Year of procedure 13"                                                  
                                                                                
  PRYEAR14                   LENGTH=3                                           
  LABEL="Year of procedure 14"                                                  
                                                                                
  PRYEAR15                   LENGTH=3                                           
  LABEL="Year of procedure 15"                                                  
                                                                                
  PRYEAR16                   LENGTH=3                                           
  LABEL="Year of procedure 16"                                                  
                                                                                
  PRYEAR17                   LENGTH=3                                           
  LABEL="Year of procedure 17"                                                  
                                                                                
  PRYEAR18                   LENGTH=3                                           
  LABEL="Year of procedure 18"                                                  
                                                                                
  PRYEAR19                   LENGTH=3                                           
  LABEL="Year of procedure 19"                                                  
                                                                                
  PRYEAR20                   LENGTH=3                                           
  LABEL="Year of procedure 20"                                                  
  ;                                                                             
                                                                                
                                                                                
*** Input the variables from the ASCII file ***;                                
INPUT                                                                           
      @1      AGE                           N3PF.                               
      @4      AGEMONTH                      N3PF.                               
      @7      AMONTH                        N2PF.                               
      @9      ATYPE                         N2PF.                               
      @11     AWEEKEND                      N2PF.                               
      @13     CPT1                          $CHAR5.                             
      @18     CPT2                          $CHAR5.                             
      @23     CPT3                          $CHAR5.                             
      @28     CPT4                          $CHAR5.                             
      @33     CPT5                          $CHAR5.                             
      @38     CPT6                          $CHAR5.                             
      @43     CPT7                          $CHAR5.                             
      @48     CPT8                          $CHAR5.                             
      @53     CPT9                          $CHAR5.                             
      @58     CPT10                         $CHAR5.                             
      @63     CPT11                         $CHAR5.                             
      @68     CPT12                         $CHAR5.                             
      @73     CPT13                         $CHAR5.                             
      @78     CPT14                         $CHAR5.                             
      @83     CPT15                         $CHAR5.                             
      @88     CPTCCS1                       N3PF.                               
      @91     CPTCCS2                       N3PF.                               
      @94     CPTCCS3                       N3PF.                               
      @97     CPTCCS4                       N3PF.                               
      @100    CPTCCS5                       N3PF.                               
      @103    CPTCCS6                       N3PF.                               
      @106    CPTCCS7                       N3PF.                               
      @109    CPTCCS8                       N3PF.                               
      @112    CPTCCS9                       N3PF.                               
      @115    CPTCCS10                      N3PF.                               
      @118    CPTCCS11                      N3PF.                               
      @121    CPTCCS12                      N3PF.                               
      @124    CPTCCS13                      N3PF.                               
      @127    CPTCCS14                      N3PF.                               
      @130    CPTCCS15                      N3PF.                               
      @133    DIED                          N2PF.                               
      @135    DISP_X                        $CHAR2.                             
      @137    DISPUB04                      N2PF.                               
      @139    DISPUNIFORM                   N2PF.                               
      @141    DMONTH                        N2PF.                               
      @143    DQTR                          N2PF.                               
      @145    DSHOSPID                      $CHAR17.                            
      @162    DXVER                         N3PF.                               
      @165    FEMALE                        N2PF.                               
      @167    HCUP_ED                       N2PF.                               
      @169    HCUP_OS                       N2PF.                               
      @171    HCUP_SURGERY_BROAD_CPT        N5PF.                               
      @176    HCUP_SURGERY_NARROW_CPT       N5PF.                               
      @181    Homeless                      N2PF.                               
      @183    HOSPST                        $CHAR2.                             
      @185    I10_DX1                       $CHAR7.                             
      @192    I10_DX2                       $CHAR7.                             
      @199    I10_DX3                       $CHAR7.                             
      @206    I10_DX4                       $CHAR7.                             
      @213    I10_DX5                       $CHAR7.                             
      @220    I10_DX6                       $CHAR7.                             
      @227    I10_DX7                       $CHAR7.                             
      @234    I10_DX8                       $CHAR7.                             
      @241    I10_DX9                       $CHAR7.                             
      @248    I10_DX10                      $CHAR7.                             
      @255    I10_DX11                      $CHAR7.                             
      @262    I10_DX12                      $CHAR7.                             
      @269    I10_DX13                      $CHAR7.                             
      @276    I10_DX14                      $CHAR7.                             
      @283    I10_DX15                      $CHAR7.                             
      @290    I10_DX16                      $CHAR7.                             
      @297    I10_DX17                      $CHAR7.                             
      @304    I10_DX18                      $CHAR7.                             
      @311    I10_DX19                      $CHAR7.                             
      @318    I10_DX20                      $CHAR7.                             
      @325    I10_DX21                      $CHAR7.                             
      @332    I10_DX22                      $CHAR7.                             
      @339    I10_DX23                      $CHAR7.                             
      @346    I10_DX24                      $CHAR7.                             
      @353    I10_DX25                      $CHAR7.                             
      @360    I10_DX26                      $CHAR7.                             
      @367    I10_DX27                      $CHAR7.                             
      @374    I10_DX28                      $CHAR7.                             
      @381    I10_DX29                      $CHAR7.                             
      @388    I10_DX30                      $CHAR7.                             
      @395    I10_DX31                      $CHAR7.                             
      @402    I10_DX32                      $CHAR7.                             
      @409    I10_DX33                      $CHAR7.                             
      @416    I10_ECAUSE1                   $CHAR7.                             
      @423    I10_ECAUSE2                   $CHAR7.                             
      @430    I10_ECAUSE3                   $CHAR7.                             
      @437    I10_ECAUSE4                   $CHAR7.                             
      @444    I10_ECAUSE5                   $CHAR7.                             
      @451    I10_ECAUSE6                   $CHAR7.                             
      @458    I10_ECAUSE7                   $CHAR7.                             
      @465    I10_ECAUSE8                   $CHAR7.                             
      @472    I10_ECAUSE9                   $CHAR7.                             
      @479    I10_ECAUSE10                  $CHAR7.                             
      @486    I10_ECAUSE11                  $CHAR7.                             
      @493    I10_ECAUSE12                  $CHAR7.                             
      @500    I10_ECAUSE13                  $CHAR7.                             
      @507    I10_ECAUSE14                  $CHAR7.                             
      @514    I10_ECAUSE15                  $CHAR7.                             
      @521    I10_ECAUSE16                  $CHAR7.                             
      @528    I10_ECAUSE17                  $CHAR7.                             
      @535    I10_ECAUSE18                  $CHAR7.                             
      @542    I10_ECAUSE19                  $CHAR7.                             
      @549    I10_ECAUSE20                  $CHAR7.                             
      @556    I10_ECAUSE21                  $CHAR7.                             
      @563    I10_ECAUSE22                  $CHAR7.                             
      @570    I10_ECAUSE23                  $CHAR7.                             
      @577    I10_ECAUSE24                  $CHAR7.                             
      @584    I10_ECAUSE25                  $CHAR7.                             
      @591    I10_ECAUSE26                  $CHAR7.                             
      @598    I10_ECAUSE27                  $CHAR7.                             
      @605    I10_ECAUSE28                  $CHAR7.                             
      @612    I10_ECAUSE29                  $CHAR7.                             
      @619    I10_ECAUSE30                  $CHAR7.                             
      @626    I10_ECAUSE31                  $CHAR7.                             
      @633    I10_ECAUSE32                  $CHAR7.                             
      @640    I10_NDX                       N3PF.                               
      @643    I10_NECAUSE                   N2PF.                               
      @645    I10_NPR                       N3PF.                               
      @648    I10_PR1                       $CHAR7.                             
      @655    I10_PR2                       $CHAR7.                             
      @662    I10_PR3                       $CHAR7.                             
      @669    I10_PR4                       $CHAR7.                             
      @676    I10_PR5                       $CHAR7.                             
      @683    I10_PR6                       $CHAR7.                             
      @690    I10_PR7                       $CHAR7.                             
      @697    I10_PR8                       $CHAR7.                             
      @704    I10_PR9                       $CHAR7.                             
      @711    I10_PR10                      $CHAR7.                             
      @718    I10_PR11                      $CHAR7.                             
      @725    I10_PR12                      $CHAR7.                             
      @732    I10_PR13                      $CHAR7.                             
      @739    I10_PR14                      $CHAR7.                             
      @746    I10_PR15                      $CHAR7.                             
      @753    I10_PR16                      $CHAR7.                             
      @760    I10_PR17                      $CHAR7.                             
      @767    I10_PR18                      $CHAR7.                             
      @774    I10_PR19                      $CHAR7.                             
      @781    I10_PR20                      $CHAR7.                             
      @788    I10_PROCTYPE                  N3PF.                               
      @791    KEY                           15.                                 
      @806    LOS                           N5PF.                               
      @811    LOS_X                         N6PF.                               
      @817    MDNUM1_R                      N9PF.                               
      @826    MDNUM2_R                      N9PF.                               
      @835    MEDINCSTQ                     N2PF.                               
      @837    NCPT                          N4PF.                               
      @841    PAY1                          N2PF.                               
      @843    PAY1_X                        $CHAR2.                             
      @845    PL_CBSA                       N3PF.                               
      @848    PL_NCHS                       N2PF.                               
      @850    PL_RUCC                       N2PF.                               
      @852    PL_UIC                        N2PF.                               
      @854    PL_UR_CAT4                    N2PF.                               
      @856    PointOfOrigin_X               $CHAR1.                             
      @857    PointOfOriginUB04             $CHAR1.                             
      @858    PRDAY1                        N5PF.                               
      @863    PRDAY2                        N5PF.                               
      @868    PRDAY3                        N5PF.                               
      @873    PRDAY4                        N5PF.                               
      @878    PRDAY5                        N5PF.                               
      @883    PRDAY6                        N5PF.                               
      @888    PRDAY7                        N5PF.                               
      @893    PRDAY8                        N5PF.                               
      @898    PRDAY9                        N5PF.                               
      @903    PRDAY10                       N5PF.                               
      @908    PRDAY11                       N5PF.                               
      @913    PRDAY12                       N5PF.                               
      @918    PRDAY13                       N5PF.                               
      @923    PRDAY14                       N5PF.                               
      @928    PRDAY15                       N5PF.                               
      @933    PRDAY16                       N5PF.                               
      @938    PRDAY17                       N5PF.                               
      @943    PRDAY18                       N5PF.                               
      @948    PRDAY19                       N5PF.                               
      @953    PRDAY20                       N5PF.                               
      @958    PRVER                         N3PF.                               
      @961    PSTATE                        $CHAR2.                             
      @963    PSTCO                         N5PF.                               
      @968    PSTCO2                        N5PF.                               
      @973    RACE                          N2PF.                               
      @975    RACE_X                        $CHAR1.                             
      @976    STATE_AS                      N2PF.                               
      @978    STATE_ED                      N2PF.                               
      @980    STATE_OS                      N2PF.                               
      @982    TOTCHG                        N10PF.                              
      @992    TOTCHG_X                      N15P2F.                             
      @1007   YEAR                          N4PF.                               
      @1011   ZIP                           $CHAR5.                             
      @1016   ZIP3                          $CHAR3.                             
      @1019   ZIPINC_QRTL                   N3PF.                               
      @1022   AYEAR                         N4PF.                               
      @1026   BMONTH                        N2PF.                               
      @1028   BYEAR                         N4PF.                               
      @1032   PRMONTH1                      N2PF.                               
      @1034   PRMONTH2                      N2PF.                               
      @1036   PRMONTH3                      N2PF.                               
      @1038   PRMONTH4                      N2PF.                               
      @1040   PRMONTH5                      N2PF.                               
      @1042   PRMONTH6                      N2PF.                               
      @1044   PRMONTH7                      N2PF.                               
      @1046   PRMONTH8                      N2PF.                               
      @1048   PRMONTH9                      N2PF.                               
      @1050   PRMONTH10                     N2PF.                               
      @1052   PRMONTH11                     N2PF.                               
      @1054   PRMONTH12                     N2PF.                               
      @1056   PRMONTH13                     N2PF.                               
      @1058   PRMONTH14                     N2PF.                               
      @1060   PRMONTH15                     N2PF.                               
      @1062   PRMONTH16                     N2PF.                               
      @1064   PRMONTH17                     N2PF.                               
      @1066   PRMONTH18                     N2PF.                               
      @1068   PRMONTH19                     N2PF.                               
      @1070   PRMONTH20                     N2PF.                               
      @1072   PRYEAR1                       N4PF.                               
      @1076   PRYEAR2                       N4PF.                               
      @1080   PRYEAR3                       N4PF.                               
      @1084   PRYEAR4                       N4PF.                               
      @1088   PRYEAR5                       N4PF.                               
      @1092   PRYEAR6                       N4PF.                               
      @1096   PRYEAR7                       N4PF.                               
      @1100   PRYEAR8                       N4PF.                               
      @1104   PRYEAR9                       N4PF.                               
      @1108   PRYEAR10                      N4PF.                               
      @1112   PRYEAR11                      N4PF.                               
      @1116   PRYEAR12                      N4PF.                               
      @1120   PRYEAR13                      N4PF.                               
      @1124   PRYEAR14                      N4PF.                               
      @1128   PRYEAR15                      N4PF.                               
      @1132   PRYEAR16                      N4PF.                               
      @1136   PRYEAR17                      N4PF.                               
      @1140   PRYEAR18                      N4PF.                               
      @1144   PRYEAR19                      N4PF.                               
      @1148   PRYEAR20                      N4PF.                               
      ;                                                                         
                                                                                
                                                                                
RUN;
