/*******************************************************************
*   CO_SASD_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII             
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'CO_SASD_2000_CORE.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AGEMONTH            21- 23
 AMONTH              24- 25
 ASOURCE             26- 27
 ASOURCE_            28 (A)
 AWEEKEND            29- 30
 CPT1                31- 35 (A)
 CPT2                36- 40 (A)
 CPT3                41- 45 (A)
 CPT4                46- 50 (A)
 CPT5                51- 55 (A)
 CPT6                56- 60 (A)
 CPT7                61- 65 (A)
 CPT8                66- 70 (A)
 CPT9                71- 75 (A)
 CPT10               76- 80 (A)
 CPT11               81- 85 (A)
 CPT12               86- 90 (A)
 CPT13               91- 95 (A)
 CPT14               96-100 (A)
 CPT15              101-105 (A)
 DIED               106-107
 DISP_X             108-109 (A)
 DISPUB92           110-111
 DISPUNIF           112-113
 DQTR               114-115
 DSHOSPID           116-128 (A)
 DX1                129-133 (A)
 DX2                134-138 (A)
 DX3                139-143 (A)
 DX4                144-148 (A)
 DX5                149-153 (A)
 DX6                154-158 (A)
 DX7                159-163 (A)
 DX8                164-168 (A)
 DX9                169-173 (A)
 DX10               174-178 (A)
 DX11               179-183 (A)
 DX12               184-188 (A)
 DX13               189-193 (A)
 DX14               194-198 (A)
 DX15               199-203 (A)
 DXCCS1             204-207
 DXCCS2             208-211
 DXCCS3             212-215
 DXCCS4             216-219
 DXCCS5             220-223
 DXCCS6             224-227
 DXCCS7             228-231
 DXCCS8             232-235
 DXCCS9             236-239
 DXCCS10            240-243
 DXCCS11            244-247
 DXCCS12            248-251
 DXCCS13            252-255
 DXCCS14            256-259
 DXCCS15            260-263
 FEMALE             264-265
 HOSPST             266-267 (A)
 LOS                268-272
 LOS_X              273-278
 MDID_S             279-294 (A)
 MRN_S              295-311 (A)
 NCPT               312-313
 NDX                314-315
 NEOMAT             316-317
 NPR                318-319
 PAY1               320-321
 PAY1_X             322-323 (A)
 PR1                324-327 (A)
 PR2                328-331 (A)
 PR3                332-335 (A)
 PR4                336-339 (A)
 PR5                340-343 (A)
 PR6                344-347 (A)
 PR7                348-351 (A)
 PR8                352-355 (A)
 PR9                356-359 (A)
 PR10               360-363 (A)
 PR11               364-367 (A)
 PR12               368-371 (A)
 PR13               372-375 (A)
 PR14               376-379 (A)
 PR15               380-383 (A)
 PRCCS1             384-386
 PRCCS2             387-389
 PRCCS3             390-392
 PRCCS4             393-395
 PRCCS5             396-398
 PRCCS6             399-401
 PRCCS7             402-404
 PRCCS8             405-407
 PRCCS9             408-410
 PRCCS10            411-413
 PRCCS11            414-416
 PRCCS12            417-419
 PRCCS13            420-422
 PRCCS14            423-425
 PRCCS15            426-428
 PRDAY1             429-431
 PSTCO              432-436
 RACE               437-438
 RACE_X             439 (A)
 SURGID_S           440-455 (A)
 TOTCHG             456-465
 TOTCHG_X           466-480
 YEAR               481-484
 ZIP                485-489 (A)
 AYEAR              490-493
 DMONTH             494-495
 PRMNTH1            496-497
 PRYEAR1            498-501.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 NCPT                (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRDAY1              (F4.0) /
 PSTCO               (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 PRMNTH1             (F3.0) /
 PRYEAR1             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY          "HCUP record identifier"
 AGE          "Age in years at admission"
 AGEDAY       "Age in days (when age < 1 year)"
 AGEMONTH     "Age in months (when age < 11 years)"
 AMONTH       "Admission month"
 ASOURCE      "Admission source (uniform)"
 ASOURCE_     "Admission source (as received from source)"
 AWEEKEND     "Admission day is a weekend"
 CPT1         "CPT/HCPCS procedure code 1"
 CPT2         "CPT/HCPCS procedure code 2"
 CPT3         "CPT/HCPCS procedure code 3"
 CPT4         "CPT/HCPCS procedure code 4"
 CPT5         "CPT/HCPCS procedure code 5"
 CPT6         "CPT/HCPCS procedure code 6"
 CPT7         "CPT/HCPCS procedure code 7"
 CPT8         "CPT/HCPCS procedure code 8"
 CPT9         "CPT/HCPCS procedure code 9"
 CPT10        "CPT/HCPCS procedure code 10"
 CPT11        "CPT/HCPCS procedure code 11"
 CPT12        "CPT/HCPCS procedure code 12"
 CPT13        "CPT/HCPCS procedure code 13"
 CPT14        "CPT/HCPCS procedure code 14"
 CPT15        "CPT/HCPCS procedure code 15"
 DIED         "Died during hospitalization"
 DISP_X       "Disposition of patient (as received from source)"
 DISPUB92     "Disposition of patient (UB-92 standard coding)"
 DISPUNIF     "Disposition of patient (uniform)"
 DQTR         "Discharge quarter"
 DSHOSPID     "Data source hospital identifier"
 DX1          "Principal diagnosis"
 DX2          "Diagnosis 2"
 DX3          "Diagnosis 3"
 DX4          "Diagnosis 4"
 DX5          "Diagnosis 5"
 DX6          "Diagnosis 6"
 DX7          "Diagnosis 7"
 DX8          "Diagnosis 8"
 DX9          "Diagnosis 9"
 DX10         "Diagnosis 10"
 DX11         "Diagnosis 11"
 DX12         "Diagnosis 12"
 DX13         "Diagnosis 13"
 DX14         "Diagnosis 14"
 DX15         "Diagnosis 15"
 DXCCS1       "CCS: principal diagnosis"
 DXCCS2       "CCS: diagnosis 2"
 DXCCS3       "CCS: diagnosis 3"
 DXCCS4       "CCS: diagnosis 4"
 DXCCS5       "CCS: diagnosis 5"
 DXCCS6       "CCS: diagnosis 6"
 DXCCS7       "CCS: diagnosis 7"
 DXCCS8       "CCS: diagnosis 8"
 DXCCS9       "CCS: diagnosis 9"
 DXCCS10      "CCS: diagnosis 10"
 DXCCS11      "CCS: diagnosis 11"
 DXCCS12      "CCS: diagnosis 12"
 DXCCS13      "CCS: diagnosis 13"
 DXCCS14      "CCS: diagnosis 14"
 DXCCS15      "CCS: diagnosis 15"
 FEMALE       "Indicator of sex"
 HOSPST       "Hospital state postal code"
 LOS          "Length of stay (cleaned)"
 LOS_X        "Length of stay (as received from source)"
 MDID_S       "Attending physician number (synthetic)"
 MRN_S        "Medical record number (synthetic)"
 NCPT         "Number of CPT/HCPCS procedures on this record"
 NDX          "Number of diagnoses on this record"
 NEOMAT       "Neonatal and/or maternal DX and/or PR"
 NPR          "Number of procedures on this record"
 PAY1         "Primary expected payer (uniform)"
 PAY1_X       "Primary expected payer (as received from source)"
 PR1          "Principal procedure"
 PR2          "Procedure 2"
 PR3          "Procedure 3"
 PR4          "Procedure 4"
 PR5          "Procedure 5"
 PR6          "Procedure 6"
 PR7          "Procedure 7"
 PR8          "Procedure 8"
 PR9          "Procedure 9"
 PR10         "Procedure 10"
 PR11         "Procedure 11"
 PR12         "Procedure 12"
 PR13         "Procedure 13"
 PR14         "Procedure 14"
 PR15         "Procedure 15"
 PRCCS1       "CCS: principal procedure"
 PRCCS2       "CCS: procedure 2"
 PRCCS3       "CCS: procedure 3"
 PRCCS4       "CCS: procedure 4"
 PRCCS5       "CCS: procedure 5"
 PRCCS6       "CCS: procedure 6"
 PRCCS7       "CCS: procedure 7"
 PRCCS8       "CCS: procedure 8"
 PRCCS9       "CCS: procedure 9"
 PRCCS10      "CCS: procedure 10"
 PRCCS11      "CCS: procedure 11"
 PRCCS12      "CCS: procedure 12"
 PRCCS13      "CCS: procedure 13"
 PRCCS14      "CCS: procedure 14"
 PRCCS15      "CCS: procedure 15"
 PRDAY1       "Number of days from admission to PR1"
 PSTCO        "Patient state/county FIPS code"
 RACE         "Race (uniform)"
 RACE_X       "Race (as received from source)"
 SURGID_S     "Primary surgeon number (synthetic)"
 TOTCHG       "Total charges (cleaned)"
 TOTCHG_X     "Total charges (as received from source)"
 YEAR         "Calendar year"
 ZIP          "Patient zip code"
 AYEAR        "Admission year"
 DMONTH       "Discharge month"
 PRMNTH1      "Month of procedure 1"
 PRYEAR1      "Year of procedure 1".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NCPT
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'CO_SASD_2000_CORE.SAV' /COMPRESSED.
