/*******************************************************************
*   NJ_SASD_2011_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CHGS FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NJ_SASD_2011_CHGS.ASC' FIXED / 
 APC                        1-   5 (A)
 CHARGE                     6-  17
 CPTHCPCS                  18-  22 (A)
 CPTMod1                   23-  24 (A)
 CPTMod2                   25-  26 (A)
 KEY                       27-  44
 REVCODE                   45-  48 (A)
 UNITS                     49-  56.


***  Specify write formats  ***.
FORMATS
 CHARGE                  (F6.2) /
 KEY                     (F8.0) /
 UNITS                   (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 APC
"Line item Ambulatory Payment Classification code (as received from source)"
 CHARGE                  "Line item charges (as received from source)"
 CPTHCPCS                "Line item CPT-4/HCPCS procedure code (as received from source)"
 CPTMod1                 "Line item CPT-4/HCPCS first modifier (as received from source)"
 CPTMod2                 "Line item CPT-4/HCPCS second modifier (as received from source)"
 KEY                     "HCUP record identifier"
 REVCODE                 "Line item revenue code (as received from source)"
 UNITS                   "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'NJ_SASD_2011_CHGS.SAV' /COMPRESSED.
