/*******************************************************************
* Creation Date: 05/15/2014   
*   NV_SASD_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NV_SASD_2012_CORE.ASC' FIXED SKIP=2 / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ASOURCE                   16-  17
 ASOURCEUB92               18     (A)
 ASOURCE_X                 19-  20 (A)
 ATYPE                     21-  22
 AWEEKEND                  23-  24
 BILLTYPE                  25-  28 (A)
 CPT1                      29-  33 (A)
 CPT2                      34-  38 (A)
 CPT3                      39-  43 (A)
 CPT4                      44-  48 (A)
 CPT5                      49-  53 (A)
 CPT6                      54-  58 (A)
 CPT7                      59-  63 (A)
 CPT8                      64-  68 (A)
 CPT9                      69-  73 (A)
 CPT10                     74-  78 (A)
 CPT11                     79-  83 (A)
 CPT12                     84-  88 (A)
 CPT13                     89-  93 (A)
 CPT14                     94-  98 (A)
 CPT15                     99- 103 (A)
 CPT16                    104- 108 (A)
 CPT17                    109- 113 (A)
 CPT18                    114- 118 (A)
 CPT19                    119- 123 (A)
 CPT20                    124- 128 (A)
 CPT21                    129- 133 (A)
 CPT22                    134- 138 (A)
 CPT23                    139- 143 (A)
 CPT24                    144- 148 (A)
 CPT25                    149- 153 (A)
 CPT26                    154- 158 (A)
 CPT27                    159- 163 (A)
 CPT28                    164- 168 (A)
 CPT29                    169- 173 (A)
 CPT30                    174- 178 (A)
 CPT31                    179- 183 (A)
 CPT32                    184- 188 (A)
 CPT33                    189- 193 (A)
 CPT34                    194- 198 (A)
 CPT35                    199- 203 (A)
 CPT36                    204- 208 (A)
 CPT37                    209- 213 (A)
 CPT38                    214- 218 (A)
 CPT39                    219- 223 (A)
 CPT40                    224- 228 (A)
 CPT41                    229- 233 (A)
 CPT42                    234- 238 (A)
 CPT43                    239- 243 (A)
 CPT44                    244- 248 (A)
 CPTCCS1                  249- 251
 CPTCCS2                  252- 254
 CPTCCS3                  255- 257
 CPTCCS4                  258- 260
 CPTCCS5                  261- 263
 CPTCCS6                  264- 266
 CPTCCS7                  267- 269
 CPTCCS8                  270- 272
 CPTCCS9                  273- 275
 CPTCCS10                 276- 278
 CPTCCS11                 279- 281
 CPTCCS12                 282- 284
 CPTCCS13                 285- 287
 CPTCCS14                 288- 290
 CPTCCS15                 291- 293
 CPTCCS16                 294- 296
 CPTCCS17                 297- 299
 CPTCCS18                 300- 302
 CPTCCS19                 303- 305
 CPTCCS20                 306- 308
 CPTCCS21                 309- 311
 CPTCCS22                 312- 314
 CPTCCS23                 315- 317
 CPTCCS24                 318- 320
 CPTCCS25                 321- 323
 CPTCCS26                 324- 326
 CPTCCS27                 327- 329
 CPTCCS28                 330- 332
 CPTCCS29                 333- 335
 CPTCCS30                 336- 338
 CPTCCS31                 339- 341
 CPTCCS32                 342- 344
 CPTCCS33                 345- 347
 CPTCCS34                 348- 350
 CPTCCS35                 351- 353
 CPTCCS36                 354- 356
 CPTCCS37                 357- 359
 CPTCCS38                 360- 362
 CPTCCS39                 363- 365
 CPTCCS40                 366- 368
 CPTCCS41                 369- 371
 CPTCCS42                 372- 374
 CPTCCS43                 375- 377
 CPTCCS44                 378- 380
 CPTM1_1                  381- 382 (A)
 CPTM1_2                  383- 384 (A)
 CPTM1_3                  385- 386 (A)
 CPTM1_4                  387- 388 (A)
 CPTM1_5                  389- 390 (A)
 CPTM1_6                  391- 392 (A)
 CPTM1_7                  393- 394 (A)
 CPTM1_8                  395- 396 (A)
 CPTM1_9                  397- 398 (A)
 CPTM1_10                 399- 400 (A)
 CPTM1_11                 401- 402 (A)
 CPTM1_12                 403- 404 (A)
 CPTM1_13                 405- 406 (A)
 CPTM1_14                 407- 408 (A)
 CPTM1_15                 409- 410 (A)
 CPTM1_16                 411- 412 (A)
 CPTM1_17                 413- 414 (A)
 CPTM1_18                 415- 416 (A)
 CPTM1_19                 417- 418 (A)
 CPTM1_20                 419- 420 (A)
 CPTM1_21                 421- 422 (A)
 CPTM1_22                 423- 424 (A)
 CPTM1_23                 425- 426 (A)
 CPTM1_24                 427- 428 (A)
 CPTM1_25                 429- 430 (A)
 CPTM1_26                 431- 432 (A)
 CPTM1_27                 433- 434 (A)
 CPTM1_28                 435- 436 (A)
 CPTM1_29                 437- 438 (A)
 CPTM1_30                 439- 440 (A)
 CPTM1_31                 441- 442 (A)
 CPTM1_32                 443- 444 (A)
 CPTM1_33                 445- 446 (A)
 CPTM1_34                 447- 448 (A)
 CPTM1_35                 449- 450 (A)
 CPTM1_36                 451- 452 (A)
 CPTM1_37                 453- 454 (A)
 CPTM1_38                 455- 456 (A)
 CPTM1_39                 457- 458 (A)
 CPTM1_40                 459- 460 (A)
 CPTM1_41                 461- 462 (A)
 CPTM1_42                 463- 464 (A)
 CPTM1_43                 465- 466 (A)
 CPTM1_44                 467- 468 (A)
 CPTM2_1                  469- 470 (A)
 CPTM2_2                  471- 472 (A)
 CPTM2_3                  473- 474 (A)
 CPTM2_4                  475- 476 (A)
 CPTM2_5                  477- 478 (A)
 CPTM2_6                  479- 480 (A)
 CPTM2_7                  481- 482 (A)
 CPTM2_8                  483- 484 (A)
 CPTM2_9                  485- 486 (A)
 CPTM2_10                 487- 488 (A)
 CPTM2_11                 489- 490 (A)
 CPTM2_12                 491- 492 (A)
 CPTM2_13                 493- 494 (A)
 CPTM2_14                 495- 496 (A)
 CPTM2_15                 497- 498 (A)
 CPTM2_16                 499- 500 (A)
 CPTM2_17                 501- 502 (A)
 CPTM2_18                 503- 504 (A)
 CPTM2_19                 505- 506 (A)
 CPTM2_20                 507- 508 (A)
 CPTM2_21                 509- 510 (A)
 CPTM2_22                 511- 512 (A)
 CPTM2_23                 513- 514 (A)
 CPTM2_24                 515- 516 (A)
 CPTM2_25                 517- 518 (A)
 CPTM2_26                 519- 520 (A)
 CPTM2_27                 521- 522 (A)
 CPTM2_28                 523- 524 (A)
 CPTM2_29                 525- 526 (A)
 CPTM2_30                 527- 528 (A)
 CPTM2_31                 529- 530 (A)
 CPTM2_32                 531- 532 (A)
 CPTM2_33                 533- 534 (A)
 CPTM2_34                 535- 536 (A)
 CPTM2_35                 537- 538 (A)
 CPTM2_36                 539- 540 (A)
 CPTM2_37                 541- 542 (A)
 CPTM2_38                 543- 544 (A)
 CPTM2_39                 545- 546 (A)
 CPTM2_40                 547- 548 (A)
 CPTM2_41                 549- 550 (A)
 CPTM2_42                 551- 552 (A)
 CPTM2_43                 553- 554 (A)
 CPTM2_44                 555- 556 (A)
 DHOUR                    557- 560
 DIED                     561- 562
 DISPUB04                 563- 564
 DISPUNIFORM              565- 566
 DISP_X                   567- 568 (A)
 DQTR                     569- 570
 DSHOSPID                 571- 587 (A)
 DURATION                 588- 593
 DX1                      594- 598 (A)
 DX2                      599- 603 (A)
 DX3                      604- 608 (A)
 DX4                      609- 613 (A)
 DX5                      614- 618 (A)
 DX6                      619- 623 (A)
 DX7                      624- 628 (A)
 DX8                      629- 633 (A)
 DX9                      634- 638 (A)
 DX10                     639- 643 (A)
 DX11                     644- 648 (A)
 DX12                     649- 653 (A)
 DX13                     654- 658 (A)
 DX14                     659- 663 (A)
 DX15                     664- 668 (A)
 DX16                     669- 673 (A)
 DX17                     674- 678 (A)
 DX18                     679- 683 (A)
 DX19                     684- 688 (A)
 DX20                     689- 693 (A)
 DX21                     694- 698 (A)
 DX22                     699- 703 (A)
 DX23                     704- 708 (A)
 DX24                     709- 713 (A)
 DX25                     714- 718 (A)
 DX26                     719- 723 (A)
 DX27                     724- 728 (A)
 DX28                     729- 733 (A)
 DX29                     734- 738 (A)
 DX30                     739- 743 (A)
 DX31                     744- 748 (A)
 DX32                     749- 753 (A)
 DX33                     754- 758 (A)
 DXCCS1                   759- 762
 DXCCS2                   763- 766
 DXCCS3                   767- 770
 DXCCS4                   771- 774
 DXCCS5                   775- 778
 DXCCS6                   779- 782
 DXCCS7                   783- 786
 DXCCS8                   787- 790
 DXCCS9                   791- 794
 DXCCS10                  795- 798
 DXCCS11                  799- 802
 DXCCS12                  803- 806
 DXCCS13                  807- 810
 DXCCS14                  811- 814
 DXCCS15                  815- 818
 DXCCS16                  819- 822
 DXCCS17                  823- 826
 DXCCS18                  827- 830
 DXCCS19                  831- 834
 DXCCS20                  835- 838
 DXCCS21                  839- 842
 DXCCS22                  843- 846
 DXCCS23                  847- 850
 DXCCS24                  851- 854
 DXCCS25                  855- 858
 DXCCS26                  859- 862
 DXCCS27                  863- 866
 DXCCS28                  867- 870
 DXCCS29                  871- 874
 DXCCS30                  875- 878
 DXCCS31                  879- 882
 DXCCS32                  883- 886
 DXCCS33                  887- 890
 ECODE1                   891- 895 (A)
 ECODE2                   896- 900 (A)
 ECODE3                   901- 905 (A)
 ECODE4                   906- 910 (A)
 E_CCS1                   911- 914
 E_CCS2                   915- 918
 E_CCS3                   919- 922
 E_CCS4                   923- 926
 FEMALE                   927- 928
 HCUP_ED                  929- 930
 HCUP_OS                  931- 932
 HOSPBRTH                 933- 935
 HOSPST                   936- 937 (A)
 KEY                      938- 952
 LOS                      953- 957
 LOS_X                    958- 963
 MARITALSTATUSUB04        964     (A)
 MARITALSTATUS_X          965     (A)
 MDNUM1_R                 966- 974
 MDNUM2_R                 975- 983
 MDNUMTYPE1               984     (A)
 MDNUMTYPE2               985     (A)
 MEDINCSTQ                986- 987
 NCHRONIC                 988- 990
 NCPT                     991- 993
 NDX                      994- 995
 NECODE                   996- 997
 NEOMAT                   998- 999
 OS_TIME                 1000-1007
 PAY1                    1008-1009
 PAY1_X                  1010-1011 (A)
 PAY2                    1012-1013
 PAY2_X                  1014-1015 (A)
 PAY3                    1016-1017
 PAY3_X                  1018-1019 (A)
 PL_NCHS2006             1020-1021
 PL_RUCA10_2005          1022-1023
 PL_RUCA2005             1024-1027
 PL_RUCA4_2005           1028-1029
 PL_RUCC2003             1030-1031
 PL_UIC2003              1032-1033
 PL_UR_CAT4              1034-1035
 PROCTYPE                1036-1038
 PSTATE                  1039-1040 (A)
 PSTCO                   1041-1045
 PSTCO2                  1046-1050
 PointOfOriginUB04       1051     (A)
 PointOfOrigin_X         1052-1053 (A)
 RACE                    1054-1055
 RACE_X                  1056-1057 (A)
 STATE_AS                1058-1059
 STATE_ED                1060-1061
 STATE_OS                1062-1063
 TOTCHG                  1064-1073
 TOTCHG_X                1074-1088
 YEAR                    1089-1092
 ZIPINC_QRTL             1093-1095
 AYEAR                   1096-1099
 DMONTH                  1100-1101.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTCCS31                (F4.0) /
 CPTCCS32                (F4.0) /
 CPTCCS33                (F4.0) /
 CPTCCS34                (F4.0) /
 CPTCCS35                (F4.0) /
 CPTCCS36                (F4.0) /
 CPTCCS37                (F4.0) /
 CPTCCS38                (F4.0) /
 CPTCCS39                (F4.0) /
 CPTCCS40                (F4.0) /
 CPTCCS41                (F4.0) /
 CPTCCS42                (F4.0) /
 CPTCCS43                (F4.0) /
 CPTCCS44                (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DURATION                (F4.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 OS_TIME                 (F4.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PAY3                    (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ASOURCE                 "Admission source (uniform)"
 ASOURCEUB92             "Admission source (UB-92 standard coding)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "UB-92 bill type"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPT31                   "CPT/HCPCS procedure code 31"
 CPT32                   "CPT/HCPCS procedure code 32"
 CPT33                   "CPT/HCPCS procedure code 33"
 CPT34                   "CPT/HCPCS procedure code 34"
 CPT35                   "CPT/HCPCS procedure code 35"
 CPT36                   "CPT/HCPCS procedure code 36"
 CPT37                   "CPT/HCPCS procedure code 37"
 CPT38                   "CPT/HCPCS procedure code 38"
 CPT39                   "CPT/HCPCS procedure code 39"
 CPT40                   "CPT/HCPCS procedure code 40"
 CPT41                   "CPT/HCPCS procedure code 41"
 CPT42                   "CPT/HCPCS procedure code 42"
 CPT43                   "CPT/HCPCS procedure code 43"
 CPT44                   "CPT/HCPCS procedure code 44"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTCCS31                "CCS: CPT 31"
 CPTCCS32                "CCS: CPT 32"
 CPTCCS33                "CCS: CPT 33"
 CPTCCS34                "CCS: CPT 34"
 CPTCCS35                "CCS: CPT 35"
 CPTCCS36                "CCS: CPT 36"
 CPTCCS37                "CCS: CPT 37"
 CPTCCS38                "CCS: CPT 38"
 CPTCCS39                "CCS: CPT 39"
 CPTCCS40                "CCS: CPT 40"
 CPTCCS41                "CCS: CPT 41"
 CPTCCS42                "CCS: CPT 42"
 CPTCCS43                "CCS: CPT 43"
 CPTCCS44                "CCS: CPT 44"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM1_26                "First CPT-4/HCPCS modifier 26"
 CPTM1_27                "First CPT-4/HCPCS modifier 27"
 CPTM1_28                "First CPT-4/HCPCS modifier 28"
 CPTM1_29                "First CPT-4/HCPCS modifier 29"
 CPTM1_30                "First CPT-4/HCPCS modifier 30"
 CPTM1_31                "First CPT-4/HCPCS modifier 31"
 CPTM1_32                "First CPT-4/HCPCS modifier 32"
 CPTM1_33                "First CPT-4/HCPCS modifier 33"
 CPTM1_34                "First CPT-4/HCPCS modifier 34"
 CPTM1_35                "First CPT-4/HCPCS modifier 35"
 CPTM1_36                "First CPT-4/HCPCS modifier 36"
 CPTM1_37                "First CPT-4/HCPCS modifier 37"
 CPTM1_38                "First CPT-4/HCPCS modifier 38"
 CPTM1_39                "First CPT-4/HCPCS modifier 39"
 CPTM1_40                "First CPT-4/HCPCS modifier 40"
 CPTM1_41                "First CPT-4/HCPCS modifier 41"
 CPTM1_42                "First CPT-4/HCPCS modifier 42"
 CPTM1_43                "First CPT-4/HCPCS modifier 43"
 CPTM1_44                "First CPT-4/HCPCS modifier 44"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                "Second CPT-4/HCPCS modifier 44"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DURATION                "Elapsed time for hospital care in hours"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MARITALSTATUSUB04       "Patient's marital status, UB-04 standard coding"
 MARITALSTATUS_X         "Patient's marital status (as received from source)"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MDNUMTYPE1              "Physician 1 number type"
 MDNUMTYPE2              "Physician 2 number type"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 OS_TIME                 "Observation stay time summed from UNITS"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3                    "Tertiary expected payer (uniform)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 YEAR                    "Calendar year"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NV_SASD_2012_CORE.SAV' /COMPRESSED.
