/*******************************************************************
*   UT_SASD_2009_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'UT_SASD_2009_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 APG1                      12-  15
 APG2                      16-  19
 APG3                      20-  23
 APG4                      24-  27
 APG5                      28-  31
 APG6                      32-  35
 APGCAT1                   36-  38
 APGCAT2                   39-  41
 APGCAT3                   42-  44
 APGCAT4                   45-  47
 APGCAT5                   48-  50
 APGCAT6                   51-  53
 APGTYPE1                  54-  56
 APGTYPE2                  57-  59
 APGTYPE3                  60-  62
 APGTYPE4                  63-  65
 APGTYPE5                  66-  68
 APGTYPE6                  69-  71
 AWEEKEND                  72-  73
 CPT1                      74-  78 (A)
 CPT2                      79-  83 (A)
 CPT3                      84-  88 (A)
 CPT4                      89-  93 (A)
 CPT5                      94-  98 (A)
 CPT6                      99- 103 (A)
 CPTCCS1                  104- 106
 CPTCCS2                  107- 109
 CPTCCS3                  110- 112
 CPTCCS4                  113- 115
 CPTCCS5                  116- 118
 CPTCCS6                  119- 121
 CPTM1_1                  122- 123 (A)
 CPTM1_2                  124- 125 (A)
 CPTM1_3                  126- 127 (A)
 CPTM1_4                  128- 129 (A)
 CPTM1_5                  130- 131 (A)
 CPTM1_6                  132- 133 (A)
 CPTM2_1                  134- 135 (A)
 CPTM2_2                  136- 137 (A)
 CPTM2_3                  138- 139 (A)
 CPTM2_4                  140- 141 (A)
 CPTM2_5                  142- 143 (A)
 CPTM2_6                  144- 145 (A)
 DIED                     146- 147
 DISPUB04                 148- 149
 DISPUNIFORM              150- 151
 DISP_X                   152- 153 (A)
 DQTR                     154- 155
 DSHOSPID                 156- 172 (A)
 DX1                      173- 177 (A)
 DX2                      178- 182 (A)
 DX3                      183- 187 (A)
 DX4                      188- 192 (A)
 DX5                      193- 197 (A)
 DX6                      198- 202 (A)
 DX7                      203- 207 (A)
 DX8                      208- 212 (A)
 DX9                      213- 217 (A)
 DXCCS1                   218- 221
 DXCCS2                   222- 225
 DXCCS3                   226- 229
 DXCCS4                   230- 233
 DXCCS5                   234- 237
 DXCCS6                   238- 241
 DXCCS7                   242- 245
 DXCCS8                   246- 249
 DXCCS9                   250- 253
 DaysToEvent              254- 259
 ECODE1                   260- 264 (A)
 ECODE2                   265- 269 (A)
 ECODE3                   270- 274 (A)
 ECODE4                   275- 279 (A)
 ECODE5                   280- 284 (A)
 E_CCS1                   285- 288
 E_CCS2                   289- 292
 E_CCS3                   293- 296
 E_CCS4                   297- 300
 E_CCS5                   301- 304
 FEMALE                   305- 306
 HCUP_AS                  307- 308
 HCUP_ED                  309- 310
 HCUP_OS                  311- 312
 HOSPBRTH                 313- 315
 HOSPST                   316- 317 (A)
 Homeless                 318- 319
 KEY                      320- 333
 LOS                      334- 338
 LOS_X                    339- 344
 MEDINCSTQ                345- 346
 NCHRONIC                 347- 349
 NCPT                     350- 352
 NDX                      353- 354
 NECODE                   355- 356
 NEOMAT                   357- 358
 NPR                      359- 360
 ORPROC                   361- 362
 PAY1                     363- 364
 PAY1_X                   365- 366 (A)
 PAY2                     367- 368
 PAY2_X                   369- 370 (A)
 PAY3_X                   371- 372 (A)
 PL_CBSA                  373- 375
 PL_MSA1993               376- 378
 PL_NCHS2006              379- 380
 PL_RUCA10_2005           381- 382
 PL_RUCA2005              383- 386
 PL_RUCA4_2005            387- 388
 PL_RUCC2003              389- 390
 PL_UIC2003               391- 392
 PL_UR_CAT4               393- 394
 PR1                      395- 398 (A)
 PR2                      399- 402 (A)
 PR3                      403- 406 (A)
 PR4                      407- 410 (A)
 PR5                      411- 414 (A)
 PR6                      415- 418 (A)
 PRCCS1                   419- 421
 PRCCS2                   422- 424
 PRCCS3                   425- 427
 PRCCS4                   428- 430
 PRCCS5                   431- 433
 PRCCS6                   434- 436
 PRDAY1                   437- 441
 PROCTYPE                 442- 444
 PSTATE                   445- 446 (A)
 PSTCO                    447- 451
 PSTCO2                   452- 456
 PointOfOriginUB04        457     (A)
 PointOfOrigin_X          458     (A)
 STATE_AS                 459- 460
 STATE_ED                 461- 462
 STATE_OS                 463- 464
 TOTCHG                   465- 474
 TOTCHG_X                 475- 489
 VisitLink                490- 498
 YEAR                     499- 502
 ZIP3                     503- 505 (A)
 ZIPINC_QRTL              506- 508
 ZIP                      509- 513 (A)
 AYEAR                    514- 517
 DMONTH                   518- 519
 BMONTH                   520- 521
 BYEAR                    522- 525
 PRMONTH1                 526- 527
 PRYEAR1                  528- 531.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 APG1                    (F3.0) /
 APG2                    (F3.0) /
 APG3                    (F3.0) /
 APG4                    (F3.0) /
 APG5                    (F3.0) /
 APG6                    (F3.0) /
 APGCAT1                 (F3.0) /
 APGCAT2                 (F3.0) /
 APGCAT3                 (F3.0) /
 APGCAT4                 (F3.0) /
 APGCAT5                 (F3.0) /
 APGCAT6                 (F3.0) /
 APGTYPE1                (F3.0) /
 APGTYPE2                (F3.0) /
 APGTYPE3                (F3.0) /
 APGTYPE4                (F3.0) /
 APGTYPE5                (F3.0) /
 APGTYPE6                (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 APG1                    "Ambulatory Patient Group 1 (as received from source)"
 APG2                    "Ambulatory Patient Group 2 (as received from source)"
 APG3                    "Ambulatory Patient Group 3 (as received from source)"
 APG4                    "Ambulatory Patient Group 4 (as received from source)"
 APG5                    "Ambulatory Patient Group 5 (as received from source)"
 APG6                    "Ambulatory Patient Group 6 (as received from source)"
 APGCAT1                 "Ambulatory Patient Group Category 1 (as received from source)"
 APGCAT2                 "Ambulatory Patient Group Category 2 (as received from source)"
 APGCAT3                 "Ambulatory Patient Group Category 3 (as received from source)"
 APGCAT4                 "Ambulatory Patient Group Category 4 (as received from source)"
 APGCAT5                 "Ambulatory Patient Group Category 5 (as received from source)"
 APGCAT6                 "Ambulatory Patient Group Category 6 (as received from source)"
 APGTYPE1                "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE2                "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE3                "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE4                "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE5                "Ambulatory Patient Group Type 1 (as received from source)"
 APGTYPE6                "Ambulatory Patient Group Type 1 (as received from source)"
 AWEEKEND                "Admission day is a weekend"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 FEMALE                  "Indicator of sex"
 HCUP_AS                 "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRDAY1                  "Number of days from admission to PR1"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRYEAR1                 "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE APG1
 (-999,-888,-666,-555=SYSMIS).
RECODE APG2
 (-999,-888,-666,-555=SYSMIS).
RECODE APG3
 (-999,-888,-666,-555=SYSMIS).
RECODE APG4
 (-999,-888,-666,-555=SYSMIS).
RECODE APG5
 (-999,-888,-666,-555=SYSMIS).
RECODE APG6
 (-999,-888,-666,-555=SYSMIS).
RECODE APGCAT1
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT2
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT3
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT4
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT5
 (-99,-88,-66,-55=SYSMIS).
RECODE APGCAT6
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE1
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE2
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE3
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE4
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE5
 (-99,-88,-66,-55=SYSMIS).
RECODE APGTYPE6
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'UT_SASD_2009_CORE.SAV' /COMPRESSED.
