/*******************************************************************
* Creation Date: 04/06/2025   
*   WI_SASD_2023_DX_PR_GRPS.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      SASD DX_PR_GRPS FILE INTO SPSS                                   
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'WI_SASD_2023_DX_PR_GRPS.asc' FIXED SKIP=2 / 
 CCIR_VERSION                    1-   6 (A)
 CCIR1                           7-   9
 CCIR2                          10-  12
 CCIR3                          13-  15
 CCIR4                          16-  18
 CCIR5                          19-  21
 CCIR6                          22-  24
 CCIR7                          25-  27
 CCIR8                          28-  30
 CCIR9                          31-  33
 CCIR10                         34-  36
 CCIR11                         37-  39
 CCIR12                         40-  42
 CCIR13                         43-  45
 CCIR14                         46-  48
 CCIR15                         49-  51
 CCIR16                         52-  54
 CCIR17                         55-  57
 CCIR18                         58-  60
 CCIR19                         61-  63
 CCIR20                         64-  66
 CCIR21                         67-  69
 CCIR22                         70-  72
 CCIR23                         73-  75
 CCIR24                         76-  78
 CCIR25                         79-  81
 CCIR26                         82-  84
 CCIR27                         85-  87
 CCIR28                         88-  90
 CCIR29                         91-  93
 CCIR30                         94-  96
 CCIR31                         97-  99
 CCIR32                        100- 102
 CCIR33                        103- 105
 CCIR34                        106- 108
 CCIR35                        109- 111
 CCIR36                        112- 114
 CCIR37                        115- 117
 CCIR38                        118- 120
 CCIR39                        121- 123
 CCIR40                        124- 126
 CCIR41                        127- 129
 CMR_AIDS                      130- 131
 CMR_ALCOHOL                   132- 133
 CMR_ANEMDEF                   134- 135
 CMR_AUTOIMMUNE                136- 137
 CMR_BLDLOSS                   138- 139
 CMR_CANCER_LEUK               140- 141
 CMR_CANCER_LYMPH              142- 143
 CMR_CANCER_METS               144- 145
 CMR_CANCER_NSITU              146- 147
 CMR_CANCER_SOLID              148- 149
 CMR_CBVD                      150- 151
 CMR_COAG                      152- 153
 CMR_DEMENTIA                  154- 155
 CMR_DEPRESS                   156- 157
 CMR_DIAB_CX                   158- 159
 CMR_DIAB_UNCX                 160- 161
 CMR_DRUG_ABUSE                162- 163
 CMR_HF                        164- 165
 CMR_HTN_CX                    166- 167
 CMR_HTN_UNCX                  168- 169
 CMR_LIVER_MLD                 170- 171
 CMR_LIVER_SEV                 172- 173
 CMR_LUNG_CHRONIC              174- 175
 CMR_NEURO_MOVT                176- 177
 CMR_NEURO_OTH                 178- 179
 CMR_NEURO_SEIZ                180- 181
 CMR_OBESE                     182- 183
 CMR_PARALYSIS                 184- 185
 CMR_PERIVASC                  186- 187
 CMR_PSYCHOSES                 188- 189
 CMR_PULMCIRC                  190- 191
 CMR_RENLFL_MOD                192- 193
 CMR_RENLFL_SEV                194- 195
 CMR_THYROID_HYPO              196- 197
 CMR_THYROID_OTH               198- 199
 CMR_ULCER_PEPTIC              200- 201
 CMR_VALVE                     202- 203
 CMR_VERSION                   204- 209 (A)
 CMR_WGHTLOSS                  210- 211
 I10_INJURY                    212- 213
 I10_INJURY_CUT                214- 215
 I10_INJURY_DROWN              216- 217
 I10_INJURY_FALL               218- 219
 I10_INJURY_FIRE               220- 221
 I10_INJURY_FIREARM            222- 223
 I10_INJURY_MACHINERY          224- 225
 I10_INJURY_MVT                226- 227
 I10_INJURY_NATURE             228- 229
 I10_INJURY_OVEREXERTION       230- 231
 I10_INJURY_POISON             232- 233
 I10_INJURY_STRUCK             234- 235
 I10_INJURY_SUFFOCATION        236- 237
 I10_INTENT_ASSAULT            238- 239
 I10_INTENT_SELF_HARM          240- 241
 I10_INTENT_UNINTENTIONAL      242- 243
 I10_MULTINJURY                244- 245
 KEY                           246- 260
 DXCCSR_Default_DX1            261- 266 (A)
 DXCCSR_BLD001                 267- 269
 DXCCSR_BLD002                 270- 272
 DXCCSR_BLD003                 273- 275
 DXCCSR_BLD004                 276- 278
 DXCCSR_BLD005                 279- 281
 DXCCSR_BLD006                 282- 284
 DXCCSR_BLD007                 285- 287
 DXCCSR_BLD008                 288- 290
 DXCCSR_BLD009                 291- 293
 DXCCSR_BLD010                 294- 296
 DXCCSR_CIR001                 297- 299
 DXCCSR_CIR002                 300- 302
 DXCCSR_CIR003                 303- 305
 DXCCSR_CIR004                 306- 308
 DXCCSR_CIR005                 309- 311
 DXCCSR_CIR006                 312- 314
 DXCCSR_CIR007                 315- 317
 DXCCSR_CIR008                 318- 320
 DXCCSR_CIR009                 321- 323
 DXCCSR_CIR010                 324- 326
 DXCCSR_CIR011                 327- 329
 DXCCSR_CIR012                 330- 332
 DXCCSR_CIR013                 333- 335
 DXCCSR_CIR014                 336- 338
 DXCCSR_CIR015                 339- 341
 DXCCSR_CIR016                 342- 344
 DXCCSR_CIR017                 345- 347
 DXCCSR_CIR018                 348- 350
 DXCCSR_CIR019                 351- 353
 DXCCSR_CIR020                 354- 356
 DXCCSR_CIR021                 357- 359
 DXCCSR_CIR022                 360- 362
 DXCCSR_CIR023                 363- 365
 DXCCSR_CIR024                 366- 368
 DXCCSR_CIR025                 369- 371
 DXCCSR_CIR026                 372- 374
 DXCCSR_CIR027                 375- 377
 DXCCSR_CIR028                 378- 380
 DXCCSR_CIR029                 381- 383
 DXCCSR_CIR030                 384- 386
 DXCCSR_CIR031                 387- 389
 DXCCSR_CIR032                 390- 392
 DXCCSR_CIR033                 393- 395
 DXCCSR_CIR034                 396- 398
 DXCCSR_CIR035                 399- 401
 DXCCSR_CIR036                 402- 404
 DXCCSR_CIR037                 405- 407
 DXCCSR_CIR038                 408- 410
 DXCCSR_CIR039                 411- 413
 DXCCSR_DEN001                 414- 416
 DXCCSR_DEN002                 417- 419
 DXCCSR_DEN003                 420- 422
 DXCCSR_DIG001                 423- 425
 DXCCSR_DIG002                 426- 428
 DXCCSR_DIG003                 429- 431
 DXCCSR_DIG004                 432- 434
 DXCCSR_DIG005                 435- 437
 DXCCSR_DIG006                 438- 440
 DXCCSR_DIG007                 441- 443
 DXCCSR_DIG008                 444- 446
 DXCCSR_DIG009                 447- 449
 DXCCSR_DIG010                 450- 452
 DXCCSR_DIG011                 453- 455
 DXCCSR_DIG012                 456- 458
 DXCCSR_DIG013                 459- 461
 DXCCSR_DIG014                 462- 464
 DXCCSR_DIG015                 465- 467
 DXCCSR_DIG016                 468- 470
 DXCCSR_DIG017                 471- 473
 DXCCSR_DIG018                 474- 476
 DXCCSR_DIG019                 477- 479
 DXCCSR_DIG020                 480- 482
 DXCCSR_DIG021                 483- 485
 DXCCSR_DIG022                 486- 488
 DXCCSR_DIG023                 489- 491
 DXCCSR_DIG024                 492- 494
 DXCCSR_DIG025                 495- 497
 DXCCSR_EAR001                 498- 500
 DXCCSR_EAR002                 501- 503
 DXCCSR_EAR003                 504- 506
 DXCCSR_EAR004                 507- 509
 DXCCSR_EAR005                 510- 512
 DXCCSR_EAR006                 513- 515
 DXCCSR_END001                 516- 518
 DXCCSR_END002                 519- 521
 DXCCSR_END003                 522- 524
 DXCCSR_END004                 525- 527
 DXCCSR_END005                 528- 530
 DXCCSR_END006                 531- 533
 DXCCSR_END007                 534- 536
 DXCCSR_END008                 537- 539
 DXCCSR_END009                 540- 542
 DXCCSR_END010                 543- 545
 DXCCSR_END011                 546- 548
 DXCCSR_END012                 549- 551
 DXCCSR_END013                 552- 554
 DXCCSR_END014                 555- 557
 DXCCSR_END015                 558- 560
 DXCCSR_END016                 561- 563
 DXCCSR_END017                 564- 566
 DXCCSR_EXT001                 567- 569
 DXCCSR_EXT002                 570- 572
 DXCCSR_EXT003                 573- 575
 DXCCSR_EXT004                 576- 578
 DXCCSR_EXT005                 579- 581
 DXCCSR_EXT006                 582- 584
 DXCCSR_EXT007                 585- 587
 DXCCSR_EXT008                 588- 590
 DXCCSR_EXT009                 591- 593
 DXCCSR_EXT010                 594- 596
 DXCCSR_EXT011                 597- 599
 DXCCSR_EXT012                 600- 602
 DXCCSR_EXT013                 603- 605
 DXCCSR_EXT014                 606- 608
 DXCCSR_EXT015                 609- 611
 DXCCSR_EXT016                 612- 614
 DXCCSR_EXT017                 615- 617
 DXCCSR_EXT018                 618- 620
 DXCCSR_EXT019                 621- 623
 DXCCSR_EXT020                 624- 626
 DXCCSR_EXT021                 627- 629
 DXCCSR_EXT022                 630- 632
 DXCCSR_EXT023                 633- 635
 DXCCSR_EXT024                 636- 638
 DXCCSR_EXT025                 639- 641
 DXCCSR_EXT026                 642- 644
 DXCCSR_EXT027                 645- 647
 DXCCSR_EXT028                 648- 650
 DXCCSR_EXT029                 651- 653
 DXCCSR_EXT030                 654- 656
 DXCCSR_EYE001                 657- 659
 DXCCSR_EYE002                 660- 662
 DXCCSR_EYE003                 663- 665
 DXCCSR_EYE004                 666- 668
 DXCCSR_EYE005                 669- 671
 DXCCSR_EYE006                 672- 674
 DXCCSR_EYE007                 675- 677
 DXCCSR_EYE008                 678- 680
 DXCCSR_EYE009                 681- 683
 DXCCSR_EYE010                 684- 686
 DXCCSR_EYE011                 687- 689
 DXCCSR_EYE012                 690- 692
 DXCCSR_FAC001                 693- 695
 DXCCSR_FAC002                 696- 698
 DXCCSR_FAC003                 699- 701
 DXCCSR_FAC004                 702- 704
 DXCCSR_FAC005                 705- 707
 DXCCSR_FAC006                 708- 710
 DXCCSR_FAC007                 711- 713
 DXCCSR_FAC008                 714- 716
 DXCCSR_FAC009                 717- 719
 DXCCSR_FAC010                 720- 722
 DXCCSR_FAC011                 723- 725
 DXCCSR_FAC012                 726- 728
 DXCCSR_FAC013                 729- 731
 DXCCSR_FAC014                 732- 734
 DXCCSR_FAC015                 735- 737
 DXCCSR_FAC016                 738- 740
 DXCCSR_FAC017                 741- 743
 DXCCSR_FAC018                 744- 746
 DXCCSR_FAC019                 747- 749
 DXCCSR_FAC020                 750- 752
 DXCCSR_FAC021                 753- 755
 DXCCSR_FAC022                 756- 758
 DXCCSR_FAC023                 759- 761
 DXCCSR_FAC024                 762- 764
 DXCCSR_FAC025                 765- 767
 DXCCSR_GEN001                 768- 770
 DXCCSR_GEN002                 771- 773
 DXCCSR_GEN003                 774- 776
 DXCCSR_GEN004                 777- 779
 DXCCSR_GEN005                 780- 782
 DXCCSR_GEN006                 783- 785
 DXCCSR_GEN007                 786- 788
 DXCCSR_GEN008                 789- 791
 DXCCSR_GEN009                 792- 794
 DXCCSR_GEN010                 795- 797
 DXCCSR_GEN011                 798- 800
 DXCCSR_GEN012                 801- 803
 DXCCSR_GEN013                 804- 806
 DXCCSR_GEN014                 807- 809
 DXCCSR_GEN015                 810- 812
 DXCCSR_GEN016                 813- 815
 DXCCSR_GEN017                 816- 818
 DXCCSR_GEN018                 819- 821
 DXCCSR_GEN019                 822- 824
 DXCCSR_GEN020                 825- 827
 DXCCSR_GEN021                 828- 830
 DXCCSR_GEN022                 831- 833
 DXCCSR_GEN023                 834- 836
 DXCCSR_GEN024                 837- 839
 DXCCSR_GEN025                 840- 842
 DXCCSR_GEN026                 843- 845
 DXCCSR_INF001                 846- 848
 DXCCSR_INF002                 849- 851
 DXCCSR_INF003                 852- 854
 DXCCSR_INF004                 855- 857
 DXCCSR_INF005                 858- 860
 DXCCSR_INF006                 861- 863
 DXCCSR_INF007                 864- 866
 DXCCSR_INF008                 867- 869
 DXCCSR_INF009                 870- 872
 DXCCSR_INF010                 873- 875
 DXCCSR_INF011                 876- 878
 DXCCSR_INF012                 879- 881
 DXCCSR_INJ001                 882- 884
 DXCCSR_INJ002                 885- 887
 DXCCSR_INJ003                 888- 890
 DXCCSR_INJ004                 891- 893
 DXCCSR_INJ005                 894- 896
 DXCCSR_INJ006                 897- 899
 DXCCSR_INJ007                 900- 902
 DXCCSR_INJ008                 903- 905
 DXCCSR_INJ009                 906- 908
 DXCCSR_INJ010                 909- 911
 DXCCSR_INJ011                 912- 914
 DXCCSR_INJ012                 915- 917
 DXCCSR_INJ013                 918- 920
 DXCCSR_INJ014                 921- 923
 DXCCSR_INJ015                 924- 926
 DXCCSR_INJ016                 927- 929
 DXCCSR_INJ017                 930- 932
 DXCCSR_INJ018                 933- 935
 DXCCSR_INJ019                 936- 938
 DXCCSR_INJ020                 939- 941
 DXCCSR_INJ021                 942- 944
 DXCCSR_INJ022                 945- 947
 DXCCSR_INJ023                 948- 950
 DXCCSR_INJ024                 951- 953
 DXCCSR_INJ025                 954- 956
 DXCCSR_INJ026                 957- 959
 DXCCSR_INJ027                 960- 962
 DXCCSR_INJ028                 963- 965
 DXCCSR_INJ029                 966- 968
 DXCCSR_INJ030                 969- 971
 DXCCSR_INJ031                 972- 974
 DXCCSR_INJ032                 975- 977
 DXCCSR_INJ033                 978- 980
 DXCCSR_INJ034                 981- 983
 DXCCSR_INJ035                 984- 986
 DXCCSR_INJ036                 987- 989
 DXCCSR_INJ037                 990- 992
 DXCCSR_INJ038                 993- 995
 DXCCSR_INJ039                 996- 998
 DXCCSR_INJ040                 999-1001
 DXCCSR_INJ041                1002-1004
 DXCCSR_INJ042                1005-1007
 DXCCSR_INJ043                1008-1010
 DXCCSR_INJ044                1011-1013
 DXCCSR_INJ045                1014-1016
 DXCCSR_INJ046                1017-1019
 DXCCSR_INJ047                1020-1022
 DXCCSR_INJ048                1023-1025
 DXCCSR_INJ049                1026-1028
 DXCCSR_INJ050                1029-1031
 DXCCSR_INJ051                1032-1034
 DXCCSR_INJ052                1035-1037
 DXCCSR_INJ053                1038-1040
 DXCCSR_INJ054                1041-1043
 DXCCSR_INJ055                1044-1046
 DXCCSR_INJ056                1047-1049
 DXCCSR_INJ057                1050-1052
 DXCCSR_INJ058                1053-1055
 DXCCSR_INJ059                1056-1058
 DXCCSR_INJ060                1059-1061
 DXCCSR_INJ061                1062-1064
 DXCCSR_INJ062                1065-1067
 DXCCSR_INJ063                1068-1070
 DXCCSR_INJ064                1071-1073
 DXCCSR_INJ065                1074-1076
 DXCCSR_INJ066                1077-1079
 DXCCSR_INJ067                1080-1082
 DXCCSR_INJ068                1083-1085
 DXCCSR_INJ069                1086-1088
 DXCCSR_INJ070                1089-1091
 DXCCSR_INJ071                1092-1094
 DXCCSR_INJ072                1095-1097
 DXCCSR_INJ073                1098-1100
 DXCCSR_INJ074                1101-1103
 DXCCSR_INJ075                1104-1106
 DXCCSR_INJ076                1107-1109
 DXCCSR_MAL001                1110-1112
 DXCCSR_MAL002                1113-1115
 DXCCSR_MAL003                1116-1118
 DXCCSR_MAL004                1119-1121
 DXCCSR_MAL005                1122-1124
 DXCCSR_MAL006                1125-1127
 DXCCSR_MAL007                1128-1130
 DXCCSR_MAL008                1131-1133
 DXCCSR_MAL009                1134-1136
 DXCCSR_MAL010                1137-1139
 DXCCSR_MBD001                1140-1142
 DXCCSR_MBD002                1143-1145
 DXCCSR_MBD003                1146-1148
 DXCCSR_MBD004                1149-1151
 DXCCSR_MBD005                1152-1154
 DXCCSR_MBD006                1155-1157
 DXCCSR_MBD007                1158-1160
 DXCCSR_MBD008                1161-1163
 DXCCSR_MBD009                1164-1166
 DXCCSR_MBD010                1167-1169
 DXCCSR_MBD011                1170-1172
 DXCCSR_MBD012                1173-1175
 DXCCSR_MBD013                1176-1178
 DXCCSR_MBD014                1179-1181
 DXCCSR_MBD017                1182-1184
 DXCCSR_MBD018                1185-1187
 DXCCSR_MBD019                1188-1190
 DXCCSR_MBD020                1191-1193
 DXCCSR_MBD021                1194-1196
 DXCCSR_MBD022                1197-1199
 DXCCSR_MBD023                1200-1202
 DXCCSR_MBD024                1203-1205
 DXCCSR_MBD025                1206-1208
 DXCCSR_MBD026                1209-1211
 DXCCSR_MBD027                1212-1214
 DXCCSR_MBD028                1215-1217
 DXCCSR_MBD029                1218-1220
 DXCCSR_MBD030                1221-1223
 DXCCSR_MBD031                1224-1226
 DXCCSR_MBD032                1227-1229
 DXCCSR_MBD033                1230-1232
 DXCCSR_MBD034                1233-1235
 DXCCSR_MUS001                1236-1238
 DXCCSR_MUS002                1239-1241
 DXCCSR_MUS003                1242-1244
 DXCCSR_MUS004                1245-1247
 DXCCSR_MUS005                1248-1250
 DXCCSR_MUS006                1251-1253
 DXCCSR_MUS007                1254-1256
 DXCCSR_MUS008                1257-1259
 DXCCSR_MUS009                1260-1262
 DXCCSR_MUS010                1263-1265
 DXCCSR_MUS011                1266-1268
 DXCCSR_MUS012                1269-1271
 DXCCSR_MUS013                1272-1274
 DXCCSR_MUS014                1275-1277
 DXCCSR_MUS015                1278-1280
 DXCCSR_MUS016                1281-1283
 DXCCSR_MUS017                1284-1286
 DXCCSR_MUS018                1287-1289
 DXCCSR_MUS019                1290-1292
 DXCCSR_MUS020                1293-1295
 DXCCSR_MUS021                1296-1298
 DXCCSR_MUS022                1299-1301
 DXCCSR_MUS023                1302-1304
 DXCCSR_MUS024                1305-1307
 DXCCSR_MUS025                1308-1310
 DXCCSR_MUS026                1311-1313
 DXCCSR_MUS027                1314-1316
 DXCCSR_MUS028                1317-1319
 DXCCSR_MUS029                1320-1322
 DXCCSR_MUS030                1323-1325
 DXCCSR_MUS031                1326-1328
 DXCCSR_MUS032                1329-1331
 DXCCSR_MUS033                1332-1334
 DXCCSR_MUS034                1335-1337
 DXCCSR_MUS035                1338-1340
 DXCCSR_MUS036                1341-1343
 DXCCSR_MUS037                1344-1346
 DXCCSR_MUS038                1347-1349
 DXCCSR_NEO001                1350-1352
 DXCCSR_NEO002                1353-1355
 DXCCSR_NEO003                1356-1358
 DXCCSR_NEO004                1359-1361
 DXCCSR_NEO005                1362-1364
 DXCCSR_NEO006                1365-1367
 DXCCSR_NEO007                1368-1370
 DXCCSR_NEO008                1371-1373
 DXCCSR_NEO009                1374-1376
 DXCCSR_NEO010                1377-1379
 DXCCSR_NEO011                1380-1382
 DXCCSR_NEO012                1383-1385
 DXCCSR_NEO013                1386-1388
 DXCCSR_NEO014                1389-1391
 DXCCSR_NEO015                1392-1394
 DXCCSR_NEO016                1395-1397
 DXCCSR_NEO017                1398-1400
 DXCCSR_NEO018                1401-1403
 DXCCSR_NEO019                1404-1406
 DXCCSR_NEO020                1407-1409
 DXCCSR_NEO021                1410-1412
 DXCCSR_NEO022                1413-1415
 DXCCSR_NEO023                1416-1418
 DXCCSR_NEO024                1419-1421
 DXCCSR_NEO025                1422-1424
 DXCCSR_NEO026                1425-1427
 DXCCSR_NEO027                1428-1430
 DXCCSR_NEO028                1431-1433
 DXCCSR_NEO029                1434-1436
 DXCCSR_NEO030                1437-1439
 DXCCSR_NEO031                1440-1442
 DXCCSR_NEO032                1443-1445
 DXCCSR_NEO033                1446-1448
 DXCCSR_NEO034                1449-1451
 DXCCSR_NEO035                1452-1454
 DXCCSR_NEO036                1455-1457
 DXCCSR_NEO037                1458-1460
 DXCCSR_NEO038                1461-1463
 DXCCSR_NEO039                1464-1466
 DXCCSR_NEO040                1467-1469
 DXCCSR_NEO041                1470-1472
 DXCCSR_NEO042                1473-1475
 DXCCSR_NEO043                1476-1478
 DXCCSR_NEO044                1479-1481
 DXCCSR_NEO045                1482-1484
 DXCCSR_NEO046                1485-1487
 DXCCSR_NEO047                1488-1490
 DXCCSR_NEO048                1491-1493
 DXCCSR_NEO049                1494-1496
 DXCCSR_NEO050                1497-1499
 DXCCSR_NEO051                1500-1502
 DXCCSR_NEO052                1503-1505
 DXCCSR_NEO053                1506-1508
 DXCCSR_NEO054                1509-1511
 DXCCSR_NEO055                1512-1514
 DXCCSR_NEO056                1515-1517
 DXCCSR_NEO057                1518-1520
 DXCCSR_NEO058                1521-1523
 DXCCSR_NEO059                1524-1526
 DXCCSR_NEO060                1527-1529
 DXCCSR_NEO061                1530-1532
 DXCCSR_NEO062                1533-1535
 DXCCSR_NEO063                1536-1538
 DXCCSR_NEO064                1539-1541
 DXCCSR_NEO065                1542-1544
 DXCCSR_NEO066                1545-1547
 DXCCSR_NEO067                1548-1550
 DXCCSR_NEO068                1551-1553
 DXCCSR_NEO069                1554-1556
 DXCCSR_NEO070                1557-1559
 DXCCSR_NEO071                1560-1562
 DXCCSR_NEO072                1563-1565
 DXCCSR_NEO073                1566-1568
 DXCCSR_NEO074                1569-1571
 DXCCSR_NVS001                1572-1574
 DXCCSR_NVS002                1575-1577
 DXCCSR_NVS003                1578-1580
 DXCCSR_NVS004                1581-1583
 DXCCSR_NVS005                1584-1586
 DXCCSR_NVS006                1587-1589
 DXCCSR_NVS007                1590-1592
 DXCCSR_NVS008                1593-1595
 DXCCSR_NVS009                1596-1598
 DXCCSR_NVS010                1599-1601
 DXCCSR_NVS011                1602-1604
 DXCCSR_NVS012                1605-1607
 DXCCSR_NVS013                1608-1610
 DXCCSR_NVS014                1611-1613
 DXCCSR_NVS015                1614-1616
 DXCCSR_NVS016                1617-1619
 DXCCSR_NVS017                1620-1622
 DXCCSR_NVS018                1623-1625
 DXCCSR_NVS019                1626-1628
 DXCCSR_NVS020                1629-1631
 DXCCSR_NVS021                1632-1634
 DXCCSR_NVS022                1635-1637
 DXCCSR_PNL001                1638-1640
 DXCCSR_PNL002                1641-1643
 DXCCSR_PNL003                1644-1646
 DXCCSR_PNL004                1647-1649
 DXCCSR_PNL005                1650-1652
 DXCCSR_PNL006                1653-1655
 DXCCSR_PNL007                1656-1658
 DXCCSR_PNL008                1659-1661
 DXCCSR_PNL009                1662-1664
 DXCCSR_PNL010                1665-1667
 DXCCSR_PNL011                1668-1670
 DXCCSR_PNL012                1671-1673
 DXCCSR_PNL013                1674-1676
 DXCCSR_PNL014                1677-1679
 DXCCSR_PNL015                1680-1682
 DXCCSR_PRG001                1683-1685
 DXCCSR_PRG002                1686-1688
 DXCCSR_PRG003                1689-1691
 DXCCSR_PRG004                1692-1694
 DXCCSR_PRG005                1695-1697
 DXCCSR_PRG006                1698-1700
 DXCCSR_PRG007                1701-1703
 DXCCSR_PRG008                1704-1706
 DXCCSR_PRG009                1707-1709
 DXCCSR_PRG010                1710-1712
 DXCCSR_PRG011                1713-1715
 DXCCSR_PRG012                1716-1718
 DXCCSR_PRG013                1719-1721
 DXCCSR_PRG014                1722-1724
 DXCCSR_PRG015                1725-1727
 DXCCSR_PRG016                1728-1730
 DXCCSR_PRG017                1731-1733
 DXCCSR_PRG018                1734-1736
 DXCCSR_PRG019                1737-1739
 DXCCSR_PRG020                1740-1742
 DXCCSR_PRG021                1743-1745
 DXCCSR_PRG022                1746-1748
 DXCCSR_PRG023                1749-1751
 DXCCSR_PRG024                1752-1754
 DXCCSR_PRG025                1755-1757
 DXCCSR_PRG026                1758-1760
 DXCCSR_PRG027                1761-1763
 DXCCSR_PRG028                1764-1766
 DXCCSR_PRG029                1767-1769
 DXCCSR_PRG030                1770-1772
 DXCCSR_RSP001                1773-1775
 DXCCSR_RSP002                1776-1778
 DXCCSR_RSP003                1779-1781
 DXCCSR_RSP004                1782-1784
 DXCCSR_RSP005                1785-1787
 DXCCSR_RSP006                1788-1790
 DXCCSR_RSP007                1791-1793
 DXCCSR_RSP008                1794-1796
 DXCCSR_RSP009                1797-1799
 DXCCSR_RSP010                1800-1802
 DXCCSR_RSP011                1803-1805
 DXCCSR_RSP012                1806-1808
 DXCCSR_RSP013                1809-1811
 DXCCSR_RSP014                1812-1814
 DXCCSR_RSP015                1815-1817
 DXCCSR_RSP016                1818-1820
 DXCCSR_RSP017                1821-1823
 DXCCSR_SKN001                1824-1826
 DXCCSR_SKN002                1827-1829
 DXCCSR_SKN003                1830-1832
 DXCCSR_SKN004                1833-1835
 DXCCSR_SKN005                1836-1838
 DXCCSR_SKN006                1839-1841
 DXCCSR_SKN007                1842-1844
 DXCCSR_SYM001                1845-1847
 DXCCSR_SYM002                1848-1850
 DXCCSR_SYM003                1851-1853
 DXCCSR_SYM004                1854-1856
 DXCCSR_SYM005                1857-1859
 DXCCSR_SYM006                1860-1862
 DXCCSR_SYM007                1863-1865
 DXCCSR_SYM008                1866-1868
 DXCCSR_SYM009                1869-1871
 DXCCSR_SYM010                1872-1874
 DXCCSR_SYM011                1875-1877
 DXCCSR_SYM012                1878-1880
 DXCCSR_SYM013                1881-1883
 DXCCSR_SYM014                1884-1886
 DXCCSR_SYM015                1887-1889
 DXCCSR_SYM016                1890-1892
 DXCCSR_SYM017                1893-1895
 DXCCSR_VERSION               1896-1901 (A).


/***  Specify write formats  ***/
FORMATS
 CCIR1                        (F3.0) /
 CCIR2                        (F3.0) /
 CCIR3                        (F3.0) /
 CCIR4                        (F3.0) /
 CCIR5                        (F3.0) /
 CCIR6                        (F3.0) /
 CCIR7                        (F3.0) /
 CCIR8                        (F3.0) /
 CCIR9                        (F3.0) /
 CCIR10                       (F3.0) /
 CCIR11                       (F3.0) /
 CCIR12                       (F3.0) /
 CCIR13                       (F3.0) /
 CCIR14                       (F3.0) /
 CCIR15                       (F3.0) /
 CCIR16                       (F3.0) /
 CCIR17                       (F3.0) /
 CCIR18                       (F3.0) /
 CCIR19                       (F3.0) /
 CCIR20                       (F3.0) /
 CCIR21                       (F3.0) /
 CCIR22                       (F3.0) /
 CCIR23                       (F3.0) /
 CCIR24                       (F3.0) /
 CCIR25                       (F3.0) /
 CCIR26                       (F3.0) /
 CCIR27                       (F3.0) /
 CCIR28                       (F3.0) /
 CCIR29                       (F3.0) /
 CCIR30                       (F3.0) /
 CCIR31                       (F3.0) /
 CCIR32                       (F3.0) /
 CCIR33                       (F3.0) /
 CCIR34                       (F3.0) /
 CCIR35                       (F3.0) /
 CCIR36                       (F3.0) /
 CCIR37                       (F3.0) /
 CCIR38                       (F3.0) /
 CCIR39                       (F3.0) /
 CCIR40                       (F3.0) /
 CCIR41                       (F3.0) /
 CMR_AIDS                     (F3.0) /
 CMR_ALCOHOL                  (F3.0) /
 CMR_ANEMDEF                  (F3.0) /
 CMR_AUTOIMMUNE               (F3.0) /
 CMR_BLDLOSS                  (F3.0) /
 CMR_CANCER_LEUK              (F3.0) /
 CMR_CANCER_LYMPH             (F3.0) /
 CMR_CANCER_METS              (F3.0) /
 CMR_CANCER_NSITU             (F3.0) /
 CMR_CANCER_SOLID             (F3.0) /
 CMR_CBVD                     (F3.0) /
 CMR_COAG                     (F3.0) /
 CMR_DEMENTIA                 (F3.0) /
 CMR_DEPRESS                  (F3.0) /
 CMR_DIAB_CX                  (F3.0) /
 CMR_DIAB_UNCX                (F3.0) /
 CMR_DRUG_ABUSE               (F3.0) /
 CMR_HF                       (F3.0) /
 CMR_HTN_CX                   (F3.0) /
 CMR_HTN_UNCX                 (F3.0) /
 CMR_LIVER_MLD                (F3.0) /
 CMR_LIVER_SEV                (F3.0) /
 CMR_LUNG_CHRONIC             (F3.0) /
 CMR_NEURO_MOVT               (F3.0) /
 CMR_NEURO_OTH                (F3.0) /
 CMR_NEURO_SEIZ               (F3.0) /
 CMR_OBESE                    (F3.0) /
 CMR_PARALYSIS                (F3.0) /
 CMR_PERIVASC                 (F3.0) /
 CMR_PSYCHOSES                (F3.0) /
 CMR_PULMCIRC                 (F3.0) /
 CMR_RENLFL_MOD               (F3.0) /
 CMR_RENLFL_SEV               (F3.0) /
 CMR_THYROID_HYPO             (F3.0) /
 CMR_THYROID_OTH              (F3.0) /
 CMR_ULCER_PEPTIC             (F3.0) /
 CMR_VALVE                    (F3.0) /
 CMR_WGHTLOSS                 (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_INJURY_CUT               (F3.0) /
 I10_INJURY_DROWN             (F3.0) /
 I10_INJURY_FALL              (F3.0) /
 I10_INJURY_FIRE              (F3.0) /
 I10_INJURY_FIREARM           (F3.0) /
 I10_INJURY_MACHINERY         (F3.0) /
 I10_INJURY_MVT               (F3.0) /
 I10_INJURY_NATURE            (F3.0) /
 I10_INJURY_OVEREXERTION      (F3.0) /
 I10_INJURY_POISON            (F3.0) /
 I10_INJURY_STRUCK            (F3.0) /
 I10_INJURY_SUFFOCATION       (F3.0) /
 I10_INTENT_ASSAULT           (F3.0) /
 I10_INTENT_SELF_HARM         (F3.0) /
 I10_INTENT_UNINTENTIONAL     (F3.0) /
 I10_MULTINJURY               (F3.0) /
 KEY                          (F8.0) /
 DXCCSR_BLD001                (F3.0) /
 DXCCSR_BLD002                (F3.0) /
 DXCCSR_BLD003                (F3.0) /
 DXCCSR_BLD004                (F3.0) /
 DXCCSR_BLD005                (F3.0) /
 DXCCSR_BLD006                (F3.0) /
 DXCCSR_BLD007                (F3.0) /
 DXCCSR_BLD008                (F3.0) /
 DXCCSR_BLD009                (F3.0) /
 DXCCSR_BLD010                (F3.0) /
 DXCCSR_CIR001                (F3.0) /
 DXCCSR_CIR002                (F3.0) /
 DXCCSR_CIR003                (F3.0) /
 DXCCSR_CIR004                (F3.0) /
 DXCCSR_CIR005                (F3.0) /
 DXCCSR_CIR006                (F3.0) /
 DXCCSR_CIR007                (F3.0) /
 DXCCSR_CIR008                (F3.0) /
 DXCCSR_CIR009                (F3.0) /
 DXCCSR_CIR010                (F3.0) /
 DXCCSR_CIR011                (F3.0) /
 DXCCSR_CIR012                (F3.0) /
 DXCCSR_CIR013                (F3.0) /
 DXCCSR_CIR014                (F3.0) /
 DXCCSR_CIR015                (F3.0) /
 DXCCSR_CIR016                (F3.0) /
 DXCCSR_CIR017                (F3.0) /
 DXCCSR_CIR018                (F3.0) /
 DXCCSR_CIR019                (F3.0) /
 DXCCSR_CIR020                (F3.0) /
 DXCCSR_CIR021                (F3.0) /
 DXCCSR_CIR022                (F3.0) /
 DXCCSR_CIR023                (F3.0) /
 DXCCSR_CIR024                (F3.0) /
 DXCCSR_CIR025                (F3.0) /
 DXCCSR_CIR026                (F3.0) /
 DXCCSR_CIR027                (F3.0) /
 DXCCSR_CIR028                (F3.0) /
 DXCCSR_CIR029                (F3.0) /
 DXCCSR_CIR030                (F3.0) /
 DXCCSR_CIR031                (F3.0) /
 DXCCSR_CIR032                (F3.0) /
 DXCCSR_CIR033                (F3.0) /
 DXCCSR_CIR034                (F3.0) /
 DXCCSR_CIR035                (F3.0) /
 DXCCSR_CIR036                (F3.0) /
 DXCCSR_CIR037                (F3.0) /
 DXCCSR_CIR038                (F3.0) /
 DXCCSR_CIR039                (F3.0) /
 DXCCSR_DEN001                (F3.0) /
 DXCCSR_DEN002                (F3.0) /
 DXCCSR_DEN003                (F3.0) /
 DXCCSR_DIG001                (F3.0) /
 DXCCSR_DIG002                (F3.0) /
 DXCCSR_DIG003                (F3.0) /
 DXCCSR_DIG004                (F3.0) /
 DXCCSR_DIG005                (F3.0) /
 DXCCSR_DIG006                (F3.0) /
 DXCCSR_DIG007                (F3.0) /
 DXCCSR_DIG008                (F3.0) /
 DXCCSR_DIG009                (F3.0) /
 DXCCSR_DIG010                (F3.0) /
 DXCCSR_DIG011                (F3.0) /
 DXCCSR_DIG012                (F3.0) /
 DXCCSR_DIG013                (F3.0) /
 DXCCSR_DIG014                (F3.0) /
 DXCCSR_DIG015                (F3.0) /
 DXCCSR_DIG016                (F3.0) /
 DXCCSR_DIG017                (F3.0) /
 DXCCSR_DIG018                (F3.0) /
 DXCCSR_DIG019                (F3.0) /
 DXCCSR_DIG020                (F3.0) /
 DXCCSR_DIG021                (F3.0) /
 DXCCSR_DIG022                (F3.0) /
 DXCCSR_DIG023                (F3.0) /
 DXCCSR_DIG024                (F3.0) /
 DXCCSR_DIG025                (F3.0) /
 DXCCSR_EAR001                (F3.0) /
 DXCCSR_EAR002                (F3.0) /
 DXCCSR_EAR003                (F3.0) /
 DXCCSR_EAR004                (F3.0) /
 DXCCSR_EAR005                (F3.0) /
 DXCCSR_EAR006                (F3.0) /
 DXCCSR_END001                (F3.0) /
 DXCCSR_END002                (F3.0) /
 DXCCSR_END003                (F3.0) /
 DXCCSR_END004                (F3.0) /
 DXCCSR_END005                (F3.0) /
 DXCCSR_END006                (F3.0) /
 DXCCSR_END007                (F3.0) /
 DXCCSR_END008                (F3.0) /
 DXCCSR_END009                (F3.0) /
 DXCCSR_END010                (F3.0) /
 DXCCSR_END011                (F3.0) /
 DXCCSR_END012                (F3.0) /
 DXCCSR_END013                (F3.0) /
 DXCCSR_END014                (F3.0) /
 DXCCSR_END015                (F3.0) /
 DXCCSR_END016                (F3.0) /
 DXCCSR_END017                (F3.0) /
 DXCCSR_EXT001                (F3.0) /
 DXCCSR_EXT002                (F3.0) /
 DXCCSR_EXT003                (F3.0) /
 DXCCSR_EXT004                (F3.0) /
 DXCCSR_EXT005                (F3.0) /
 DXCCSR_EXT006                (F3.0) /
 DXCCSR_EXT007                (F3.0) /
 DXCCSR_EXT008                (F3.0) /
 DXCCSR_EXT009                (F3.0) /
 DXCCSR_EXT010                (F3.0) /
 DXCCSR_EXT011                (F3.0) /
 DXCCSR_EXT012                (F3.0) /
 DXCCSR_EXT013                (F3.0) /
 DXCCSR_EXT014                (F3.0) /
 DXCCSR_EXT015                (F3.0) /
 DXCCSR_EXT016                (F3.0) /
 DXCCSR_EXT017                (F3.0) /
 DXCCSR_EXT018                (F3.0) /
 DXCCSR_EXT019                (F3.0) /
 DXCCSR_EXT020                (F3.0) /
 DXCCSR_EXT021                (F3.0) /
 DXCCSR_EXT022                (F3.0) /
 DXCCSR_EXT023                (F3.0) /
 DXCCSR_EXT024                (F3.0) /
 DXCCSR_EXT025                (F3.0) /
 DXCCSR_EXT026                (F3.0) /
 DXCCSR_EXT027                (F3.0) /
 DXCCSR_EXT028                (F3.0) /
 DXCCSR_EXT029                (F3.0) /
 DXCCSR_EXT030                (F3.0) /
 DXCCSR_EYE001                (F3.0) /
 DXCCSR_EYE002                (F3.0) /
 DXCCSR_EYE003                (F3.0) /
 DXCCSR_EYE004                (F3.0) /
 DXCCSR_EYE005                (F3.0) /
 DXCCSR_EYE006                (F3.0) /
 DXCCSR_EYE007                (F3.0) /
 DXCCSR_EYE008                (F3.0) /
 DXCCSR_EYE009                (F3.0) /
 DXCCSR_EYE010                (F3.0) /
 DXCCSR_EYE011                (F3.0) /
 DXCCSR_EYE012                (F3.0) /
 DXCCSR_FAC001                (F3.0) /
 DXCCSR_FAC002                (F3.0) /
 DXCCSR_FAC003                (F3.0) /
 DXCCSR_FAC004                (F3.0) /
 DXCCSR_FAC005                (F3.0) /
 DXCCSR_FAC006                (F3.0) /
 DXCCSR_FAC007                (F3.0) /
 DXCCSR_FAC008                (F3.0) /
 DXCCSR_FAC009                (F3.0) /
 DXCCSR_FAC010                (F3.0) /
 DXCCSR_FAC011                (F3.0) /
 DXCCSR_FAC012                (F3.0) /
 DXCCSR_FAC013                (F3.0) /
 DXCCSR_FAC014                (F3.0) /
 DXCCSR_FAC015                (F3.0) /
 DXCCSR_FAC016                (F3.0) /
 DXCCSR_FAC017                (F3.0) /
 DXCCSR_FAC018                (F3.0) /
 DXCCSR_FAC019                (F3.0) /
 DXCCSR_FAC020                (F3.0) /
 DXCCSR_FAC021                (F3.0) /
 DXCCSR_FAC022                (F3.0) /
 DXCCSR_FAC023                (F3.0) /
 DXCCSR_FAC024                (F3.0) /
 DXCCSR_FAC025                (F3.0) /
 DXCCSR_GEN001                (F3.0) /
 DXCCSR_GEN002                (F3.0) /
 DXCCSR_GEN003                (F3.0) /
 DXCCSR_GEN004                (F3.0) /
 DXCCSR_GEN005                (F3.0) /
 DXCCSR_GEN006                (F3.0) /
 DXCCSR_GEN007                (F3.0) /
 DXCCSR_GEN008                (F3.0) /
 DXCCSR_GEN009                (F3.0) /
 DXCCSR_GEN010                (F3.0) /
 DXCCSR_GEN011                (F3.0) /
 DXCCSR_GEN012                (F3.0) /
 DXCCSR_GEN013                (F3.0) /
 DXCCSR_GEN014                (F3.0) /
 DXCCSR_GEN015                (F3.0) /
 DXCCSR_GEN016                (F3.0) /
 DXCCSR_GEN017                (F3.0) /
 DXCCSR_GEN018                (F3.0) /
 DXCCSR_GEN019                (F3.0) /
 DXCCSR_GEN020                (F3.0) /
 DXCCSR_GEN021                (F3.0) /
 DXCCSR_GEN022                (F3.0) /
 DXCCSR_GEN023                (F3.0) /
 DXCCSR_GEN024                (F3.0) /
 DXCCSR_GEN025                (F3.0) /
 DXCCSR_GEN026                (F3.0) /
 DXCCSR_INF001                (F3.0) /
 DXCCSR_INF002                (F3.0) /
 DXCCSR_INF003                (F3.0) /
 DXCCSR_INF004                (F3.0) /
 DXCCSR_INF005                (F3.0) /
 DXCCSR_INF006                (F3.0) /
 DXCCSR_INF007                (F3.0) /
 DXCCSR_INF008                (F3.0) /
 DXCCSR_INF009                (F3.0) /
 DXCCSR_INF010                (F3.0) /
 DXCCSR_INF011                (F3.0) /
 DXCCSR_INF012                (F3.0) /
 DXCCSR_INJ001                (F3.0) /
 DXCCSR_INJ002                (F3.0) /
 DXCCSR_INJ003                (F3.0) /
 DXCCSR_INJ004                (F3.0) /
 DXCCSR_INJ005                (F3.0) /
 DXCCSR_INJ006                (F3.0) /
 DXCCSR_INJ007                (F3.0) /
 DXCCSR_INJ008                (F3.0) /
 DXCCSR_INJ009                (F3.0) /
 DXCCSR_INJ010                (F3.0) /
 DXCCSR_INJ011                (F3.0) /
 DXCCSR_INJ012                (F3.0) /
 DXCCSR_INJ013                (F3.0) /
 DXCCSR_INJ014                (F3.0) /
 DXCCSR_INJ015                (F3.0) /
 DXCCSR_INJ016                (F3.0) /
 DXCCSR_INJ017                (F3.0) /
 DXCCSR_INJ018                (F3.0) /
 DXCCSR_INJ019                (F3.0) /
 DXCCSR_INJ020                (F3.0) /
 DXCCSR_INJ021                (F3.0) /
 DXCCSR_INJ022                (F3.0) /
 DXCCSR_INJ023                (F3.0) /
 DXCCSR_INJ024                (F3.0) /
 DXCCSR_INJ025                (F3.0) /
 DXCCSR_INJ026                (F3.0) /
 DXCCSR_INJ027                (F3.0) /
 DXCCSR_INJ028                (F3.0) /
 DXCCSR_INJ029                (F3.0) /
 DXCCSR_INJ030                (F3.0) /
 DXCCSR_INJ031                (F3.0) /
 DXCCSR_INJ032                (F3.0) /
 DXCCSR_INJ033                (F3.0) /
 DXCCSR_INJ034                (F3.0) /
 DXCCSR_INJ035                (F3.0) /
 DXCCSR_INJ036                (F3.0) /
 DXCCSR_INJ037                (F3.0) /
 DXCCSR_INJ038                (F3.0) /
 DXCCSR_INJ039                (F3.0) /
 DXCCSR_INJ040                (F3.0) /
 DXCCSR_INJ041                (F3.0) /
 DXCCSR_INJ042                (F3.0) /
 DXCCSR_INJ043                (F3.0) /
 DXCCSR_INJ044                (F3.0) /
 DXCCSR_INJ045                (F3.0) /
 DXCCSR_INJ046                (F3.0) /
 DXCCSR_INJ047                (F3.0) /
 DXCCSR_INJ048                (F3.0) /
 DXCCSR_INJ049                (F3.0) /
 DXCCSR_INJ050                (F3.0) /
 DXCCSR_INJ051                (F3.0) /
 DXCCSR_INJ052                (F3.0) /
 DXCCSR_INJ053                (F3.0) /
 DXCCSR_INJ054                (F3.0) /
 DXCCSR_INJ055                (F3.0) /
 DXCCSR_INJ056                (F3.0) /
 DXCCSR_INJ057                (F3.0) /
 DXCCSR_INJ058                (F3.0) /
 DXCCSR_INJ059                (F3.0) /
 DXCCSR_INJ060                (F3.0) /
 DXCCSR_INJ061                (F3.0) /
 DXCCSR_INJ062                (F3.0) /
 DXCCSR_INJ063                (F3.0) /
 DXCCSR_INJ064                (F3.0) /
 DXCCSR_INJ065                (F3.0) /
 DXCCSR_INJ066                (F3.0) /
 DXCCSR_INJ067                (F3.0) /
 DXCCSR_INJ068                (F3.0) /
 DXCCSR_INJ069                (F3.0) /
 DXCCSR_INJ070                (F3.0) /
 DXCCSR_INJ071                (F3.0) /
 DXCCSR_INJ072                (F3.0) /
 DXCCSR_INJ073                (F3.0) /
 DXCCSR_INJ074                (F3.0) /
 DXCCSR_INJ075                (F3.0) /
 DXCCSR_INJ076                (F3.0) /
 DXCCSR_MAL001                (F3.0) /
 DXCCSR_MAL002                (F3.0) /
 DXCCSR_MAL003                (F3.0) /
 DXCCSR_MAL004                (F3.0) /
 DXCCSR_MAL005                (F3.0) /
 DXCCSR_MAL006                (F3.0) /
 DXCCSR_MAL007                (F3.0) /
 DXCCSR_MAL008                (F3.0) /
 DXCCSR_MAL009                (F3.0) /
 DXCCSR_MAL010                (F3.0) /
 DXCCSR_MBD001                (F3.0) /
 DXCCSR_MBD002                (F3.0) /
 DXCCSR_MBD003                (F3.0) /
 DXCCSR_MBD004                (F3.0) /
 DXCCSR_MBD005                (F3.0) /
 DXCCSR_MBD006                (F3.0) /
 DXCCSR_MBD007                (F3.0) /
 DXCCSR_MBD008                (F3.0) /
 DXCCSR_MBD009                (F3.0) /
 DXCCSR_MBD010                (F3.0) /
 DXCCSR_MBD011                (F3.0) /
 DXCCSR_MBD012                (F3.0) /
 DXCCSR_MBD013                (F3.0) /
 DXCCSR_MBD014                (F3.0) /
 DXCCSR_MBD017                (F3.0) /
 DXCCSR_MBD018                (F3.0) /
 DXCCSR_MBD019                (F3.0) /
 DXCCSR_MBD020                (F3.0) /
 DXCCSR_MBD021                (F3.0) /
 DXCCSR_MBD022                (F3.0) /
 DXCCSR_MBD023                (F3.0) /
 DXCCSR_MBD024                (F3.0) /
 DXCCSR_MBD025                (F3.0) /
 DXCCSR_MBD026                (F3.0) /
 DXCCSR_MBD027                (F3.0) /
 DXCCSR_MBD028                (F3.0) /
 DXCCSR_MBD029                (F3.0) /
 DXCCSR_MBD030                (F3.0) /
 DXCCSR_MBD031                (F3.0) /
 DXCCSR_MBD032                (F3.0) /
 DXCCSR_MBD033                (F3.0) /
 DXCCSR_MBD034                (F3.0) /
 DXCCSR_MUS001                (F3.0) /
 DXCCSR_MUS002                (F3.0) /
 DXCCSR_MUS003                (F3.0) /
 DXCCSR_MUS004                (F3.0) /
 DXCCSR_MUS005                (F3.0) /
 DXCCSR_MUS006                (F3.0) /
 DXCCSR_MUS007                (F3.0) /
 DXCCSR_MUS008                (F3.0) /
 DXCCSR_MUS009                (F3.0) /
 DXCCSR_MUS010                (F3.0) /
 DXCCSR_MUS011                (F3.0) /
 DXCCSR_MUS012                (F3.0) /
 DXCCSR_MUS013                (F3.0) /
 DXCCSR_MUS014                (F3.0) /
 DXCCSR_MUS015                (F3.0) /
 DXCCSR_MUS016                (F3.0) /
 DXCCSR_MUS017                (F3.0) /
 DXCCSR_MUS018                (F3.0) /
 DXCCSR_MUS019                (F3.0) /
 DXCCSR_MUS020                (F3.0) /
 DXCCSR_MUS021                (F3.0) /
 DXCCSR_MUS022                (F3.0) /
 DXCCSR_MUS023                (F3.0) /
 DXCCSR_MUS024                (F3.0) /
 DXCCSR_MUS025                (F3.0) /
 DXCCSR_MUS026                (F3.0) /
 DXCCSR_MUS027                (F3.0) /
 DXCCSR_MUS028                (F3.0) /
 DXCCSR_MUS029                (F3.0) /
 DXCCSR_MUS030                (F3.0) /
 DXCCSR_MUS031                (F3.0) /
 DXCCSR_MUS032                (F3.0) /
 DXCCSR_MUS033                (F3.0) /
 DXCCSR_MUS034                (F3.0) /
 DXCCSR_MUS035                (F3.0) /
 DXCCSR_MUS036                (F3.0) /
 DXCCSR_MUS037                (F3.0) /
 DXCCSR_MUS038                (F3.0) /
 DXCCSR_NEO001                (F3.0) /
 DXCCSR_NEO002                (F3.0) /
 DXCCSR_NEO003                (F3.0) /
 DXCCSR_NEO004                (F3.0) /
 DXCCSR_NEO005                (F3.0) /
 DXCCSR_NEO006                (F3.0) /
 DXCCSR_NEO007                (F3.0) /
 DXCCSR_NEO008                (F3.0) /
 DXCCSR_NEO009                (F3.0) /
 DXCCSR_NEO010                (F3.0) /
 DXCCSR_NEO011                (F3.0) /
 DXCCSR_NEO012                (F3.0) /
 DXCCSR_NEO013                (F3.0) /
 DXCCSR_NEO014                (F3.0) /
 DXCCSR_NEO015                (F3.0) /
 DXCCSR_NEO016                (F3.0) /
 DXCCSR_NEO017                (F3.0) /
 DXCCSR_NEO018                (F3.0) /
 DXCCSR_NEO019                (F3.0) /
 DXCCSR_NEO020                (F3.0) /
 DXCCSR_NEO021                (F3.0) /
 DXCCSR_NEO022                (F3.0) /
 DXCCSR_NEO023                (F3.0) /
 DXCCSR_NEO024                (F3.0) /
 DXCCSR_NEO025                (F3.0) /
 DXCCSR_NEO026                (F3.0) /
 DXCCSR_NEO027                (F3.0) /
 DXCCSR_NEO028                (F3.0) /
 DXCCSR_NEO029                (F3.0) /
 DXCCSR_NEO030                (F3.0) /
 DXCCSR_NEO031                (F3.0) /
 DXCCSR_NEO032                (F3.0) /
 DXCCSR_NEO033                (F3.0) /
 DXCCSR_NEO034                (F3.0) /
 DXCCSR_NEO035                (F3.0) /
 DXCCSR_NEO036                (F3.0) /
 DXCCSR_NEO037                (F3.0) /
 DXCCSR_NEO038                (F3.0) /
 DXCCSR_NEO039                (F3.0) /
 DXCCSR_NEO040                (F3.0) /
 DXCCSR_NEO041                (F3.0) /
 DXCCSR_NEO042                (F3.0) /
 DXCCSR_NEO043                (F3.0) /
 DXCCSR_NEO044                (F3.0) /
 DXCCSR_NEO045                (F3.0) /
 DXCCSR_NEO046                (F3.0) /
 DXCCSR_NEO047                (F3.0) /
 DXCCSR_NEO048                (F3.0) /
 DXCCSR_NEO049                (F3.0) /
 DXCCSR_NEO050                (F3.0) /
 DXCCSR_NEO051                (F3.0) /
 DXCCSR_NEO052                (F3.0) /
 DXCCSR_NEO053                (F3.0) /
 DXCCSR_NEO054                (F3.0) /
 DXCCSR_NEO055                (F3.0) /
 DXCCSR_NEO056                (F3.0) /
 DXCCSR_NEO057                (F3.0) /
 DXCCSR_NEO058                (F3.0) /
 DXCCSR_NEO059                (F3.0) /
 DXCCSR_NEO060                (F3.0) /
 DXCCSR_NEO061                (F3.0) /
 DXCCSR_NEO062                (F3.0) /
 DXCCSR_NEO063                (F3.0) /
 DXCCSR_NEO064                (F3.0) /
 DXCCSR_NEO065                (F3.0) /
 DXCCSR_NEO066                (F3.0) /
 DXCCSR_NEO067                (F3.0) /
 DXCCSR_NEO068                (F3.0) /
 DXCCSR_NEO069                (F3.0) /
 DXCCSR_NEO070                (F3.0) /
 DXCCSR_NEO071                (F3.0) /
 DXCCSR_NEO072                (F3.0) /
 DXCCSR_NEO073                (F3.0) /
 DXCCSR_NEO074                (F3.0) /
 DXCCSR_NVS001                (F3.0) /
 DXCCSR_NVS002                (F3.0) /
 DXCCSR_NVS003                (F3.0) /
 DXCCSR_NVS004                (F3.0) /
 DXCCSR_NVS005                (F3.0) /
 DXCCSR_NVS006                (F3.0) /
 DXCCSR_NVS007                (F3.0) /
 DXCCSR_NVS008                (F3.0) /
 DXCCSR_NVS009                (F3.0) /
 DXCCSR_NVS010                (F3.0) /
 DXCCSR_NVS011                (F3.0) /
 DXCCSR_NVS012                (F3.0) /
 DXCCSR_NVS013                (F3.0) /
 DXCCSR_NVS014                (F3.0) /
 DXCCSR_NVS015                (F3.0) /
 DXCCSR_NVS016                (F3.0) /
 DXCCSR_NVS017                (F3.0) /
 DXCCSR_NVS018                (F3.0) /
 DXCCSR_NVS019                (F3.0) /
 DXCCSR_NVS020                (F3.0) /
 DXCCSR_NVS021                (F3.0) /
 DXCCSR_NVS022                (F3.0) /
 DXCCSR_PNL001                (F3.0) /
 DXCCSR_PNL002                (F3.0) /
 DXCCSR_PNL003                (F3.0) /
 DXCCSR_PNL004                (F3.0) /
 DXCCSR_PNL005                (F3.0) /
 DXCCSR_PNL006                (F3.0) /
 DXCCSR_PNL007                (F3.0) /
 DXCCSR_PNL008                (F3.0) /
 DXCCSR_PNL009                (F3.0) /
 DXCCSR_PNL010                (F3.0) /
 DXCCSR_PNL011                (F3.0) /
 DXCCSR_PNL012                (F3.0) /
 DXCCSR_PNL013                (F3.0) /
 DXCCSR_PNL014                (F3.0) /
 DXCCSR_PNL015                (F3.0) /
 DXCCSR_PRG001                (F3.0) /
 DXCCSR_PRG002                (F3.0) /
 DXCCSR_PRG003                (F3.0) /
 DXCCSR_PRG004                (F3.0) /
 DXCCSR_PRG005                (F3.0) /
 DXCCSR_PRG006                (F3.0) /
 DXCCSR_PRG007                (F3.0) /
 DXCCSR_PRG008                (F3.0) /
 DXCCSR_PRG009                (F3.0) /
 DXCCSR_PRG010                (F3.0) /
 DXCCSR_PRG011                (F3.0) /
 DXCCSR_PRG012                (F3.0) /
 DXCCSR_PRG013                (F3.0) /
 DXCCSR_PRG014                (F3.0) /
 DXCCSR_PRG015                (F3.0) /
 DXCCSR_PRG016                (F3.0) /
 DXCCSR_PRG017                (F3.0) /
 DXCCSR_PRG018                (F3.0) /
 DXCCSR_PRG019                (F3.0) /
 DXCCSR_PRG020                (F3.0) /
 DXCCSR_PRG021                (F3.0) /
 DXCCSR_PRG022                (F3.0) /
 DXCCSR_PRG023                (F3.0) /
 DXCCSR_PRG024                (F3.0) /
 DXCCSR_PRG025                (F3.0) /
 DXCCSR_PRG026                (F3.0) /
 DXCCSR_PRG027                (F3.0) /
 DXCCSR_PRG028                (F3.0) /
 DXCCSR_PRG029                (F3.0) /
 DXCCSR_PRG030                (F3.0) /
 DXCCSR_RSP001                (F3.0) /
 DXCCSR_RSP002                (F3.0) /
 DXCCSR_RSP003                (F3.0) /
 DXCCSR_RSP004                (F3.0) /
 DXCCSR_RSP005                (F3.0) /
 DXCCSR_RSP006                (F3.0) /
 DXCCSR_RSP007                (F3.0) /
 DXCCSR_RSP008                (F3.0) /
 DXCCSR_RSP009                (F3.0) /
 DXCCSR_RSP010                (F3.0) /
 DXCCSR_RSP011                (F3.0) /
 DXCCSR_RSP012                (F3.0) /
 DXCCSR_RSP013                (F3.0) /
 DXCCSR_RSP014                (F3.0) /
 DXCCSR_RSP015                (F3.0) /
 DXCCSR_RSP016                (F3.0) /
 DXCCSR_RSP017                (F3.0) /
 DXCCSR_SKN001                (F3.0) /
 DXCCSR_SKN002                (F3.0) /
 DXCCSR_SKN003                (F3.0) /
 DXCCSR_SKN004                (F3.0) /
 DXCCSR_SKN005                (F3.0) /
 DXCCSR_SKN006                (F3.0) /
 DXCCSR_SKN007                (F3.0) /
 DXCCSR_SYM001                (F3.0) /
 DXCCSR_SYM002                (F3.0) /
 DXCCSR_SYM003                (F3.0) /
 DXCCSR_SYM004                (F3.0) /
 DXCCSR_SYM005                (F3.0) /
 DXCCSR_SYM006                (F3.0) /
 DXCCSR_SYM007                (F3.0) /
 DXCCSR_SYM008                (F3.0) /
 DXCCSR_SYM009                (F3.0) /
 DXCCSR_SYM010                (F3.0) /
 DXCCSR_SYM011                (F3.0) /
 DXCCSR_SYM012                (F3.0) /
 DXCCSR_SYM013                (F3.0) /
 DXCCSR_SYM014                (F3.0) /
 DXCCSR_SYM015                (F3.0) /
 DXCCSR_SYM016                (F3.0) /
 DXCCSR_SYM017                (F3.0) /
.


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 CCIR_VERSION                 "Version of Chronic Condition Indicator Refined for ICD-10-CM"
 CCIR1                        "ICD-10-CM Chronic Condition Indicator Refined 1"
 CCIR2                        "ICD-10-CM Chronic Condition Indicator Refined 2"
 CCIR3                        "ICD-10-CM Chronic Condition Indicator Refined 3"
 CCIR4                        "ICD-10-CM Chronic Condition Indicator Refined 4"
 CCIR5                        "ICD-10-CM Chronic Condition Indicator Refined 5"
 CCIR6                        "ICD-10-CM Chronic Condition Indicator Refined 6"
 CCIR7                        "ICD-10-CM Chronic Condition Indicator Refined 7"
 CCIR8                        "ICD-10-CM Chronic Condition Indicator Refined 8"
 CCIR9                        "ICD-10-CM Chronic Condition Indicator Refined 9"
 CCIR10                       "ICD-10-CM Chronic Condition Indicator Refined 10"
 CCIR11                       "ICD-10-CM Chronic Condition Indicator Refined 11"
 CCIR12                       "ICD-10-CM Chronic Condition Indicator Refined 12"
 CCIR13                       "ICD-10-CM Chronic Condition Indicator Refined 13"
 CCIR14                       "ICD-10-CM Chronic Condition Indicator Refined 14"
 CCIR15                       "ICD-10-CM Chronic Condition Indicator Refined 15"
 CCIR16                       "ICD-10-CM Chronic Condition Indicator Refined 16"
 CCIR17                       "ICD-10-CM Chronic Condition Indicator Refined 17"
 CCIR18                       "ICD-10-CM Chronic Condition Indicator Refined 18"
 CCIR19                       "ICD-10-CM Chronic Condition Indicator Refined 19"
 CCIR20                       "ICD-10-CM Chronic Condition Indicator Refined 20"
 CCIR21                       "ICD-10-CM Chronic Condition Indicator Refined 21"
 CCIR22                       "ICD-10-CM Chronic Condition Indicator Refined 22"
 CCIR23                       "ICD-10-CM Chronic Condition Indicator Refined 23"
 CCIR24                       "ICD-10-CM Chronic Condition Indicator Refined 24"
 CCIR25                       "ICD-10-CM Chronic Condition Indicator Refined 25"
 CCIR26                       "ICD-10-CM Chronic Condition Indicator Refined 26"
 CCIR27                       "ICD-10-CM Chronic Condition Indicator Refined 27"
 CCIR28                       "ICD-10-CM Chronic Condition Indicator Refined 28"
 CCIR29                       "ICD-10-CM Chronic Condition Indicator Refined 29"
 CCIR30                       "ICD-10-CM Chronic Condition Indicator Refined 30"
 CCIR31                       "ICD-10-CM Chronic Condition Indicator Refined 31"
 CCIR32                       "ICD-10-CM Chronic Condition Indicator Refined 32"
 CCIR33                       "ICD-10-CM Chronic Condition Indicator Refined 33"
 CCIR34                       "ICD-10-CM Chronic Condition Indicator Refined 34"
 CCIR35                       "ICD-10-CM Chronic Condition Indicator Refined 35"
 CCIR36                       "ICD-10-CM Chronic Condition Indicator Refined 36"
 CCIR37                       "ICD-10-CM Chronic Condition Indicator Refined 37"
 CCIR38                       "ICD-10-CM Chronic Condition Indicator Refined 38"
 CCIR39                       "ICD-10-CM Chronic Condition Indicator Refined 39"
 CCIR40                       "ICD-10-CM Chronic Condition Indicator Refined 40"
 CCIR41                       "ICD-10-CM Chronic Condition Indicator Refined 41"
 CMR_AIDS                     "Acquired immune deficiency syndrome"
 CMR_ALCOHOL                  "Alcohol abuse"
 CMR_ANEMDEF                  "Anemias due to other nutritional deficiencies"
 CMR_AUTOIMMUNE               "Autoimmune conditions"
 CMR_BLDLOSS                  "Chronic blood loss anemia (iron deficiency)"
 CMR_CANCER_LEUK              "Leukemia"
 CMR_CANCER_LYMPH             "Lymphoma"
 CMR_CANCER_METS              "Metastatic cancer"
 CMR_CANCER_NSITU             "Solid tumor without metastasis, in situ"
 CMR_CANCER_SOLID             "Solid tumor without metastasis, malignant"
 CMR_CBVD                     "Cerebrovascular disease"
 CMR_COAG                     "Coagulopathy"
 CMR_DEMENTIA                 "Dementia"
 CMR_DEPRESS                  "Depression"
 CMR_DIAB_CX                  "Diabetes with chronic complications"
 CMR_DIAB_UNCX                "Diabetes without chronic complications"
 CMR_DRUG_ABUSE               "Drug abuse"
 CMR_HF                       "Heart failure"
 CMR_HTN_CX                   "Hypertension, complicated"
 CMR_HTN_UNCX                 "Hypertension, uncomplicated"
 CMR_LIVER_MLD                "Liver disease, mild"
 CMR_LIVER_SEV                "Liver disease, moderate to severe"
 CMR_LUNG_CHRONIC             "Chronic pulmonary disease"
 CMR_NEURO_MOVT               "Neurological disorders affecting movement"
 CMR_NEURO_OTH                "Other neurological disorders"
 CMR_NEURO_SEIZ               "Seizures and epilepsy"
 CMR_OBESE                    "Obesity"
 CMR_PARALYSIS                "Paralysis"
 CMR_PERIVASC                 "Peripheral vascular disease"
 CMR_PSYCHOSES                "Psychoses"
 CMR_PULMCIRC                 "Pulmonary circulation disease"
 CMR_RENLFL_MOD               "Renal failure, moderate"
 CMR_RENLFL_SEV               "Renal failure, severe"
 CMR_THYROID_HYPO             "Hypothyroidism"
 CMR_THYROID_OTH              "Other thyroid disorders"
 CMR_ULCER_PEPTIC             "Peptic ulcer disease x bleeding"
 CMR_VALVE                    "Valvular disease"
 CMR_VERSION                  "Version of Elixhauser Comorbidity Software Refined"
 CMR_WGHTLOSS                 "Weight loss"
 I10_INJURY

"Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)
"
 I10_INJURY_CUT               "Mechanism of injury: cut or pierce"
 I10_INJURY_DROWN             "Mechanism of injury: drowning or submersion"
 I10_INJURY_FALL              "Mechanism of injury: fall"
 I10_INJURY_FIRE              "Mechanism of injury: fire, flame, hot object, or hot substance"
 I10_INJURY_FIREARM           "Mechanism of injury: firearm"
 I10_INJURY_MACHINERY         "Mechanism of injury: machinery"
 I10_INJURY_MVT

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, o
ther, or unspecified"
 I10_INJURY_NATURE
"Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"
 I10_INJURY_OVEREXERTION      "Mechanism of injury: overexertion"
 I10_INJURY_POISON            "Mechanism of injury: poisoning, including drugs and nondrugs"
 I10_INJURY_STRUCK            "Mechanism of injury: struck by or against"
 I10_INJURY_SUFFOCATION       "Mechanism of injury: suffocation"
 I10_INTENT_ASSAULT           "Intent of injury: assault"
 I10_INTENT_SELF_HARM         "Intent of injury: intentional self-harm"
 I10_INTENT_UNINTENTIONAL     "Intent of injury: unintentional"
 I10_MULTINJURY               "Multiple ICD-10-CM injuries reported on record"
 KEY                          "HCUP record identifier"
 DXCCSR_Default_DX1           "Default CCSR for principal/first-listed ICD-10-CM diagnosis"
 DXCCSR_BLD001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001"
 DXCCSR_BLD002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002"
 DXCCSR_BLD003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003"
 DXCCSR_BLD004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004"
 DXCCSR_BLD005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005"
 DXCCSR_BLD006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006"
 DXCCSR_BLD007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007"
 DXCCSR_BLD008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008"
 DXCCSR_BLD009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009"
 DXCCSR_BLD010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010"
 DXCCSR_CIR001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001"
 DXCCSR_CIR002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002"
 DXCCSR_CIR003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003"
 DXCCSR_CIR004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004"
 DXCCSR_CIR005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005"
 DXCCSR_CIR006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006"
 DXCCSR_CIR007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007"
 DXCCSR_CIR008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008"
 DXCCSR_CIR009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009"
 DXCCSR_CIR010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010"
 DXCCSR_CIR011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011"
 DXCCSR_CIR012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012"
 DXCCSR_CIR013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013"
 DXCCSR_CIR014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014"
 DXCCSR_CIR015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015"
 DXCCSR_CIR016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016"
 DXCCSR_CIR017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017"
 DXCCSR_CIR018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018"
 DXCCSR_CIR019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019"
 DXCCSR_CIR020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020"
 DXCCSR_CIR021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021"
 DXCCSR_CIR022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022"
 DXCCSR_CIR023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023"
 DXCCSR_CIR024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024"
 DXCCSR_CIR025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025"
 DXCCSR_CIR026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026"
 DXCCSR_CIR027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027"
 DXCCSR_CIR028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028"
 DXCCSR_CIR029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029"
 DXCCSR_CIR030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030"
 DXCCSR_CIR031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031"
 DXCCSR_CIR032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032"
 DXCCSR_CIR033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033"
 DXCCSR_CIR034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034"
 DXCCSR_CIR035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035"
 DXCCSR_CIR036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036"
 DXCCSR_CIR037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037"
 DXCCSR_CIR038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038"
 DXCCSR_CIR039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039"
 DXCCSR_DEN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN001"
 DXCCSR_DEN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN002"
 DXCCSR_DEN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN003"
 DXCCSR_DIG001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001"
 DXCCSR_DIG002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002"
 DXCCSR_DIG003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003"
 DXCCSR_DIG004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004"
 DXCCSR_DIG005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005"
 DXCCSR_DIG006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006"
 DXCCSR_DIG007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007"
 DXCCSR_DIG008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008"
 DXCCSR_DIG009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009"
 DXCCSR_DIG010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010"
 DXCCSR_DIG011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011"
 DXCCSR_DIG012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012"
 DXCCSR_DIG013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013"
 DXCCSR_DIG014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014"
 DXCCSR_DIG015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015"
 DXCCSR_DIG016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016"
 DXCCSR_DIG017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017"
 DXCCSR_DIG018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018"
 DXCCSR_DIG019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019"
 DXCCSR_DIG020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020"
 DXCCSR_DIG021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021"
 DXCCSR_DIG022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022"
 DXCCSR_DIG023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023"
 DXCCSR_DIG024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024"
 DXCCSR_DIG025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025"
 DXCCSR_EAR001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001"
 DXCCSR_EAR002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002"
 DXCCSR_EAR003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003"
 DXCCSR_EAR004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004"
 DXCCSR_EAR005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005"
 DXCCSR_EAR006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006"
 DXCCSR_END001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001"
 DXCCSR_END002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002"
 DXCCSR_END003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003"
 DXCCSR_END004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004"
 DXCCSR_END005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005"
 DXCCSR_END006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006"
 DXCCSR_END007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007"
 DXCCSR_END008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008"
 DXCCSR_END009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009"
 DXCCSR_END010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010"
 DXCCSR_END011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011"
 DXCCSR_END012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012"
 DXCCSR_END013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013"
 DXCCSR_END014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014"
 DXCCSR_END015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015"
 DXCCSR_END016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016"
 DXCCSR_END017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017"
 DXCCSR_EXT001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001"
 DXCCSR_EXT002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002"
 DXCCSR_EXT003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003"
 DXCCSR_EXT004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004"
 DXCCSR_EXT005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005"
 DXCCSR_EXT006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006"
 DXCCSR_EXT007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007"
 DXCCSR_EXT008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008"
 DXCCSR_EXT009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009"
 DXCCSR_EXT010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010"
 DXCCSR_EXT011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011"
 DXCCSR_EXT012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012"
 DXCCSR_EXT013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013"
 DXCCSR_EXT014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014"
 DXCCSR_EXT015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015"
 DXCCSR_EXT016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016"
 DXCCSR_EXT017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017"
 DXCCSR_EXT018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018"
 DXCCSR_EXT019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019"
 DXCCSR_EXT020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020"
 DXCCSR_EXT021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021"
 DXCCSR_EXT022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022"
 DXCCSR_EXT023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023"
 DXCCSR_EXT024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024"
 DXCCSR_EXT025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025"
 DXCCSR_EXT026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026"
 DXCCSR_EXT027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027"
 DXCCSR_EXT028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028"
 DXCCSR_EXT029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029"
 DXCCSR_EXT030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030"
 DXCCSR_EYE001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001"
 DXCCSR_EYE002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002"
 DXCCSR_EYE003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003"
 DXCCSR_EYE004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004"
 DXCCSR_EYE005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005"
 DXCCSR_EYE006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006"
 DXCCSR_EYE007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007"
 DXCCSR_EYE008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008"
 DXCCSR_EYE009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009"
 DXCCSR_EYE010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010"
 DXCCSR_EYE011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011"
 DXCCSR_EYE012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012"
 DXCCSR_FAC001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001"
 DXCCSR_FAC002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002"
 DXCCSR_FAC003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003"
 DXCCSR_FAC004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004"
 DXCCSR_FAC005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005"
 DXCCSR_FAC006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006"
 DXCCSR_FAC007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007"
 DXCCSR_FAC008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008"
 DXCCSR_FAC009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009"
 DXCCSR_FAC010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010"
 DXCCSR_FAC011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011"
 DXCCSR_FAC012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012"
 DXCCSR_FAC013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013"
 DXCCSR_FAC014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014"
 DXCCSR_FAC015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015"
 DXCCSR_FAC016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016"
 DXCCSR_FAC017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017"
 DXCCSR_FAC018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018"
 DXCCSR_FAC019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019"
 DXCCSR_FAC020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020"
 DXCCSR_FAC021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021"
 DXCCSR_FAC022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022"
 DXCCSR_FAC023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023"
 DXCCSR_FAC024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024"
 DXCCSR_FAC025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025"
 DXCCSR_GEN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001"
 DXCCSR_GEN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002"
 DXCCSR_GEN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003"
 DXCCSR_GEN004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004"
 DXCCSR_GEN005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005"
 DXCCSR_GEN006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006"
 DXCCSR_GEN007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007"
 DXCCSR_GEN008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008"
 DXCCSR_GEN009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009"
 DXCCSR_GEN010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010"
 DXCCSR_GEN011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011"
 DXCCSR_GEN012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012"
 DXCCSR_GEN013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013"
 DXCCSR_GEN014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014"
 DXCCSR_GEN015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015"
 DXCCSR_GEN016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016"
 DXCCSR_GEN017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017"
 DXCCSR_GEN018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018"
 DXCCSR_GEN019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019"
 DXCCSR_GEN020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020"
 DXCCSR_GEN021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021"
 DXCCSR_GEN022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022"
 DXCCSR_GEN023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023"
 DXCCSR_GEN024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024"
 DXCCSR_GEN025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025"
 DXCCSR_GEN026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026"
 DXCCSR_INF001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001"
 DXCCSR_INF002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002"
 DXCCSR_INF003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003"
 DXCCSR_INF004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004"
 DXCCSR_INF005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005"
 DXCCSR_INF006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006"
 DXCCSR_INF007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007"
 DXCCSR_INF008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008"
 DXCCSR_INF009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009"
 DXCCSR_INF010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010"
 DXCCSR_INF011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011"
 DXCCSR_INF012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012"
 DXCCSR_INJ001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001"
 DXCCSR_INJ002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002"
 DXCCSR_INJ003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003"
 DXCCSR_INJ004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004"
 DXCCSR_INJ005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005"
 DXCCSR_INJ006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006"
 DXCCSR_INJ007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007"
 DXCCSR_INJ008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008"
 DXCCSR_INJ009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009"
 DXCCSR_INJ010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010"
 DXCCSR_INJ011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011"
 DXCCSR_INJ012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012"
 DXCCSR_INJ013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013"
 DXCCSR_INJ014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014"
 DXCCSR_INJ015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015"
 DXCCSR_INJ016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016"
 DXCCSR_INJ017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017"
 DXCCSR_INJ018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018"
 DXCCSR_INJ019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019"
 DXCCSR_INJ020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020"
 DXCCSR_INJ021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021"
 DXCCSR_INJ022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022"
 DXCCSR_INJ023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023"
 DXCCSR_INJ024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024"
 DXCCSR_INJ025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025"
 DXCCSR_INJ026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026"
 DXCCSR_INJ027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027"
 DXCCSR_INJ028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028"
 DXCCSR_INJ029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029"
 DXCCSR_INJ030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030"
 DXCCSR_INJ031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031"
 DXCCSR_INJ032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032"
 DXCCSR_INJ033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033"
 DXCCSR_INJ034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034"
 DXCCSR_INJ035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035"
 DXCCSR_INJ036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036"
 DXCCSR_INJ037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037"
 DXCCSR_INJ038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038"
 DXCCSR_INJ039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039"
 DXCCSR_INJ040
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040"
 DXCCSR_INJ041
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041"
 DXCCSR_INJ042
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042"
 DXCCSR_INJ043
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043"
 DXCCSR_INJ044
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044"
 DXCCSR_INJ045
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045"
 DXCCSR_INJ046
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046"
 DXCCSR_INJ047
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047"
 DXCCSR_INJ048
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048"
 DXCCSR_INJ049
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049"
 DXCCSR_INJ050
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050"
 DXCCSR_INJ051
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051"
 DXCCSR_INJ052
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052"
 DXCCSR_INJ053
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053"
 DXCCSR_INJ054
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054"
 DXCCSR_INJ055
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055"
 DXCCSR_INJ056
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056"
 DXCCSR_INJ057
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057"
 DXCCSR_INJ058
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058"
 DXCCSR_INJ059
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059"
 DXCCSR_INJ060
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060"
 DXCCSR_INJ061
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061"
 DXCCSR_INJ062
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062"
 DXCCSR_INJ063
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063"
 DXCCSR_INJ064
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064"
 DXCCSR_INJ065
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065"
 DXCCSR_INJ066
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066"
 DXCCSR_INJ067
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067"
 DXCCSR_INJ068
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068"
 DXCCSR_INJ069
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069"
 DXCCSR_INJ070
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070"
 DXCCSR_INJ071
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071"
 DXCCSR_INJ072
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072"
 DXCCSR_INJ073
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073"
 DXCCSR_INJ074
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074"
 DXCCSR_INJ075
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075"
 DXCCSR_INJ076
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076"
 DXCCSR_MAL001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001"
 DXCCSR_MAL002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002"
 DXCCSR_MAL003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003"
 DXCCSR_MAL004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004"
 DXCCSR_MAL005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005"
 DXCCSR_MAL006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006"
 DXCCSR_MAL007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007"
 DXCCSR_MAL008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008"
 DXCCSR_MAL009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009"
 DXCCSR_MAL010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010"
 DXCCSR_MBD001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001"
 DXCCSR_MBD002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002"
 DXCCSR_MBD003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003"
 DXCCSR_MBD004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004"
 DXCCSR_MBD005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005"
 DXCCSR_MBD006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006"
 DXCCSR_MBD007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007"
 DXCCSR_MBD008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008"
 DXCCSR_MBD009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009"
 DXCCSR_MBD010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010"
 DXCCSR_MBD011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011"
 DXCCSR_MBD012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012"
 DXCCSR_MBD013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013"
 DXCCSR_MBD014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014"
 DXCCSR_MBD017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017"
 DXCCSR_MBD018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018"
 DXCCSR_MBD019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019"
 DXCCSR_MBD020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020"
 DXCCSR_MBD021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021"
 DXCCSR_MBD022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022"
 DXCCSR_MBD023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023"
 DXCCSR_MBD024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024"
 DXCCSR_MBD025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025"
 DXCCSR_MBD026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026"
 DXCCSR_MBD027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027"
 DXCCSR_MBD028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028"
 DXCCSR_MBD029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029"
 DXCCSR_MBD030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030"
 DXCCSR_MBD031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031"
 DXCCSR_MBD032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032"
 DXCCSR_MBD033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033"
 DXCCSR_MBD034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034"
 DXCCSR_MUS001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001"
 DXCCSR_MUS002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002"
 DXCCSR_MUS003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003"
 DXCCSR_MUS004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004"
 DXCCSR_MUS005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005"
 DXCCSR_MUS006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006"
 DXCCSR_MUS007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007"
 DXCCSR_MUS008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008"
 DXCCSR_MUS009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009"
 DXCCSR_MUS010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010"
 DXCCSR_MUS011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011"
 DXCCSR_MUS012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012"
 DXCCSR_MUS013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013"
 DXCCSR_MUS014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014"
 DXCCSR_MUS015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015"
 DXCCSR_MUS016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016"
 DXCCSR_MUS017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017"
 DXCCSR_MUS018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018"
 DXCCSR_MUS019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019"
 DXCCSR_MUS020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020"
 DXCCSR_MUS021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021"
 DXCCSR_MUS022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022"
 DXCCSR_MUS023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023"
 DXCCSR_MUS024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024"
 DXCCSR_MUS025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025"
 DXCCSR_MUS026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026"
 DXCCSR_MUS027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027"
 DXCCSR_MUS028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028"
 DXCCSR_MUS029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029"
 DXCCSR_MUS030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030"
 DXCCSR_MUS031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031"
 DXCCSR_MUS032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032"
 DXCCSR_MUS033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033"
 DXCCSR_MUS034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034"
 DXCCSR_MUS035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035"
 DXCCSR_MUS036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036"
 DXCCSR_MUS037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037"
 DXCCSR_MUS038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038"
 DXCCSR_NEO001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001"
 DXCCSR_NEO002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002"
 DXCCSR_NEO003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003"
 DXCCSR_NEO004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004"
 DXCCSR_NEO005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005"
 DXCCSR_NEO006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006"
 DXCCSR_NEO007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007"
 DXCCSR_NEO008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008"
 DXCCSR_NEO009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009"
 DXCCSR_NEO010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010"
 DXCCSR_NEO011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011"
 DXCCSR_NEO012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012"
 DXCCSR_NEO013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013"
 DXCCSR_NEO014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014"
 DXCCSR_NEO015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015"
 DXCCSR_NEO016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016"
 DXCCSR_NEO017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017"
 DXCCSR_NEO018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018"
 DXCCSR_NEO019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019"
 DXCCSR_NEO020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020"
 DXCCSR_NEO021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021"
 DXCCSR_NEO022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022"
 DXCCSR_NEO023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023"
 DXCCSR_NEO024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024"
 DXCCSR_NEO025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025"
 DXCCSR_NEO026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026"
 DXCCSR_NEO027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027"
 DXCCSR_NEO028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028"
 DXCCSR_NEO029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029"
 DXCCSR_NEO030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030"
 DXCCSR_NEO031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031"
 DXCCSR_NEO032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032"
 DXCCSR_NEO033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033"
 DXCCSR_NEO034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034"
 DXCCSR_NEO035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035"
 DXCCSR_NEO036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036"
 DXCCSR_NEO037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037"
 DXCCSR_NEO038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038"
 DXCCSR_NEO039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039"
 DXCCSR_NEO040
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040"
 DXCCSR_NEO041
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041"
 DXCCSR_NEO042
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042"
 DXCCSR_NEO043
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043"
 DXCCSR_NEO044
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044"
 DXCCSR_NEO045
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045"
 DXCCSR_NEO046
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046"
 DXCCSR_NEO047
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047"
 DXCCSR_NEO048
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048"
 DXCCSR_NEO049
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049"
 DXCCSR_NEO050
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050"
 DXCCSR_NEO051
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051"
 DXCCSR_NEO052
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052"
 DXCCSR_NEO053
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053"
 DXCCSR_NEO054
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054"
 DXCCSR_NEO055
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055"
 DXCCSR_NEO056
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056"
 DXCCSR_NEO057
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057"
 DXCCSR_NEO058
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058"
 DXCCSR_NEO059
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059"
 DXCCSR_NEO060
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060"
 DXCCSR_NEO061
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061"
 DXCCSR_NEO062
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062"
 DXCCSR_NEO063
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063"
 DXCCSR_NEO064
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064"
 DXCCSR_NEO065
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065"
 DXCCSR_NEO066
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066"
 DXCCSR_NEO067
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067"
 DXCCSR_NEO068
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068"
 DXCCSR_NEO069
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069"
 DXCCSR_NEO070
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070"
 DXCCSR_NEO071
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071"
 DXCCSR_NEO072
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072"
 DXCCSR_NEO073
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073"
 DXCCSR_NEO074
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074"
 DXCCSR_NVS001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001"
 DXCCSR_NVS002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002"
 DXCCSR_NVS003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003"
 DXCCSR_NVS004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004"
 DXCCSR_NVS005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005"
 DXCCSR_NVS006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006"
 DXCCSR_NVS007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007"
 DXCCSR_NVS008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008"
 DXCCSR_NVS009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009"
 DXCCSR_NVS010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010"
 DXCCSR_NVS011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011"
 DXCCSR_NVS012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012"
 DXCCSR_NVS013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013"
 DXCCSR_NVS014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014"
 DXCCSR_NVS015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015"
 DXCCSR_NVS016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016"
 DXCCSR_NVS017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017"
 DXCCSR_NVS018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018"
 DXCCSR_NVS019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019"
 DXCCSR_NVS020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020"
 DXCCSR_NVS021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021"
 DXCCSR_NVS022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022"
 DXCCSR_PNL001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001"
 DXCCSR_PNL002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002"
 DXCCSR_PNL003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003"
 DXCCSR_PNL004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004"
 DXCCSR_PNL005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005"
 DXCCSR_PNL006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006"
 DXCCSR_PNL007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007"
 DXCCSR_PNL008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008"
 DXCCSR_PNL009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009"
 DXCCSR_PNL010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010"
 DXCCSR_PNL011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011"
 DXCCSR_PNL012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012"
 DXCCSR_PNL013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013"
 DXCCSR_PNL014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014"
 DXCCSR_PNL015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015"
 DXCCSR_PRG001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001"
 DXCCSR_PRG002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002"
 DXCCSR_PRG003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003"
 DXCCSR_PRG004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004"
 DXCCSR_PRG005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005"
 DXCCSR_PRG006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006"
 DXCCSR_PRG007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007"
 DXCCSR_PRG008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008"
 DXCCSR_PRG009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009"
 DXCCSR_PRG010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010"
 DXCCSR_PRG011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011"
 DXCCSR_PRG012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012"
 DXCCSR_PRG013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013"
 DXCCSR_PRG014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014"
 DXCCSR_PRG015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015"
 DXCCSR_PRG016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016"
 DXCCSR_PRG017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017"
 DXCCSR_PRG018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018"
 DXCCSR_PRG019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019"
 DXCCSR_PRG020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020"
 DXCCSR_PRG021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021"
 DXCCSR_PRG022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022"
 DXCCSR_PRG023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023"
 DXCCSR_PRG024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024"
 DXCCSR_PRG025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025"
 DXCCSR_PRG026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026"
 DXCCSR_PRG027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027"
 DXCCSR_PRG028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028"
 DXCCSR_PRG029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029"
 DXCCSR_PRG030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030"
 DXCCSR_RSP001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001"
 DXCCSR_RSP002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002"
 DXCCSR_RSP003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003"
 DXCCSR_RSP004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004"
 DXCCSR_RSP005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005"
 DXCCSR_RSP006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006"
 DXCCSR_RSP007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007"
 DXCCSR_RSP008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008"
 DXCCSR_RSP009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009"
 DXCCSR_RSP010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010"
 DXCCSR_RSP011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011"
 DXCCSR_RSP012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012"
 DXCCSR_RSP013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013"
 DXCCSR_RSP014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014"
 DXCCSR_RSP015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015"
 DXCCSR_RSP016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016"
 DXCCSR_RSP017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017"
 DXCCSR_SKN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001"
 DXCCSR_SKN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002"
 DXCCSR_SKN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003"
 DXCCSR_SKN004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004"
 DXCCSR_SKN005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005"
 DXCCSR_SKN006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006"
 DXCCSR_SKN007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007"
 DXCCSR_SYM001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001"
 DXCCSR_SYM002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002"
 DXCCSR_SYM003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003"
 DXCCSR_SYM004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004"
 DXCCSR_SYM005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005"
 DXCCSR_SYM006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006"
 DXCCSR_SYM007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007"
 DXCCSR_SYM008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008"
 DXCCSR_SYM009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009"
 DXCCSR_SYM010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010"
 DXCCSR_SYM011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011"
 DXCCSR_SYM012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012"
 DXCCSR_SYM013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013"
 DXCCSR_SYM014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014"
 DXCCSR_SYM015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015"
 DXCCSR_SYM016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016"
 DXCCSR_SYM017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017"
 DXCCSR_VERSION               "Version of CCSR for ICD-10-CM diagnoses" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE CCIR1
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR2
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR3
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR4
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR5
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR6
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR7
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR8
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR9
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR10
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR11
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR12
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR13
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR14
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR15
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR16
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR17
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR18
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR19
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR20
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR21
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR22
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR23
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR24
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR25
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR26
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR27
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR28
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR29
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR30
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR31
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR32
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR33
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR34
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR35
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR36
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR37
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR38
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR39
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR40
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR41
 (-99,-88,-66,-55=SYSMIS).
RECODE CMR_AIDS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ALCOHOL
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ANEMDEF
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_AUTOIMMUNE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_BLDLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_LEUK
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_NSITU
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_SOLID
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CBVD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DEMENTIA
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DEPRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DIAB_CX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DIAB_UNCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DRUG_ABUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HF
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HTN_CX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HTN_UNCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LIVER_MLD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LIVER_SEV
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LUNG_CHRONIC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_MOVT
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_OTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_SEIZ
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_OBESE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PARALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PERIVASC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PSYCHOSES
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PULMCIRC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_RENLFL_MOD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_RENLFL_SEV
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_THYROID_HYPO
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_THYROID_OTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ULCER_PEPTIC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_WGHTLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_OVEREXERTION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCSR_BLD001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ040
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ041
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ042
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ043
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ044
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ045
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ046
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ047
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ048
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ049
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ050
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ051
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ052
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ053
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ054
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ055
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ056
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ057
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ058
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ059
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ060
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ061
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ062
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ063
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ064
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ065
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ066
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ067
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ068
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ069
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ070
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ071
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ072
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ073
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ074
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ075
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ076
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO040
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO041
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO042
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO043
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO044
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO045
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO046
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO047
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO048
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO049
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO050
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO051
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO052
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO053
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO054
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO055
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO056
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO057
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO058
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO059
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO060
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO061
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO062
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO063
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO064
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO065
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO066
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO067
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO068
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO069
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO070
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO071
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO072
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO073
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO074
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM017
 (-99,-88,-66,-55=SYSMIS).



SAVE OUTFILE = 'WI_SASD_2023_DX_PR_GRPS.sav' /COMPRESSED.
