/*****************************************************************************
* Creation Date: 11/17/2016   
* UT_SASD_2014_CORE.Do
* This program will load the 2014 UT ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEDAY                       4-   6   ///
      int    AGEMONTH                     7-   9   ///
      byte   AMONTH                      10-  11   ///
      int    APG1                        12-  15   ///
      int    APG2                        16-  19   ///
      int    APG3                        20-  23   ///
      int    APG4                        24-  27   ///
      int    APG5                        28-  31   ///
      int    APG6                        32-  35   ///
      int    APGCAT1                     36-  38   ///
      int    APGCAT2                     39-  41   ///
      int    APGCAT3                     42-  44   ///
      int    APGCAT4                     45-  47   ///
      int    APGCAT5                     48-  50   ///
      int    APGCAT6                     51-  53   ///
      int    APGTYPE1                    54-  56   ///
      int    APGTYPE2                    57-  59   ///
      int    APGTYPE3                    60-  62   ///
      int    APGTYPE4                    63-  65   ///
      int    APGTYPE5                    66-  68   ///
      int    APGTYPE6                    69-  71   ///
      byte   AWEEKEND                    72-  73   ///
      str    CPT1                        74-  78   ///
      str    CPT2                        79-  83   ///
      str    CPT3                        84-  88   ///
      str    CPT4                        89-  93   ///
      str    CPT5                        94-  98   ///
      str    CPT6                        99- 103   ///
      int    CPTCCS1                    104- 106   ///
      int    CPTCCS2                    107- 109   ///
      int    CPTCCS3                    110- 112   ///
      int    CPTCCS4                    113- 115   ///
      int    CPTCCS5                    116- 118   ///
      int    CPTCCS6                    119- 121   ///
      str    CPTM1_1                    122- 123   ///
      str    CPTM1_2                    124- 125   ///
      str    CPTM1_3                    126- 127   ///
      str    CPTM1_4                    128- 129   ///
      str    CPTM1_5                    130- 131   ///
      str    CPTM1_6                    132- 133   ///
      str    CPTM2_1                    134- 135   ///
      str    CPTM2_2                    136- 137   ///
      str    CPTM2_3                    138- 139   ///
      str    CPTM2_4                    140- 141   ///
      str    CPTM2_5                    142- 143   ///
      str    CPTM2_6                    144- 145   ///
      byte   DIED                       146- 147   ///
      byte   DISPUB04                   148- 149   ///
      byte   DISPUNIFORM                150- 151   ///
      str    DISP_X                     152- 153   ///
      byte   DMONTH                     154- 155   ///
      byte   DQTR                       156- 157   ///
      str    DSHOSPID                   158- 174   ///
      str    DX1                        175- 181   ///
      str    DX2                        182- 188   ///
      str    DX3                        189- 195   ///
      str    DX4                        196- 202   ///
      str    DX5                        203- 209   ///
      str    DX6                        210- 216   ///
      str    DX7                        217- 223   ///
      str    DX8                        224- 230   ///
      str    DX9                        231- 237   ///
      int    DXCCS1                     238- 241   ///
      int    DXCCS2                     242- 245   ///
      int    DXCCS3                     246- 249   ///
      int    DXCCS4                     250- 253   ///
      int    DXCCS5                     254- 257   ///
      int    DXCCS6                     258- 261   ///
      int    DXCCS7                     262- 265   ///
      int    DXCCS8                     266- 269   ///
      int    DXCCS9                     270- 273   ///
      int    DXVER                      274- 276   ///
      long   DaysToEvent                277- 282   ///
      str    ECODE1                     283- 289   ///
      str    ECODE2                     290- 296   ///
      str    ECODE3                     297- 303   ///
      str    ECODE4                     304- 310   ///
      str    ECODE5                     311- 317   ///
      str    ECODE6                     318- 324   ///
      int    E_CCS1                     325- 328   ///
      int    E_CCS2                     329- 332   ///
      int    E_CCS3                     333- 336   ///
      int    E_CCS4                     337- 340   ///
      int    E_CCS5                     341- 344   ///
      int    E_CCS6                     345- 348   ///
      byte   FEMALE                     349- 350   ///
      byte   HCUP_ED                    351- 352   ///
      byte   HCUP_OS                    353- 354   ///
      int    HOSPBRTH                   355- 357   ///
      str    HOSPST                     358- 359   ///
      byte   Homeless                   360- 361   ///
      double KEY                        362- 376   ///
      long   LOS                        377- 381   ///
      long   LOS_X                      382- 387   ///
      long   MDNUM1_R                   388- 396   ///
      byte   MEDINCSTQ                  397- 398   ///
      int    NCHRONIC                   399- 401   ///
      int    NCPT                       402- 405   ///
      int    NDX                        406- 408   ///
      byte   NECODE                     409- 410   ///
      byte   NEOMAT                     411- 412   ///
      int    NPR                        413- 415   ///
      byte   ORPROC                     416- 417   ///
      byte   PAY1                       418- 419   ///
      str    PAY1_X                     420- 421   ///
      byte   PAY2                       422- 423   ///
      str    PAY2_X                     424- 425   ///
      byte   PAY3                       426- 427   ///
      str    PAY3_X                     428- 429   ///
      int    PL_CBSA                    430- 432   ///
      byte   PL_NCHS                    433- 434   ///
      byte   PL_RUCC                    435- 436   ///
      byte   PL_UIC                     437- 438   ///
      byte   PL_UR_CAT4                 439- 440   ///
      str    PR1                        441- 447   ///
      str    PR2                        448- 454   ///
      str    PR3                        455- 461   ///
      str    PR4                        462- 468   ///
      str    PR5                        469- 475   ///
      str    PR6                        476- 482   ///
      int    PRCCS1                     483- 485   ///
      int    PRCCS2                     486- 488   ///
      int    PRCCS3                     489- 491   ///
      int    PRCCS4                     492- 494   ///
      int    PRCCS5                     495- 497   ///
      int    PRCCS6                     498- 500   ///
      long   PRDAY1                     501- 505   ///
      int    PROCTYPE                   506- 508   ///
      int    PRVER                      509- 511   ///
      str    PSTATE                     512- 513   ///
      long   PSTCO                      514- 518   ///
      long   PSTCO2                     519- 523   ///
      str    PointOfOriginUB04          524        ///
      str    PointOfOrigin_X            525        ///
      byte   STATE_AS                   526- 527   ///
      byte   STATE_ED                   528- 529   ///
      byte   STATE_OS                   530- 531   ///
      double TOTCHG                     532- 541   ///
      double TOTCHG_X                   542- 556   ///
      long   VisitLink                  557- 565   ///
      int    YEAR                       566- 569   ///
      str    ZIP                        570- 574   ///
      str    ZIP3                       575- 577   ///
      int    ZIPINC_QRTL                578- 580   ///
      int    AYEAR                      581- 584   ///
      byte   BMONTH                     585- 586   ///
      int    BYEAR                      587- 590   ///
      byte   PRMONTH1                   591- 592   ///
      int    PRYEAR1                    593- 596   ///
      using  "UT_SASD_2014_CORE.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var APG1                     "Ambulatory Patient Group 1 (as received from source)"
label var APG2                     "Ambulatory Patient Group 2 (as received from source)"
label var APG3                     "Ambulatory Patient Group 3 (as received from source)"
label var APG4                     "Ambulatory Patient Group 4 (as received from source)"
label var APG5                     "Ambulatory Patient Group 5 (as received from source)"
label var APG6                     "Ambulatory Patient Group 6 (as received from source)"
label var APGCAT1                  "Ambulatory Patient Group Category 1 (as received from source)"
label var APGCAT2                  "Ambulatory Patient Group Category 2 (as received from source)"
label var APGCAT3                  "Ambulatory Patient Group Category 3 (as received from source)"
label var APGCAT4                  "Ambulatory Patient Group Category 4 (as received from source)"
label var APGCAT5                  "Ambulatory Patient Group Category 5 (as received from source)"
label var APGCAT6                  "Ambulatory Patient Group Category 6 (as received from source)"
label var APGTYPE1                 "Ambulatory Patient Group Type 1 (as received from source)"
label var APGTYPE2                 "Ambulatory Patient Group Type 1 (as received from source)"
label var APGTYPE3                 "Ambulatory Patient Group Type 1 (as received from source)"
label var APGTYPE4                 "Ambulatory Patient Group Type 1 (as received from source)"
label var APGTYPE5                 "Ambulatory Patient Group Type 1 (as received from source)"
label var APGTYPE6                 "Ambulatory Patient Group Type 1 (as received from source)"
label var AWEEKEND                 "Admission day is a weekend"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTM1_1                  "First CPT-4/HCPCS modifier 1"
label var CPTM1_2                  "First CPT-4/HCPCS modifier 2"
label var CPTM1_3                  "First CPT-4/HCPCS modifier 3"
label var CPTM1_4                  "First CPT-4/HCPCS modifier 4"
label var CPTM1_5                  "First CPT-4/HCPCS modifier 5"
label var CPTM1_6                  "First CPT-4/HCPCS modifier 6"
label var CPTM2_1                  "Second CPT-4/HCPCS modifier 1"
label var CPTM2_2                  "Second CPT-4/HCPCS modifier 2"
label var CPTM2_3                  "Second CPT-4/HCPCS modifier 3"
label var CPTM2_4                  "Second CPT-4/HCPCS modifier 4"
label var CPTM2_5                  "Second CPT-4/HCPCS modifier 5"
label var CPTM2_6                  "Second CPT-4/HCPCS modifier 6"
label var DIED                     "Died during hospitalization"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXVER                    "Diagnosis Version"
label var DaysToEvent              "Days from 'start date' to admission"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ECODE5                   "E code 5"
label var ECODE6                   "E code 6"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var E_CCS5                   "CCS: E Code 5"
label var E_CCS6                   "CCS: E Code 6"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPST                   "Hospital state postal code"
label var Homeless                 "Indicator that patient is homeless"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var NCHRONIC                 "Number of chronic conditions"
label var NCPT                     "Number of CPT/HCPCS procedures for this visit"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PAY3                     "Tertiary expected payer (uniform)"
label var PAY3_X                   "Tertiary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes(RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRDAY1                   "Number of days from admission to PR1"
label var PROCTYPE                 "Procedure type indicator"
label var PRVER                    "Procedure Version"
label var PSTATE                   "Patient State postal code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO2                   "Patient state/county FIPS code, possibly derived from ZIP Code"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var VisitLink                "Visit linkage variable"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRYEAR1                  "Year of procedure 1"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode APG1                      (-999 -888 -666=.)
recode APG2                      (-999 -888 -666=.)
recode APG3                      (-999 -888 -666=.)
recode APG4                      (-999 -888 -666=.)
recode APG5                      (-999 -888 -666=.)
recode APG6                      (-999 -888 -666=.)
recode APGCAT1                   (-99 -88 -66=.)
recode APGCAT2                   (-99 -88 -66=.)
recode APGCAT3                   (-99 -88 -66=.)
recode APGCAT4                   (-99 -88 -66=.)
recode APGCAT5                   (-99 -88 -66=.)
recode APGCAT6                   (-99 -88 -66=.)
recode APGTYPE1                  (-99 -88 -66=.)
recode APGTYPE2                  (-99 -88 -66=.)
recode APGTYPE3                  (-99 -88 -66=.)
recode APGTYPE4                  (-99 -88 -66=.)
recode APGTYPE5                  (-99 -88 -66=.)
recode APGTYPE6                  (-99 -88 -66=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXVER                     (-99 -88 -66=.)
recode DaysToEvent               (-99999 -88888 -66666=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode E_CCS5                    (-999 -888 -666=.)
recode E_CCS6                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HOSPBRTH                  (-99 -88 -66=.)
recode Homeless                  (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode NCHRONIC                  (-99 -88 -66=.)
recode NCPT                      (-999 -888 -666=.)
recode NDX                       (-99 -88 -66=.)
recode NECODE                    (-9 -8 -6 -5=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-99 -88 -66=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PAY3                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PROCTYPE                  (-99 -88 -66=.)
recode PRVER                     (-99 -88 -66=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO2                    (-9999 -8888 -6666=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode VisitLink                 (-99999999 -88888888 -66666666=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)

save "UT_SASD_2014_CORE.dta", replace
