/*******************************************************************
* Creation Date: 11/28/2017   
*   RI_SEDD_2015q4_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'RI_SEDD_2015q4_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_BODYSYSTEM1                 1-   2
 I10_BODYSYSTEM2                 3-   4
 I10_BODYSYSTEM3                 5-   6
 I10_BODYSYSTEM4                 7-   8
 I10_BODYSYSTEM5                 9-  10
 I10_BODYSYSTEM6                11-  12
 I10_BODYSYSTEM7                13-  14
 I10_BODYSYSTEM8                15-  16
 I10_BODYSYSTEM9                17-  18
 I10_BODYSYSTEM10               19-  20
 I10_BODYSYSTEM11               21-  22
 I10_CHRON1                     23-  24
 I10_CHRON2                     25-  26
 I10_CHRON3                     27-  28
 I10_CHRON4                     29-  30
 I10_CHRON5                     31-  32
 I10_CHRON6                     33-  34
 I10_CHRON7                     35-  36
 I10_CHRON8                     37-  38
 I10_CHRON9                     39-  40
 I10_CHRON10                    41-  42
 I10_CHRON11                    43-  44
 I10_DXMCCS1                    45-  55 (A)
 I10_DXMCCS2                    56-  66 (A)
 I10_DXMCCS3                    67-  77 (A)
 I10_DXMCCS4                    78-  88 (A)
 I10_DXMCCS5                    89-  99 (A)
 I10_DXMCCS6                   100- 110 (A)
 I10_DXMCCS7                   111- 121 (A)
 I10_DXMCCS8                   122- 132 (A)
 I10_DXMCCS9                   133- 143 (A)
 I10_DXMCCS10                  144- 154 (A)
 I10_DXMCCS11                  155- 165 (A)
 I10_ECauseMCCS1               166- 176 (A)
 I10_ECauseMCCS2               177- 187 (A)
 I10_ECauseMCCS3               188- 198 (A)
 I10_ECauseMCCS4               199- 209 (A)
 I10_ECauseMCCS5               210- 220 (A)
 I10_ECauseMCCS6               221- 231 (A)
 I10_ECauseMCCS7               232- 242 (A)
 I10_ECauseMCCS8               243- 253 (A)
 I10_ECauseMCCS9               254- 264 (A)
 I10_ECauseMCCS10              265- 275 (A)
 I10_INJURY                    276- 277
 I10_MULTINJURY                278- 279
 KEY                           280- 294.


***  Specify write formats  ***.
FORMATS
 I10_BODYSYSTEM1              (F3.0) /
 I10_BODYSYSTEM2              (F3.0) /
 I10_BODYSYSTEM3              (F3.0) /
 I10_BODYSYSTEM4              (F3.0) /
 I10_BODYSYSTEM5              (F3.0) /
 I10_BODYSYSTEM6              (F3.0) /
 I10_BODYSYSTEM7              (F3.0) /
 I10_BODYSYSTEM8              (F3.0) /
 I10_BODYSYSTEM9              (F3.0) /
 I10_BODYSYSTEM10             (F3.0) /
 I10_BODYSYSTEM11             (F3.0) /
 I10_CHRON1                   (F3.0) /
 I10_CHRON2                   (F3.0) /
 I10_CHRON3                   (F3.0) /
 I10_CHRON4                   (F3.0) /
 I10_CHRON5                   (F3.0) /
 I10_CHRON6                   (F3.0) /
 I10_CHRON7                   (F3.0) /
 I10_CHRON8                   (F3.0) /
 I10_CHRON9                   (F3.0) /
 I10_CHRON10                  (F3.0) /
 I10_CHRON11                  (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_MULTINJURY               (F3.0) /
 KEY                          (F8.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_BODYSYSTEM1              "ICD-10-CM Body system 1"
 I10_BODYSYSTEM2              "ICD-10-CM Body system 2"
 I10_BODYSYSTEM3              "ICD-10-CM Body system 3"
 I10_BODYSYSTEM4              "ICD-10-CM Body system 4"
 I10_BODYSYSTEM5              "ICD-10-CM Body system 5"
 I10_BODYSYSTEM6              "ICD-10-CM Body system 6"
 I10_BODYSYSTEM7              "ICD-10-CM Body system 7"
 I10_BODYSYSTEM8              "ICD-10-CM Body system 8"
 I10_BODYSYSTEM9              "ICD-10-CM Body system 9"
 I10_BODYSYSTEM10             "ICD-10-CM Body system 10"
 I10_BODYSYSTEM11             "ICD-10-CM Body system 11"
 I10_CHRON1                   "ICD-10-CM Chronic condition indicator 1"
 I10_CHRON2                   "ICD-10-CM Chronic condition indicator 2"
 I10_CHRON3                   "ICD-10-CM Chronic condition indicator 3"
 I10_CHRON4                   "ICD-10-CM Chronic condition indicator 4"
 I10_CHRON5                   "ICD-10-CM Chronic condition indicator 5"
 I10_CHRON6                   "ICD-10-CM Chronic condition indicator 6"
 I10_CHRON7                   "ICD-10-CM Chronic condition indicator 7"
 I10_CHRON8                   "ICD-10-CM Chronic condition indicator 8"
 I10_CHRON9                   "ICD-10-CM Chronic condition indicator 9"
 I10_CHRON10                  "ICD-10-CM Chronic condition indicator 10"
 I10_CHRON11                  "ICD-10-CM Chronic condition indicator 11"
 I10_DXMCCS1                  "ICD-10-CM Multi-Level CCS:  Diagnosis 1"
 I10_DXMCCS2                  "ICD-10-CM Multi-Level CCS:  Diagnosis 2"
 I10_DXMCCS3                  "ICD-10-CM Multi-Level CCS:  Diagnosis 3"
 I10_DXMCCS4                  "ICD-10-CM Multi-Level CCS:  Diagnosis 4"
 I10_DXMCCS5                  "ICD-10-CM Multi-Level CCS:  Diagnosis 5"
 I10_DXMCCS6                  "ICD-10-CM Multi-Level CCS:  Diagnosis 6"
 I10_DXMCCS7                  "ICD-10-CM Multi-Level CCS:  Diagnosis 7"
 I10_DXMCCS8                  "ICD-10-CM Multi-Level CCS:  Diagnosis 8"
 I10_DXMCCS9                  "ICD-10-CM Multi-Level CCS:  Diagnosis 9"
 I10_DXMCCS10                 "ICD-10-CM Multi-Level CCS:  Diagnosis 10"
 I10_DXMCCS11                 "ICD-10-CM Multi-Level CCS:  Diagnosis 11"
 I10_ECauseMCCS1              "ICD-10-CM Multi-Level CCS:  E Cause 1"
 I10_ECauseMCCS2              "ICD-10-CM Multi-Level CCS:  E Cause 2"
 I10_ECauseMCCS3              "ICD-10-CM Multi-Level CCS:  E Cause 3"
 I10_ECauseMCCS4              "ICD-10-CM Multi-Level CCS:  E Cause 4"
 I10_ECauseMCCS5              "ICD-10-CM Multi-Level CCS:  E Cause 5"
 I10_ECauseMCCS6              "ICD-10-CM Multi-Level CCS:  E Cause 6"
 I10_ECauseMCCS7              "ICD-10-CM Multi-Level CCS:  E Cause 7"
 I10_ECauseMCCS8              "ICD-10-CM Multi-Level CCS:  E Cause 8"
 I10_ECauseMCCS9              "ICD-10-CM Multi-Level CCS:  E Cause 9"
 I10_ECauseMCCS10             "ICD-10-CM Multi-Level CCS:  E Cause 10"
 I10_INJURY
 "ICD-10-CM Injury diagnosis reported on record (1:I10_DX1 is an injury; 2:I10_DX2+ is an injury; 0:No injury)"
 I10_MULTINJURY               "ICD-10-CM More than one injury diagnosis reported on record"
 KEY                          "HCUP record identifier" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'RI_SEDD_2015q4_DX_PR_GRPS.SAV' /COMPRESSED.
