/*******************************************************************            
* Creation Date: 07/05/2017                                                     
*   HI_SID_2015q4_SEVERITY.SAS:                                                 
*      THE SAS CODE SHOWN BELOW WILL LOAD THE ASCII                             
*      INPATIENT STAY SEVERITY FILE INTO SAS                                    
*******************************************************************/            
                                                                                
                                                                                
***************************************************************;                
* ----------------------------------------------------------- *;                
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;                
* |  terms and conditions of the HCUP Data Use Agreement.   | *;                
* ----------------------------------------------------------- *;                
***************************************************************;                
                                                                                
                                                                                
***********************************************;                                
*  Create SAS informats for missing values     ;                                
***********************************************;                                
PROC FORMAT;                                                                    
  INVALUE N2PF                                                                  
    '-9' = .                                                                    
    '-8' = .A                                                                   
    '-6' = .C                                                                   
    '-5' = .N                                                                   
    OTHER = (|2.|)                                                              
  ;                                                                             
  INVALUE N3PF                                                                  
    '-99' = .                                                                   
    '-88' = .A                                                                  
    '-66' = .C                                                                  
    OTHER = (|3.|)                                                              
  ;                                                                             
  INVALUE N4PF                                                                  
    '-999' = .                                                                  
    '-888' = .A                                                                 
    '-666' = .C                                                                 
    OTHER = (|4.|)                                                              
  ;                                                                             
  INVALUE N4P1F                                                                 
    '-9.9' = .                                                                  
    '-8.8' = .A                                                                 
    '-6.6' = .C                                                                 
    OTHER = (|4.1|)                                                             
  ;                                                                             
  INVALUE N5PF                                                                  
    '-9999' = .                                                                 
    '-8888' = .A                                                                
    '-6666' = .C                                                                
    OTHER = (|5.|)                                                              
  ;                                                                             
  INVALUE N5P2F                                                                 
    '-9.99' = .                                                                 
    '-8.88' = .A                                                                
    '-6.66' = .C                                                                
    OTHER = (|5.2|)                                                             
  ;                                                                             
  INVALUE N6PF                                                                  
    '-99999' = .                                                                
    '-88888' = .A                                                               
    '-66666' = .C                                                               
    OTHER = (|6.|)                                                              
  ;                                                                             
  INVALUE N6P2F                                                                 
    '-99.99' = .                                                                
    '-88.88' = .A                                                               
    '-66.66' = .C                                                               
    OTHER = (|6.2|)                                                             
  ;                                                                             
  INVALUE N7P2F                                                                 
    '-999.99' = .                                                               
    '-888.88' = .A                                                              
    '-666.66' = .C                                                              
    OTHER = (|7.2|)                                                             
  ;                                                                             
  INVALUE N7P4F                                                                 
    '-9.9999' = .                                                               
    '-8.8888' = .A                                                              
    '-6.6666' = .C                                                              
    OTHER = (|7.4|)                                                             
  ;                                                                             
  INVALUE N8PF                                                                  
    '-9999999' = .                                                              
    '-8888888' = .A                                                             
    '-6666666' = .C                                                             
    OTHER = (|8.|)                                                              
  ;                                                                             
  INVALUE N8P2F                                                                 
    '-9999.99' = .                                                              
    '-8888.88' = .A                                                             
    '-6666.66' = .C                                                             
    OTHER = (|8.2|)                                                             
  ;                                                                             
  INVALUE N9PF                                                                  
    '-99999999' = .                                                             
    '-88888888' = .A                                                            
    '-66666666' = .C                                                            
    OTHER = (|9.|)                                                              
  ;                                                                             
  INVALUE N9P2F                                                                 
    '-99999.99' = .                                                             
    '-88888.88' = .A                                                            
    '-66666.66' = .C                                                            
    OTHER = (|9.2|)                                                             
  ;                                                                             
  INVALUE N10PF                                                                 
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|10.|)                                                             
  ;                                                                             
  INVALUE N10P4F                                                                
    '-9999.9999' = .                                                            
    '-8888.8888' = .A                                                           
    '-6666.6666' = .C                                                           
    OTHER = (|10.4|)                                                            
  ;                                                                             
  INVALUE N10P5F                                                                
    '-999.99999' = .                                                            
    '-888.88888' = .A                                                           
    '-666.66666' = .C                                                           
    OTHER = (|10.5|)                                                            
  ;                                                                             
  INVALUE DATE10F                                                               
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|MMDDYY10.|)                                                       
  ;                                                                             
  INVALUE N11PF                                                                 
    '-9999999999' = .                                                           
    '-8888888888' = .A                                                          
    '-6666666666' = .C                                                          
    OTHER = (|11.|)                                                             
  ;                                                                             
  INVALUE N11P2F                                                                
    '-9999999.99' = .                                                           
    '-8888888.88' = .A                                                          
    '-6666666.66' = .C                                                          
    OTHER = (|11.2|)                                                            
  ;                                                                             
  INVALUE N12P2F                                                                
    '-99999999.99' = .                                                          
    '-88888888.88' = .A                                                         
    '-66666666.66' = .C                                                         
    OTHER = (|12.2|)                                                            
  ;                                                                             
  INVALUE N12P5F                                                                
    '-99999.99999' = .                                                          
    '-88888.88888' = .A                                                         
    '-66666.66666' = .C                                                         
    OTHER = (|12.5|)                                                            
  ;                                                                             
  INVALUE N13PF                                                                 
    '-999999999999' = .                                                         
    '-888888888888' = .A                                                        
    '-666666666666' = .C                                                        
    OTHER = (|13.|)                                                             
  ;                                                                             
  INVALUE N15P2F                                                                
    '-99999999999.99' = .                                                       
    '-88888888888.88' = .A                                                      
    '-66666666666.66' = .C                                                      
    OTHER = (|15.2|)                                                            
  ;                                                                             
  RUN;                                                                          
                                                                                
                                                                                
*******************************;                                                
*  Data Step                  *;                                                
*******************************;                                                
DATA HI_SIDC_2015q4_SEVERITY;                                                   
INFILE 'HI_SID_2015q4_SEVERITY.ASC' FIRSTOBS=3 LRECL = 73;                      
                                                                                
*** Variable attribute ***;                                                     
ATTRIB                                                                          
  KEY                        LENGTH=8                      FORMAT=Z15.          
  LABEL="HCUP record identifier"                                                
                                                                                
  I10_CM_AIDS                LENGTH=3                                           
  LABEL=                                                                        
  "ICD-10-CM AHRQ comorbidity measure: Acquired immune deficiency syndrome"     
                                                                                
  I10_CM_ALCOHOL             LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Alcohol abuse"                     
                                                                                
  I10_CM_ANEMDEF             LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Deficiency anemias"                
                                                                                
  I10_CM_ARTH                LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"ICD-10-CM AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular dise
ases"                                                                           
                                                                                
  I10_CM_BLDLOSS             LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Chronic blood loss anemia"         
                                                                                
  I10_CM_CHF                 LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Congestive heart failure"          
                                                                                
  I10_CM_CHRNLUNG            LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Chronic pulmonary disease"         
                                                                                
  I10_CM_COAG                LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Coagulopathy"                      
                                                                                
  I10_CM_DEPRESS             LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Depression"                        
                                                                                
  I10_CM_DM                  LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Diabetes, uncomplicated"           
                                                                                
  I10_CM_DMCX                LENGTH=3                                           
  LABEL=                                                                        
  "ICD-10-CM AHRQ comorbidity measure: Diabetes with chronic complications"     
                                                                                
  I10_CM_DRUG                LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Drug abuse"                        
                                                                                
  I10_CM_HTN_C               LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"ICD-10-CM AHRQ comorbidity measure: Hypertension (combine uncomplicated and com
plicated)"                                                                      
                                                                                
  I10_CM_HYPOTHY             LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Hypothyroidism"                    
                                                                                
  I10_CM_LIVER               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Liver disease"                     
                                                                                
  I10_CM_LYMPH               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Lymphoma"                          
                                                                                
  I10_CM_LYTES               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Fluid and electrolyte disorders"   
                                                                                
  I10_CM_METS                LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Metastatic cancer"                 
                                                                                
  I10_CM_NEURO               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Other neurological disorders"      
                                                                                
  I10_CM_OBESE               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Obesity"                           
                                                                                
  I10_CM_PARA                LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Paralysis"                         
                                                                                
  I10_CM_PERIVASC            LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Peripheral vascular disorders"     
                                                                                
  I10_CM_PSYCH               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Psychoses"                         
                                                                                
  I10_CM_PULMCIRC            LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Pulmonary circulation disorders"   
                                                                                
  I10_CM_RENLFAIL            LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Renal failure"                     
                                                                                
  I10_CM_TUMOR               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Solid tumor without metastasis"    
                                                                                
  I10_CM_ULCER               LENGTH=3                                           
  LABEL=                                                                        
  "ICD-10-CM AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding" 
                                                                                
  I10_CM_VALVE               LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Valvular disease"                  
                                                                                
  I10_CM_WGHTLOSS            LENGTH=3                                           
  LABEL="ICD-10-CM AHRQ comorbidity measure: Weight loss"                       
  ;                                                                             
                                                                                
                                                                                
*** Input the variables from the ASCII file ***;                                
INPUT                                                                           
      @1      KEY                           15.                                 
      @16     I10_CM_AIDS                   N2PF.                               
      @18     I10_CM_ALCOHOL                N2PF.                               
      @20     I10_CM_ANEMDEF                N2PF.                               
      @22     I10_CM_ARTH                   N2PF.                               
      @24     I10_CM_BLDLOSS                N2PF.                               
      @26     I10_CM_CHF                    N2PF.                               
      @28     I10_CM_CHRNLUNG               N2PF.                               
      @30     I10_CM_COAG                   N2PF.                               
      @32     I10_CM_DEPRESS                N2PF.                               
      @34     I10_CM_DM                     N2PF.                               
      @36     I10_CM_DMCX                   N2PF.                               
      @38     I10_CM_DRUG                   N2PF.                               
      @40     I10_CM_HTN_C                  N2PF.                               
      @42     I10_CM_HYPOTHY                N2PF.                               
      @44     I10_CM_LIVER                  N2PF.                               
      @46     I10_CM_LYMPH                  N2PF.                               
      @48     I10_CM_LYTES                  N2PF.                               
      @50     I10_CM_METS                   N2PF.                               
      @52     I10_CM_NEURO                  N2PF.                               
      @54     I10_CM_OBESE                  N2PF.                               
      @56     I10_CM_PARA                   N2PF.                               
      @58     I10_CM_PERIVASC               N2PF.                               
      @60     I10_CM_PSYCH                  N2PF.                               
      @62     I10_CM_PULMCIRC               N2PF.                               
      @64     I10_CM_RENLFAIL               N2PF.                               
      @66     I10_CM_TUMOR                  N2PF.                               
      @68     I10_CM_ULCER                  N2PF.                               
      @70     I10_CM_VALVE                  N2PF.                               
      @72     I10_CM_WGHTLOSS               N2PF.                               
      ;                                                                         
                                                                                
                                                                                
RUN;
