/*******************************************************************
*   AZ_SID_2002_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'AZ_SID_2002_CORE.ASC' FIXED / 
 KEY                   1-  14
 AGE                  15-  17
 AGEDAY               18-  20
 AGEMONTH             21-  23
 AMONTH               24-  25
 ASOURCE              26-  27
 ASOURCE_             28     (A)
 ASOURCEU             29     (A)
 ATYPE                30-  31
 AWEEKEND             32-  33
 BWT                  34-  37
 DIED                 38-  39
 DISP_X               40-  41 (A)
 DISPUB92             42-  43
 DISPUNIF             44-  45
 DQTR                 46-  47
 DRG                  48-  50
 DRG18                51-  53
 DRGVER               54-  55
 DSHOSPID             56-  68 (A)
 DX1                  69-  73 (A)
 DX2                  74-  78 (A)
 DX3                  79-  83 (A)
 DX4                  84-  88 (A)
 DX5                  89-  93 (A)
 DX6                  94-  98 (A)
 DX7                  99- 103 (A)
 DX8                 104- 108 (A)
 DX9                 109- 113 (A)
 DX10                114- 118 (A)
 DX11                119- 123 (A)
 DXCCS1              124- 127
 DXCCS2              128- 131
 DXCCS3              132- 135
 DXCCS4              136- 139
 DXCCS5              140- 143
 DXCCS6              144- 147
 DXCCS7              148- 151
 DXCCS8              152- 155
 DXCCS9              156- 159
 DXCCS10             160- 163
 DXCCS11             164- 167
 FEMALE              168- 169
 HOSPST              170- 171 (A)
 LOS                 172- 176
 LOS_X               177- 182
 MDBOARD1            183     (A)
 MDBOARD2            184     (A)
 MDC                 185- 186
 MDC18               187- 188
 MDNUM1_S            189- 204 (A)
 MDNUM2_S            205- 220 (A)
 NDX                 221- 222
 NEOMAT              223- 224
 NPR                 225- 226
 PAY1                227- 228
 PAY1_X              229- 230 (A)
 PL_CBSA             231- 232
 PL_MSA19            233- 234
 PL_RUCA             235- 238
 PL_RUCA1            239- 240
 PL_RUCA4            241- 242
 PL_RUCC             243- 244
 PL_UIC              245- 246
 PNUM_S              247- 263 (A)
 PR1                 264- 267 (A)
 PR2                 268- 271 (A)
 PR3                 272- 275 (A)
 PR4                 276- 279 (A)
 PR5                 280- 283 (A)
 PR6                 284- 287 (A)
 PRCCS1              288- 290
 PRCCS2              291- 293
 PRCCS3              294- 296
 PRCCS4              297- 299
 PRCCS5              300- 302
 PRCCS6              303- 305
 PRDAY1              306- 310
 PSTCO2              311- 315
 RACE                316- 317
 RACE_X              318     (A)
 TOTCHG              319- 328
 TOTCHG_X            329- 343
 YEAR                344- 347
 ZIP                 348- 352 (A)
 AYEAR               353- 356
 DMONTH              357- 358
 BMONTH              359- 360
 BYEAR               361- 364
 PRMNTH1             365- 366
 PRYEAR1             367- 370.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 BWT                 (F4.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PL_CBSA             (F3.0) /
 PL_MSA19            (F3.0) /
 PL_RUCA             (F4.1) /
 PL_RUCA1            (F3.0) /
 PL_RUCA4            (F3.0) /
 PL_RUCC             (F3.0) /
 PL_UIC              (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRDAY1              (F4.0) /
 PSTCO2              (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) /
 PRMNTH1             (F3.0) /
 PRYEAR1             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BWT       "Birth weight in grams"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDBOARD1  "Physician 1 licensing board (as received from source)"
 MDBOARD2  "Physician 2 licensing board (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDNUM1_S  "Physician 1 number (synthetic)"
 MDNUM2_S  "Physician 2 number (synthetic)"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA   "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC   "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC    "Patient location: Urban Influence Codes"
 PNUM_S    "Person number (synthetic)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRDAY1    "Number of days from admission to PR1"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_MSA19
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AZ_SID_2002_CORE.SAV' /COMPRESSED.
