/*******************************************************************
*   CO_SID_1990_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'CO_SID_1990_CHGS.ASC' FIXED / 
 PROCESS               1-  11
 CHG1                 12-  23
 CHG2                 24-  35
 CHG3                 36-  47
 CHG4                 48-  59
 CHG5                 60-  71.


***  Specify write formats  ***.
FORMATS
 PROCESS             (F6.0) /
 CHG1                (F5.2) /
 CHG2                (F5.2) /
 CHG3                (F5.2) /
 CHG4                (F5.2) /
 CHG5                (F5.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 PROCESS   "I:HCUP-3 discharge processing ID number"
 CHG1      "I:Detailed charges 1 (from data source)"
 CHG2      "I:Detailed charges 2 (from data source)"
 CHG3      "I:Detailed charges 3 (from data source)"
 CHG4      "I:Detailed charges 4 (from data source)"
 CHG5      "I:Detailed charges 5 (from data source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'CO_SID_1990_CHGS.SAV' /COMPRESSED.
