/*******************************************************************
* Creation Date: 07/05/2017   
*   HI_SID_2015q1q3_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'HI_SID_2015q1q3_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 BODYSYSTEM1                     1-   2
 BODYSYSTEM2                     3-   4
 BODYSYSTEM3                     5-   6
 BODYSYSTEM4                     7-   8
 BODYSYSTEM5                     9-  10
 BODYSYSTEM6                    11-  12
 BODYSYSTEM7                    13-  14
 BODYSYSTEM8                    15-  16
 BODYSYSTEM9                    17-  18
 BODYSYSTEM10                   19-  20
 BODYSYSTEM11                   21-  22
 BODYSYSTEM12                   23-  24
 BODYSYSTEM13                   25-  26
 BODYSYSTEM14                   27-  28
 BODYSYSTEM15                   29-  30
 BODYSYSTEM16                   31-  32
 BODYSYSTEM17                   33-  34
 BODYSYSTEM18                   35-  36
 BODYSYSTEM19                   37-  38
 BODYSYSTEM20                   39-  40
 BODYSYSTEM21                   41-  42
 BODYSYSTEM22                   43-  44
 BODYSYSTEM23                   45-  46
 BODYSYSTEM24                   47-  48
 BODYSYSTEM25                   49-  50
 BODYSYSTEM26                   51-  52
 BODYSYSTEM27                   53-  54
 BODYSYSTEM28                   55-  56
 BODYSYSTEM29                   57-  58
 BODYSYSTEM30                   59-  60
 BODYSYSTEM31                   61-  62
 BODYSYSTEM32                   63-  64
 BODYSYSTEM33                   65-  66
 BODYSYSTEM34                   67-  68
 BODYSYSTEM35                   69-  70
 BODYSYSTEM36                   71-  72
 BODYSYSTEM37                   73-  74
 BODYSYSTEM38                   75-  76
 CHRON1                         77-  78
 CHRON2                         79-  80
 CHRON3                         81-  82
 CHRON4                         83-  84
 CHRON5                         85-  86
 CHRON6                         87-  88
 CHRON7                         89-  90
 CHRON8                         91-  92
 CHRON9                         93-  94
 CHRON10                        95-  96
 CHRON11                        97-  98
 CHRON12                        99- 100
 CHRON13                       101- 102
 CHRON14                       103- 104
 CHRON15                       105- 106
 CHRON16                       107- 108
 CHRON17                       109- 110
 CHRON18                       111- 112
 CHRON19                       113- 114
 CHRON20                       115- 116
 CHRON21                       117- 118
 CHRON22                       119- 120
 CHRON23                       121- 122
 CHRON24                       123- 124
 CHRON25                       125- 126
 CHRON26                       127- 128
 CHRON27                       129- 130
 CHRON28                       131- 132
 CHRON29                       133- 134
 CHRON30                       135- 136
 CHRON31                       137- 138
 CHRON32                       139- 140
 CHRON33                       141- 142
 CHRON34                       143- 144
 CHRON35                       145- 146
 CHRON36                       147- 148
 CHRON37                       149- 150
 CHRON38                       151- 152
 DXMCCS1                       153- 163 (A)
 DXMCCS2                       164- 174 (A)
 DXMCCS3                       175- 185 (A)
 DXMCCS4                       186- 196 (A)
 DXMCCS5                       197- 207 (A)
 DXMCCS6                       208- 218 (A)
 DXMCCS7                       219- 229 (A)
 DXMCCS8                       230- 240 (A)
 DXMCCS9                       241- 251 (A)
 DXMCCS10                      252- 262 (A)
 DXMCCS11                      263- 273 (A)
 DXMCCS12                      274- 284 (A)
 DXMCCS13                      285- 295 (A)
 DXMCCS14                      296- 306 (A)
 DXMCCS15                      307- 317 (A)
 DXMCCS16                      318- 328 (A)
 DXMCCS17                      329- 339 (A)
 DXMCCS18                      340- 350 (A)
 DXMCCS19                      351- 361 (A)
 DXMCCS20                      362- 372 (A)
 DXMCCS21                      373- 383 (A)
 DXMCCS22                      384- 394 (A)
 DXMCCS23                      395- 405 (A)
 DXMCCS24                      406- 416 (A)
 DXMCCS25                      417- 427 (A)
 DXMCCS26                      428- 438 (A)
 DXMCCS27                      439- 449 (A)
 DXMCCS28                      450- 460 (A)
 DXMCCS29                      461- 471 (A)
 DXMCCS30                      472- 482 (A)
 DXMCCS31                      483- 493 (A)
 DXMCCS32                      494- 504 (A)
 DXMCCS33                      505- 515 (A)
 DXMCCS34                      516- 526 (A)
 DXMCCS35                      527- 537 (A)
 DXMCCS36                      538- 548 (A)
 DXMCCS37                      549- 559 (A)
 DXMCCS38                      560- 570 (A)
 E_MCCS1                       571- 581 (A)
 E_MCCS2                       582- 592 (A)
 E_MCCS3                       593- 603 (A)
 E_MCCS4                       604- 614 (A)
 E_MCCS5                       615- 625 (A)
 E_MCCS6                       626- 636 (A)
 E_MCCS7                       637- 647 (A)
 E_MCCS8                       648- 658 (A)
 E_MCCS9                       659- 669 (A)
 INJURY                        670- 671
 INJURY_CUT                    672- 673
 INJURY_DROWN                  674- 675
 INJURY_FALL                   676- 677
 INJURY_FIRE                   678- 679
 INJURY_FIREARM                680- 681
 INJURY_MACHINERY              682- 683
 INJURY_MVT                    684- 685
 INJURY_NATURE                 686- 687
 INJURY_POISON                 688- 689
 INJURY_STRUCK                 690- 691
 INJURY_SUFFOCATION            692- 693
 INTENT_ASSAULT                694- 695
 INTENT_SELF_HARM              696- 697
 INTENT_UNINTENTIONAL          698- 699
 KEY                           700- 714
 MULTINJURY                    715- 716
 PCLASS1                       717- 718
 PCLASS2                       719- 720
 PCLASS3                       721- 722
 PCLASS4                       723- 724
 PCLASS5                       725- 726
 PCLASS6                       727- 728
 PCLASS7                       729- 730
 PCLASS8                       731- 732
 PCLASS9                       733- 734
 PCLASS10                      735- 736
 PCLASS11                      737- 738
 PCLASS12                      739- 740
 PCLASS13                      741- 742
 PCLASS14                      743- 744
 PCLASS15                      745- 746
 PCLASS16                      747- 748
 PCLASS17                      749- 750
 PCLASS18                      751- 752
 PCLASS19                      753- 754
 PCLASS20                      755- 756
 PCLASS21                      757- 758
 PCLASS22                      759- 760
 PCLASS23                      761- 762
 PCLASS24                      763- 764
 PCLASS25                      765- 766
 PCLASS26                      767- 768
 PCLASS27                      769- 770
 PCLASS28                      771- 772
 PCLASS29                      773- 774
 PCLASS30                      775- 776
 PCLASS31                      777- 778
 PCLASS32                      779- 780
 PCLASS33                      781- 782
 PCLASS34                      783- 784
 PCLASS35                      785- 786
 PRMCCS1                       787- 794 (A)
 PRMCCS2                       795- 802 (A)
 PRMCCS3                       803- 810 (A)
 PRMCCS4                       811- 818 (A)
 PRMCCS5                       819- 826 (A)
 PRMCCS6                       827- 834 (A)
 PRMCCS7                       835- 842 (A)
 PRMCCS8                       843- 850 (A)
 PRMCCS9                       851- 858 (A)
 PRMCCS10                      859- 866 (A)
 PRMCCS11                      867- 874 (A)
 PRMCCS12                      875- 882 (A)
 PRMCCS13                      883- 890 (A)
 PRMCCS14                      891- 898 (A)
 PRMCCS15                      899- 906 (A)
 PRMCCS16                      907- 914 (A)
 PRMCCS17                      915- 922 (A)
 PRMCCS18                      923- 930 (A)
 PRMCCS19                      931- 938 (A)
 PRMCCS20                      939- 946 (A)
 PRMCCS21                      947- 954 (A)
 PRMCCS22                      955- 962 (A)
 PRMCCS23                      963- 970 (A)
 PRMCCS24                      971- 978 (A)
 PRMCCS25                      979- 986 (A)
 PRMCCS26                      987- 994 (A)
 PRMCCS27                      995-1002 (A)
 PRMCCS28                     1003-1010 (A)
 PRMCCS29                     1011-1018 (A)
 PRMCCS30                     1019-1026 (A)
 PRMCCS31                     1027-1034 (A)
 PRMCCS32                     1035-1042 (A)
 PRMCCS33                     1043-1050 (A)
 PRMCCS34                     1051-1058 (A)
 PRMCCS35                     1059-1066 (A)
 U_BLOOD                      1067-1068
 U_CATH                       1069-1070
 U_CCU                        1071-1072
 U_CHESTXRAY                  1073-1074
 U_CTSCAN                     1075-1076
 U_DIALYSIS                   1077-1078
 U_ECHO                       1079-1080
 U_ED                         1081-1082
 U_EEG                        1083-1084
 U_EKG                        1085-1086
 U_EPO                        1087-1088
 U_ICU                        1089-1090
 U_LITHOTRIPSY                1091-1092
 U_MHSA                       1093-1094
 U_MRT                        1095-1096
 U_NEWBN2L                    1097-1098
 U_NEWBN3L                    1099-1100
 U_NEWBN4L                    1101-1102
 U_NUCMED                     1103-1104
 U_OBSERVATION                1105-1106
 U_OCCTHERAPY                 1107-1108
 U_ORGANACQ                   1109-1110
 U_OTHIMPLANTS                1111-1112
 U_PACEMAKER                  1113-1114
 U_PHYTHERAPY                 1115-1116
 U_RADTHERAPY                 1117-1118
 U_RESPTHERAPY                1119-1120
 U_SPEECHTHERAPY              1121-1122
 U_STRESS                     1123-1124
 U_ULTRASOUND                 1125-1126.


***  Specify write formats  ***.
FORMATS
 BODYSYSTEM1                  (F3.0) /
 BODYSYSTEM2                  (F3.0) /
 BODYSYSTEM3                  (F3.0) /
 BODYSYSTEM4                  (F3.0) /
 BODYSYSTEM5                  (F3.0) /
 BODYSYSTEM6                  (F3.0) /
 BODYSYSTEM7                  (F3.0) /
 BODYSYSTEM8                  (F3.0) /
 BODYSYSTEM9                  (F3.0) /
 BODYSYSTEM10                 (F3.0) /
 BODYSYSTEM11                 (F3.0) /
 BODYSYSTEM12                 (F3.0) /
 BODYSYSTEM13                 (F3.0) /
 BODYSYSTEM14                 (F3.0) /
 BODYSYSTEM15                 (F3.0) /
 BODYSYSTEM16                 (F3.0) /
 BODYSYSTEM17                 (F3.0) /
 BODYSYSTEM18                 (F3.0) /
 BODYSYSTEM19                 (F3.0) /
 BODYSYSTEM20                 (F3.0) /
 BODYSYSTEM21                 (F3.0) /
 BODYSYSTEM22                 (F3.0) /
 BODYSYSTEM23                 (F3.0) /
 BODYSYSTEM24                 (F3.0) /
 BODYSYSTEM25                 (F3.0) /
 BODYSYSTEM26                 (F3.0) /
 BODYSYSTEM27                 (F3.0) /
 BODYSYSTEM28                 (F3.0) /
 BODYSYSTEM29                 (F3.0) /
 BODYSYSTEM30                 (F3.0) /
 BODYSYSTEM31                 (F3.0) /
 BODYSYSTEM32                 (F3.0) /
 BODYSYSTEM33                 (F3.0) /
 BODYSYSTEM34                 (F3.0) /
 BODYSYSTEM35                 (F3.0) /
 BODYSYSTEM36                 (F3.0) /
 BODYSYSTEM37                 (F3.0) /
 BODYSYSTEM38                 (F3.0) /
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 CHRON31                      (F3.0) /
 CHRON32                      (F3.0) /
 CHRON33                      (F3.0) /
 CHRON34                      (F3.0) /
 CHRON35                      (F3.0) /
 CHRON36                      (F3.0) /
 CHRON37                      (F3.0) /
 CHRON38                      (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 PCLASS26                     (F3.0) /
 PCLASS27                     (F3.0) /
 PCLASS28                     (F3.0) /
 PCLASS29                     (F3.0) /
 PCLASS30                     (F3.0) /
 PCLASS31                     (F3.0) /
 PCLASS32                     (F3.0) /
 PCLASS33                     (F3.0) /
 PCLASS34                     (F3.0) /
 PCLASS35                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 BODYSYSTEM1                  "Body system 1"
 BODYSYSTEM2                  "Body system 2"
 BODYSYSTEM3                  "Body system 3"
 BODYSYSTEM4                  "Body system 4"
 BODYSYSTEM5                  "Body system 5"
 BODYSYSTEM6                  "Body system 6"
 BODYSYSTEM7                  "Body system 7"
 BODYSYSTEM8                  "Body system 8"
 BODYSYSTEM9                  "Body system 9"
 BODYSYSTEM10                 "Body system 10"
 BODYSYSTEM11                 "Body system 11"
 BODYSYSTEM12                 "Body system 12"
 BODYSYSTEM13                 "Body system 13"
 BODYSYSTEM14                 "Body system 14"
 BODYSYSTEM15                 "Body system 15"
 BODYSYSTEM16                 "Body system 16"
 BODYSYSTEM17                 "Body system 17"
 BODYSYSTEM18                 "Body system 18"
 BODYSYSTEM19                 "Body system 19"
 BODYSYSTEM20                 "Body system 20"
 BODYSYSTEM21                 "Body system 21"
 BODYSYSTEM22                 "Body system 22"
 BODYSYSTEM23                 "Body system 23"
 BODYSYSTEM24                 "Body system 24"
 BODYSYSTEM25                 "Body system 25"
 BODYSYSTEM26                 "Body system 26"
 BODYSYSTEM27                 "Body system 27"
 BODYSYSTEM28                 "Body system 28"
 BODYSYSTEM29                 "Body system 29"
 BODYSYSTEM30                 "Body system 30"
 BODYSYSTEM31                 "Body system 31"
 BODYSYSTEM32                 "Body system 32"
 BODYSYSTEM33                 "Body system 33"
 BODYSYSTEM34                 "Body system 34"
 BODYSYSTEM35                 "Body system 35"
 BODYSYSTEM36                 "Body system 36"
 BODYSYSTEM37                 "Body system 37"
 BODYSYSTEM38                 "Body system 38"
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 CHRON31                      "Chronic condition indicator 31"
 CHRON32                      "Chronic condition indicator 32"
 CHRON33                      "Chronic condition indicator 33"
 CHRON34                      "Chronic condition indicator 34"
 CHRON35                      "Chronic condition indicator 35"
 CHRON36                      "Chronic condition indicator 36"
 CHRON37                      "Chronic condition indicator 37"
 CHRON38                      "Chronic condition indicator 38"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                     "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                     "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                     "Multi-Level CCS:  Diagnosis 33"
 DXMCCS34                     "Multi-Level CCS:  Diagnosis 34"
 DXMCCS35                     "Multi-Level CCS:  Diagnosis 35"
 DXMCCS36                     "Multi-Level CCS:  Diagnosis 36"
 DXMCCS37                     "Multi-Level CCS:  Diagnosis 37"
 DXMCCS38                     "Multi-Level CCS:  Diagnosis 38"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 E_MCCS9                      "Multi-Level CCS:  E Code 9"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PCLASS26                     "Procedure class 26"
 PCLASS27                     "Procedure class 27"
 PCLASS28                     "Procedure class 28"
 PCLASS29                     "Procedure class 29"
 PCLASS30                     "Procedure class 30"
 PCLASS31                     "Procedure class 31"
 PCLASS32                     "Procedure class 32"
 PCLASS33                     "Procedure class 33"
 PCLASS34                     "Procedure class 34"
 PCLASS35                     "Procedure class 35"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 PRMCCS26                     "Multi-Level CCS:  Procedure 26"
 PRMCCS27                     "Multi-Level CCS:  Procedure 27"
 PRMCCS28                     "Multi-Level CCS:  Procedure 28"
 PRMCCS29                     "Multi-Level CCS:  Procedure 29"
 PRMCCS30                     "Multi-Level CCS:  Procedure 30"
 PRMCCS31                     "Multi-Level CCS:  Procedure 31"
 PRMCCS32                     "Multi-Level CCS:  Procedure 32"
 PRMCCS33                     "Multi-Level CCS:  Procedure 33"
 PRMCCS34                     "Multi-Level CCS:  Procedure 34"
 PRMCCS35                     "Multi-Level CCS:  Procedure 35"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Magnetic Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM22
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM23
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM24
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM25
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM26
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM27
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM28
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM29
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM30
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM31
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM32
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM33
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM34
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM35
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM36
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM37
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON38
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS31
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS32
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS33
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS34
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS35
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'HI_SID_2015q1q3_DX_PR_GRPS.SAV' /COMPRESSED.
