/*******************************************************************
* Creation Date: 03/09/2015   
*   IA_SID_2013_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'IA_SID_2013_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 DIED                           16-  17
 DISPUB04                       18-  19
 DISPUNIFORM                    20-  21
 DISP_X                         22-  25 (A)
 DMONTH                         26-  27
 DQTR                           28-  29
 DRG                            30-  32
 DRG24                          33-  35
 DRGVER                         36-  37
 DRG_NoPOA                      38-  40
 DX1                            41-  45 (A)
 DX2                            46-  50 (A)
 DX3                            51-  55 (A)
 DX4                            56-  60 (A)
 DX5                            61-  65 (A)
 DX6                            66-  70 (A)
 DX7                            71-  75 (A)
 DX8                            76-  80 (A)
 DX9                            81-  85 (A)
 DX10                           86-  90 (A)
 DX11                           91-  95 (A)
 DX12                           96- 100 (A)
 DX13                          101- 105 (A)
 DX14                          106- 110 (A)
 DX15                          111- 115 (A)
 DX16                          116- 120 (A)
 DX17                          121- 125 (A)
 DX18                          126- 130 (A)
 DX19                          131- 135 (A)
 DX20                          136- 140 (A)
 DX21                          141- 145 (A)
 DX22                          146- 150 (A)
 DX23                          151- 155 (A)
 DX24                          156- 160 (A)
 DX25                          161- 165 (A)
 DX26                          166- 170 (A)
 DX27                          171- 175 (A)
 DX28                          176- 180 (A)
 DX29                          181- 185 (A)
 DX30                          186- 190 (A)
 DX31                          191- 195 (A)
 DX32                          196- 200 (A)
 DX33                          201- 205 (A)
 DX34                          206- 210 (A)
 DX35                          211- 215 (A)
 DX36                          216- 220 (A)
 DX37                          221- 225 (A)
 DX38                          226- 230 (A)
 DX39                          231- 235 (A)
 DX40                          236- 240 (A)
 DX41                          241- 245 (A)
 DX42                          246- 250 (A)
 DX43                          251- 255 (A)
 DX44                          256- 260 (A)
 DX45                          261- 265 (A)
 DX46                          266- 270 (A)
 DX47                          271- 275 (A)
 DX48                          276- 280 (A)
 DX49                          281- 285 (A)
 DX50                          286- 290 (A)
 DXCCS1                        291- 294
 DXCCS2                        295- 298
 DXCCS3                        299- 302
 DXCCS4                        303- 306
 DXCCS5                        307- 310
 DXCCS6                        311- 314
 DXCCS7                        315- 318
 DXCCS8                        319- 322
 DXCCS9                        323- 326
 DXCCS10                       327- 330
 DXCCS11                       331- 334
 DXCCS12                       335- 338
 DXCCS13                       339- 342
 DXCCS14                       343- 346
 DXCCS15                       347- 350
 DXCCS16                       351- 354
 DXCCS17                       355- 358
 DXCCS18                       359- 362
 DXCCS19                       363- 366
 DXCCS20                       367- 370
 DXCCS21                       371- 374
 DXCCS22                       375- 378
 DXCCS23                       379- 382
 DXCCS24                       383- 386
 DXCCS25                       387- 390
 DXCCS26                       391- 394
 DXCCS27                       395- 398
 DXCCS28                       399- 402
 DXCCS29                       403- 406
 DXCCS30                       407- 410
 DXCCS31                       411- 414
 DXCCS32                       415- 418
 DXCCS33                       419- 422
 DXCCS34                       423- 426
 DXCCS35                       427- 430
 DXCCS36                       431- 434
 DXCCS37                       435- 438
 DXCCS38                       439- 442
 DXCCS39                       443- 446
 DXCCS40                       447- 450
 DXCCS41                       451- 454
 DXCCS42                       455- 458
 DXCCS43                       459- 462
 DXCCS44                       463- 466
 DXCCS45                       467- 470
 DXCCS46                       471- 474
 DXCCS47                       475- 478
 DXCCS48                       479- 482
 DXCCS49                       483- 486
 DXCCS50                       487- 490
 DXPOA1                        491     (A)
 DXPOA2                        492     (A)
 DXPOA3                        493     (A)
 DXPOA4                        494     (A)
 DXPOA5                        495     (A)
 DXPOA6                        496     (A)
 DXPOA7                        497     (A)
 DXPOA8                        498     (A)
 DXPOA9                        499     (A)
 DXPOA10                       500     (A)
 DXPOA11                       501     (A)
 DXPOA12                       502     (A)
 DXPOA13                       503     (A)
 DXPOA14                       504     (A)
 DXPOA15                       505     (A)
 DXPOA16                       506     (A)
 DXPOA17                       507     (A)
 DXPOA18                       508     (A)
 DXPOA19                       509     (A)
 DXPOA20                       510     (A)
 DXPOA21                       511     (A)
 DXPOA22                       512     (A)
 DXPOA23                       513     (A)
 DXPOA24                       514     (A)
 DXPOA25                       515     (A)
 DXPOA26                       516     (A)
 DXPOA27                       517     (A)
 DXPOA28                       518     (A)
 DXPOA29                       519     (A)
 DXPOA30                       520     (A)
 DXPOA31                       521     (A)
 DXPOA32                       522     (A)
 DXPOA33                       523     (A)
 DXPOA34                       524     (A)
 DXPOA35                       525     (A)
 DXPOA36                       526     (A)
 DXPOA37                       527     (A)
 DXPOA38                       528     (A)
 DXPOA39                       529     (A)
 DXPOA40                       530     (A)
 DXPOA41                       531     (A)
 DXPOA42                       532     (A)
 DXPOA43                       533     (A)
 DXPOA44                       534     (A)
 DXPOA45                       535     (A)
 DXPOA46                       536     (A)
 DXPOA47                       537     (A)
 DXPOA48                       538     (A)
 DXPOA49                       539     (A)
 DXPOA50                       540     (A)
 DX_Admitting                  541- 545 (A)
 DaysToEvent                   546- 551
 ECODE1                        552- 556 (A)
 ECODE2                        557- 561 (A)
 ECODE3                        562- 566 (A)
 ECODE4                        567- 571 (A)
 ECODE5                        572- 576 (A)
 ECODE6                        577- 581 (A)
 ECODE7                        582- 586 (A)
 ECODE8                        587- 591 (A)
 E_CCS1                        592- 595
 E_CCS2                        596- 599
 E_CCS3                        600- 603
 E_CCS4                        604- 607
 E_CCS5                        608- 611
 E_CCS6                        612- 615
 E_CCS7                        616- 619
 E_CCS8                        620- 623
 E_POA1                        624     (A)
 E_POA2                        625     (A)
 E_POA3                        626     (A)
 E_POA4                        627     (A)
 E_POA5                        628     (A)
 E_POA6                        629     (A)
 E_POA7                        630     (A)
 E_POA8                        631     (A)
 FEMALE                        632- 633
 HCUP_ED                       634- 635
 HCUP_OS                       636- 637
 HISPANIC_X                    638     (A)
 HOSPBRTH                      639- 641
 HOSPST                        642- 643 (A)
 HospitalUnit                  644- 645
 KEY                           646- 660
 LOS                           661- 665
 LOS_X                         666- 671
 MDC                           672- 673
 MDC24                         674- 675
 MDC_NoPOA                     676- 677
 MDNUM1_R                      678- 686
 MDNUM2_R                      687- 695
 MDNUM3_R                      696- 704
 MEDINCSTQ                     705- 706
 MRN_R                         707- 715
 NCHRONIC                      716- 718
 NDX                           719- 721
 NECODE                        722- 723
 NEOMAT                        724- 725
 NPR                           726- 728
 ORPROC                        729- 730
 P7EDSRC_X                     731- 732 (A)
 PAY1                          733- 734
 PAY1_X                        735- 738 (A)
 PAY2                          739- 740
 PAY2_X                        741- 744 (A)
 PAY3                          745- 746
 PAY3_X                        747- 750 (A)
 PL_CBSA                       751- 753
 PL_NCHS                       754- 755
 PL_RUCA10_2005                756- 757
 PL_RUCA2005                   758- 761
 PL_RUCA4_2005                 762- 763
 PL_RUCC                       764- 765
 PL_UIC                        766- 767
 PL_UR_CAT4                    768- 769
 PR1                           770- 773 (A)
 PR2                           774- 777 (A)
 PR3                           778- 781 (A)
 PR4                           782- 785 (A)
 PR5                           786- 789 (A)
 PR6                           790- 793 (A)
 PR7                           794- 797 (A)
 PR8                           798- 801 (A)
 PR9                           802- 805 (A)
 PR10                          806- 809 (A)
 PR11                          810- 813 (A)
 PR12                          814- 817 (A)
 PR13                          818- 821 (A)
 PR14                          822- 825 (A)
 PR15                          826- 829 (A)
 PR16                          830- 833 (A)
 PR17                          834- 837 (A)
 PR18                          838- 841 (A)
 PR19                          842- 845 (A)
 PR20                          846- 849 (A)
 PR21                          850- 853 (A)
 PR22                          854- 857 (A)
 PR23                          858- 861 (A)
 PR24                          862- 865 (A)
 PR25                          866- 869 (A)
 PR26                          870- 873 (A)
 PR27                          874- 877 (A)
 PR28                          878- 881 (A)
 PR29                          882- 885 (A)
 PR30                          886- 889 (A)
 PR31                          890- 893 (A)
 PR32                          894- 897 (A)
 PR33                          898- 901 (A)
 PR34                          902- 905 (A)
 PR35                          906- 909 (A)
 PR36                          910- 913 (A)
 PR37                          914- 917 (A)
 PR38                          918- 921 (A)
 PR39                          922- 925 (A)
 PR40                          926- 929 (A)
 PR41                          930- 933 (A)
 PR42                          934- 937 (A)
 PR43                          938- 941 (A)
 PR44                          942- 945 (A)
 PR45                          946- 949 (A)
 PR46                          950- 953 (A)
 PR47                          954- 957 (A)
 PR48                          958- 961 (A)
 PR49                          962- 965 (A)
 PR50                          966- 969 (A)
 PR51                          970- 973 (A)
 PR52                          974- 977 (A)
 PR53                          978- 981 (A)
 PR54                          982- 985 (A)
 PR55                          986- 989 (A)
 PRCCS1                        990- 992
 PRCCS2                        993- 995
 PRCCS3                        996- 998
 PRCCS4                        999-1001
 PRCCS5                       1002-1004
 PRCCS6                       1005-1007
 PRCCS7                       1008-1010
 PRCCS8                       1011-1013
 PRCCS9                       1014-1016
 PRCCS10                      1017-1019
 PRCCS11                      1020-1022
 PRCCS12                      1023-1025
 PRCCS13                      1026-1028
 PRCCS14                      1029-1031
 PRCCS15                      1032-1034
 PRCCS16                      1035-1037
 PRCCS17                      1038-1040
 PRCCS18                      1041-1043
 PRCCS19                      1044-1046
 PRCCS20                      1047-1049
 PRCCS21                      1050-1052
 PRCCS22                      1053-1055
 PRCCS23                      1056-1058
 PRCCS24                      1059-1061
 PRCCS25                      1062-1064
 PRCCS26                      1065-1067
 PRCCS27                      1068-1070
 PRCCS28                      1071-1073
 PRCCS29                      1074-1076
 PRCCS30                      1077-1079
 PRCCS31                      1080-1082
 PRCCS32                      1083-1085
 PRCCS33                      1086-1088
 PRCCS34                      1089-1091
 PRCCS35                      1092-1094
 PRCCS36                      1095-1097
 PRCCS37                      1098-1100
 PRCCS38                      1101-1103
 PRCCS39                      1104-1106
 PRCCS40                      1107-1109
 PRCCS41                      1110-1112
 PRCCS42                      1113-1115
 PRCCS43                      1116-1118
 PRCCS44                      1119-1121
 PRCCS45                      1122-1124
 PRCCS46                      1125-1127
 PRCCS47                      1128-1130
 PRCCS48                      1131-1133
 PRCCS49                      1134-1136
 PRCCS50                      1137-1139
 PRCCS51                      1140-1142
 PRCCS52                      1143-1145
 PRCCS53                      1146-1148
 PRCCS54                      1149-1151
 PRCCS55                      1152-1154
 PRDAY1                       1155-1159
 PRDAY2                       1160-1164
 PRDAY3                       1165-1169
 PRDAY4                       1170-1174
 PRDAY5                       1175-1179
 PRDAY6                       1180-1184
 PRDAY7                       1185-1189
 PRDAY8                       1190-1194
 PRDAY9                       1195-1199
 PRDAY10                      1200-1204
 PRDAY11                      1205-1209
 PRDAY12                      1210-1214
 PRDAY13                      1215-1219
 PRDAY14                      1220-1224
 PRDAY15                      1225-1229
 PRDAY16                      1230-1234
 PRDAY17                      1235-1239
 PRDAY18                      1240-1244
 PRDAY19                      1245-1249
 PRDAY20                      1250-1254
 PRDAY21                      1255-1259
 PRDAY22                      1260-1264
 PRDAY23                      1265-1269
 PRDAY24                      1270-1274
 PRDAY25                      1275-1279
 PRDAY26                      1280-1284
 PRDAY27                      1285-1289
 PRDAY28                      1290-1294
 PRDAY29                      1295-1299
 PRDAY30                      1300-1304
 PRDAY31                      1305-1309
 PRDAY32                      1310-1314
 PRDAY33                      1315-1319
 PRDAY34                      1320-1324
 PRDAY35                      1325-1329
 PRDAY36                      1330-1334
 PRDAY37                      1335-1339
 PRDAY38                      1340-1344
 PRDAY39                      1345-1349
 PRDAY40                      1350-1354
 PRDAY41                      1355-1359
 PRDAY42                      1360-1364
 PRDAY43                      1365-1369
 PRDAY44                      1370-1374
 PRDAY45                      1375-1379
 PRDAY46                      1380-1384
 PRDAY47                      1385-1389
 PRDAY48                      1390-1394
 PRDAY49                      1395-1399
 PRDAY50                      1400-1404
 PRDAY51                      1405-1409
 PRDAY52                      1410-1414
 PRDAY53                      1415-1419
 PRDAY54                      1420-1424
 PRDAY55                      1425-1429
 PROCTYPE                     1430-1432
 PSTATE                       1433-1434 (A)
 PSTCO                        1435-1439
 PSTCO2                       1440-1444
 PointOfOriginUB04            1445     (A)
 PointOfOrigin_X              1446     (A)
 RACE                         1447-1448
 RACE_X                       1449-1452 (A)
 TOTCHG                       1453-1462
 TOTCHG_X                     1463-1477
 TRAN_IN                      1478-1479
 TRAN_OUT                     1480-1481
 VisitLink                    1482-1490
 YEAR                         1491-1494
 ZIP3                         1495-1497 (A)
 ZIPINC_QRTL                  1498-1500
 ZIP                          1501-1505 (A)
 AYEAR                        1506-1509
 BMONTH                       1510-1511
 BYEAR                        1512-1515
 PRMONTH1                     1516-1517
 PRMONTH2                     1518-1519
 PRMONTH3                     1520-1521
 PRMONTH4                     1522-1523
 PRMONTH5                     1524-1525
 PRMONTH6                     1526-1527
 PRMONTH7                     1528-1529
 PRMONTH8                     1530-1531
 PRMONTH9                     1532-1533
 PRMONTH10                    1534-1535
 PRMONTH11                    1536-1537
 PRMONTH12                    1538-1539
 PRMONTH13                    1540-1541
 PRMONTH14                    1542-1543
 PRMONTH15                    1544-1545
 PRMONTH16                    1546-1547
 PRMONTH17                    1548-1549
 PRMONTH18                    1550-1551
 PRMONTH19                    1552-1553
 PRMONTH20                    1554-1555
 PRMONTH21                    1556-1557
 PRMONTH22                    1558-1559
 PRMONTH23                    1560-1561
 PRMONTH24                    1562-1563
 PRMONTH25                    1564-1565
 PRMONTH26                    1566-1567
 PRMONTH27                    1568-1569
 PRMONTH28                    1570-1571
 PRMONTH29                    1572-1573
 PRMONTH30                    1574-1575
 PRMONTH31                    1576-1577
 PRMONTH32                    1578-1579
 PRMONTH33                    1580-1581
 PRMONTH34                    1582-1583
 PRMONTH35                    1584-1585
 PRMONTH36                    1586-1587
 PRMONTH37                    1588-1589
 PRMONTH38                    1590-1591
 PRMONTH39                    1592-1593
 PRMONTH40                    1594-1595
 PRMONTH41                    1596-1597
 PRMONTH42                    1598-1599
 PRMONTH43                    1600-1601
 PRMONTH44                    1602-1603
 PRMONTH45                    1604-1605
 PRMONTH46                    1606-1607
 PRMONTH47                    1608-1609
 PRMONTH48                    1610-1611
 PRMONTH49                    1612-1613
 PRMONTH50                    1614-1615
 PRMONTH51                    1616-1617
 PRMONTH52                    1618-1619
 PRMONTH53                    1620-1621
 PRMONTH54                    1622-1623
 PRMONTH55                    1624-1625
 PRYEAR1                      1626-1629
 PRYEAR2                      1630-1633
 PRYEAR3                      1634-1637
 PRYEAR4                      1638-1641
 PRYEAR5                      1642-1645
 PRYEAR6                      1646-1649
 PRYEAR7                      1650-1653
 PRYEAR8                      1654-1657
 PRYEAR9                      1658-1661
 PRYEAR10                     1662-1665
 PRYEAR11                     1666-1669
 PRYEAR12                     1670-1673
 PRYEAR13                     1674-1677
 PRYEAR14                     1678-1681
 PRYEAR15                     1682-1685
 PRYEAR16                     1686-1689
 PRYEAR17                     1690-1693
 PRYEAR18                     1694-1697
 PRYEAR19                     1698-1701
 PRYEAR20                     1702-1705
 PRYEAR21                     1706-1709
 PRYEAR22                     1710-1713
 PRYEAR23                     1714-1717
 PRYEAR24                     1718-1721
 PRYEAR25                     1722-1725
 PRYEAR26                     1726-1729
 PRYEAR27                     1730-1733
 PRYEAR28                     1734-1737
 PRYEAR29                     1738-1741
 PRYEAR30                     1742-1745
 PRYEAR31                     1746-1749
 PRYEAR32                     1750-1753
 PRYEAR33                     1754-1757
 PRYEAR34                     1758-1761
 PRYEAR35                     1762-1765
 PRYEAR36                     1766-1769
 PRYEAR37                     1770-1773
 PRYEAR38                     1774-1777
 PRYEAR39                     1778-1781
 PRYEAR40                     1782-1785
 PRYEAR41                     1786-1789
 PRYEAR42                     1790-1793
 PRYEAR43                     1794-1797
 PRYEAR44                     1798-1801
 PRYEAR45                     1802-1805
 PRYEAR46                     1806-1809
 PRYEAR47                     1810-1813
 PRYEAR48                     1814-1817
 PRYEAR49                     1818-1821
 PRYEAR50                     1822-1825
 PRYEAR51                     1826-1829
 PRYEAR52                     1830-1833
 PRYEAR53                     1834-1837
 PRYEAR54                     1838-1841
 PRYEAR55                     1842-1845.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG24                        (F3.0) /
 DRGVER                       (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXCCS25                      (F4.0) /
 DXCCS26                      (F4.0) /
 DXCCS27                      (F4.0) /
 DXCCS28                      (F4.0) /
 DXCCS29                      (F4.0) /
 DXCCS30                      (F4.0) /
 DXCCS31                      (F4.0) /
 DXCCS32                      (F4.0) /
 DXCCS33                      (F4.0) /
 DXCCS34                      (F4.0) /
 DXCCS35                      (F4.0) /
 DXCCS36                      (F4.0) /
 DXCCS37                      (F4.0) /
 DXCCS38                      (F4.0) /
 DXCCS39                      (F4.0) /
 DXCCS40                      (F4.0) /
 DXCCS41                      (F4.0) /
 DXCCS42                      (F4.0) /
 DXCCS43                      (F4.0) /
 DXCCS44                      (F4.0) /
 DXCCS45                      (F4.0) /
 DXCCS46                      (F4.0) /
 DXCCS47                      (F4.0) /
 DXCCS48                      (F4.0) /
 DXCCS49                      (F4.0) /
 DXCCS50                      (F4.0) /
 DaysToEvent                  (F8.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 HospitalUnit                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC24                        (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCHRONIC                     (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCA10_2005               (F3.0) /
 PL_RUCA2005                  (F4.1) /
 PL_RUCA4_2005                (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRCCS21                      (F3.0) /
 PRCCS22                      (F3.0) /
 PRCCS23                      (F3.0) /
 PRCCS24                      (F3.0) /
 PRCCS25                      (F3.0) /
 PRCCS26                      (F3.0) /
 PRCCS27                      (F3.0) /
 PRCCS28                      (F3.0) /
 PRCCS29                      (F3.0) /
 PRCCS30                      (F3.0) /
 PRCCS31                      (F3.0) /
 PRCCS32                      (F3.0) /
 PRCCS33                      (F3.0) /
 PRCCS34                      (F3.0) /
 PRCCS35                      (F3.0) /
 PRCCS36                      (F3.0) /
 PRCCS37                      (F3.0) /
 PRCCS38                      (F3.0) /
 PRCCS39                      (F3.0) /
 PRCCS40                      (F3.0) /
 PRCCS41                      (F3.0) /
 PRCCS42                      (F3.0) /
 PRCCS43                      (F3.0) /
 PRCCS44                      (F3.0) /
 PRCCS45                      (F3.0) /
 PRCCS46                      (F3.0) /
 PRCCS47                      (F3.0) /
 PRCCS48                      (F3.0) /
 PRCCS49                      (F3.0) /
 PRCCS50                      (F3.0) /
 PRCCS51                      (F3.0) /
 PRCCS52                      (F3.0) /
 PRCCS53                      (F3.0) /
 PRCCS54                      (F3.0) /
 PRCCS55                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRMONTH43                    (F3.0) /
 PRMONTH44                    (F3.0) /
 PRMONTH45                    (F3.0) /
 PRMONTH46                    (F3.0) /
 PRMONTH47                    (F3.0) /
 PRMONTH48                    (F3.0) /
 PRMONTH49                    (F3.0) /
 PRMONTH50                    (F3.0) /
 PRMONTH51                    (F3.0) /
 PRMONTH52                    (F3.0) /
 PRMONTH53                    (F3.0) /
 PRMONTH54                    (F3.0) /
 PRMONTH55                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) /
 PRYEAR43                     (F3.0) /
 PRYEAR44                     (F3.0) /
 PRYEAR45                     (F3.0) /
 PRYEAR46                     (F3.0) /
 PRYEAR47                     (F3.0) /
 PRYEAR48                     (F3.0) /
 PRYEAR49                     (F3.0) /
 PRYEAR50                     (F3.0) /
 PRYEAR51                     (F3.0) /
 PRYEAR52                     (F3.0) /
 PRYEAR53                     (F3.0) /
 PRYEAR54                     (F3.0) /
 PRYEAR55                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG24                        "DRG, version 24"
 DRGVER                       "DRG grouper version used on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DX25                         "Diagnosis 25"
 DX26                         "Diagnosis 26"
 DX27                         "Diagnosis 27"
 DX28                         "Diagnosis 28"
 DX29                         "Diagnosis 29"
 DX30                         "Diagnosis 30"
 DX31                         "Diagnosis 31"
 DX32                         "Diagnosis 32"
 DX33                         "Diagnosis 33"
 DX34                         "Diagnosis 34"
 DX35                         "Diagnosis 35"
 DX36                         "Diagnosis 36"
 DX37                         "Diagnosis 37"
 DX38                         "Diagnosis 38"
 DX39                         "Diagnosis 39"
 DX40                         "Diagnosis 40"
 DX41                         "Diagnosis 41"
 DX42                         "Diagnosis 42"
 DX43                         "Diagnosis 43"
 DX44                         "Diagnosis 44"
 DX45                         "Diagnosis 45"
 DX46                         "Diagnosis 46"
 DX47                         "Diagnosis 47"
 DX48                         "Diagnosis 48"
 DX49                         "Diagnosis 49"
 DX50                         "Diagnosis 50"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXCCS25                      "CCS: diagnosis 25"
 DXCCS26                      "CCS: diagnosis 26"
 DXCCS27                      "CCS: diagnosis 27"
 DXCCS28                      "CCS: diagnosis 28"
 DXCCS29                      "CCS: diagnosis 29"
 DXCCS30                      "CCS: diagnosis 30"
 DXCCS31                      "CCS: diagnosis 31"
 DXCCS32                      "CCS: diagnosis 32"
 DXCCS33                      "CCS: diagnosis 33"
 DXCCS34                      "CCS: diagnosis 34"
 DXCCS35                      "CCS: diagnosis 35"
 DXCCS36                      "CCS: diagnosis 36"
 DXCCS37                      "CCS: diagnosis 37"
 DXCCS38                      "CCS: diagnosis 38"
 DXCCS39                      "CCS: diagnosis 39"
 DXCCS40                      "CCS: diagnosis 40"
 DXCCS41                      "CCS: diagnosis 41"
 DXCCS42                      "CCS: diagnosis 42"
 DXCCS43                      "CCS: diagnosis 43"
 DXCCS44                      "CCS: diagnosis 44"
 DXCCS45                      "CCS: diagnosis 45"
 DXCCS46                      "CCS: diagnosis 46"
 DXCCS47                      "CCS: diagnosis 47"
 DXCCS48                      "CCS: diagnosis 48"
 DXCCS49                      "CCS: diagnosis 49"
 DXCCS50                      "CCS: diagnosis 50"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DX_Admitting                 "Admitting Diagnosis Code"
 DaysToEvent                  "Days from 'start date' to admission"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 HospitalUnit

"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC24                        "MDC, version 24"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCHRONIC                     "Number of chronic conditions"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 P7EDSRC_X
"Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005                  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PR21                         "Procedure 21"
 PR22                         "Procedure 22"
 PR23                         "Procedure 23"
 PR24                         "Procedure 24"
 PR25                         "Procedure 25"
 PR26                         "Procedure 26"
 PR27                         "Procedure 27"
 PR28                         "Procedure 28"
 PR29                         "Procedure 29"
 PR30                         "Procedure 30"
 PR31                         "Procedure 31"
 PR32                         "Procedure 32"
 PR33                         "Procedure 33"
 PR34                         "Procedure 34"
 PR35                         "Procedure 35"
 PR36                         "Procedure 36"
 PR37                         "Procedure 37"
 PR38                         "Procedure 38"
 PR39                         "Procedure 39"
 PR40                         "Procedure 40"
 PR41                         "Procedure 41"
 PR42                         "Procedure 42"
 PR43                         "Procedure 43"
 PR44                         "Procedure 44"
 PR45                         "Procedure 45"
 PR46                         "Procedure 46"
 PR47                         "Procedure 47"
 PR48                         "Procedure 48"
 PR49                         "Procedure 49"
 PR50                         "Procedure 50"
 PR51                         "Procedure 51"
 PR52                         "Procedure 52"
 PR53                         "Procedure 53"
 PR54                         "Procedure 54"
 PR55                         "Procedure 55"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRCCS21                      "CCS: procedure 21"
 PRCCS22                      "CCS: procedure 22"
 PRCCS23                      "CCS: procedure 23"
 PRCCS24                      "CCS: procedure 24"
 PRCCS25                      "CCS: procedure 25"
 PRCCS26                      "CCS: procedure 26"
 PRCCS27                      "CCS: procedure 27"
 PRCCS28                      "CCS: procedure 28"
 PRCCS29                      "CCS: procedure 29"
 PRCCS30                      "CCS: procedure 30"
 PRCCS31                      "CCS: procedure 31"
 PRCCS32                      "CCS: procedure 32"
 PRCCS33                      "CCS: procedure 33"
 PRCCS34                      "CCS: procedure 34"
 PRCCS35                      "CCS: procedure 35"
 PRCCS36                      "CCS: procedure 36"
 PRCCS37                      "CCS: procedure 37"
 PRCCS38                      "CCS: procedure 38"
 PRCCS39                      "CCS: procedure 39"
 PRCCS40                      "CCS: procedure 40"
 PRCCS41                      "CCS: procedure 41"
 PRCCS42                      "CCS: procedure 42"
 PRCCS43                      "CCS: procedure 43"
 PRCCS44                      "CCS: procedure 44"
 PRCCS45                      "CCS: procedure 45"
 PRCCS46                      "CCS: procedure 46"
 PRCCS47                      "CCS: procedure 47"
 PRCCS48                      "CCS: procedure 48"
 PRCCS49                      "CCS: procedure 49"
 PRCCS50                      "CCS: procedure 50"
 PRCCS51                      "CCS: procedure 51"
 PRCCS52                      "CCS: procedure 52"
 PRCCS53                      "CCS: procedure 53"
 PRCCS54                      "CCS: procedure 54"
 PRCCS55                      "CCS: procedure 55"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PRDAY14                      "Number of days from admission to PR14"
 PRDAY15                      "Number of days from admission to PR15"
 PRDAY16                      "Number of days from admission to PR16"
 PRDAY17                      "Number of days from admission to PR17"
 PRDAY18                      "Number of days from admission to PR18"
 PRDAY19                      "Number of days from admission to PR19"
 PRDAY20                      "Number of days from admission to PR20"
 PRDAY21                      "Number of days from admission to PR21"
 PRDAY22                      "Number of days from admission to PR22"
 PRDAY23                      "Number of days from admission to PR23"
 PRDAY24                      "Number of days from admission to PR24"
 PRDAY25                      "Number of days from admission to PR25"
 PRDAY26                      "Number of days from admission to PR26"
 PRDAY27                      "Number of days from admission to PR27"
 PRDAY28                      "Number of days from admission to PR28"
 PRDAY29                      "Number of days from admission to PR29"
 PRDAY30                      "Number of days from admission to PR30"
 PRDAY31                      "Number of days from admission to PR31"
 PRDAY32                      "Number of days from admission to PR32"
 PRDAY33                      "Number of days from admission to PR33"
 PRDAY34                      "Number of days from admission to PR34"
 PRDAY35                      "Number of days from admission to PR35"
 PRDAY36                      "Number of days from admission to PR36"
 PRDAY37                      "Number of days from admission to PR37"
 PRDAY38                      "Number of days from admission to PR38"
 PRDAY39                      "Number of days from admission to PR39"
 PRDAY40                      "Number of days from admission to PR40"
 PRDAY41                      "Number of days from admission to PR41"
 PRDAY42                      "Number of days from admission to PR42"
 PRDAY43                      "Number of days from admission to PR43"
 PRDAY44                      "Number of days from admission to PR44"
 PRDAY45                      "Number of days from admission to PR45"
 PRDAY46                      "Number of days from admission to PR46"
 PRDAY47                      "Number of days from admission to PR47"
 PRDAY48                      "Number of days from admission to PR48"
 PRDAY49                      "Number of days from admission to PR49"
 PRDAY50                      "Number of days from admission to PR50"
 PRDAY51                      "Number of days from admission to PR51"
 PRDAY52                      "Number of days from admission to PR52"
 PRDAY53                      "Number of days from admission to PR53"
 PRDAY54                      "Number of days from admission to PR54"
 PRDAY55                      "Number of days from admission to PR55"
 PROCTYPE                     "Procedure type indicator"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 ZIP                          "Patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRMONTH43                    "Month of procedure 43"
 PRMONTH44                    "Month of procedure 44"
 PRMONTH45                    "Month of procedure 45"
 PRMONTH46                    "Month of procedure 46"
 PRMONTH47                    "Month of procedure 47"
 PRMONTH48                    "Month of procedure 48"
 PRMONTH49                    "Month of procedure 49"
 PRMONTH50                    "Month of procedure 50"
 PRMONTH51                    "Month of procedure 51"
 PRMONTH52                    "Month of procedure 52"
 PRMONTH53                    "Month of procedure 53"
 PRMONTH54                    "Month of procedure 54"
 PRMONTH55                    "Month of procedure 55"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42"
 PRYEAR43                     "Year of procedure 43"
 PRYEAR44                     "Year of procedure 44"
 PRYEAR45                     "Year of procedure 45"
 PRYEAR46                     "Year of procedure 46"
 PRYEAR47                     "Year of procedure 47"
 PRYEAR48                     "Year of procedure 48"
 PRYEAR49                     "Year of procedure 49"
 PRYEAR50                     "Year of procedure 50"
 PRYEAR51                     "Year of procedure 51"
 PRYEAR52                     "Year of procedure 52"
 PRYEAR53                     "Year of procedure 53"
 PRYEAR54                     "Year of procedure 54"
 PRYEAR55                     "Year of procedure 55" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH48
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH49
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH50
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH51
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH52
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH53
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH54
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH55
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR48
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR49
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR50
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR51
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR52
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR53
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR54
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR55
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_2013_CORE.SAV' /COMPRESSED.
