/*******************************************************************
* Creation Date: 05/18/2021   
*   IN_SID_2017_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'IN_SID_2017_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 BWT                            20-  23
 DaysToEvent                    24-  29
 DIED                           30-  31
 DISP_X                         32-  33 (A)
 DISPUB04                       34-  35
 DISPUNIFORM                    36-  37
 DMONTH                         38-  39
 DQTR                           40-  41
 DRG                            42-  44
 DRG_NoPOA                      45-  47
 DRGVER                         48-  49
 DXPOA1                         50     (A)
 DXPOA2                         51     (A)
 DXPOA3                         52     (A)
 DXPOA4                         53     (A)
 DXPOA5                         54     (A)
 DXPOA6                         55     (A)
 DXPOA7                         56     (A)
 DXPOA8                         57     (A)
 DXPOA9                         58     (A)
 DXPOA10                        59     (A)
 DXPOA11                        60     (A)
 DXPOA12                        61     (A)
 DXPOA13                        62     (A)
 DXPOA14                        63     (A)
 DXPOA15                        64     (A)
 DXPOA16                        65     (A)
 DXPOA17                        66     (A)
 DXPOA18                        67     (A)
 DXPOA19                        68     (A)
 DXPOA20                        69     (A)
 DXPOA21                        70     (A)
 DXPOA22                        71     (A)
 DXPOA23                        72     (A)
 DXPOA24                        73     (A)
 DXPOA25                        74     (A)
 DXPOA26                        75     (A)
 DXPOA27                        76     (A)
 DXPOA28                        77     (A)
 DXPOA29                        78     (A)
 DXPOA30                        79     (A)
 DXPOA31                        80     (A)
 DXPOA32                        81     (A)
 DXPOA33                        82     (A)
 DXPOA34                        83     (A)
 DXPOA35                        84     (A)
 DXPOA36                        85     (A)
 DXPOA37                        86     (A)
 DXPOA38                        87     (A)
 DXPOA39                        88     (A)
 DXPOA40                        89     (A)
 DXPOA41                        90     (A)
 DXPOA42                        91     (A)
 DXPOA43                        92     (A)
 DXPOA44                        93     (A)
 DXPOA45                        94     (A)
 DXPOA46                        95     (A)
 DXPOA47                        96     (A)
 DXPOA48                        97     (A)
 DXPOA49                        98     (A)
 DXPOA50                        99     (A)
 DXPOA51                       100     (A)
 DXPOA52                       101     (A)
 DXPOA53                       102     (A)
 DXPOA54                       103     (A)
 DXPOA55                       104     (A)
 DXPOA56                       105     (A)
 DXPOA57                       106     (A)
 DXPOA58                       107     (A)
 DXPOA59                       108     (A)
 DXPOA60                       109     (A)
 DXVER                         110- 112
 FEMALE                        113- 114
 HCUP_ED                       115- 116
 HCUP_OS                       117- 118
 HISPANIC                      119- 120
 HISPANIC_X                    121     (A)
 HospitalUnit                  122- 123
 HOSPST                        124- 125 (A)
 I10_DX_Admitting              126- 132 (A)
 I10_DX1                       133- 139 (A)
 I10_DX2                       140- 146 (A)
 I10_DX3                       147- 153 (A)
 I10_DX4                       154- 160 (A)
 I10_DX5                       161- 167 (A)
 I10_DX6                       168- 174 (A)
 I10_DX7                       175- 181 (A)
 I10_DX8                       182- 188 (A)
 I10_DX9                       189- 195 (A)
 I10_DX10                      196- 202 (A)
 I10_DX11                      203- 209 (A)
 I10_DX12                      210- 216 (A)
 I10_DX13                      217- 223 (A)
 I10_DX14                      224- 230 (A)
 I10_DX15                      231- 237 (A)
 I10_DX16                      238- 244 (A)
 I10_DX17                      245- 251 (A)
 I10_DX18                      252- 258 (A)
 I10_DX19                      259- 265 (A)
 I10_DX20                      266- 272 (A)
 I10_DX21                      273- 279 (A)
 I10_DX22                      280- 286 (A)
 I10_DX23                      287- 293 (A)
 I10_DX24                      294- 300 (A)
 I10_DX25                      301- 307 (A)
 I10_DX26                      308- 314 (A)
 I10_DX27                      315- 321 (A)
 I10_DX28                      322- 328 (A)
 I10_DX29                      329- 335 (A)
 I10_DX30                      336- 342 (A)
 I10_DX31                      343- 349 (A)
 I10_DX32                      350- 356 (A)
 I10_DX33                      357- 363 (A)
 I10_DX34                      364- 370 (A)
 I10_DX35                      371- 377 (A)
 I10_DX36                      378- 384 (A)
 I10_DX37                      385- 391 (A)
 I10_DX38                      392- 398 (A)
 I10_DX39                      399- 405 (A)
 I10_DX40                      406- 412 (A)
 I10_DX41                      413- 419 (A)
 I10_DX42                      420- 426 (A)
 I10_DX43                      427- 433 (A)
 I10_DX44                      434- 440 (A)
 I10_DX45                      441- 447 (A)
 I10_DX46                      448- 454 (A)
 I10_DX47                      455- 461 (A)
 I10_DX48                      462- 468 (A)
 I10_DX49                      469- 475 (A)
 I10_DX50                      476- 482 (A)
 I10_DX51                      483- 489 (A)
 I10_DX52                      490- 496 (A)
 I10_DX53                      497- 503 (A)
 I10_DX54                      504- 510 (A)
 I10_DX55                      511- 517 (A)
 I10_DX56                      518- 524 (A)
 I10_DX57                      525- 531 (A)
 I10_DX58                      532- 538 (A)
 I10_DX59                      539- 545 (A)
 I10_DX60                      546- 552 (A)
 I10_NDX                       553- 555
 I10_NPR                       556- 558
 I10_PR1                       559- 565 (A)
 I10_PR2                       566- 572 (A)
 I10_PR3                       573- 579 (A)
 I10_PR4                       580- 586 (A)
 I10_PR5                       587- 593 (A)
 I10_PR6                       594- 600 (A)
 I10_PR7                       601- 607 (A)
 I10_PR8                       608- 614 (A)
 I10_PR9                       615- 621 (A)
 I10_PR10                      622- 628 (A)
 I10_PR11                      629- 635 (A)
 I10_PR12                      636- 642 (A)
 I10_PR13                      643- 649 (A)
 I10_PR14                      650- 656 (A)
 I10_PR15                      657- 663 (A)
 I10_PR16                      664- 670 (A)
 I10_PR17                      671- 677 (A)
 I10_PR18                      678- 684 (A)
 I10_PR19                      685- 691 (A)
 I10_PR20                      692- 698 (A)
 I10_PR21                      699- 705 (A)
 I10_PR22                      706- 712 (A)
 I10_PR23                      713- 719 (A)
 I10_PR24                      720- 726 (A)
 I10_PR25                      727- 733 (A)
 I10_PR26                      734- 740 (A)
 I10_PR27                      741- 747 (A)
 I10_PR28                      748- 754 (A)
 I10_PR29                      755- 761 (A)
 I10_PR30                      762- 768 (A)
 I10_PR31                      769- 775 (A)
 I10_PR32                      776- 782 (A)
 I10_PR33                      783- 789 (A)
 I10_PR34                      790- 796 (A)
 I10_PR35                      797- 803 (A)
 I10_PR36                      804- 810 (A)
 I10_PR37                      811- 817 (A)
 I10_PR38                      818- 824 (A)
 I10_PR39                      825- 831 (A)
 I10_PR40                      832- 838 (A)
 I10_PR41                      839- 845 (A)
 I10_PR42                      846- 852 (A)
 I10_PR43                      853- 859 (A)
 I10_PR44                      860- 866 (A)
 I10_PR45                      867- 873 (A)
 I10_PR46                      874- 880 (A)
 I10_PR47                      881- 887 (A)
 I10_PR48                      888- 894 (A)
 I10_PR49                      895- 901 (A)
 I10_PR50                      902- 908 (A)
 I10_PR51                      909- 915 (A)
 I10_PR52                      916- 922 (A)
 I10_PR53                      923- 929 (A)
 I10_PR54                      930- 936 (A)
 I10_PR55                      937- 943 (A)
 I10_PR56                      944- 950 (A)
 I10_PR57                      951- 957 (A)
 I10_PR58                      958- 964 (A)
 I10_PR59                      965- 971 (A)
 I10_PR60                      972- 978 (A)
 I10_PROCTYPE                  979- 981
 KEY                           982- 996
 LOS                           997-1001
 LOS_X                        1002-1007
 MDC                          1008-1009
 MDC_NoPOA                    1010-1011
 MEDINCSTQ                    1012-1013
 PAY1                         1014-1015
 PAY1_X                       1016     (A)
 PAY2                         1017-1018
 PAY2_X                       1019     (A)
 PL_CBSA                      1020-1022
 PL_NCHS                      1023-1024
 PL_RUCC                      1025-1026
 PL_UIC                       1027-1028
 PL_UR_CAT4                   1029-1030
 POA_Disch_Edit1              1031-1032
 POA_Disch_Edit2              1033-1034
 POA_Hosp_Edit1               1035-1036
 POA_Hosp_Edit2               1037-1038
 POA_Hosp_Edit3               1039-1040
 POA_Hosp_Edit3_Value         1041-1048
 PointOfOrigin_X              1049     (A)
 PointOfOriginUB04            1050     (A)
 PRDAY1                       1051-1055
 PRDAY2                       1056-1060
 PRDAY3                       1061-1065
 PRDAY4                       1066-1070
 PRDAY5                       1071-1075
 PRDAY6                       1076-1080
 PRDAY7                       1081-1085
 PRDAY8                       1086-1090
 PRDAY9                       1091-1095
 PRDAY10                      1096-1100
 PRDAY11                      1101-1105
 PRDAY12                      1106-1110
 PRDAY13                      1111-1115
 PRDAY14                      1116-1120
 PRDAY15                      1121-1125
 PRDAY16                      1126-1130
 PRDAY17                      1131-1135
 PRDAY18                      1136-1140
 PRDAY19                      1141-1145
 PRDAY20                      1146-1150
 PRDAY21                      1151-1155
 PRDAY22                      1156-1160
 PRDAY23                      1161-1165
 PRDAY24                      1166-1170
 PRDAY25                      1171-1175
 PRDAY26                      1176-1180
 PRDAY27                      1181-1185
 PRDAY28                      1186-1190
 PRDAY29                      1191-1195
 PRDAY30                      1196-1200
 PRDAY31                      1201-1205
 PRDAY32                      1206-1210
 PRDAY33                      1211-1215
 PRDAY34                      1216-1220
 PRDAY35                      1221-1225
 PRDAY36                      1226-1230
 PRDAY37                      1231-1235
 PRDAY38                      1236-1240
 PRDAY39                      1241-1245
 PRDAY40                      1246-1250
 PRDAY41                      1251-1255
 PRDAY42                      1256-1260
 PRDAY43                      1261-1265
 PRDAY44                      1266-1270
 PRDAY45                      1271-1275
 PRDAY46                      1276-1280
 PRDAY47                      1281-1285
 PRDAY48                      1286-1290
 PRDAY49                      1291-1295
 PRDAY50                      1296-1300
 PRDAY51                      1301-1305
 PRDAY52                      1306-1310
 PRDAY53                      1311-1315
 PRDAY54                      1316-1320
 PRDAY55                      1321-1325
 PRDAY56                      1326-1330
 PRDAY57                      1331-1335
 PRDAY58                      1336-1340
 PRDAY59                      1341-1345
 PRDAY60                      1346-1350
 PRVER                        1351-1353
 PSTATE                       1354-1355 (A)
 PSTCO2                       1356-1360
 RACE                         1361-1362
 RACE_EDIT                    1363-1364
 RACE_X                       1365-1369 (A)
 TOTCHG                       1370-1379
 TOTCHG_X                     1380-1394
 TRAN_IN                      1395-1396
 TRAN_OUT                     1397-1398
 VisitLink                    1399-1407
 YEAR                         1408-1411
 ZIP                          1412-1416 (A)
 ZIP3                         1417-1419 (A)
 ZIPINC_QRTL                  1420-1422
 HOSPID                       1423-1427
 AYEAR                        1428-1431
 BMONTH                       1432-1433
 BYEAR                        1434-1437
 PRMONTH1                     1438-1439
 PRMONTH2                     1440-1441
 PRMONTH3                     1442-1443
 PRMONTH4                     1444-1445
 PRMONTH5                     1446-1447
 PRMONTH6                     1448-1449
 PRMONTH7                     1450-1451
 PRMONTH8                     1452-1453
 PRMONTH9                     1454-1455
 PRMONTH10                    1456-1457
 PRMONTH11                    1458-1459
 PRMONTH12                    1460-1461
 PRMONTH13                    1462-1463
 PRMONTH14                    1464-1465
 PRMONTH15                    1466-1467
 PRMONTH16                    1468-1469
 PRMONTH17                    1470-1471
 PRMONTH18                    1472-1473
 PRMONTH19                    1474-1475
 PRMONTH20                    1476-1477
 PRMONTH21                    1478-1479
 PRMONTH22                    1480-1481
 PRMONTH23                    1482-1483
 PRMONTH24                    1484-1485
 PRMONTH25                    1486-1487
 PRMONTH26                    1488-1489
 PRMONTH27                    1490-1491
 PRMONTH28                    1492-1493
 PRMONTH29                    1494-1495
 PRMONTH30                    1496-1497
 PRMONTH31                    1498-1499
 PRMONTH32                    1500-1501
 PRMONTH33                    1502-1503
 PRMONTH34                    1504-1505
 PRMONTH35                    1506-1507
 PRMONTH36                    1508-1509
 PRMONTH37                    1510-1511
 PRMONTH38                    1512-1513
 PRMONTH39                    1514-1515
 PRMONTH40                    1516-1517
 PRMONTH41                    1518-1519
 PRMONTH42                    1520-1521
 PRMONTH43                    1522-1523
 PRMONTH44                    1524-1525
 PRMONTH45                    1526-1527
 PRMONTH46                    1528-1529
 PRMONTH47                    1530-1531
 PRMONTH48                    1532-1533
 PRMONTH49                    1534-1535
 PRMONTH50                    1536-1537
 PRMONTH51                    1538-1539
 PRMONTH52                    1540-1541
 PRMONTH53                    1542-1543
 PRMONTH54                    1544-1545
 PRMONTH55                    1546-1547
 PRMONTH56                    1548-1549
 PRMONTH57                    1550-1551
 PRMONTH58                    1552-1553
 PRMONTH59                    1554-1555
 PRMONTH60                    1556-1557
 PRYEAR1                      1558-1561
 PRYEAR2                      1562-1565
 PRYEAR3                      1566-1569
 PRYEAR4                      1570-1573
 PRYEAR5                      1574-1577
 PRYEAR6                      1578-1581
 PRYEAR7                      1582-1585
 PRYEAR8                      1586-1589
 PRYEAR9                      1590-1593
 PRYEAR10                     1594-1597
 PRYEAR11                     1598-1601
 PRYEAR12                     1602-1605
 PRYEAR13                     1606-1609
 PRYEAR14                     1610-1613
 PRYEAR15                     1614-1617
 PRYEAR16                     1618-1621
 PRYEAR17                     1622-1625
 PRYEAR18                     1626-1629
 PRYEAR19                     1630-1633
 PRYEAR20                     1634-1637
 PRYEAR21                     1638-1641
 PRYEAR22                     1642-1645
 PRYEAR23                     1646-1649
 PRYEAR24                     1650-1653
 PRYEAR25                     1654-1657
 PRYEAR26                     1658-1661
 PRYEAR27                     1662-1665
 PRYEAR28                     1666-1669
 PRYEAR29                     1670-1673
 PRYEAR30                     1674-1677
 PRYEAR31                     1678-1681
 PRYEAR32                     1682-1685
 PRYEAR33                     1686-1689
 PRYEAR34                     1690-1693
 PRYEAR35                     1694-1697
 PRYEAR36                     1698-1701
 PRYEAR37                     1702-1705
 PRYEAR38                     1706-1709
 PRYEAR39                     1710-1713
 PRYEAR40                     1714-1717
 PRYEAR41                     1718-1721
 PRYEAR42                     1722-1725
 PRYEAR43                     1726-1729
 PRYEAR44                     1730-1733
 PRYEAR45                     1734-1737
 PRYEAR46                     1738-1741
 PRYEAR47                     1742-1745
 PRYEAR48                     1746-1749
 PRYEAR49                     1750-1753
 PRYEAR50                     1754-1757
 PRYEAR51                     1758-1761
 PRYEAR52                     1762-1765
 PRYEAR53                     1766-1769
 PRYEAR54                     1770-1773
 PRYEAR55                     1774-1777
 PRYEAR56                     1778-1781
 PRYEAR57                     1782-1785
 PRYEAR58                     1786-1789
 PRYEAR59                     1790-1793
 PRYEAR60                     1794-1797.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MEDINCSTQ                    (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PRDAY56                      (F4.0) /
 PRDAY57                      (F4.0) /
 PRDAY58                      (F4.0) /
 PRDAY59                      (F4.0) /
 PRDAY60                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 RACE_EDIT                    (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRMONTH43                    (F3.0) /
 PRMONTH44                    (F3.0) /
 PRMONTH45                    (F3.0) /
 PRMONTH46                    (F3.0) /
 PRMONTH47                    (F3.0) /
 PRMONTH48                    (F3.0) /
 PRMONTH49                    (F3.0) /
 PRMONTH50                    (F3.0) /
 PRMONTH51                    (F3.0) /
 PRMONTH52                    (F3.0) /
 PRMONTH53                    (F3.0) /
 PRMONTH54                    (F3.0) /
 PRMONTH55                    (F3.0) /
 PRMONTH56                    (F3.0) /
 PRMONTH57                    (F3.0) /
 PRMONTH58                    (F3.0) /
 PRMONTH59                    (F3.0) /
 PRMONTH60                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) /
 PRYEAR43                     (F3.0) /
 PRYEAR44                     (F3.0) /
 PRYEAR45                     (F3.0) /
 PRYEAR46                     (F3.0) /
 PRYEAR47                     (F3.0) /
 PRYEAR48                     (F3.0) /
 PRYEAR49                     (F3.0) /
 PRYEAR50                     (F3.0) /
 PRYEAR51                     (F3.0) /
 PRYEAR52                     (F3.0) /
 PRYEAR53                     (F3.0) /
 PRYEAR54                     (F3.0) /
 PRYEAR55                     (F3.0) /
 PRYEAR56                     (F3.0) /
 PRYEAR57                     (F3.0) /
 PRYEAR58                     (F3.0) /
 PRYEAR59                     (F3.0) /
 PRYEAR60                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PR51                     "ICD-10-PCS Procedure 51"
 I10_PR52                     "ICD-10-PCS Procedure 52"
 I10_PR53                     "ICD-10-PCS Procedure 53"
 I10_PR54                     "ICD-10-PCS Procedure 54"
 I10_PR55                     "ICD-10-PCS Procedure 55"
 I10_PR56                     "ICD-10-PCS Procedure 56"
 I10_PR57                     "ICD-10-PCS Procedure 57"
 I10_PR58                     "ICD-10-PCS Procedure 58"
 I10_PR59                     "ICD-10-PCS Procedure 59"
 I10_PR60                     "ICD-10-PCS Procedure 60"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRDAY51                      "Number of days from admission to I10_PR51"
 PRDAY52                      "Number of days from admission to I10_PR52"
 PRDAY53                      "Number of days from admission to I10_PR53"
 PRDAY54                      "Number of days from admission to I10_PR54"
 PRDAY55                      "Number of days from admission to I10_PR55"
 PRDAY56                      "Number of days from admission to I10_PR56"
 PRDAY57                      "Number of days from admission to I10_PR57"
 PRDAY58                      "Number of days from admission to I10_PR58"
 PRDAY59                      "Number of days from admission to I10_PR59"
 PRDAY60                      "Number of days from admission to I10_PR60"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_EDIT                    "Race Edit Checks"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRMONTH43                    "Month of procedure 43"
 PRMONTH44                    "Month of procedure 44"
 PRMONTH45                    "Month of procedure 45"
 PRMONTH46                    "Month of procedure 46"
 PRMONTH47                    "Month of procedure 47"
 PRMONTH48                    "Month of procedure 48"
 PRMONTH49                    "Month of procedure 49"
 PRMONTH50                    "Month of procedure 50"
 PRMONTH51                    "Month of procedure 51"
 PRMONTH52                    "Month of procedure 52"
 PRMONTH53                    "Month of procedure 53"
 PRMONTH54                    "Month of procedure 54"
 PRMONTH55                    "Month of procedure 55"
 PRMONTH56                    "Month of procedure 56"
 PRMONTH57                    "Month of procedure 57"
 PRMONTH58                    "Month of procedure 58"
 PRMONTH59                    "Month of procedure 59"
 PRMONTH60                    "Month of procedure 60"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42"
 PRYEAR43                     "Year of procedure 43"
 PRYEAR44                     "Year of procedure 44"
 PRYEAR45                     "Year of procedure 45"
 PRYEAR46                     "Year of procedure 46"
 PRYEAR47                     "Year of procedure 47"
 PRYEAR48                     "Year of procedure 48"
 PRYEAR49                     "Year of procedure 49"
 PRYEAR50                     "Year of procedure 50"
 PRYEAR51                     "Year of procedure 51"
 PRYEAR52                     "Year of procedure 52"
 PRYEAR53                     "Year of procedure 53"
 PRYEAR54                     "Year of procedure 54"
 PRYEAR55                     "Year of procedure 55"
 PRYEAR56                     "Year of procedure 56"
 PRYEAR57                     "Year of procedure 57"
 PRYEAR58                     "Year of procedure 58"
 PRYEAR59                     "Year of procedure 59"
 PRYEAR60                     "Year of procedure 60" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY56
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY57
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY58
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY59
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY60
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_EDIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH48
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH49
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH50
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH51
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH52
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH53
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH54
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH55
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH56
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH57
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH58
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH59
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH60
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR48
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR49
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR50
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR51
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR52
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR53
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR54
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR55
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR56
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR57
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR58
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR59
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR60
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IN_SID_2017_CORE.SAV' /COMPRESSED.
