/*******************************************************************
* Creation Date: 10/30/2018   
*   MA_SID_2016_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MA_SID_2016_CORE.ASC' FIXED SKIP=2 / 
 ADRG                            1-   3
 ADRGRISKMORTALITY               4-   5
 ADRGSEV                         6-   7
 AGE                             8-  10
 AGEMONTH                       11-  13
 AMDC                           14-  15
 AMONTH                         16-  17
 ASOURCE                        18-  19
 ASOURCE_X                      20     (A)
 ASOURCEUB92                    21     (A)
 ATYPE                          22-  23
 AWEEKEND                       24-  25
 BWT                            26-  29
 DaysBetweenVisits              30-  33
 DaysToEvent                    34-  39
 DIED                           40-  41
 DISP_X                         42-  43 (A)
 DISPUB04                       44-  45
 DISPUNIFORM                    46-  47
 DMONTH                         48-  49
 DNR                            50-  51
 DQTR                           52-  53
 DRG                            54-  56
 DRG_NoPOA                      57-  59
 DRGVER                         60-  61
 DSHOSPID                       62-  78 (A)
 DXPOA1                         79     (A)
 DXPOA2                         80     (A)
 DXPOA3                         81     (A)
 DXPOA4                         82     (A)
 DXPOA5                         83     (A)
 DXPOA6                         84     (A)
 DXPOA7                         85     (A)
 DXPOA8                         86     (A)
 DXPOA9                         87     (A)
 DXPOA10                        88     (A)
 DXPOA11                        89     (A)
 DXPOA12                        90     (A)
 DXPOA13                        91     (A)
 DXPOA14                        92     (A)
 DXPOA15                        93     (A)
 DXPOA16                        94     (A)
 DXPOA17                        95     (A)
 DXPOA18                        96     (A)
 DXPOA19                        97     (A)
 DXPOA20                        98     (A)
 DXPOA21                        99     (A)
 DXPOA22                       100     (A)
 DXPOA23                       101     (A)
 DXPOA24                       102     (A)
 DXPOA25                       103     (A)
 DXPOA26                       104     (A)
 DXPOA27                       105     (A)
 DXPOA28                       106     (A)
 DXPOA29                       107     (A)
 DXPOA30                       108     (A)
 DXPOA31                       109     (A)
 DXPOA32                       110     (A)
 DXPOA33                       111     (A)
 DXPOA34                       112     (A)
 DXPOA35                       113     (A)
 DXPOA36                       114     (A)
 DXPOA37                       115     (A)
 DXPOA38                       116     (A)
 DXPOA39                       117     (A)
 DXPOA40                       118     (A)
 DXPOA41                       119     (A)
 DXPOA42                       120     (A)
 DXPOA43                       121     (A)
 DXPOA44                       122     (A)
 DXPOA45                       123     (A)
 DXPOA46                       124     (A)
 DXPOA47                       125     (A)
 DXPOA48                       126     (A)
 DXPOA49                       127     (A)
 DXPOA50                       128     (A)
 DXPOA51                       129     (A)
 DXPOA52                       130     (A)
 DXPOA53                       131     (A)
 DXPOA54                       132     (A)
 DXPOA55                       133     (A)
 DXPOA56                       134     (A)
 DXPOA57                       135     (A)
 DXPOA58                       136     (A)
 DXPOA59                       137     (A)
 DXPOA60                       138     (A)
 DXPOA61                       139     (A)
 DXPOA62                       140     (A)
 DXPOA63                       141     (A)
 DXPOA64                       142     (A)
 DXPOA65                       143     (A)
 DXPOA66                       144     (A)
 DXPOA67                       145     (A)
 DXPOA68                       146     (A)
 DXPOA69                       147     (A)
 DXPOA70                       148     (A)
 DXPOA71                       149     (A)
 DXVER                         150- 152
 E_POA1                        153     (A)
 E_POA2                        154     (A)
 E_POA3                        155     (A)
 E_POA4                        156     (A)
 E_POA5                        157     (A)
 E_POA6                        158     (A)
 E_POA7                        159     (A)
 E_POA8                        160     (A)
 E_POA9                        161     (A)
 E_POA10                       162     (A)
 E_POA11                       163     (A)
 FEMALE                        164- 165
 HCUP_ED                       166- 167
 HCUP_OS                       168- 169
 HISPANIC                      170- 171
 HISPANIC_X                    172- 186 (A)
 Homeless                      187- 188
 HOSPST                        189- 190 (A)
 I10_DX_Admitting              191- 197 (A)
 I10_DX1                       198- 204 (A)
 I10_DX2                       205- 211 (A)
 I10_DX3                       212- 218 (A)
 I10_DX4                       219- 225 (A)
 I10_DX5                       226- 232 (A)
 I10_DX6                       233- 239 (A)
 I10_DX7                       240- 246 (A)
 I10_DX8                       247- 253 (A)
 I10_DX9                       254- 260 (A)
 I10_DX10                      261- 267 (A)
 I10_DX11                      268- 274 (A)
 I10_DX12                      275- 281 (A)
 I10_DX13                      282- 288 (A)
 I10_DX14                      289- 295 (A)
 I10_DX15                      296- 302 (A)
 I10_DX16                      303- 309 (A)
 I10_DX17                      310- 316 (A)
 I10_DX18                      317- 323 (A)
 I10_DX19                      324- 330 (A)
 I10_DX20                      331- 337 (A)
 I10_DX21                      338- 344 (A)
 I10_DX22                      345- 351 (A)
 I10_DX23                      352- 358 (A)
 I10_DX24                      359- 365 (A)
 I10_DX25                      366- 372 (A)
 I10_DX26                      373- 379 (A)
 I10_DX27                      380- 386 (A)
 I10_DX28                      387- 393 (A)
 I10_DX29                      394- 400 (A)
 I10_DX30                      401- 407 (A)
 I10_DX31                      408- 414 (A)
 I10_DX32                      415- 421 (A)
 I10_DX33                      422- 428 (A)
 I10_DX34                      429- 435 (A)
 I10_DX35                      436- 442 (A)
 I10_DX36                      443- 449 (A)
 I10_DX37                      450- 456 (A)
 I10_DX38                      457- 463 (A)
 I10_DX39                      464- 470 (A)
 I10_DX40                      471- 477 (A)
 I10_DX41                      478- 484 (A)
 I10_DX42                      485- 491 (A)
 I10_DX43                      492- 498 (A)
 I10_DX44                      499- 505 (A)
 I10_DX45                      506- 512 (A)
 I10_DX46                      513- 519 (A)
 I10_DX47                      520- 526 (A)
 I10_DX48                      527- 533 (A)
 I10_DX49                      534- 540 (A)
 I10_DX50                      541- 547 (A)
 I10_DX51                      548- 554 (A)
 I10_DX52                      555- 561 (A)
 I10_DX53                      562- 568 (A)
 I10_DX54                      569- 575 (A)
 I10_DX55                      576- 582 (A)
 I10_DX56                      583- 589 (A)
 I10_DX57                      590- 596 (A)
 I10_DX58                      597- 603 (A)
 I10_DX59                      604- 610 (A)
 I10_DX60                      611- 617 (A)
 I10_DX61                      618- 624 (A)
 I10_DX62                      625- 631 (A)
 I10_DX63                      632- 638 (A)
 I10_DX64                      639- 645 (A)
 I10_DX65                      646- 652 (A)
 I10_DX66                      653- 659 (A)
 I10_DX67                      660- 666 (A)
 I10_DX68                      667- 673 (A)
 I10_DX69                      674- 680 (A)
 I10_DX70                      681- 687 (A)
 I10_DX71                      688- 694 (A)
 I10_ECAUSE1                   695- 701 (A)
 I10_ECAUSE2                   702- 708 (A)
 I10_ECAUSE3                   709- 715 (A)
 I10_ECAUSE4                   716- 722 (A)
 I10_ECAUSE5                   723- 729 (A)
 I10_ECAUSE6                   730- 736 (A)
 I10_ECAUSE7                   737- 743 (A)
 I10_ECAUSE8                   744- 750 (A)
 I10_ECAUSE9                   751- 757 (A)
 I10_ECAUSE10                  758- 764 (A)
 I10_ECAUSE11                  765- 771 (A)
 I10_NDX                       772- 774
 I10_NECAUSE                   775- 776
 I10_NPR                       777- 779
 I10_PR1                       780- 786 (A)
 I10_PR2                       787- 793 (A)
 I10_PR3                       794- 800 (A)
 I10_PR4                       801- 807 (A)
 I10_PR5                       808- 814 (A)
 I10_PR6                       815- 821 (A)
 I10_PR7                       822- 828 (A)
 I10_PR8                       829- 835 (A)
 I10_PR9                       836- 842 (A)
 I10_PR10                      843- 849 (A)
 I10_PR11                      850- 856 (A)
 I10_PR12                      857- 863 (A)
 I10_PR13                      864- 870 (A)
 I10_PR14                      871- 877 (A)
 I10_PR15                      878- 884 (A)
 I10_PR16                      885- 891 (A)
 I10_PR17                      892- 898 (A)
 I10_PR18                      899- 905 (A)
 I10_PR19                      906- 912 (A)
 I10_PR20                      913- 919 (A)
 I10_PR21                      920- 926 (A)
 I10_PR22                      927- 933 (A)
 I10_PR23                      934- 940 (A)
 I10_PR24                      941- 947 (A)
 I10_PR25                      948- 954 (A)
 I10_PR26                      955- 961 (A)
 I10_PR27                      962- 968 (A)
 I10_PR28                      969- 975 (A)
 I10_PR29                      976- 982 (A)
 I10_PR30                      983- 989 (A)
 I10_PR31                      990- 996 (A)
 I10_PR32                      997-1003 (A)
 I10_PR33                     1004-1010 (A)
 I10_PR34                     1011-1017 (A)
 I10_PR35                     1018-1024 (A)
 I10_PR36                     1025-1031 (A)
 I10_PR37                     1032-1038 (A)
 I10_PR38                     1039-1045 (A)
 I10_PR39                     1046-1052 (A)
 I10_PR40                     1053-1059 (A)
 I10_PR41                     1060-1066 (A)
 I10_PR42                     1067-1073 (A)
 I10_PR43                     1074-1080 (A)
 I10_PR44                     1081-1087 (A)
 I10_PR45                     1088-1094 (A)
 I10_PR46                     1095-1101 (A)
 I10_PR47                     1102-1108 (A)
 I10_PR48                     1109-1115 (A)
 I10_PR49                     1116-1122 (A)
 I10_PR50                     1123-1129 (A)
 I10_PR51                     1130-1136 (A)
 I10_PR52                     1137-1143 (A)
 I10_PR53                     1144-1150 (A)
 I10_PR54                     1151-1157 (A)
 I10_PR55                     1158-1164 (A)
 I10_PR56                     1165-1171 (A)
 I10_PR57                     1172-1178 (A)
 I10_PR58                     1179-1185 (A)
 I10_PR59                     1186-1192 (A)
 I10_PR60                     1193-1199 (A)
 I10_PR61                     1200-1206 (A)
 I10_PR62                     1207-1213 (A)
 I10_PR63                     1214-1220 (A)
 I10_PR64                     1221-1227 (A)
 I10_PR65                     1228-1234 (A)
 I10_PR66                     1235-1241 (A)
 I10_PR67                     1242-1248 (A)
 I10_PR68                     1249-1255 (A)
 I10_PR69                     1256-1262 (A)
 I10_PR70                     1263-1269 (A)
 I10_PROCTYPE                 1270-1272
 KEY                          1273-1287
 LOS                          1288-1292
 LOS_X                        1293-1298
 MDC                          1299-1300
 MDC_NoPOA                    1301-1302
 MEDINCSTQ                    1303-1304
 OS_TIME                      1305-1315
 PAY1                         1316-1317
 PAY1_X                       1318     (A)
 PAY2                         1319-1320
 PAY2_X                       1321     (A)
 PAYER1_X                     1322-1324 (A)
 PAYER2_X                     1325-1327 (A)
 PL_CBSA                      1328-1330
 PL_UR_CAT4                   1331-1332
 POA_Disch_Edit1              1333-1334
 POA_Disch_Edit2              1335-1336
 POA_Hosp_Edit1               1337-1338
 POA_Hosp_Edit2               1339-1340
 POA_Hosp_Edit3               1341-1342
 POA_Hosp_Edit3_Value         1343-1350
 PRDAY1                       1351-1355
 PRDAY2                       1356-1360
 PRDAY3                       1361-1365
 PRDAY4                       1366-1370
 PRDAY5                       1371-1375
 PRDAY6                       1376-1380
 PRDAY7                       1381-1385
 PRDAY8                       1386-1390
 PRDAY9                       1391-1395
 PRDAY10                      1396-1400
 PRDAY11                      1401-1405
 PRDAY12                      1406-1410
 PRDAY13                      1411-1415
 PRDAY14                      1416-1420
 PRDAY15                      1421-1425
 PRDAY16                      1426-1430
 PRDAY17                      1431-1435
 PRDAY18                      1436-1440
 PRDAY19                      1441-1445
 PRDAY20                      1446-1450
 PRDAY21                      1451-1455
 PRDAY22                      1456-1460
 PRDAY23                      1461-1465
 PRDAY24                      1466-1470
 PRDAY25                      1471-1475
 PRDAY26                      1476-1480
 PRDAY27                      1481-1485
 PRDAY28                      1486-1490
 PRDAY29                      1491-1495
 PRDAY30                      1496-1500
 PRDAY31                      1501-1505
 PRDAY32                      1506-1510
 PRDAY33                      1511-1515
 PRDAY34                      1516-1520
 PRDAY35                      1521-1525
 PRDAY36                      1526-1530
 PRDAY37                      1531-1535
 PRDAY38                      1536-1540
 PRDAY39                      1541-1545
 PRDAY40                      1546-1550
 PRDAY41                      1551-1555
 PRDAY42                      1556-1560
 PRDAY43                      1561-1565
 PRDAY44                      1566-1570
 PRDAY45                      1571-1575
 PRDAY46                      1576-1580
 PRDAY47                      1581-1585
 PRDAY48                      1586-1590
 PRDAY49                      1591-1595
 PRDAY50                      1596-1600
 PRDAY51                      1601-1605
 PRDAY52                      1606-1610
 PRDAY53                      1611-1615
 PRDAY54                      1616-1620
 PRDAY55                      1621-1625
 PRDAY56                      1626-1630
 PRDAY57                      1631-1635
 PRDAY58                      1636-1640
 PRDAY59                      1641-1645
 PRDAY60                      1646-1650
 PRDAY61                      1651-1655
 PRDAY62                      1656-1660
 PRDAY63                      1661-1665
 PRDAY64                      1666-1670
 PRDAY65                      1671-1675
 PRDAY66                      1676-1680
 PRDAY67                      1681-1685
 PRDAY68                      1686-1690
 PRDAY69                      1691-1695
 PRDAY70                      1696-1700
 PRVER                        1701-1703
 PSTATE                       1704-1705 (A)
 PSTCO2                       1706-1710
 RACE                         1711-1712
 RACE_X                       1713-1725 (A)
 TOTCHG                       1726-1735
 TOTCHG_X                     1736-1750
 TRAN_IN                      1751-1752
 TRAN_OUT                     1753-1754
 VisitLink                    1755-1763
 YEAR                         1764-1767
 ZIP3                         1768-1770 (A)
 ZIPINC_QRTL                  1771-1773
 AYEAR                        1774-1777
 PRMONTH1                     1778-1779
 PRMONTH2                     1780-1781
 PRMONTH3                     1782-1783
 PRMONTH4                     1784-1785
 PRMONTH5                     1786-1787
 PRMONTH6                     1788-1789
 PRMONTH7                     1790-1791
 PRMONTH8                     1792-1793
 PRMONTH9                     1794-1795
 PRMONTH10                    1796-1797
 PRMONTH11                    1798-1799
 PRMONTH12                    1800-1801
 PRMONTH13                    1802-1803
 PRMONTH14                    1804-1805
 PRMONTH15                    1806-1807
 PRMONTH16                    1808-1809
 PRMONTH17                    1810-1811
 PRMONTH18                    1812-1813
 PRMONTH19                    1814-1815
 PRMONTH20                    1816-1817
 PRMONTH21                    1818-1819
 PRMONTH22                    1820-1821
 PRMONTH23                    1822-1823
 PRMONTH24                    1824-1825
 PRMONTH25                    1826-1827
 PRMONTH26                    1828-1829
 PRMONTH27                    1830-1831
 PRMONTH28                    1832-1833
 PRMONTH29                    1834-1835
 PRMONTH30                    1836-1837
 PRMONTH31                    1838-1839
 PRMONTH32                    1840-1841
 PRMONTH33                    1842-1843
 PRMONTH34                    1844-1845
 PRMONTH35                    1846-1847
 PRMONTH36                    1848-1849
 PRMONTH37                    1850-1851
 PRMONTH38                    1852-1853
 PRMONTH39                    1854-1855
 PRMONTH40                    1856-1857
 PRMONTH41                    1858-1859
 PRMONTH42                    1860-1861
 PRMONTH43                    1862-1863
 PRMONTH44                    1864-1865
 PRMONTH45                    1866-1867
 PRMONTH46                    1868-1869
 PRMONTH47                    1870-1871
 PRMONTH48                    1872-1873
 PRMONTH49                    1874-1875
 PRMONTH50                    1876-1877
 PRMONTH51                    1878-1879
 PRMONTH52                    1880-1881
 PRMONTH53                    1882-1883
 PRMONTH54                    1884-1885
 PRMONTH55                    1886-1887
 PRMONTH56                    1888-1889
 PRMONTH57                    1890-1891
 PRMONTH58                    1892-1893
 PRMONTH59                    1894-1895
 PRMONTH60                    1896-1897
 PRMONTH61                    1898-1899
 PRMONTH62                    1900-1901
 PRMONTH63                    1902-1903
 PRMONTH64                    1904-1905
 PRMONTH65                    1906-1907
 PRMONTH66                    1908-1909
 PRMONTH67                    1910-1911
 PRMONTH68                    1912-1913
 PRMONTH69                    1914-1915
 PRMONTH70                    1916-1917
 PRYEAR1                      1918-1921
 PRYEAR2                      1922-1925
 PRYEAR3                      1926-1929
 PRYEAR4                      1930-1933
 PRYEAR5                      1934-1937
 PRYEAR6                      1938-1941
 PRYEAR7                      1942-1945
 PRYEAR8                      1946-1949
 PRYEAR9                      1950-1953
 PRYEAR10                     1954-1957
 PRYEAR11                     1958-1961
 PRYEAR12                     1962-1965
 PRYEAR13                     1966-1969
 PRYEAR14                     1970-1973
 PRYEAR15                     1974-1977
 PRYEAR16                     1978-1981
 PRYEAR17                     1982-1985
 PRYEAR18                     1986-1989
 PRYEAR19                     1990-1993
 PRYEAR20                     1994-1997
 PRYEAR21                     1998-2001
 PRYEAR22                     2002-2005
 PRYEAR23                     2006-2009
 PRYEAR24                     2010-2013
 PRYEAR25                     2014-2017
 PRYEAR26                     2018-2021
 PRYEAR27                     2022-2025
 PRYEAR28                     2026-2029
 PRYEAR29                     2030-2033
 PRYEAR30                     2034-2037
 PRYEAR31                     2038-2041
 PRYEAR32                     2042-2045
 PRYEAR33                     2046-2049
 PRYEAR34                     2050-2053
 PRYEAR35                     2054-2057
 PRYEAR36                     2058-2061
 PRYEAR37                     2062-2065
 PRYEAR38                     2066-2069
 PRYEAR39                     2070-2073
 PRYEAR40                     2074-2077
 PRYEAR41                     2078-2081
 PRYEAR42                     2082-2085
 PRYEAR43                     2086-2089
 PRYEAR44                     2090-2093
 PRYEAR45                     2094-2097
 PRYEAR46                     2098-2101
 PRYEAR47                     2102-2105
 PRYEAR48                     2106-2109
 PRYEAR49                     2110-2113
 PRYEAR50                     2114-2117
 PRYEAR51                     2118-2121
 PRYEAR52                     2122-2125
 PRYEAR53                     2126-2129
 PRYEAR54                     2130-2133
 PRYEAR55                     2134-2137
 PRYEAR56                     2138-2141
 PRYEAR57                     2142-2145
 PRYEAR58                     2146-2149
 PRYEAR59                     2150-2153
 PRYEAR60                     2154-2157
 PRYEAR61                     2158-2161
 PRYEAR62                     2162-2165
 PRYEAR63                     2166-2169
 PRYEAR64                     2170-2173
 PRYEAR65                     2174-2177
 PRYEAR66                     2178-2181
 PRYEAR67                     2182-2185
 PRYEAR68                     2186-2189
 PRYEAR69                     2190-2193
 PRYEAR70                     2194-2197.


***  Specify write formats  ***.
FORMATS
 ADRG                         (F3.0) /
 ADRGRISKMORTALITY            (F3.0) /
 ADRGSEV                      (F3.0) /
 AGE                          (F3.0) /
 AGEMONTH                     (F3.0) /
 AMDC                         (F3.0) /
 AMONTH                       (F3.0) /
 ASOURCE                      (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysBetweenVisits            (F3.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DNR                          (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MEDINCSTQ                    (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PRDAY56                      (F4.0) /
 PRDAY57                      (F4.0) /
 PRDAY58                      (F4.0) /
 PRDAY59                      (F4.0) /
 PRDAY60                      (F4.0) /
 PRDAY61                      (F4.0) /
 PRDAY62                      (F4.0) /
 PRDAY63                      (F4.0) /
 PRDAY64                      (F4.0) /
 PRDAY65                      (F4.0) /
 PRDAY66                      (F4.0) /
 PRDAY67                      (F4.0) /
 PRDAY68                      (F4.0) /
 PRDAY69                      (F4.0) /
 PRDAY70                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRMONTH43                    (F3.0) /
 PRMONTH44                    (F3.0) /
 PRMONTH45                    (F3.0) /
 PRMONTH46                    (F3.0) /
 PRMONTH47                    (F3.0) /
 PRMONTH48                    (F3.0) /
 PRMONTH49                    (F3.0) /
 PRMONTH50                    (F3.0) /
 PRMONTH51                    (F3.0) /
 PRMONTH52                    (F3.0) /
 PRMONTH53                    (F3.0) /
 PRMONTH54                    (F3.0) /
 PRMONTH55                    (F3.0) /
 PRMONTH56                    (F3.0) /
 PRMONTH57                    (F3.0) /
 PRMONTH58                    (F3.0) /
 PRMONTH59                    (F3.0) /
 PRMONTH60                    (F3.0) /
 PRMONTH61                    (F3.0) /
 PRMONTH62                    (F3.0) /
 PRMONTH63                    (F3.0) /
 PRMONTH64                    (F3.0) /
 PRMONTH65                    (F3.0) /
 PRMONTH66                    (F3.0) /
 PRMONTH67                    (F3.0) /
 PRMONTH68                    (F3.0) /
 PRMONTH69                    (F3.0) /
 PRMONTH70                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) /
 PRYEAR43                     (F3.0) /
 PRYEAR44                     (F3.0) /
 PRYEAR45                     (F3.0) /
 PRYEAR46                     (F3.0) /
 PRYEAR47                     (F3.0) /
 PRYEAR48                     (F3.0) /
 PRYEAR49                     (F3.0) /
 PRYEAR50                     (F3.0) /
 PRYEAR51                     (F3.0) /
 PRYEAR52                     (F3.0) /
 PRYEAR53                     (F3.0) /
 PRYEAR54                     (F3.0) /
 PRYEAR55                     (F3.0) /
 PRYEAR56                     (F3.0) /
 PRYEAR57                     (F3.0) /
 PRYEAR58                     (F3.0) /
 PRYEAR59                     (F3.0) /
 PRYEAR60                     (F3.0) /
 PRYEAR61                     (F3.0) /
 PRYEAR62                     (F3.0) /
 PRYEAR63                     (F3.0) /
 PRYEAR64                     (F3.0) /
 PRYEAR65                     (F3.0) /
 PRYEAR66                     (F3.0) /
 PRYEAR67                     (F3.0) /
 PRYEAR68                     (F3.0) /
 PRYEAR69                     (F3.0) /
 PRYEAR70                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 ADRG                         "All Patient Refined DRG"
 ADRGRISKMORTALITY            "All Patient Refined DRG mortality risk"
 ADRGSEV                      "All Patient Refined DRG severity level"
 AGE                          "Age in years at admission"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMDC                         "All Patient Refined MDC"
 AMONTH                       "Admission month"
 ASOURCE                      "Admission source (uniform)"
 ASOURCE_X                    "Admission source (as received from source)"
 ASOURCEUB92                  "Admission source (UB-92 standard coding)"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DaysBetweenVisits            "Number of days between visits"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DNR                          "Do not resuscitate indicator"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 DXPOA71                      "Diagnosis 71, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "External cause 1, present on admission indicator"
 E_POA2                       "External cause 2, present on admission indicator"
 E_POA3                       "External cause 3, present on admission indicator"
 E_POA4                       "External cause 4, present on admission indicator"
 E_POA5                       "External cause 5, present on admission indicator"
 E_POA6                       "External cause 6, present on admission indicator"
 E_POA7                       "External cause 7, present on admission indicator"
 E_POA8                       "External cause 8, present on admission indicator"
 E_POA9                       "External cause 9, present on admission indicator"
 E_POA10                      "External cause 10, present on admission indicator"
 E_POA11                      "External cause 11, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_DX71                     "ICD-10-CM Diagnosis 71"
 I10_ECAUSE1                  "ICD-10-CM External cause 1"
 I10_ECAUSE2                  "ICD-10-CM External cause 2"
 I10_ECAUSE3                  "ICD-10-CM External cause 3"
 I10_ECAUSE4                  "ICD-10-CM External cause 4"
 I10_ECAUSE5                  "ICD-10-CM External cause 5"
 I10_ECAUSE6                  "ICD-10-CM External cause 6"
 I10_ECAUSE7                  "ICD-10-CM External cause 7"
 I10_ECAUSE8                  "ICD-10-CM External cause 8"
 I10_ECAUSE9                  "ICD-10-CM External cause 9"
 I10_ECAUSE10                 "ICD-10-CM External cause 10"
 I10_ECAUSE11                 "ICD-10-CM External cause 11"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of External cause codes on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PR51                     "ICD-10-PCS Procedure 51"
 I10_PR52                     "ICD-10-PCS Procedure 52"
 I10_PR53                     "ICD-10-PCS Procedure 53"
 I10_PR54                     "ICD-10-PCS Procedure 54"
 I10_PR55                     "ICD-10-PCS Procedure 55"
 I10_PR56                     "ICD-10-PCS Procedure 56"
 I10_PR57                     "ICD-10-PCS Procedure 57"
 I10_PR58                     "ICD-10-PCS Procedure 58"
 I10_PR59                     "ICD-10-PCS Procedure 59"
 I10_PR60                     "ICD-10-PCS Procedure 60"
 I10_PR61                     "ICD-10-PCS Procedure 61"
 I10_PR62                     "ICD-10-PCS Procedure 62"
 I10_PR63                     "ICD-10-PCS Procedure 63"
 I10_PR64                     "ICD-10-PCS Procedure 64"
 I10_PR65                     "ICD-10-PCS Procedure 65"
 I10_PR66                     "ICD-10-PCS Procedure 66"
 I10_PR67                     "ICD-10-PCS Procedure 67"
 I10_PR68                     "ICD-10-PCS Procedure 68"
 I10_PR69                     "ICD-10-PCS Procedure 69"
 I10_PR70                     "ICD-10-PCS Procedure 70"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAYER1_X                     "Primary expected payer plan identifier (as received from source)"
 PAYER2_X                     "Secondary expected payer plan identifier (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRDAY51                      "Number of days from admission to I10_PR51"
 PRDAY52                      "Number of days from admission to I10_PR52"
 PRDAY53                      "Number of days from admission to I10_PR53"
 PRDAY54                      "Number of days from admission to I10_PR54"
 PRDAY55                      "Number of days from admission to I10_PR55"
 PRDAY56                      "Number of days from admission to I10_PR56"
 PRDAY57                      "Number of days from admission to I10_PR57"
 PRDAY58                      "Number of days from admission to I10_PR58"
 PRDAY59                      "Number of days from admission to I10_PR59"
 PRDAY60                      "Number of days from admission to I10_PR60"
 PRDAY61                      "Number of days from admission to I10_PR61"
 PRDAY62                      "Number of days from admission to I10_PR62"
 PRDAY63                      "Number of days from admission to I10_PR63"
 PRDAY64                      "Number of days from admission to I10_PR64"
 PRDAY65                      "Number of days from admission to I10_PR65"
 PRDAY66                      "Number of days from admission to I10_PR66"
 PRDAY67                      "Number of days from admission to I10_PR67"
 PRDAY68                      "Number of days from admission to I10_PR68"
 PRDAY69                      "Number of days from admission to I10_PR69"
 PRDAY70                      "Number of days from admission to I10_PR70"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRMONTH43                    "Month of procedure 43"
 PRMONTH44                    "Month of procedure 44"
 PRMONTH45                    "Month of procedure 45"
 PRMONTH46                    "Month of procedure 46"
 PRMONTH47                    "Month of procedure 47"
 PRMONTH48                    "Month of procedure 48"
 PRMONTH49                    "Month of procedure 49"
 PRMONTH50                    "Month of procedure 50"
 PRMONTH51                    "Month of procedure 51"
 PRMONTH52                    "Month of procedure 52"
 PRMONTH53                    "Month of procedure 53"
 PRMONTH54                    "Month of procedure 54"
 PRMONTH55                    "Month of procedure 55"
 PRMONTH56                    "Month of procedure 56"
 PRMONTH57                    "Month of procedure 57"
 PRMONTH58                    "Month of procedure 58"
 PRMONTH59                    "Month of procedure 59"
 PRMONTH60                    "Month of procedure 60"
 PRMONTH61                    "Month of procedure 61"
 PRMONTH62                    "Month of procedure 62"
 PRMONTH63                    "Month of procedure 63"
 PRMONTH64                    "Month of procedure 64"
 PRMONTH65                    "Month of procedure 65"
 PRMONTH66                    "Month of procedure 66"
 PRMONTH67                    "Month of procedure 67"
 PRMONTH68                    "Month of procedure 68"
 PRMONTH69                    "Month of procedure 69"
 PRMONTH70                    "Month of procedure 70"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42"
 PRYEAR43                     "Year of procedure 43"
 PRYEAR44                     "Year of procedure 44"
 PRYEAR45                     "Year of procedure 45"
 PRYEAR46                     "Year of procedure 46"
 PRYEAR47                     "Year of procedure 47"
 PRYEAR48                     "Year of procedure 48"
 PRYEAR49                     "Year of procedure 49"
 PRYEAR50                     "Year of procedure 50"
 PRYEAR51                     "Year of procedure 51"
 PRYEAR52                     "Year of procedure 52"
 PRYEAR53                     "Year of procedure 53"
 PRYEAR54                     "Year of procedure 54"
 PRYEAR55                     "Year of procedure 55"
 PRYEAR56                     "Year of procedure 56"
 PRYEAR57                     "Year of procedure 57"
 PRYEAR58                     "Year of procedure 58"
 PRYEAR59                     "Year of procedure 59"
 PRYEAR60                     "Year of procedure 60"
 PRYEAR61                     "Year of procedure 61"
 PRYEAR62                     "Year of procedure 62"
 PRYEAR63                     "Year of procedure 63"
 PRYEAR64                     "Year of procedure 64"
 PRYEAR65                     "Year of procedure 65"
 PRYEAR66                     "Year of procedure 66"
 PRYEAR67                     "Year of procedure 67"
 PRYEAR68                     "Year of procedure 68"
 PRYEAR69                     "Year of procedure 69"
 PRYEAR70                     "Year of procedure 70" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE ADRG
 (-99,-88,-66,-55=SYSMIS).
RECODE ADRGRISKMORTALITY
 (-9,-8,-6,-5=SYSMIS).
RECODE ADRGSEV
 (-9,-8,-6,-5=SYSMIS).
RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMDC
 (-9,-8,-6,-5=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBetweenVisits
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY56
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY57
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY58
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY59
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY60
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY61
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY62
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY63
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY64
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY65
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY66
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY67
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY68
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY69
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY70
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH48
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH49
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH50
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH51
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH52
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH53
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH54
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH55
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH56
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH57
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH58
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH59
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH60
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH61
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH62
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH63
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH64
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH65
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH66
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH67
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH68
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH69
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH70
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR48
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR49
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR50
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR51
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR52
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR53
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR54
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR55
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR56
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR57
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR58
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR59
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR60
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR61
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR62
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR63
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR64
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR65
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR66
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR67
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR68
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR69
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR70
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MA_SID_2016_CORE.SAV' /COMPRESSED.
