/*******************************************************************
* Creation Date: 05/17/2016   
*   MD_SID_2014_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MD_SID_2014_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 BODYSYSTEM1                     1-   2
 BODYSYSTEM2                     3-   4
 BODYSYSTEM3                     5-   6
 BODYSYSTEM4                     7-   8
 BODYSYSTEM5                     9-  10
 BODYSYSTEM6                    11-  12
 BODYSYSTEM7                    13-  14
 BODYSYSTEM8                    15-  16
 BODYSYSTEM9                    17-  18
 BODYSYSTEM10                   19-  20
 BODYSYSTEM11                   21-  22
 BODYSYSTEM12                   23-  24
 BODYSYSTEM13                   25-  26
 BODYSYSTEM14                   27-  28
 BODYSYSTEM15                   29-  30
 BODYSYSTEM16                   31-  32
 BODYSYSTEM17                   33-  34
 BODYSYSTEM18                   35-  36
 BODYSYSTEM19                   37-  38
 BODYSYSTEM20                   39-  40
 BODYSYSTEM21                   41-  42
 BODYSYSTEM22                   43-  44
 BODYSYSTEM23                   45-  46
 BODYSYSTEM24                   47-  48
 BODYSYSTEM25                   49-  50
 BODYSYSTEM26                   51-  52
 BODYSYSTEM27                   53-  54
 BODYSYSTEM28                   55-  56
 BODYSYSTEM29                   57-  58
 BODYSYSTEM30                   59-  60
 CHRON1                         61-  62
 CHRON2                         63-  64
 CHRON3                         65-  66
 CHRON4                         67-  68
 CHRON5                         69-  70
 CHRON6                         71-  72
 CHRON7                         73-  74
 CHRON8                         75-  76
 CHRON9                         77-  78
 CHRON10                        79-  80
 CHRON11                        81-  82
 CHRON12                        83-  84
 CHRON13                        85-  86
 CHRON14                        87-  88
 CHRON15                        89-  90
 CHRON16                        91-  92
 CHRON17                        93-  94
 CHRON18                        95-  96
 CHRON19                        97-  98
 CHRON20                        99- 100
 CHRON21                       101- 102
 CHRON22                       103- 104
 CHRON23                       105- 106
 CHRON24                       107- 108
 CHRON25                       109- 110
 CHRON26                       111- 112
 CHRON27                       113- 114
 CHRON28                       115- 116
 CHRON29                       117- 118
 CHRON30                       119- 120
 DXMCCS1                       121- 131 (A)
 DXMCCS2                       132- 142 (A)
 DXMCCS3                       143- 153 (A)
 DXMCCS4                       154- 164 (A)
 DXMCCS5                       165- 175 (A)
 DXMCCS6                       176- 186 (A)
 DXMCCS7                       187- 197 (A)
 DXMCCS8                       198- 208 (A)
 DXMCCS9                       209- 219 (A)
 DXMCCS10                      220- 230 (A)
 DXMCCS11                      231- 241 (A)
 DXMCCS12                      242- 252 (A)
 DXMCCS13                      253- 263 (A)
 DXMCCS14                      264- 274 (A)
 DXMCCS15                      275- 285 (A)
 DXMCCS16                      286- 296 (A)
 DXMCCS17                      297- 307 (A)
 DXMCCS18                      308- 318 (A)
 DXMCCS19                      319- 329 (A)
 DXMCCS20                      330- 340 (A)
 DXMCCS21                      341- 351 (A)
 DXMCCS22                      352- 362 (A)
 DXMCCS23                      363- 373 (A)
 DXMCCS24                      374- 384 (A)
 DXMCCS25                      385- 395 (A)
 DXMCCS26                      396- 406 (A)
 DXMCCS27                      407- 417 (A)
 DXMCCS28                      418- 428 (A)
 DXMCCS29                      429- 439 (A)
 DXMCCS30                      440- 450 (A)
 E_MCCS1                       451- 461 (A)
 E_MCCS2                       462- 472 (A)
 E_MCCS3                       473- 483 (A)
 E_MCCS4                       484- 494 (A)
 E_MCCS5                       495- 505 (A)
 E_MCCS6                       506- 516 (A)
 E_MCCS7                       517- 527 (A)
 E_MCCS8                       528- 538 (A)
 INJURY                        539- 540
 INJURY_CUT                    541- 542
 INJURY_DROWN                  543- 544
 INJURY_FALL                   545- 546
 INJURY_FIRE                   547- 548
 INJURY_FIREARM                549- 550
 INJURY_MACHINERY              551- 552
 INJURY_MVT                    553- 554
 INJURY_NATURE                 555- 556
 INJURY_POISON                 557- 558
 INJURY_STRUCK                 559- 560
 INJURY_SUFFOCATION            561- 562
 INTENT_ASSAULT                563- 564
 INTENT_SELF_HARM              565- 566
 INTENT_UNINTENTIONAL          567- 568
 KEY                           569- 583
 MULTINJURY                    584- 585
 PCLASS1                       586- 587
 PCLASS2                       588- 589
 PCLASS3                       590- 591
 PCLASS4                       592- 593
 PCLASS5                       594- 595
 PCLASS6                       596- 597
 PCLASS7                       598- 599
 PCLASS8                       600- 601
 PCLASS9                       602- 603
 PCLASS10                      604- 605
 PCLASS11                      606- 607
 PCLASS12                      608- 609
 PCLASS13                      610- 611
 PCLASS14                      612- 613
 PCLASS15                      614- 615
 PCLASS16                      616- 617
 PCLASS17                      618- 619
 PCLASS18                      620- 621
 PCLASS19                      622- 623
 PCLASS20                      624- 625
 PCLASS21                      626- 627
 PCLASS22                      628- 629
 PCLASS23                      630- 631
 PCLASS24                      632- 633
 PCLASS25                      634- 635
 PCLASS26                      636- 637
 PCLASS27                      638- 639
 PCLASS28                      640- 641
 PCLASS29                      642- 643
 PCLASS30                      644- 645
 PRMCCS1                       646- 653 (A)
 PRMCCS2                       654- 661 (A)
 PRMCCS3                       662- 669 (A)
 PRMCCS4                       670- 677 (A)
 PRMCCS5                       678- 685 (A)
 PRMCCS6                       686- 693 (A)
 PRMCCS7                       694- 701 (A)
 PRMCCS8                       702- 709 (A)
 PRMCCS9                       710- 717 (A)
 PRMCCS10                      718- 725 (A)
 PRMCCS11                      726- 733 (A)
 PRMCCS12                      734- 741 (A)
 PRMCCS13                      742- 749 (A)
 PRMCCS14                      750- 757 (A)
 PRMCCS15                      758- 765 (A)
 PRMCCS16                      766- 773 (A)
 PRMCCS17                      774- 781 (A)
 PRMCCS18                      782- 789 (A)
 PRMCCS19                      790- 797 (A)
 PRMCCS20                      798- 805 (A)
 PRMCCS21                      806- 813 (A)
 PRMCCS22                      814- 821 (A)
 PRMCCS23                      822- 829 (A)
 PRMCCS24                      830- 837 (A)
 PRMCCS25                      838- 845 (A)
 PRMCCS26                      846- 853 (A)
 PRMCCS27                      854- 861 (A)
 PRMCCS28                      862- 869 (A)
 PRMCCS29                      870- 877 (A)
 PRMCCS30                      878- 885 (A)
 U_BLOOD                       886- 887
 U_CATH                        888- 889
 U_CCU                         890- 891
 U_CHESTXRAY                   892- 893
 U_CTSCAN                      894- 895
 U_DIALYSIS                    896- 897
 U_ECHO                        898- 899
 U_ED                          900- 901
 U_EEG                         902- 903
 U_EKG                         904- 905
 U_EPO                         906- 907
 U_ICU                         908- 909
 U_LITHOTRIPSY                 910- 911
 U_MHSA                        912- 913
 U_MRT                         914- 915
 U_NEWBN2L                     916- 917
 U_NEWBN3L                     918- 919
 U_NEWBN4L                     920- 921
 U_NUCMED                      922- 923
 U_OBSERVATION                 924- 925
 U_OCCTHERAPY                  926- 927
 U_ORGANACQ                    928- 929
 U_OTHIMPLANTS                 930- 931
 U_PACEMAKER                   932- 933
 U_PHYTHERAPY                  934- 935
 U_RADTHERAPY                  936- 937
 U_RESPTHERAPY                 938- 939
 U_SPEECHTHERAPY               940- 941
 U_STRESS                      942- 943
 U_ULTRASOUND                  944- 945.


***  Specify write formats  ***.
FORMATS
 BODYSYSTEM1                  (F3.0) /
 BODYSYSTEM2                  (F3.0) /
 BODYSYSTEM3                  (F3.0) /
 BODYSYSTEM4                  (F3.0) /
 BODYSYSTEM5                  (F3.0) /
 BODYSYSTEM6                  (F3.0) /
 BODYSYSTEM7                  (F3.0) /
 BODYSYSTEM8                  (F3.0) /
 BODYSYSTEM9                  (F3.0) /
 BODYSYSTEM10                 (F3.0) /
 BODYSYSTEM11                 (F3.0) /
 BODYSYSTEM12                 (F3.0) /
 BODYSYSTEM13                 (F3.0) /
 BODYSYSTEM14                 (F3.0) /
 BODYSYSTEM15                 (F3.0) /
 BODYSYSTEM16                 (F3.0) /
 BODYSYSTEM17                 (F3.0) /
 BODYSYSTEM18                 (F3.0) /
 BODYSYSTEM19                 (F3.0) /
 BODYSYSTEM20                 (F3.0) /
 BODYSYSTEM21                 (F3.0) /
 BODYSYSTEM22                 (F3.0) /
 BODYSYSTEM23                 (F3.0) /
 BODYSYSTEM24                 (F3.0) /
 BODYSYSTEM25                 (F3.0) /
 BODYSYSTEM26                 (F3.0) /
 BODYSYSTEM27                 (F3.0) /
 BODYSYSTEM28                 (F3.0) /
 BODYSYSTEM29                 (F3.0) /
 BODYSYSTEM30                 (F3.0) /
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 PCLASS26                     (F3.0) /
 PCLASS27                     (F3.0) /
 PCLASS28                     (F3.0) /
 PCLASS29                     (F3.0) /
 PCLASS30                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 BODYSYSTEM1                  "Body system 1"
 BODYSYSTEM2                  "Body system 2"
 BODYSYSTEM3                  "Body system 3"
 BODYSYSTEM4                  "Body system 4"
 BODYSYSTEM5                  "Body system 5"
 BODYSYSTEM6                  "Body system 6"
 BODYSYSTEM7                  "Body system 7"
 BODYSYSTEM8                  "Body system 8"
 BODYSYSTEM9                  "Body system 9"
 BODYSYSTEM10                 "Body system 10"
 BODYSYSTEM11                 "Body system 11"
 BODYSYSTEM12                 "Body system 12"
 BODYSYSTEM13                 "Body system 13"
 BODYSYSTEM14                 "Body system 14"
 BODYSYSTEM15                 "Body system 15"
 BODYSYSTEM16                 "Body system 16"
 BODYSYSTEM17                 "Body system 17"
 BODYSYSTEM18                 "Body system 18"
 BODYSYSTEM19                 "Body system 19"
 BODYSYSTEM20                 "Body system 20"
 BODYSYSTEM21                 "Body system 21"
 BODYSYSTEM22                 "Body system 22"
 BODYSYSTEM23                 "Body system 23"
 BODYSYSTEM24                 "Body system 24"
 BODYSYSTEM25                 "Body system 25"
 BODYSYSTEM26                 "Body system 26"
 BODYSYSTEM27                 "Body system 27"
 BODYSYSTEM28                 "Body system 28"
 BODYSYSTEM29                 "Body system 29"
 BODYSYSTEM30                 "Body system 30"
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PCLASS26                     "Procedure class 26"
 PCLASS27                     "Procedure class 27"
 PCLASS28                     "Procedure class 28"
 PCLASS29                     "Procedure class 29"
 PCLASS30                     "Procedure class 30"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 PRMCCS26                     "Multi-Level CCS:  Procedure 26"
 PRMCCS27                     "Multi-Level CCS:  Procedure 27"
 PRMCCS28                     "Multi-Level CCS:  Procedure 28"
 PRMCCS29                     "Multi-Level CCS:  Procedure 29"
 PRMCCS30                     "Multi-Level CCS:  Procedure 30"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Magnetic Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM22
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM23
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM24
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM25
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM26
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM27
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM28
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM29
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MD_SID_2014_DX_PR_GRPS.SAV' /COMPRESSED.
