/*******************************************************************
*   ME_SID_2010_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'ME_SID_2010_CHGS.ASC' FIXED / 
 KEY                        1-  15
 NREVCD                    16-  17
 REVCD1                    18-  21 (A)
 REVCD2                    22-  25 (A)
 REVCD3                    26-  29 (A)
 REVCD4                    30-  33 (A)
 REVCD5                    34-  37 (A)
 REVCD6                    38-  41 (A)
 REVCD7                    42-  45 (A)
 REVCD8                    46-  49 (A)
 REVCD9                    50-  53 (A)
 REVCD10                   54-  57 (A)
 REVCD11                   58-  61 (A)
 REVCD12                   62-  65 (A)
 REVCD13                   66-  69 (A)
 REVCD14                   70-  73 (A)
 REVCD15                   74-  77 (A)
 REVCD16                   78-  81 (A)
 REVCD17                   82-  85 (A)
 REVCD18                   86-  89 (A)
 REVCD19                   90-  93 (A)
 REVCD20                   94-  97 (A)
 REVCD21                   98- 101 (A)
 REVCD22                  102- 105 (A)
 REVCD23                  106- 109 (A)
 REVCD24                  110- 113 (A)
 REVCD25                  114- 117 (A)
 REVCD26                  118- 121 (A)
 REVCD27                  122- 125 (A)
 REVCD28                  126- 129 (A)
 REVCD29                  130- 133 (A)
 REVCD30                  134- 137 (A)
 REVCD31                  138- 141 (A)
 REVCD32                  142- 145 (A)
 REVCD33                  146- 149 (A).


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 NREVCD                  (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY                     "HCUP record identifier"
 NREVCD                  "Number of revenue codes for this discharge"
 REVCD1                  "Revenue code 1 (as received from source)"
 REVCD2                  "Revenue code 2 (as received from source)"
 REVCD3                  "Revenue code 3 (as received from source)"
 REVCD4                  "Revenue code 4 (as received from source)"
 REVCD5                  "Revenue code 5 (as received from source)"
 REVCD6                  "Revenue code 6 (as received from source)"
 REVCD7                  "Revenue code 7 (as received from source)"
 REVCD8                  "Revenue code 8 (as received from source)"
 REVCD9                  "Revenue code 9 (as received from source)"
 REVCD10                 "Revenue code 10 (as received from source)"
 REVCD11                 "Revenue code 11 (as received from source)"
 REVCD12                 "Revenue code 12 (as received from source)"
 REVCD13                 "Revenue code 13 (as received from source)"
 REVCD14                 "Revenue code 14 (as received from source)"
 REVCD15                 "Revenue code 15 (as received from source)"
 REVCD16                 "Revenue code 16 (as received from source)"
 REVCD17                 "Revenue code 17 (as received from source)"
 REVCD18                 "Revenue code 18 (as received from source)"
 REVCD19                 "Revenue code 19 (as received from source)"
 REVCD20                 "Revenue code 20 (as received from source)"
 REVCD21                 "Revenue code 21 (as received from source)"
 REVCD22                 "Revenue code 22 (as received from source)"
 REVCD23                 "Revenue code 23 (as received from source)"
 REVCD24                 "Revenue code 24 (as received from source)"
 REVCD25                 "Revenue code 25 (as received from source)"
 REVCD26                 "Revenue code 26 (as received from source)"
 REVCD27                 "Revenue code 27 (as received from source)"
 REVCD28                 "Revenue code 28 (as received from source)"
 REVCD29                 "Revenue code 29 (as received from source)"
 REVCD30                 "Revenue code 30 (as received from source)"
 REVCD31                 "Revenue code 31 (as received from source)"
 REVCD32                 "Revenue code 32 (as received from source)"
 REVCD33                 "Revenue code 33 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE NREVCD
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'ME_SID_2010_CHGS.SAV' /COMPRESSED.
