/*******************************************************************
*   NY_SID_1994_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NY_SID_1994_CORE.ASC' FIXED / 
 SEQ_SID               1-  13
 AGE                  14-  16
 AGEDAY               17-  19
 SEX                  20-  22
 RACE                 23-  24
 DQTR                 25-  26
 LOS                  27-  31
 DISP                 32-  33
 DIED                 34-  35
 ATYPE                36-  37
 ASOURCE              38-  39
 NDX                  40-  41
 DX1                  42-  46 (A)
 DXV1                 47-  50
 DCCHPR1              51-  54
 NPR                  55-  56
 PR1                  57-  60 (A)
 PRV1                 61-  63
 PCCHPR1              64-  67
 DRG                  68-  70
 MDC                  71-  72
 DRGVER               73-  74
 DRG10                75-  77
 MDC10                78-  79
 PAY1                 80-  81
 TOTCHG               82-  91
 PROCESS              92- 102
 YEAR                103- 106
 DSHOSPID            107- 119 (A)
 DSNUM               120- 122
 DSTYPE              123- 125
 HOSPST              126- 127 (A)
 MDID_S              128- 143 (A)
 SURGID_S            144- 159 (A)
 ADAYWK              160- 162
 AMONTH              163- 164
 LOS_X               165- 169
 NEOMAT              170- 171
 DXSYS               172- 174
 DSNDX               175- 177
 PRSYS               178- 180
 DSNPR               181- 183
 PRDAY1              184- 188
 PAY1_N              189- 191
 PAY2                192- 193
 PAY2_N              194- 196
 TOTCHG_X            197- 208
 DX2                 209- 213 (A)
 DX3                 214- 218 (A)
 DX4                 219- 223 (A)
 DX5                 224- 228 (A)
 DX6                 229- 233 (A)
 DX7                 234- 238 (A)
 DX8                 239- 243 (A)
 DX9                 244- 248 (A)
 DX10                249- 253 (A)
 DX11                254- 258 (A)
 DX12                259- 263 (A)
 DX13                264- 268 (A)
 DX14                269- 273 (A)
 DX15                274- 278 (A)
 DX16                279- 283 (A)
 DX17                284- 288 (A)
 DXV2                289- 292
 DXV3                293- 296
 DXV4                297- 300
 DXV5                301- 304
 DXV6                305- 308
 DXV7                309- 312
 DXV8                313- 316
 DXV9                317- 320
 DXV10               321- 324
 DXV11               325- 328
 DXV12               329- 332
 DXV13               333- 336
 DXV14               337- 340
 DXV15               341- 344
 DXV16               345- 348
 DXV17               349- 352
 DCCHPR2             353- 356
 DCCHPR3             357- 360
 DCCHPR4             361- 364
 DCCHPR5             365- 368
 DCCHPR6             369- 372
 DCCHPR7             373- 376
 DCCHPR8             377- 380
 DCCHPR9             381- 384
 DCCHPR10            385- 388
 DCCHPR11            389- 392
 DCCHPR12            393- 396
 DCCHPR13            397- 400
 DCCHPR14            401- 404
 DCCHPR15            405- 408
 DCCHPR16            409- 412
 DCCHPR17            413- 416
 PR2                 417- 420 (A)
 PR3                 421- 424 (A)
 PR4                 425- 428 (A)
 PR5                 429- 432 (A)
 PR6                 433- 436 (A)
 PR7                 437- 440 (A)
 PR8                 441- 444 (A)
 PR9                 445- 448 (A)
 PR10                449- 452 (A)
 PR11                453- 456 (A)
 PR12                457- 460 (A)
 PR13                461- 464 (A)
 PR14                465- 468 (A)
 PR15                469- 472 (A)
 PRV2                473- 475
 PRV3                476- 478
 PRV4                479- 481
 PRV5                482- 484
 PRV6                485- 487
 PRV7                488- 490
 PRV8                491- 493
 PRV9                494- 496
 PRV10               497- 499
 PRV11               500- 502
 PRV12               503- 505
 PRV13               506- 508
 PRV14               509- 511
 PRV15               512- 514
 PCCHPR2             515- 518
 PCCHPR3             519- 522
 PCCHPR4             523- 526
 PCCHPR5             527- 530
 PCCHPR6             531- 534
 PCCHPR7             535- 538
 PCCHPR8             539- 542
 PCCHPR9             543- 546
 PCCHPR10            547- 550
 PCCHPR11            551- 554
 PCCHPR12            555- 558
 PCCHPR13            559- 562
 PCCHPR14            563- 566
 PCCHPR15            567- 570
 PRDAY2              571- 575
 PRDAY3              576- 580
 PRDAY4              581- 585
 PRDAY5              586- 590
 PRDAY6              591- 595
 PRDAY7              596- 600
 PRDAY8              601- 605
 PRDAY9              606- 610
 PRDAY10             611- 615
 PRDAY11             616- 620
 PRDAY12             621- 625
 PRDAY13             626- 630
 PRDAY14             631- 635
 PRDAY15             636- 640
 ZIP                 641- 645 (A)
 PSTCO               646- 650
 BWT                 651- 654
 TMDX1               655- 656
 TMDX2               657- 658
 TMDX3               659- 660
 TMDX4               661- 662
 TMDX5               663- 664
 TMDX6               665- 666
 TMDX7               667- 668
 TMDX8               669- 670
 TMDX9               671- 672
 TMDX10              673- 674
 TMDX11              675- 676
 TMDX12              677- 678
 TMDX13              679- 680
 TMDX14              681- 682
 TMDX15              683- 684
 PAY1_X              685- 686 (A)
 PAY2_X              687- 688 (A)
 AYEAR               689- 692
 DMONTH              693- 694
 BMONTH              695- 696
 BYEAR               697- 700.


***  Specify write formats  ***.
FORMATS
 SEQ_SID             (F7.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 PROCESS             (F6.0) /
 YEAR                (F3.0) /
 DSNUM               (F3.0) /
 DSTYPE              (F3.0) /
 ADAYWK              (F3.0) /
 AMONTH              (F3.0) /
 LOS_X               (F4.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F4.0) /
 PAY1_N              (F3.0) /
 PAY2                (F3.0) /
 PAY2_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DXV11               (F3.0) /
 DXV12               (F3.0) /
 DXV13               (F3.0) /
 DXV14               (F3.0) /
 DXV15               (F3.0) /
 DXV16               (F3.0) /
 DXV17               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 DCCHPR11            (F3.0) /
 DCCHPR12            (F3.0) /
 DCCHPR13            (F3.0) /
 DCCHPR14            (F3.0) /
 DCCHPR15            (F3.0) /
 DCCHPR16            (F3.0) /
 DCCHPR17            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PRV7                (F3.0) /
 PRV8                (F3.0) /
 PRV9                (F3.0) /
 PRV10               (F3.0) /
 PRV11               (F3.0) /
 PRV12               (F3.0) /
 PRV13               (F3.0) /
 PRV14               (F3.0) /
 PRV15               (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PCCHPR7             (F3.0) /
 PCCHPR8             (F3.0) /
 PCCHPR9             (F3.0) /
 PCCHPR10            (F3.0) /
 PCCHPR11            (F3.0) /
 PCCHPR12            (F3.0) /
 PCCHPR13            (F3.0) /
 PCCHPR14            (F3.0) /
 PCCHPR15            (F3.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 PSTCO               (F5.0) /
 BWT                 (F4.0) /
 TMDX1               (F3.0) /
 TMDX2               (F3.0) /
 TMDX3               (F3.0) /
 TMDX4               (F3.0) /
 TMDX5               (F3.0) /
 TMDX6               (F3.0) /
 TMDX7               (F3.0) /
 TMDX8               (F3.0) /
 TMDX9               (F3.0) /
 TMDX10              (F3.0) /
 TMDX11              (F3.0) /
 TMDX12              (F3.0) /
 TMDX13              (F3.0) /
 TMDX14              (F3.0) /
 TMDX15              (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 SEQ_SID   "I:HCUP-3 SID record sequence number"
 AGE       "I:Age in years at admission"
 AGEDAY    "I:Age in days (when < 1 year)"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSNUM     "I:Data source ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 ADAYWK    "I:Admission day of week"
 AMONTH    "I:Admission month"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 PAY2      "I:Secondary expected payer, uniform"
 PAY2_N    "I:Secondary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DX11      "I:Diagnosis 11"
 DX12      "I:Diagnosis 12"
 DX13      "I:Diagnosis 13"
 DX14      "I:Diagnosis 14"
 DX15      "I:Diagnosis 15"
 DX16      "I:Diagnosis 16"
 DX17      "I:Diagnosis 17"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DXV11     "I:Validity flag: diagnosis 11"
 DXV12     "I:Validity flag: diagnosis 12"
 DXV13     "I:Validity flag: diagnosis 13"
 DXV14     "I:Validity flag: diagnosis 14"
 DXV15     "I:Validity flag: diagnosis 15"
 DXV16     "I:Validity flag: diagnosis 16"
 DXV17     "I:Validity flag: diagnosis 17"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 DCCHPR11  "I:CCHPR: diagnosis 11"
 DCCHPR12  "I:CCHPR: diagnosis 12"
 DCCHPR13  "I:CCHPR: diagnosis 13"
 DCCHPR14  "I:CCHPR: diagnosis 14"
 DCCHPR15  "I:CCHPR: diagnosis 15"
 DCCHPR16  "I:CCHPR: diagnosis 16"
 DCCHPR17  "I:CCHPR: diagnosis 17"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PR11      "I:Procedure 11"
 PR12      "I:Procedure 12"
 PR13      "I:Procedure 13"
 PR14      "I:Procedure 14"
 PR15      "I:Procedure 15"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PRV11     "I:Validity flag: procedure 11"
 PRV12     "I:Validity flag: procedure 12"
 PRV13     "I:Validity flag: procedure 13"
 PRV14     "I:Validity flag: procedure 14"
 PRV15     "I:Validity flag: procedure 15"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 PCCHPR11  "I:CCHPR: procedure 11"
 PCCHPR12  "I:CCHPR: procedure 12"
 PCCHPR13  "I:CCHPR: procedure 13"
 PCCHPR14  "I:CCHPR: procedure 14"
 PCCHPR15  "I:CCHPR: procedure 15"
 PRDAY2    "I:No. of days from admission to PR2"
 PRDAY3    "I:No. of days from admission to PR3"
 PRDAY4    "I:No. of days from admission to PR4"
 PRDAY5    "I:No. of days from admission to PR5"
 PRDAY6    "I:No. of days from admission to PR6"
 PRDAY7    "I:No. of days from admission to PR7"
 PRDAY8    "I:No. of days from admission to PR8"
 PRDAY9    "I:No. of days from admission to PR9"
 PRDAY10   "I:No. of days from admission to PR10"
 PRDAY11   "I:No. of days from admission to PR11"
 PRDAY12   "I:No. of days from admission to PR12"
 PRDAY13   "I:No. of days from admission to PR13"
 PRDAY14   "I:No. of days from admission to PR14"
 PRDAY15   "I:No. of days from admission to PR15"
 ZIP       "I:Patient zip code"
 PSTCO     "I:Patient state/county FIPS code"
 BWT       "I:Birthweight in grams"
 TMDX1     "I:Time of onset: principal diagnosis"
 TMDX2     "I:Time of onset: diagnosis 2"
 TMDX3     "I:Time of onset: diagnosis 3"
 TMDX4     "I:Time of onset: diagnosis 4"
 TMDX5     "I:Time of onset: diagnosis 5"
 TMDX6     "I:Time of onset: diagnosis 6"
 TMDX7     "I:Time of onset: diagnosis 7"
 TMDX8     "I:Time of onset: diagnosis 8"
 TMDX9     "I:Time of onset: diagnosis 9"
 TMDX10    "I:Time of onset: diagnosis 10"
 TMDX11    "I:Time of onset: diagnosis 11"
 TMDX12    "I:Time of onset: diagnosis 12"
 TMDX13    "I:Time of onset: diagnosis 13"
 TMDX14    "I:Time of onset: diagnosis 14"
 TMDX15    "I:Time of onset: diagnosis 15"
 PAY1_X    "I:Primary exp. payer (from data source)"
 PAY2_X    "I:Secondary exp. payer (from data source"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSNUM
 (-99,-88,-66,-55=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE ADAYWK
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV17
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR16
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV15
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE TMDX1
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX2
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX3
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX4
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX5
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX6
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX7
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX8
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX9
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX10
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX11
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX12
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX13
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX14
 (-9,-8,-6,-5=SYSMIS).
RECODE TMDX15
 (-9,-8,-6,-5=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NY_SID_1994_CORE.SAV' /COMPRESSED.
