/*******************************************************************
*   RI_SID_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'RI_SID_2007_CORE.ASC' FIXED / 
 AGE                        1-   3
 AMONTH                     4-   5
 ASOURCE                    6-   7
 ASOURCEU                   8     (A)
 ASOURCE_                   9-  16 (A)
 ATYPE                     17-  18
 AWEEKEND                  19-  20
 BWT                       21-  24
 CPT1                      25-  29 (A)
 CPT2                      30-  34 (A)
 CPT3                      35-  39 (A)
 CPT4                      40-  44 (A)
 CPT5                      45-  49 (A)
 CPT6                      50-  54 (A)
 CPT7                      55-  59 (A)
 CPT8                      60-  64 (A)
 CPT9                      65-  69 (A)
 CPT10                     70-  74 (A)
 CPT11                     75-  79 (A)
 CPTDAY1                   80-  82
 CPTDAY2                   83-  85
 CPTDAY3                   86-  88
 CPTDAY4                   89-  91
 CPTDAY5                   92-  94
 CPTDAY6                   95-  97
 CPTDAY7                   98- 100
 CPTDAY8                  101- 103
 CPTDAY9                  104- 106
 CPTDAY10                 107- 109
 CPTDAY11                 110- 112
 DIED                     113- 114
 DISPUB04                 115- 116
 DISPUNIF                 117- 118
 DISP_X                   119- 126 (A)
 DQTR                     127- 128
 DRG                      129- 131
 DRG24                    132- 134
 DRGVER                   135- 136
 DSHOSPID                 137- 149 (A)
 DX1                      150- 154 (A)
 DX2                      155- 159 (A)
 DX3                      160- 164 (A)
 DX4                      165- 169 (A)
 DX5                      170- 174 (A)
 DX6                      175- 179 (A)
 DX7                      180- 184 (A)
 DX8                      185- 189 (A)
 DX9                      190- 194 (A)
 DX10                     195- 199 (A)
 DX11                     200- 204 (A)
 DX12                     205- 209 (A)
 DX13                     210- 214 (A)
 DX14                     215- 219 (A)
 DX15                     220- 224 (A)
 DX16                     225- 229 (A)
 DX17                     230- 234 (A)
 DX18                     235- 239 (A)
 DX19                     240- 244 (A)
 DX20                     245- 249 (A)
 DX21                     250- 254 (A)
 DX22                     255- 259 (A)
 DX23                     260- 264 (A)
 DX24                     265- 269 (A)
 DX25                     270- 274 (A)
 DXCCS1                   275- 278
 DXCCS2                   279- 282
 DXCCS3                   283- 286
 DXCCS4                   287- 290
 DXCCS5                   291- 294
 DXCCS6                   295- 298
 DXCCS7                   299- 302
 DXCCS8                   303- 306
 DXCCS9                   307- 310
 DXCCS10                  311- 314
 DXCCS11                  315- 318
 DXCCS12                  319- 322
 DXCCS13                  323- 326
 DXCCS14                  327- 330
 DXCCS15                  331- 334
 DXCCS16                  335- 338
 DXCCS17                  339- 342
 DXCCS18                  343- 346
 DXCCS19                  347- 350
 DXCCS20                  351- 354
 DXCCS21                  355- 358
 DXCCS22                  359- 362
 DXCCS23                  363- 366
 DXCCS24                  367- 370
 DXCCS25                  371- 374
 DaysCCU                  375- 377
 DaysICU                  378- 380
 DaysNICU                 381- 383
 ECODE1                   384- 388 (A)
 ECODE2                   389- 393 (A)
 ECODE3                   394- 398 (A)
 ECODE4                   399- 403 (A)
 ECODE5                   404- 408 (A)
 ECODE6                   409- 413 (A)
 ECODE7                   414- 418 (A)
 ECODE8                   419- 423 (A)
 E_CCS1                   424- 427
 E_CCS2                   428- 431
 E_CCS3                   432- 435
 E_CCS4                   436- 439
 E_CCS5                   440- 443
 E_CCS6                   444- 447
 E_CCS7                   448- 451
 E_CCS8                   452- 455
 FEMALE                   456- 457
 HCUP_ED                  458- 459
 HCUP_OS                  460- 461
 HISPANIC                 462- 469 (A)
 HOSPBRTH                 470- 472
 HOSPST                   473- 474 (A)
 KEY                      475- 488
 LOS                      489- 493
 LOS_X                    494- 499
 MDC                      500- 501
 MDC24                    502- 503
 MDNUM1_R                 504- 512
 MDNUM2_R                 513- 521
 MDNUM3_R                 522- 530
 MEDINCST                 531- 532
 NCPT                     533- 535
 NDX                      536- 537
 NECODE                   538- 539
 NEOMAT                   540- 541
 NPR                      542- 543
 OBSERVAT                 544- 547
 PAY1                     548- 549
 PAY1_X                   550- 555 (A)
 PL_CBSA                  556- 558
 PL_MSA19                 559- 561
 PL_NCHS2                 562- 563
 PL_RUCA1                 564- 565
 PL_RUCA2                 566- 569
 PL_RUCA4                 570- 571
 PL_RUCC2                 572- 573
 PL_UIC20                 574- 575
 PL_UR_CA                 576- 577
 PR1                      578- 581 (A)
 PR2                      582- 585 (A)
 PR3                      586- 589 (A)
 PR4                      590- 593 (A)
 PR5                      594- 597 (A)
 PR6                      598- 601 (A)
 PR7                      602- 605 (A)
 PR8                      606- 609 (A)
 PR9                      610- 613 (A)
 PR10                     614- 617 (A)
 PR11                     618- 621 (A)
 PR12                     622- 625 (A)
 PR13                     626- 629 (A)
 PR14                     630- 633 (A)
 PR15                     634- 637 (A)
 PR16                     638- 641 (A)
 PR17                     642- 645 (A)
 PR18                     646- 649 (A)
 PR19                     650- 653 (A)
 PR20                     654- 657 (A)
 PR21                     658- 661 (A)
 PR22                     662- 665 (A)
 PR23                     666- 669 (A)
 PR24                     670- 673 (A)
 PR25                     674- 677 (A)
 PRCCS1                   678- 680
 PRCCS2                   681- 683
 PRCCS3                   684- 686
 PRCCS4                   687- 689
 PRCCS5                   690- 692
 PRCCS6                   693- 695
 PRCCS7                   696- 698
 PRCCS8                   699- 701
 PRCCS9                   702- 704
 PRCCS10                  705- 707
 PRCCS11                  708- 710
 PRCCS12                  711- 713
 PRCCS13                  714- 716
 PRCCS14                  717- 719
 PRCCS15                  720- 722
 PRCCS16                  723- 725
 PRCCS17                  726- 728
 PRCCS18                  729- 731
 PRCCS19                  732- 734
 PRCCS20                  735- 737
 PRCCS21                  738- 740
 PRCCS22                  741- 743
 PRCCS23                  744- 746
 PRCCS24                  747- 749
 PRCCS25                  750- 752
 PRDAY1                   753- 757
 PRDAY2                   758- 762
 PRDAY3                   763- 767
 PRDAY4                   768- 772
 PRDAY5                   773- 777
 PRDAY6                   778- 782
 PRDAY7                   783- 787
 PRDAY8                   788- 792
 PRDAY9                   793- 797
 PRDAY10                  798- 802
 PRDAY11                  803- 807
 PRDAY12                  808- 812
 PRDAY13                  813- 817
 PRDAY14                  818- 822
 PRDAY15                  823- 827
 PRDAY16                  828- 832
 PRDAY17                  833- 837
 PRDAY18                  838- 842
 PRDAY19                  843- 847
 PRDAY20                  848- 852
 PRDAY21                  853- 857
 PRDAY22                  858- 862
 PRDAY23                  863- 867
 PRDAY24                  868- 872
 PRDAY25                  873- 877
 PROCTYPE                 878- 880
 PSTATE                   881- 882 (A)
 PSTCO                    883- 887
 PSTCO2                   888- 892
 POFOUB04                 893     (A)
 POFO_X                   894- 901 (A)
 RACE                     902- 903
 RACE_X                   904- 911 (A)
 TOTCHG                   912- 921
 TOTCHG_X                 922- 936
 YEAR                     937- 940
 ZIPINC_Q                 941- 943
 TOWN                     944- 945 (A)
 ZIP                      946- 950 (A)
 AYEAR                    951- 954
 DMONTH                   955- 956
 PRMNTH1                  957- 958
 PRMNTH2                  959- 960
 PRMNTH3                  961- 962
 PRMNTH4                  963- 964
 PRMNTH5                  965- 966
 PRMNTH6                  967- 968
 PRMNTH7                  969- 970
 PRMNTH8                  971- 972
 PRMNTH9                  973- 974
 PRMNTH10                 975- 976
 PRMNTH11                 977- 978
 PRMNTH12                 979- 980
 PRMNTH13                 981- 982
 PRMNTH14                 983- 984
 PRMNTH15                 985- 986
 PRMNTH16                 987- 988
 PRMNTH17                 989- 990
 PRMNTH18                 991- 992
 PRMNTH19                 993- 994
 PRMNTH20                 995- 996
 PRMNTH21                 997- 998
 PRMNTH22                 999-1000
 PRMNTH23                1001-1002
 PRMNTH24                1003-1004
 PRMNTH25                1005-1006
 PRYEAR1                 1007-1010
 PRYEAR2                 1011-1014
 PRYEAR3                 1015-1018
 PRYEAR4                 1019-1022
 PRYEAR5                 1023-1026
 PRYEAR6                 1027-1030
 PRYEAR7                 1031-1034
 PRYEAR8                 1035-1038
 PRYEAR9                 1039-1042
 PRYEAR10                1043-1046
 PRYEAR11                1047-1050
 PRYEAR12                1051-1054
 PRYEAR13                1055-1058
 PRYEAR14                1059-1062
 PRYEAR15                1063-1066
 PRYEAR16                1067-1070
 PRYEAR17                1071-1074
 PRYEAR18                1075-1078
 PRYEAR19                1079-1082
 PRYEAR20                1083-1086
 PRYEAR21                1087-1090
 PRYEAR22                1091-1094
 PRYEAR23                1095-1098
 PRYEAR24                1099-1102
 PRYEAR25                1103-1106.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DaysCCU                 (F3.0) /
 DaysICU                 (F3.0) /
 DaysNICU                (F3.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MDNUM3_R                (F5.0) /
 MEDINCST                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 OBSERVAT                (F4.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRMNTH16                (F3.0) /
 PRMNTH17                (F3.0) /
 PRMNTH18                (F3.0) /
 PRMNTH19                (F3.0) /
 PRMNTH20                (F3.0) /
 PRMNTH21                (F3.0) /
 PRMNTH22                (F3.0) /
 PRMNTH23                (F3.0) /
 PRMNTH24                (F3.0) /
 PRMNTH25                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BWT       "Birth weight in grams"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPTDAY1   "Number of days from admission to CPT1"
 CPTDAY2   "Number of days from admission to CPT2"
 CPTDAY3   "Number of days from admission to CPT3"
 CPTDAY4   "Number of days from admission to CPT4"
 CPTDAY5   "Number of days from admission to CPT5"
 CPTDAY6   "Number of days from admission to CPT6"
 CPTDAY7   "Number of days from admission to CPT7"
 CPTDAY8   "Number of days from admission to CPT8"
 CPTDAY9   "Number of days from admission to CPT9"
 CPTDAY10  "Number of days from admission to CPT10"
 CPTDAY11  "Number of days from admission to CPT11"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DaysCCU   "Days in coronary care unit (as received from source)"
 DaysICU   "Days in medical/surgical intensive care unit (as received from source)"
 DaysNICU  "Days in neonetal care unit (as received from source)"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC24     "MDC, version 24"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MDNUM3_R  "Physician 3 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 OBSERVAT  "Time for observation services (as received from source)"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PRDAY21   "Number of days from admission to PR21"
 PRDAY22   "Number of days from admission to PR22"
 PRDAY23   "Number of days from admission to PR23"
 PRDAY24   "Number of days from admission to PR24"
 PRDAY25   "Number of days from admission to PR25"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 POFO_X    "Point of origin for admission or visit, as received from source"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 TOWN      "Patient town of residence (as received from source)"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRMNTH19  "Month of procedure 19"
 PRMNTH20  "Month of procedure 20"
 PRMNTH21  "Month of procedure 21"
 PRMNTH22  "Month of procedure 22"
 PRMNTH23  "Month of procedure 23"
 PRMNTH24  "Month of procedure 24"
 PRMNTH25  "Month of procedure 25"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18"
 PRYEAR19  "Year of procedure 19"
 PRYEAR20  "Year of procedure 20"
 PRYEAR21  "Year of procedure 21"
 PRYEAR22  "Year of procedure 22"
 PRYEAR23  "Year of procedure 23"
 PRYEAR24  "Year of procedure 24"
 PRYEAR25  "Year of procedure 25" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysNICU
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE OBSERVAT
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'RI_SID_2007_CORE.SAV' /COMPRESSED.
