/*******************************************************************
* Creation Date: 11/13/2017   
*   RI_SID_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'RI_SID_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AHOUR                           4-   7
 AMONTH                          8-   9
 ATYPE                          10-  11
 AWEEKEND                       12-  13
 BWT                            14-  17
 CPT1                           18-  22 (A)
 CPT2                           23-  27 (A)
 CPT3                           28-  32 (A)
 CPT4                           33-  37 (A)
 CPT5                           38-  42 (A)
 CPT6                           43-  47 (A)
 CPT7                           48-  52 (A)
 CPT8                           53-  57 (A)
 CPT9                           58-  62 (A)
 CPT10                          63-  67 (A)
 CPT11                          68-  72 (A)
 CPTCCS1                        73-  75
 CPTCCS2                        76-  78
 CPTCCS3                        79-  81
 CPTCCS4                        82-  84
 CPTCCS5                        85-  87
 CPTCCS6                        88-  90
 CPTCCS7                        91-  93
 CPTCCS8                        94-  96
 CPTCCS9                        97-  99
 CPTCCS10                      100- 102
 CPTCCS11                      103- 105
 CPTDAY1                       106- 108
 CPTDAY2                       109- 111
 CPTDAY3                       112- 114
 CPTDAY4                       115- 117
 CPTDAY5                       118- 120
 CPTDAY6                       121- 123
 CPTDAY7                       124- 126
 CPTDAY8                       127- 129
 CPTDAY9                       130- 132
 CPTDAY10                      133- 135
 CPTDAY11                      136- 138
 DaysCCU                       139- 141
 DaysICU                       142- 144
 DaysNICU                      145- 147
 DHOUR                         148- 151
 DIED                          152- 153
 DISP_X                        154- 155 (A)
 DISPUB04                      156- 157
 DISPUNIFORM                   158- 159
 DMONTH                        160- 161
 DQTR                          162- 163
 DRG                           164- 166
 DRG_NoPOA                     167- 169
 DRG32                         170- 172
 DRGVER                        173- 174
 DSHOSPID                      175- 191 (A)
 DXPOA1                        192     (A)
 DXPOA2                        193     (A)
 DXPOA3                        194     (A)
 DXPOA4                        195     (A)
 DXPOA5                        196     (A)
 DXPOA6                        197     (A)
 DXPOA7                        198     (A)
 DXPOA8                        199     (A)
 DXPOA9                        200     (A)
 DXPOA10                       201     (A)
 DXPOA11                       202     (A)
 DXPOA12                       203     (A)
 DXPOA13                       204     (A)
 DXPOA14                       205     (A)
 DXPOA15                       206     (A)
 DXPOA16                       207     (A)
 DXPOA17                       208     (A)
 DXPOA18                       209     (A)
 DXPOA19                       210     (A)
 DXPOA20                       211     (A)
 DXPOA21                       212     (A)
 DXPOA22                       213     (A)
 DXPOA23                       214     (A)
 DXPOA24                       215     (A)
 DXPOA25                       216     (A)
 DXVER                         217- 219
 E_POA1                        220     (A)
 E_POA2                        221     (A)
 E_POA3                        222     (A)
 E_POA4                        223     (A)
 E_POA5                        224     (A)
 E_POA6                        225     (A)
 E_POA7                        226     (A)
 E_POA8                        227     (A)
 E_POA9                        228     (A)
 E_POA10                       229     (A)
 E_POA11                       230     (A)
 E_POA12                       231     (A)
 FEMALE                        232- 233
 HCUP_ED                       234- 235
 HCUP_OS                       236- 237
 HISPANIC                      238- 239
 HISPANIC_X                    240- 243 (A)
 HOSPST                        244- 245 (A)
 I10_DX_Admitting              246- 252 (A)
 I10_DX1                       253- 259 (A)
 I10_DX2                       260- 266 (A)
 I10_DX3                       267- 273 (A)
 I10_DX4                       274- 280 (A)
 I10_DX5                       281- 287 (A)
 I10_DX6                       288- 294 (A)
 I10_DX7                       295- 301 (A)
 I10_DX8                       302- 308 (A)
 I10_DX9                       309- 315 (A)
 I10_DX10                      316- 322 (A)
 I10_DX11                      323- 329 (A)
 I10_DX12                      330- 336 (A)
 I10_DX13                      337- 343 (A)
 I10_DX14                      344- 350 (A)
 I10_DX15                      351- 357 (A)
 I10_DX16                      358- 364 (A)
 I10_DX17                      365- 371 (A)
 I10_DX18                      372- 378 (A)
 I10_DX19                      379- 385 (A)
 I10_DX20                      386- 392 (A)
 I10_DX21                      393- 399 (A)
 I10_DX22                      400- 406 (A)
 I10_DX23                      407- 413 (A)
 I10_DX24                      414- 420 (A)
 I10_DX25                      421- 427 (A)
 I10_DXCCS1                    428- 431
 I10_DXCCS2                    432- 435
 I10_DXCCS3                    436- 439
 I10_DXCCS4                    440- 443
 I10_DXCCS5                    444- 447
 I10_DXCCS6                    448- 451
 I10_DXCCS7                    452- 455
 I10_DXCCS8                    456- 459
 I10_DXCCS9                    460- 463
 I10_DXCCS10                   464- 467
 I10_DXCCS11                   468- 471
 I10_DXCCS12                   472- 475
 I10_DXCCS13                   476- 479
 I10_DXCCS14                   480- 483
 I10_DXCCS15                   484- 487
 I10_DXCCS16                   488- 491
 I10_DXCCS17                   492- 495
 I10_DXCCS18                   496- 499
 I10_DXCCS19                   500- 503
 I10_DXCCS20                   504- 507
 I10_DXCCS21                   508- 511
 I10_DXCCS22                   512- 515
 I10_DXCCS23                   516- 519
 I10_DXCCS24                   520- 523
 I10_DXCCS25                   524- 527
 I10_ECAUSE1                   528- 534 (A)
 I10_ECAUSE2                   535- 541 (A)
 I10_ECAUSE3                   542- 548 (A)
 I10_ECAUSE4                   549- 555 (A)
 I10_ECAUSE5                   556- 562 (A)
 I10_ECAUSE6                   563- 569 (A)
 I10_ECAUSE7                   570- 576 (A)
 I10_ECAUSE8                   577- 583 (A)
 I10_ECAUSE9                   584- 590 (A)
 I10_ECAUSE10                  591- 597 (A)
 I10_ECAUSE11                  598- 604 (A)
 I10_ECAUSE12                  605- 611 (A)
 I10_ECauseCCS1                612- 615
 I10_ECauseCCS2                616- 619
 I10_ECauseCCS3                620- 623
 I10_ECauseCCS4                624- 627
 I10_ECauseCCS5                628- 631
 I10_ECauseCCS6                632- 635
 I10_ECauseCCS7                636- 639
 I10_ECauseCCS8                640- 643
 I10_ECauseCCS9                644- 647
 I10_ECauseCCS10               648- 651
 I10_ECauseCCS11               652- 655
 I10_ECauseCCS12               656- 659
 I10_HOSPBRTH                  660- 662
 I10_NCHRONIC                  663- 665
 I10_NDX                       666- 668
 I10_NECAUSE                   669- 670
 I10_NEOMAT                    671- 672
 I10_NPR                       673- 675
 I10_ORPROC                    676- 677
 I10_PR1                       678- 684 (A)
 I10_PR2                       685- 691 (A)
 I10_PR3                       692- 698 (A)
 I10_PR4                       699- 705 (A)
 I10_PR5                       706- 712 (A)
 I10_PR6                       713- 719 (A)
 I10_PR7                       720- 726 (A)
 I10_PR8                       727- 733 (A)
 I10_PR9                       734- 740 (A)
 I10_PR10                      741- 747 (A)
 I10_PR11                      748- 754 (A)
 I10_PR12                      755- 761 (A)
 I10_PR13                      762- 768 (A)
 I10_PR14                      769- 775 (A)
 I10_PR15                      776- 782 (A)
 I10_PR16                      783- 789 (A)
 I10_PR17                      790- 796 (A)
 I10_PR18                      797- 803 (A)
 I10_PR19                      804- 810 (A)
 I10_PR20                      811- 817 (A)
 I10_PR21                      818- 824 (A)
 I10_PR22                      825- 831 (A)
 I10_PR23                      832- 838 (A)
 I10_PR24                      839- 845 (A)
 I10_PR25                      846- 852 (A)
 I10_PRCCS1                    853- 855
 I10_PRCCS2                    856- 858
 I10_PRCCS3                    859- 861
 I10_PRCCS4                    862- 864
 I10_PRCCS5                    865- 867
 I10_PRCCS6                    868- 870
 I10_PRCCS7                    871- 873
 I10_PRCCS8                    874- 876
 I10_PRCCS9                    877- 879
 I10_PRCCS10                   880- 882
 I10_PRCCS11                   883- 885
 I10_PRCCS12                   886- 888
 I10_PRCCS13                   889- 891
 I10_PRCCS14                   892- 894
 I10_PRCCS15                   895- 897
 I10_PRCCS16                   898- 900
 I10_PRCCS17                   901- 903
 I10_PRCCS18                   904- 906
 I10_PRCCS19                   907- 909
 I10_PRCCS20                   910- 912
 I10_PRCCS21                   913- 915
 I10_PRCCS22                   916- 918
 I10_PRCCS23                   919- 921
 I10_PRCCS24                   922- 924
 I10_PRCCS25                   925- 927
 I10_PROCTYPE                  928- 930
 I10_SERVICELINE               931- 932
 KEY                           933- 947
 LOS                           948- 952
 LOS_X                         953- 958
 MDC                           959- 960
 MDC_NoPOA                     961- 962
 MDC32                         963- 964
 MDNUM1_R                      965- 973
 MDNUM2_R                      974- 982
 MDNUM3_R                      983- 991
 MEDINCSTQ                     992- 993
 NCPT                          994- 997
 OBSERVATION                   998-1001
 PAY1                         1002-1003
 PAY1_X                       1004-1014 (A)
 PL_CBSA                      1015-1017
 PL_NCHS                      1018-1019
 PL_RUCC                      1020-1021
 PL_UIC                       1022-1023
 PL_UR_CAT4                   1024-1025
 POA_Disch_Edit1              1026-1027
 POA_Disch_Edit2              1028-1029
 POA_Hosp_Edit1               1030-1031
 POA_Hosp_Edit2               1032-1033
 POA_Hosp_Edit3               1034-1035
 POA_Hosp_Edit3_Value         1036-1043
 PointOfOrigin_X              1044     (A)
 PointOfOriginUB04            1045     (A)
 PRDAY1                       1046-1050
 PRDAY2                       1051-1055
 PRDAY3                       1056-1060
 PRDAY4                       1061-1065
 PRDAY5                       1066-1070
 PRDAY6                       1071-1075
 PRDAY7                       1076-1080
 PRDAY8                       1081-1085
 PRDAY9                       1086-1090
 PRDAY10                      1091-1095
 PRDAY11                      1096-1100
 PRDAY12                      1101-1105
 PRDAY13                      1106-1110
 PRDAY14                      1111-1115
 PRDAY15                      1116-1120
 PRDAY16                      1121-1125
 PRDAY17                      1126-1130
 PRDAY18                      1131-1135
 PRDAY19                      1136-1140
 PRDAY20                      1141-1145
 PRDAY21                      1146-1150
 PRDAY22                      1151-1155
 PRDAY23                      1156-1160
 PRDAY24                      1161-1165
 PRDAY25                      1166-1170
 PRVER                        1171-1173
 PSTATE                       1174-1175 (A)
 PSTCO                        1176-1180
 PSTCO2                       1181-1185
 RACE                         1186-1187
 RACE_X                       1188-1195 (A)
 TOTCHG                       1196-1205
 TOTCHG_X                     1206-1220
 TRAN_IN                      1221-1222
 TRAN_OUT                     1223-1224
 YEAR                         1225-1228
 ZIP                          1229-1233 (A)
 ZIPINC_QRTL                  1234-1236
 TOWN                         1237-1238 (A)
 AYEAR                        1239-1242
 PRMONTH1                     1243-1244
 PRMONTH2                     1245-1246
 PRMONTH3                     1247-1248
 PRMONTH4                     1249-1250
 PRMONTH5                     1251-1252
 PRMONTH6                     1253-1254
 PRMONTH7                     1255-1256
 PRMONTH8                     1257-1258
 PRMONTH9                     1259-1260
 PRMONTH10                    1261-1262
 PRMONTH11                    1263-1264
 PRMONTH12                    1265-1266
 PRMONTH13                    1267-1268
 PRMONTH14                    1269-1270
 PRMONTH15                    1271-1272
 PRMONTH16                    1273-1274
 PRMONTH17                    1275-1276
 PRMONTH18                    1277-1278
 PRMONTH19                    1279-1280
 PRMONTH20                    1281-1282
 PRMONTH21                    1283-1284
 PRMONTH22                    1285-1286
 PRMONTH23                    1287-1288
 PRMONTH24                    1289-1290
 PRMONTH25                    1291-1292
 PRYEAR1                      1293-1296
 PRYEAR2                      1297-1300
 PRYEAR3                      1301-1304
 PRYEAR4                      1305-1308
 PRYEAR5                      1309-1312
 PRYEAR6                      1313-1316
 PRYEAR7                      1317-1320
 PRYEAR8                      1321-1324
 PRYEAR9                      1325-1328
 PRYEAR10                     1329-1332
 PRYEAR11                     1333-1336
 PRYEAR12                     1337-1340
 PRYEAR13                     1341-1344
 PRYEAR14                     1345-1348
 PRYEAR15                     1349-1352
 PRYEAR16                     1353-1356
 PRYEAR17                     1357-1360
 PRYEAR18                     1361-1364
 PRYEAR19                     1365-1368
 PRYEAR20                     1369-1372
 PRYEAR21                     1373-1376
 PRYEAR22                     1377-1380
 PRYEAR23                     1381-1384
 PRYEAR24                     1385-1388
 PRYEAR25                     1389-1392.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 DaysCCU                      (F3.0) /
 DaysICU                      (F3.0) /
 DaysNICU                     (F3.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_ECauseCCS7               (F3.0) /
 I10_ECauseCCS8               (F3.0) /
 I10_ECauseCCS9               (F3.0) /
 I10_ECauseCCS10              (F3.0) /
 I10_ECauseCCS11              (F3.0) /
 I10_ECauseCCS12              (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PRCCS22                  (F3.0) /
 I10_PRCCS23                  (F3.0) /
 I10_PRCCS24                  (F3.0) /
 I10_PRCCS25                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 OBSERVATION                  (F4.0) /
 PAY1                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 DaysCCU                      "Days in coronary care unit (as received from source)"
 DaysICU                      "Days in medical/surgical intensive care unit (as received from source)"
 DaysNICU                     "Days in neonetal care unit (as received from source)"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "E Cause 1, present on admission indicator"
 E_POA2                       "E Cause 2, present on admission indicator"
 E_POA3                       "E Cause 3, present on admission indicator"
 E_POA4                       "E Cause 4, present on admission indicator"
 E_POA5                       "E Cause 5, present on admission indicator"
 E_POA6                       "E Cause 6, present on admission indicator"
 E_POA7                       "E Cause 7, present on admission indicator"
 E_POA8                       "E Cause 8, present on admission indicator"
 E_POA9                       "E Cause 9, present on admission indicator"
 E_POA10                      "E Cause 10, present on admission indicator"
 E_POA11                      "E Cause 11, present on admission indicator"
 E_POA12                      "E Cause 12, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECAUSE7                  "ICD-10-CM E Cause 7"
 I10_ECAUSE8                  "ICD-10-CM E Cause 8"
 I10_ECAUSE9                  "ICD-10-CM E Cause 9"
 I10_ECAUSE10                 "ICD-10-CM E Cause 10"
 I10_ECAUSE11                 "ICD-10-CM E Cause 11"
 I10_ECAUSE12                 "ICD-10-CM E Cause 12"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_ECauseCCS7               "ICD-10-CM CCS: E Cause 7"
 I10_ECauseCCS8               "ICD-10-CM CCS: E Cause 8"
 I10_ECauseCCS9               "ICD-10-CM CCS: E Cause 9"
 I10_ECauseCCS10              "ICD-10-CM CCS: E Cause 10"
 I10_ECauseCCS11              "ICD-10-CM CCS: E Cause 11"
 I10_ECauseCCS12              "ICD-10-CM CCS: E Cause 12"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PRCCS22                  "ICD-10-PCS CCS: procedure 22"
 I10_PRCCS23                  "ICD-10-PCS CCS: procedure 23"
 I10_PRCCS24                  "ICD-10-PCS CCS: procedure 24"
 I10_PRCCS25                  "ICD-10-PCS CCS: procedure 25"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OBSERVATION                  "Time for observation services (as received from source)"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 TOWN                         "Patient town of residence (as received from source)"
 AYEAR                        "Admission year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysNICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OBSERVATION
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'RI_SID_2015q4_CORE.SAV' /COMPRESSED.
