/*******************************************************************
*   SD_SID_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'SD_SID_2007_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ASOURCE                   12-  13
 ASOURCEU                  14     (A)
 ASOURCE_                  15     (A)
 ATYPE                     16-  17
 AWEEKEND                  18-  19
 DIED                      20-  21
 DISPUB04                  22-  23
 DISPUNIF                  24-  25
 DISP_X                    26-  29 (A)
 DQTR                      30-  31
 DRG                       32-  34
 DRG24                     35-  37
 DRGVER                    38-  39
 DX1                       40-  44 (A)
 DX2                       45-  49 (A)
 DX3                       50-  54 (A)
 DX4                       55-  59 (A)
 DX5                       60-  64 (A)
 DX6                       65-  69 (A)
 DX7                       70-  74 (A)
 DX8                       75-  79 (A)
 DX9                       80-  84 (A)
 DX10                      85-  89 (A)
 DX11                      90-  94 (A)
 DX12                      95-  99 (A)
 DX13                     100- 104 (A)
 DX14                     105- 109 (A)
 DX15                     110- 114 (A)
 DX16                     115- 119 (A)
 DX17                     120- 124 (A)
 DX18                     125- 129 (A)
 DX19                     130- 134 (A)
 DX20                     135- 139 (A)
 DX21                     140- 144 (A)
 DX22                     145- 149 (A)
 DX23                     150- 154 (A)
 DX24                     155- 159 (A)
 DX25                     160- 164 (A)
 DX26                     165- 169 (A)
 DX27                     170- 174 (A)
 DX28                     175- 179 (A)
 DX29                     180- 184 (A)
 DX30                     185- 189 (A)
 DX31                     190- 194 (A)
 DX32                     195- 199 (A)
 DX33                     200- 204 (A)
 DX34                     205- 209 (A)
 DX35                     210- 214 (A)
 DX36                     215- 219 (A)
 DX37                     220- 224 (A)
 DX38                     225- 229 (A)
 DX39                     230- 234 (A)
 DX40                     235- 239 (A)
 DX41                     240- 244 (A)
 DX42                     245- 249 (A)
 DX43                     250- 254 (A)
 DX44                     255- 259 (A)
 DX45                     260- 264 (A)
 DX46                     265- 269 (A)
 DX47                     270- 274 (A)
 DX48                     275- 279 (A)
 DX49                     280- 284 (A)
 DX50                     285- 289 (A)
 DX51                     290- 294 (A)
 DX52                     295- 299 (A)
 DX53                     300- 304 (A)
 DX54                     305- 309 (A)
 DX55                     310- 314 (A)
 DX56                     315- 319 (A)
 DX57                     320- 324 (A)
 DX58                     325- 329 (A)
 DX59                     330- 334 (A)
 DX60                     335- 339 (A)
 DX61                     340- 344 (A)
 DX62                     345- 349 (A)
 DX63                     350- 354 (A)
 DX64                     355- 359 (A)
 DX65                     360- 364 (A)
 DX66                     365- 369 (A)
 DX67                     370- 374 (A)
 DX68                     375- 379 (A)
 DX69                     380- 384 (A)
 DX70                     385- 389 (A)
 DX71                     390- 394 (A)
 DX72                     395- 399 (A)
 DX73                     400- 404 (A)
 DX74                     405- 409 (A)
 DX75                     410- 414 (A)
 DX76                     415- 419 (A)
 DX77                     420- 424 (A)
 DX78                     425- 429 (A)
 DX79                     430- 434 (A)
 DXCCS1                   435- 438
 DXCCS2                   439- 442
 DXCCS3                   443- 446
 DXCCS4                   447- 450
 DXCCS5                   451- 454
 DXCCS6                   455- 458
 DXCCS7                   459- 462
 DXCCS8                   463- 466
 DXCCS9                   467- 470
 DXCCS10                  471- 474
 DXCCS11                  475- 478
 DXCCS12                  479- 482
 DXCCS13                  483- 486
 DXCCS14                  487- 490
 DXCCS15                  491- 494
 DXCCS16                  495- 498
 DXCCS17                  499- 502
 DXCCS18                  503- 506
 DXCCS19                  507- 510
 DXCCS20                  511- 514
 DXCCS21                  515- 518
 DXCCS22                  519- 522
 DXCCS23                  523- 526
 DXCCS24                  527- 530
 DXCCS25                  531- 534
 DXCCS26                  535- 538
 DXCCS27                  539- 542
 DXCCS28                  543- 546
 DXCCS29                  547- 550
 DXCCS30                  551- 554
 DXCCS31                  555- 558
 DXCCS32                  559- 562
 DXCCS33                  563- 566
 DXCCS34                  567- 570
 DXCCS35                  571- 574
 DXCCS36                  575- 578
 DXCCS37                  579- 582
 DXCCS38                  583- 586
 DXCCS39                  587- 590
 DXCCS40                  591- 594
 DXCCS41                  595- 598
 DXCCS42                  599- 602
 DXCCS43                  603- 606
 DXCCS44                  607- 610
 DXCCS45                  611- 614
 DXCCS46                  615- 618
 DXCCS47                  619- 622
 DXCCS48                  623- 626
 DXCCS49                  627- 630
 DXCCS50                  631- 634
 DXCCS51                  635- 638
 DXCCS52                  639- 642
 DXCCS53                  643- 646
 DXCCS54                  647- 650
 DXCCS55                  651- 654
 DXCCS56                  655- 658
 DXCCS57                  659- 662
 DXCCS58                  663- 666
 DXCCS59                  667- 670
 DXCCS60                  671- 674
 DXCCS61                  675- 678
 DXCCS62                  679- 682
 DXCCS63                  683- 686
 DXCCS64                  687- 690
 DXCCS65                  691- 694
 DXCCS66                  695- 698
 DXCCS67                  699- 702
 DXCCS68                  703- 706
 DXCCS69                  707- 710
 DXCCS70                  711- 714
 DXCCS71                  715- 718
 DXCCS72                  719- 722
 DXCCS73                  723- 726
 DXCCS74                  727- 730
 DXCCS75                  731- 734
 DXCCS76                  735- 738
 DXCCS77                  739- 742
 DXCCS78                  743- 746
 DXCCS79                  747- 750
 ECODE1                   751- 755 (A)
 ECODE2                   756- 760 (A)
 ECODE3                   761- 765 (A)
 ECODE4                   766- 770 (A)
 ECODE5                   771- 775 (A)
 ECODE6                   776- 780 (A)
 ECODE7                   781- 785 (A)
 ECODE8                   786- 790 (A)
 ECODE9                   791- 795 (A)
 E_CCS1                   796- 799
 E_CCS2                   800- 803
 E_CCS3                   804- 807
 E_CCS4                   808- 811
 E_CCS5                   812- 815
 E_CCS6                   816- 819
 E_CCS7                   820- 823
 E_CCS8                   824- 827
 E_CCS9                   828- 831
 FEMALE                   832- 833
 HCUP_ED                  834- 835
 HCUP_OS                  836- 837
 HOSPBRTH                 838- 840
 HOSPST                   841- 842 (A)
 Hospital                 843- 844
 KEY                      845- 858
 LOS                      859- 863
 LOS_X                    864- 869
 MDC                      870- 871
 MDC24                    872- 873
 MDNUM1_R                 874- 882
 MDNUM2_R                 883- 891
 MEDINCST                 892- 893
 MRN_R                    894- 902
 NDX                      903- 904
 NECODE                   905- 906
 NEOMAT                   907- 908
 NPR                      909- 910
 PAY1                     911- 912
 PL_CBSA                  913- 915
 PL_MSA19                 916- 918
 PL_NCHS2                 919- 920
 PL_RUCA1                 921- 922
 PL_RUCA2                 923- 926
 PL_RUCA4                 927- 928
 PL_RUCC2                 929- 930
 PL_UIC20                 931- 932
 PL_UR_CA                 933- 934
 PR1                      935- 938 (A)
 PR2                      939- 942 (A)
 PR3                      943- 946 (A)
 PR4                      947- 950 (A)
 PR5                      951- 954 (A)
 PR6                      955- 958 (A)
 PR7                      959- 962 (A)
 PR8                      963- 966 (A)
 PR9                      967- 970 (A)
 PR10                     971- 974 (A)
 PR11                     975- 978 (A)
 PR12                     979- 982 (A)
 PR13                     983- 986 (A)
 PR14                     987- 990 (A)
 PR15                     991- 994 (A)
 PR16                     995- 998 (A)
 PR17                     999-1002 (A)
 PR18                    1003-1006 (A)
 PR19                    1007-1010 (A)
 PR20                    1011-1014 (A)
 PR21                    1015-1018 (A)
 PR22                    1019-1022 (A)
 PR23                    1023-1026 (A)
 PR24                    1027-1030 (A)
 PR25                    1031-1034 (A)
 PR26                    1035-1038 (A)
 PR27                    1039-1042 (A)
 PR28                    1043-1046 (A)
 PR29                    1047-1050 (A)
 PR30                    1051-1054 (A)
 PR31                    1055-1058 (A)
 PR32                    1059-1062 (A)
 PR33                    1063-1066 (A)
 PR34                    1067-1070 (A)
 PR35                    1071-1074 (A)
 PR36                    1075-1078 (A)
 PR37                    1079-1082 (A)
 PR38                    1083-1086 (A)
 PR39                    1087-1090 (A)
 PR40                    1091-1094 (A)
 PR41                    1095-1098 (A)
 PR42                    1099-1102 (A)
 PR43                    1103-1106 (A)
 PR44                    1107-1110 (A)
 PRCCS1                  1111-1113
 PRCCS2                  1114-1116
 PRCCS3                  1117-1119
 PRCCS4                  1120-1122
 PRCCS5                  1123-1125
 PRCCS6                  1126-1128
 PRCCS7                  1129-1131
 PRCCS8                  1132-1134
 PRCCS9                  1135-1137
 PRCCS10                 1138-1140
 PRCCS11                 1141-1143
 PRCCS12                 1144-1146
 PRCCS13                 1147-1149
 PRCCS14                 1150-1152
 PRCCS15                 1153-1155
 PRCCS16                 1156-1158
 PRCCS17                 1159-1161
 PRCCS18                 1162-1164
 PRCCS19                 1165-1167
 PRCCS20                 1168-1170
 PRCCS21                 1171-1173
 PRCCS22                 1174-1176
 PRCCS23                 1177-1179
 PRCCS24                 1180-1182
 PRCCS25                 1183-1185
 PRCCS26                 1186-1188
 PRCCS27                 1189-1191
 PRCCS28                 1192-1194
 PRCCS29                 1195-1197
 PRCCS30                 1198-1200
 PRCCS31                 1201-1203
 PRCCS32                 1204-1206
 PRCCS33                 1207-1209
 PRCCS34                 1210-1212
 PRCCS35                 1213-1215
 PRCCS36                 1216-1218
 PRCCS37                 1219-1221
 PRCCS38                 1222-1224
 PRCCS39                 1225-1227
 PRCCS40                 1228-1230
 PRCCS41                 1231-1233
 PRCCS42                 1234-1236
 PRCCS43                 1237-1239
 PRCCS44                 1240-1242
 PRDAY1                  1243-1247
 PRDAY2                  1248-1252
 PRDAY3                  1253-1257
 PRDAY4                  1258-1262
 PRDAY5                  1263-1267
 PRDAY6                  1268-1272
 PRDAY7                  1273-1277
 PRDAY8                  1278-1282
 PRDAY9                  1283-1287
 PRDAY10                 1288-1292
 PRDAY11                 1293-1297
 PRDAY12                 1298-1302
 PRDAY13                 1303-1307
 PRDAY14                 1308-1312
 PRDAY15                 1313-1317
 PRDAY16                 1318-1322
 PRDAY17                 1323-1327
 PRDAY18                 1328-1332
 PRDAY19                 1333-1337
 PRDAY20                 1338-1342
 PRDAY21                 1343-1347
 PRDAY22                 1348-1352
 PRDAY23                 1353-1357
 PRDAY24                 1358-1362
 PRDAY25                 1363-1367
 PRDAY26                 1368-1372
 PRDAY27                 1373-1377
 PRDAY28                 1378-1382
 PRDAY29                 1383-1387
 PRDAY30                 1388-1392
 PRDAY31                 1393-1397
 PRDAY32                 1398-1402
 PRDAY33                 1403-1407
 PRDAY34                 1408-1412
 PRDAY35                 1413-1417
 PRDAY36                 1418-1422
 PRDAY37                 1423-1427
 PRDAY38                 1428-1432
 PRDAY39                 1433-1437
 PRDAY40                 1438-1442
 PRDAY41                 1443-1447
 PRDAY42                 1448-1452
 PRDAY43                 1453-1457
 PRDAY44                 1458-1462
 PROCTYPE                1463-1465
 PSTATE                  1466-1467 (A)
 PSTCO                   1468-1472
 PSTCO2                  1473-1477
 POFOUB04                1478     (A)
 POFO_X                  1479     (A)
 RACE                    1480-1481
 RACE_X                  1482-1485 (A)
 TOTCHG                  1486-1495
 TOTCHG_X                1496-1510
 YEAR                    1511-1514
 ZIP3                    1515-1517 (A)
 ZIPINC_Q                1518-1520
 HOSPID                  1521-1525
 ZIP                     1526-1530 (A)
 AYEAR                   1531-1534
 DMONTH                  1535-1536
 BMONTH                  1537-1538
 BYEAR                   1539-1542
 PRMNTH1                 1543-1544
 PRMNTH2                 1545-1546
 PRMNTH3                 1547-1548
 PRMNTH4                 1549-1550
 PRMNTH5                 1551-1552
 PRMNTH6                 1553-1554
 PRMNTH7                 1555-1556
 PRMNTH8                 1557-1558
 PRMNTH9                 1559-1560
 PRMNTH10                1561-1562
 PRMNTH11                1563-1564
 PRMNTH12                1565-1566
 PRMNTH13                1567-1568
 PRMNTH14                1569-1570
 PRMNTH15                1571-1572
 PRMNTH16                1573-1574
 PRMNTH17                1575-1576
 PRMNTH18                1577-1578
 PRMNTH19                1579-1580
 PRMNTH20                1581-1582
 PRMNTH21                1583-1584
 PRMNTH22                1585-1586
 PRMNTH23                1587-1588
 PRMNTH24                1589-1590
 PRMNTH25                1591-1592
 PRMNTH26                1593-1594
 PRMNTH27                1595-1596
 PRMNTH28                1597-1598
 PRMNTH29                1599-1600
 PRMNTH30                1601-1602
 PRMNTH31                1603-1604
 PRMNTH32                1605-1606
 PRMNTH33                1607-1608
 PRMNTH34                1609-1610
 PRMNTH35                1611-1612
 PRMNTH36                1613-1614
 PRMNTH37                1615-1616
 PRMNTH38                1617-1618
 PRMNTH39                1619-1620
 PRMNTH40                1621-1622
 PRMNTH41                1623-1624
 PRMNTH42                1625-1626
 PRMNTH43                1627-1628
 PRMNTH44                1629-1630
 PRYEAR1                 1631-1634
 PRYEAR2                 1635-1638
 PRYEAR3                 1639-1642
 PRYEAR4                 1643-1646
 PRYEAR5                 1647-1650
 PRYEAR6                 1651-1654
 PRYEAR7                 1655-1658
 PRYEAR8                 1659-1662
 PRYEAR9                 1663-1666
 PRYEAR10                1667-1670
 PRYEAR11                1671-1674
 PRYEAR12                1675-1678
 PRYEAR13                1679-1682
 PRYEAR14                1683-1686
 PRYEAR15                1687-1690
 PRYEAR16                1691-1694
 PRYEAR17                1695-1698
 PRYEAR18                1699-1702
 PRYEAR19                1703-1706
 PRYEAR20                1707-1710
 PRYEAR21                1711-1714
 PRYEAR22                1715-1718
 PRYEAR23                1719-1722
 PRYEAR24                1723-1726
 PRYEAR25                1727-1730
 PRYEAR26                1731-1734
 PRYEAR27                1735-1738
 PRYEAR28                1739-1742
 PRYEAR29                1743-1746
 PRYEAR30                1747-1750
 PRYEAR31                1751-1754
 PRYEAR32                1755-1758
 PRYEAR33                1759-1762
 PRYEAR34                1763-1766
 PRYEAR35                1767-1770
 PRYEAR36                1771-1774
 PRYEAR37                1775-1778
 PRYEAR38                1779-1782
 PRYEAR39                1783-1786
 PRYEAR40                1787-1790
 PRYEAR41                1791-1794
 PRYEAR42                1795-1798
 PRYEAR43                1799-1802
 PRYEAR44                1803-1806.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DXCCS34                 (F4.0) /
 DXCCS35                 (F4.0) /
 DXCCS36                 (F4.0) /
 DXCCS37                 (F4.0) /
 DXCCS38                 (F4.0) /
 DXCCS39                 (F4.0) /
 DXCCS40                 (F4.0) /
 DXCCS41                 (F4.0) /
 DXCCS42                 (F4.0) /
 DXCCS43                 (F4.0) /
 DXCCS44                 (F4.0) /
 DXCCS45                 (F4.0) /
 DXCCS46                 (F4.0) /
 DXCCS47                 (F4.0) /
 DXCCS48                 (F4.0) /
 DXCCS49                 (F4.0) /
 DXCCS50                 (F4.0) /
 DXCCS51                 (F4.0) /
 DXCCS52                 (F4.0) /
 DXCCS53                 (F4.0) /
 DXCCS54                 (F4.0) /
 DXCCS55                 (F4.0) /
 DXCCS56                 (F4.0) /
 DXCCS57                 (F4.0) /
 DXCCS58                 (F4.0) /
 DXCCS59                 (F4.0) /
 DXCCS60                 (F4.0) /
 DXCCS61                 (F4.0) /
 DXCCS62                 (F4.0) /
 DXCCS63                 (F4.0) /
 DXCCS64                 (F4.0) /
 DXCCS65                 (F4.0) /
 DXCCS66                 (F4.0) /
 DXCCS67                 (F4.0) /
 DXCCS68                 (F4.0) /
 DXCCS69                 (F4.0) /
 DXCCS70                 (F4.0) /
 DXCCS71                 (F4.0) /
 DXCCS72                 (F4.0) /
 DXCCS73                 (F4.0) /
 DXCCS74                 (F4.0) /
 DXCCS75                 (F4.0) /
 DXCCS76                 (F4.0) /
 DXCCS77                 (F4.0) /
 DXCCS78                 (F4.0) /
 DXCCS79                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Hospital                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRCCS31                 (F3.0) /
 PRCCS32                 (F3.0) /
 PRCCS33                 (F3.0) /
 PRCCS34                 (F3.0) /
 PRCCS35                 (F3.0) /
 PRCCS36                 (F3.0) /
 PRCCS37                 (F3.0) /
 PRCCS38                 (F3.0) /
 PRCCS39                 (F3.0) /
 PRCCS40                 (F3.0) /
 PRCCS41                 (F3.0) /
 PRCCS42                 (F3.0) /
 PRCCS43                 (F3.0) /
 PRCCS44                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PRDAY26                 (F4.0) /
 PRDAY27                 (F4.0) /
 PRDAY28                 (F4.0) /
 PRDAY29                 (F4.0) /
 PRDAY30                 (F4.0) /
 PRDAY31                 (F4.0) /
 PRDAY32                 (F4.0) /
 PRDAY33                 (F4.0) /
 PRDAY34                 (F4.0) /
 PRDAY35                 (F4.0) /
 PRDAY36                 (F4.0) /
 PRDAY37                 (F4.0) /
 PRDAY38                 (F4.0) /
 PRDAY39                 (F4.0) /
 PRDAY40                 (F4.0) /
 PRDAY41                 (F4.0) /
 PRDAY42                 (F4.0) /
 PRDAY43                 (F4.0) /
 PRDAY44                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRMNTH16                (F3.0) /
 PRMNTH17                (F3.0) /
 PRMNTH18                (F3.0) /
 PRMNTH19                (F3.0) /
 PRMNTH20                (F3.0) /
 PRMNTH21                (F3.0) /
 PRMNTH22                (F3.0) /
 PRMNTH23                (F3.0) /
 PRMNTH24                (F3.0) /
 PRMNTH25                (F3.0) /
 PRMNTH26                (F3.0) /
 PRMNTH27                (F3.0) /
 PRMNTH28                (F3.0) /
 PRMNTH29                (F3.0) /
 PRMNTH30                (F3.0) /
 PRMNTH31                (F3.0) /
 PRMNTH32                (F3.0) /
 PRMNTH33                (F3.0) /
 PRMNTH34                (F3.0) /
 PRMNTH35                (F3.0) /
 PRMNTH36                (F3.0) /
 PRMNTH37                (F3.0) /
 PRMNTH38                (F3.0) /
 PRMNTH39                (F3.0) /
 PRMNTH40                (F3.0) /
 PRMNTH41                (F3.0) /
 PRMNTH42                (F3.0) /
 PRMNTH43                (F3.0) /
 PRMNTH44                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) /
 PRYEAR26                (F3.0) /
 PRYEAR27                (F3.0) /
 PRYEAR28                (F3.0) /
 PRYEAR29                (F3.0) /
 PRYEAR30                (F3.0) /
 PRYEAR31                (F3.0) /
 PRYEAR32                (F3.0) /
 PRYEAR33                (F3.0) /
 PRYEAR34                (F3.0) /
 PRYEAR35                (F3.0) /
 PRYEAR36                (F3.0) /
 PRYEAR37                (F3.0) /
 PRYEAR38                (F3.0) /
 PRYEAR39                (F3.0) /
 PRYEAR40                (F3.0) /
 PRYEAR41                (F3.0) /
 PRYEAR42                (F3.0) /
 PRYEAR43                (F3.0) /
 PRYEAR44                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DX31      "Diagnosis 31"
 DX32      "Diagnosis 32"
 DX33      "Diagnosis 33"
 DX34      "Diagnosis 34"
 DX35      "Diagnosis 35"
 DX36      "Diagnosis 36"
 DX37      "Diagnosis 37"
 DX38      "Diagnosis 38"
 DX39      "Diagnosis 39"
 DX40      "Diagnosis 40"
 DX41      "Diagnosis 41"
 DX42      "Diagnosis 42"
 DX43      "Diagnosis 43"
 DX44      "Diagnosis 44"
 DX45      "Diagnosis 45"
 DX46      "Diagnosis 46"
 DX47      "Diagnosis 47"
 DX48      "Diagnosis 48"
 DX49      "Diagnosis 49"
 DX50      "Diagnosis 50"
 DX51      "Diagnosis 51"
 DX52      "Diagnosis 52"
 DX53      "Diagnosis 53"
 DX54      "Diagnosis 54"
 DX55      "Diagnosis 55"
 DX56      "Diagnosis 56"
 DX57      "Diagnosis 57"
 DX58      "Diagnosis 58"
 DX59      "Diagnosis 59"
 DX60      "Diagnosis 60"
 DX61      "Diagnosis 61"
 DX62      "Diagnosis 62"
 DX63      "Diagnosis 63"
 DX64      "Diagnosis 64"
 DX65      "Diagnosis 65"
 DX66      "Diagnosis 66"
 DX67      "Diagnosis 67"
 DX68      "Diagnosis 68"
 DX69      "Diagnosis 69"
 DX70      "Diagnosis 70"
 DX71      "Diagnosis 71"
 DX72      "Diagnosis 72"
 DX73      "Diagnosis 73"
 DX74      "Diagnosis 74"
 DX75      "Diagnosis 75"
 DX76      "Diagnosis 76"
 DX77      "Diagnosis 77"
 DX78      "Diagnosis 78"
 DX79      "Diagnosis 79"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 DXCCS31   "CCS: diagnosis 31"
 DXCCS32   "CCS: diagnosis 32"
 DXCCS33   "CCS: diagnosis 33"
 DXCCS34   "CCS: diagnosis 34"
 DXCCS35   "CCS: diagnosis 35"
 DXCCS36   "CCS: diagnosis 36"
 DXCCS37   "CCS: diagnosis 37"
 DXCCS38   "CCS: diagnosis 38"
 DXCCS39   "CCS: diagnosis 39"
 DXCCS40   "CCS: diagnosis 40"
 DXCCS41   "CCS: diagnosis 41"
 DXCCS42   "CCS: diagnosis 42"
 DXCCS43   "CCS: diagnosis 43"
 DXCCS44   "CCS: diagnosis 44"
 DXCCS45   "CCS: diagnosis 45"
 DXCCS46   "CCS: diagnosis 46"
 DXCCS47   "CCS: diagnosis 47"
 DXCCS48   "CCS: diagnosis 48"
 DXCCS49   "CCS: diagnosis 49"
 DXCCS50   "CCS: diagnosis 50"
 DXCCS51   "CCS: diagnosis 51"
 DXCCS52   "CCS: diagnosis 52"
 DXCCS53   "CCS: diagnosis 53"
 DXCCS54   "CCS: diagnosis 54"
 DXCCS55   "CCS: diagnosis 55"
 DXCCS56   "CCS: diagnosis 56"
 DXCCS57   "CCS: diagnosis 57"
 DXCCS58   "CCS: diagnosis 58"
 DXCCS59   "CCS: diagnosis 59"
 DXCCS60   "CCS: diagnosis 60"
 DXCCS61   "CCS: diagnosis 61"
 DXCCS62   "CCS: diagnosis 62"
 DXCCS63   "CCS: diagnosis 63"
 DXCCS64   "CCS: diagnosis 64"
 DXCCS65   "CCS: diagnosis 65"
 DXCCS66   "CCS: diagnosis 66"
 DXCCS67   "CCS: diagnosis 67"
 DXCCS68   "CCS: diagnosis 68"
 DXCCS69   "CCS: diagnosis 69"
 DXCCS70   "CCS: diagnosis 70"
 DXCCS71   "CCS: diagnosis 71"
 DXCCS72   "CCS: diagnosis 72"
 DXCCS73   "CCS: diagnosis 73"
 DXCCS74   "CCS: diagnosis 74"
 DXCCS75   "CCS: diagnosis 75"
 DXCCS76   "CCS: diagnosis 76"
 DXCCS77   "CCS: diagnosis 77"
 DXCCS78   "CCS: diagnosis 78"
 DXCCS79   "CCS: diagnosis 79"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 ECODE9    "E code 9"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 E_CCS9    "CCS: E Code 9"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 Hospital
"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC24     "MDC, version 24"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PR31      "Procedure 31"
 PR32      "Procedure 32"
 PR33      "Procedure 33"
 PR34      "Procedure 34"
 PR35      "Procedure 35"
 PR36      "Procedure 36"
 PR37      "Procedure 37"
 PR38      "Procedure 38"
 PR39      "Procedure 39"
 PR40      "Procedure 40"
 PR41      "Procedure 41"
 PR42      "Procedure 42"
 PR43      "Procedure 43"
 PR44      "Procedure 44"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRCCS31   "CCS: procedure 31"
 PRCCS32   "CCS: procedure 32"
 PRCCS33   "CCS: procedure 33"
 PRCCS34   "CCS: procedure 34"
 PRCCS35   "CCS: procedure 35"
 PRCCS36   "CCS: procedure 36"
 PRCCS37   "CCS: procedure 37"
 PRCCS38   "CCS: procedure 38"
 PRCCS39   "CCS: procedure 39"
 PRCCS40   "CCS: procedure 40"
 PRCCS41   "CCS: procedure 41"
 PRCCS42   "CCS: procedure 42"
 PRCCS43   "CCS: procedure 43"
 PRCCS44   "CCS: procedure 44"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PRDAY21   "Number of days from admission to PR21"
 PRDAY22   "Number of days from admission to PR22"
 PRDAY23   "Number of days from admission to PR23"
 PRDAY24   "Number of days from admission to PR24"
 PRDAY25   "Number of days from admission to PR25"
 PRDAY26   "Number of days from admission to PR26"
 PRDAY27   "Number of days from admission to PR27"
 PRDAY28   "Number of days from admission to PR28"
 PRDAY29   "Number of days from admission to PR29"
 PRDAY30   "Number of days from admission to PR30"
 PRDAY31   "Number of days from admission to PR31"
 PRDAY32   "Number of days from admission to PR32"
 PRDAY33   "Number of days from admission to PR33"
 PRDAY34   "Number of days from admission to PR34"
 PRDAY35   "Number of days from admission to PR35"
 PRDAY36   "Number of days from admission to PR36"
 PRDAY37   "Number of days from admission to PR37"
 PRDAY38   "Number of days from admission to PR38"
 PRDAY39   "Number of days from admission to PR39"
 PRDAY40   "Number of days from admission to PR40"
 PRDAY41   "Number of days from admission to PR41"
 PRDAY42   "Number of days from admission to PR42"
 PRDAY43   "Number of days from admission to PR43"
 PRDAY44   "Number of days from admission to PR44"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 POFO_X    "Point of origin for admission or visit, as received from source"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 HOSPID    "HCUP hospital identification number"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRMNTH19  "Month of procedure 19"
 PRMNTH20  "Month of procedure 20"
 PRMNTH21  "Month of procedure 21"
 PRMNTH22  "Month of procedure 22"
 PRMNTH23  "Month of procedure 23"
 PRMNTH24  "Month of procedure 24"
 PRMNTH25  "Month of procedure 25"
 PRMNTH26  "Month of procedure 26"
 PRMNTH27  "Month of procedure 27"
 PRMNTH28  "Month of procedure 28"
 PRMNTH29  "Month of procedure 29"
 PRMNTH30  "Month of procedure 30"
 PRMNTH31  "Month of procedure 31"
 PRMNTH32  "Month of procedure 32"
 PRMNTH33  "Month of procedure 33"
 PRMNTH34  "Month of procedure 34"
 PRMNTH35  "Month of procedure 35"
 PRMNTH36  "Month of procedure 36"
 PRMNTH37  "Month of procedure 37"
 PRMNTH38  "Month of procedure 38"
 PRMNTH39  "Month of procedure 39"
 PRMNTH40  "Month of procedure 40"
 PRMNTH41  "Month of procedure 41"
 PRMNTH42  "Month of procedure 42"
 PRMNTH43  "Month of procedure 43"
 PRMNTH44  "Month of procedure 44"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18"
 PRYEAR19  "Year of procedure 19"
 PRYEAR20  "Year of procedure 20"
 PRYEAR21  "Year of procedure 21"
 PRYEAR22  "Year of procedure 22"
 PRYEAR23  "Year of procedure 23"
 PRYEAR24  "Year of procedure 24"
 PRYEAR25  "Year of procedure 25"
 PRYEAR26  "Year of procedure 26"
 PRYEAR27  "Year of procedure 27"
 PRYEAR28  "Year of procedure 28"
 PRYEAR29  "Year of procedure 29"
 PRYEAR30  "Year of procedure 30"
 PRYEAR31  "Year of procedure 31"
 PRYEAR32  "Year of procedure 32"
 PRYEAR33  "Year of procedure 33"
 PRYEAR34  "Year of procedure 34"
 PRYEAR35  "Year of procedure 35"
 PRYEAR36  "Year of procedure 36"
 PRYEAR37  "Year of procedure 37"
 PRYEAR38  "Year of procedure 38"
 PRYEAR39  "Year of procedure 39"
 PRYEAR40  "Year of procedure 40"
 PRYEAR41  "Year of procedure 41"
 PRYEAR42  "Year of procedure 42"
 PRYEAR43  "Year of procedure 43"
 PRYEAR44  "Year of procedure 44" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS58
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS59
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS60
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS61
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS62
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS63
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS64
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS65
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS66
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS67
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS68
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS69
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS70
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS71
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS72
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS73
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS74
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS75
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS76
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS77
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS78
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS79
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Hospital
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'SD_SID_2007_CORE.SAV' /COMPRESSED.
