/*******************************************************************
*   WI_SID_1990_AHAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY AHAL FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'WI_SID_1990_AHAL.ASC' FIXED / 
 HOSPSTCO              1-   5
 HOSPID                6-  10
 DSHOSPID             11-  23 (A)
 YEAR                 24-  27
 HOSPST               28-  29 (A)
 IDNUMBER             30-  35 (A)
 AHAID                36-  42 (A).


***  Specify write formats  ***.
FORMATS
 HOSPSTCO            (F5.0) /
 HOSPID              (F4.0) /
 YEAR                (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 HOSPSTCO  "Hospital modified FIPS state/county code"
 HOSPID    "HCUP hospital ID number (SSHHH)"
 DSHOSPID  "I:Data source hospital ID number"
 YEAR      "Calendar year"
 HOSPST    "Hospital state postal code"
 IDNUMBER  "HCUP AHA ID number without the leading 6"
 AHAID     "AHA ID number with the leading 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE HOSPSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).



SAVE OUTFILE = 'WI_SID_1990_AHAL.SAV' /COMPRESSED.
